/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.adjustbill;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class TailDiffAdjustFromPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String CODE = "fcode";
    private static final String COMMONMAPCONFIG = "commonmapconfig";
    private static final String SOURCEBILL = "sourcebill";
    private static final String TARGETOBJ = "targetobj";
    private static final String IM_OTHERINBILL = "im_otherinbill";
    private static final String IM_OTHEROUTBILL = "im_otheroutbill";
    private static final String ADJUSTIN_SETTING = "adjustin_setting";
    private static final String ADJUSTOUT_SETTING = "adjustout_setting";
    private static final String IM_REAL_BAL_REPO = "im_real_bal_repo";
    private static final String ISENABLE = "isenable";
    private static final String ON = "1";
    private static final String SBS_BILLFIELDMAPPING = "sbs_billfieldmapping";
    private static final String ID = "id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        BasedataEdit commonMapConfig = (BasedataEdit)this.getView().getControl(COMMONMAPCONFIG);
        commonMapConfig.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        Object opKey = this.getView().getFormShowParameter().getCustomParam("opkey");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (COMMONMAPCONFIG.equals(fieldKey)) {
            QFilter qFilter = new QFilter(ISENABLE, "=", (Object)ON);
            qFilter.and(SOURCEBILL, "=", (Object)IM_REAL_BAL_REPO);
            if (ADJUSTIN_SETTING.equals(opKey)) {
                qFilter.and(TARGETOBJ, "=", (Object)IM_OTHERINBILL);
            } else if (ADJUSTOUT_SETTING.equals(opKey)) {
                qFilter.and(TARGETOBJ, "=", (Object)IM_OTHEROUTBILL);
            }
            Map fieldMapping = BusinessDataServiceHelper.loadFromCache((String)SBS_BILLFIELDMAPPING, (String)ID, (QFilter[])qFilter.toArray());
            Set ids = fieldMapping.keySet();
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter(ID, "in", ids)));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object opKey = this.getView().getFormShowParameter().getCustomParam("opkey");
        if (opKey != null) {
            DataSet dataSet = DB.queryDataSet((String)"kd.scmc.im.report.algox.realbal.TailDiffAdjustFromPlugin.afterCreateNewData", (DBRoute)new DBRoute("scm"), (String)("select FCOMMONMAPID from T_IM_TAILADJUST_SETTING where fopnum = '" + opKey.toString() + "'"));
            Object pkId = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                pkId = row.get("FCOMMONMAPID");
            }
            this.getModel().setValue(COMMONMAPCONFIG, pkId);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key) && this.saveConfig()) {
            this.getView().close();
        }
        if ("btncancel".equals(key)) {
            this.getView().close();
        }
    }

    private boolean saveConfig() {
        Object commonMapConfig = this.getModel().getValue(COMMONMAPCONFIG);
        if (commonMapConfig == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"TailDiffAdjustFromPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object opKey = this.getView().getFormShowParameter().getCustomParam("opkey");
        long pkValue = ((DynamicObject)commonMapConfig).getLong(ID);
        DataSet dataSet = DB.queryDataSet((String)"kd.scmc.im.report.algox.realbal.TailDiffAdjustFromPlugin.saveConfig", (DBRoute)new DBRoute("scm"), (String)("select fopnum from T_IM_TAILADJUST_SETTING where fopnum = '" + opKey.toString() + "'"));
        if (dataSet.hasNext()) {
            DB.execute((DBRoute)new DBRoute("scm"), (String)"update T_IM_TAILADJUST_SETTING set FCOMMONMAPID = ?, fmodifytime = ? ,fmodifier = ? where fopnum = ?", (Object[])new Object[]{pkValue, new Date(), UserServiceHelper.getCurrentUserId(), opKey.toString()});
        } else {
            DB.execute((DBRoute)new DBRoute("scm"), (String)"insert into T_IM_TAILADJUST_SETTING (FID,FCOMMONMAPID, fmodifytime,fmodifier,fopnum) values(?,?,?,?,?) ", (Object[])new Object[]{ADJUSTIN_SETTING.equals(opKey.toString()) ? 69584236548962518L : 69584236548962519L, pkValue, new Date(), UserServiceHelper.getCurrentUserId(), opKey.toString()});
        }
        return true;
    }
}

