/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv.workbenches;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.scmc.im.business.balanceinv.workbench.executor.BalanceInvWorkBenchExecutor;
import kd.scmc.im.business.balanceinv.workbench.helper.BalanceInvAdjustmentHelper;
import kd.scmc.im.consts.BalanceInvWorkbenchLogConstant;
import kd.scmc.im.formplugin.balanceinv.helper.BalanceInvFormHelper;
import kd.scmc.im.formplugin.balanceinv.workbenches.BalanceInvWorkbenchLog;
import kd.scmc.im.formplugin.balanceinv.workbenches.genadvice.BalanceInvGenResult;
import kd.scmc.im.formplugin.balanceinv.workbenches.genadvice.BalanceInvWbConfirm;
import kd.scmc.im.formplugin.balanceinv.workbenches.helper.BalanceInvWbPushHelper;
import kd.scmc.im.formplugin.balanceinv.workbenches.helper.MutexLockHelper;

public class BalanceInvWorkbenchEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String ENTRY_SEQ = "entryentity.seq";
    private static final String ENTRY_MATCH_BASE_QTY = "entryentity.matchbaseqty";
    private static final String ENTRY_DEMAND_BASE_QTY = "entryentity.demandbaseqty";
    private static final String ENTRY_NET_DEMAND_BASE_QTY = "entryentity.netdemandbaseqty";

    public void initialize() {
        this.setListEntryCanSelect("billlistap", "needpushlistap", "pushlistap");
        this.addListDataProvider();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BalanceInvFormHelper.checkLicense(e);
    }

    private void setListEntryCanSelect(String ... listKeys) {
        for (String listKey : listKeys) {
            BillList billList = (BillList)this.getControl(listKey);
            if (billList == null) continue;
            billList.getListUserOption().setMergeRow(false);
        }
    }

    private void addListDataProvider() {
        BillList billList = (BillList)this.getControl("matchlistap");
        if (billList != null) {
            billList.addCreateListDataProviderListener(new CreateListDataProviderListener(){

                public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
                    e.setListDataProvider((IListDataProvider)new ListDataProvider(){

                        public void setListFields(List<ListField> listFields) {
                            BalanceInvWorkbenchEditPlugin.this.addSelectedFields(listFields);
                            super.setListFields(listFields);
                        }

                        public DynamicObjectCollection getData(int start, int limit) {
                            DynamicObjectCollection cols = super.getData(start, limit);
                            BalanceInvWorkbenchEditPlugin.this.dealDemandQtyValue(cols, start);
                            return cols;
                        }
                    });
                }
            });
            billList.addPackageDataListener(evt -> {
                DynamicObject dynamicObject = evt.getRowData();
                String confirmStatus = dynamicObject.getString("comfirmstatus");
                String key = evt.getColKey();
                boolean enable = true;
                if ("1".equals(confirmStatus) && "opcolumn".equals(key)) {
                    enable = false;
                    List operationColItems = (List)evt.getFormatValue();
                    for (OperationColItem operationColItem : operationColItems) {
                        operationColItem.setLocked(true);
                    }
                }
                this.getView().setEnable(Boolean.valueOf(enable), new String[]{"btnsure"});
            });
        }
    }

    private void addSelectedFields(List<ListField> listFields) {
        if (listFields != null) {
            boolean containSeq = false;
            boolean containMatchBaseQty = false;
            boolean containDemandBaseQty = false;
            boolean containNetDemandBaseQty = false;
            for (ListField listField : listFields) {
                String key = listField.getFieldName();
                if (ENTRY_SEQ.equals(key)) {
                    containSeq = true;
                    continue;
                }
                if (ENTRY_MATCH_BASE_QTY.equals(key)) {
                    containMatchBaseQty = true;
                    continue;
                }
                if (ENTRY_DEMAND_BASE_QTY.equals(key)) {
                    containDemandBaseQty = true;
                    continue;
                }
                if (!ENTRY_NET_DEMAND_BASE_QTY.equals(key)) continue;
                containNetDemandBaseQty = true;
            }
            if (!containSeq) {
                listFields.add(this.createListField(ENTRY_SEQ, ENTRY_SEQ));
            }
            if (!containMatchBaseQty) {
                listFields.add(this.createListField("matchbaseqty", ENTRY_MATCH_BASE_QTY));
            }
            if (!containDemandBaseQty) {
                listFields.add(this.createListField("demandbaseqty", ENTRY_DEMAND_BASE_QTY));
            }
            if (!containNetDemandBaseQty) {
                listFields.add(this.createListField("netdemandbaseqty", ENTRY_NET_DEMAND_BASE_QTY));
            }
        }
    }

    private ListField createListField(String key, String fieldName) {
        ListField listField = new ListField(key);
        listField.setFieldName(fieldName);
        return listField;
    }

    private void dealDemandQtyValue(DynamicObjectCollection collection, int start) {
        for (DynamicObject dynamicObject : collection) {
            if (dynamicObject == null) continue;
            dynamicObject.set(ENTRY_SEQ, (Object)(++start));
            BigDecimal matchBaseQty = dynamicObject.getBigDecimal(ENTRY_MATCH_BASE_QTY);
            if (matchBaseQty.compareTo(BigDecimal.ZERO) != 0) continue;
            BigDecimal demandBaseQty = dynamicObject.getBigDecimal(ENTRY_DEMAND_BASE_QTY);
            dynamicObject.set(ENTRY_NET_DEMAND_BASE_QTY, (Object)demandBaseQty);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "balanceorg", "scheme");
        this.addTabSelectedListener("subtabap", "tabap");
        this.addItemClickListeners(new String[]{"toolbarap", "toolbarview", "toolbarpush", "toolbarinvp"});
        this.helperClickListeners("billlistap", "needpushlistap", "pushlistap");
    }

    private void addF7Listener(BeforeF7SelectListener listener, String ... f7keys) {
        for (String key : f7keys) {
            BasedataEdit edit = (BasedataEdit)this.getView().getControl(key);
            if (edit == null) continue;
            edit.addBeforeF7SelectListener(listener);
        }
    }

    private void addTabSelectedListener(String ... tabkeys) {
        for (String key : tabkeys) {
            Tab tab = (Tab)this.getControl(key);
            if (tab == null) continue;
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    private void helperClickListeners(String ... keys) {
        for (final String key : keys) {
            BillList billList = (BillList)this.getControl(key);
            billList.addHyperClickListener(new HyperLinkClickListener(){
                String formEntityNumber;
                {
                    this.formEntityNumber = BalanceInvWorkbenchEditPlugin.this.getFormEntityNumber(key);
                }

                public void hyperLinkClick(HyperLinkClickEvent evt) {
                    String fieldKey = evt.getFieldName();
                    if (StringUtils.isNotEmpty((CharSequence)this.formEntityNumber) && ("billno".equals(fieldKey) || "advicebillno".equals(fieldKey) || "padvicebillno".equals(fieldKey))) {
                        Control control = (Control)evt.getSource();
                        ListSelectedRow selectedRow = ((BillList)control).getCurrentSelectedRowInfo();
                        Object id = selectedRow.getPrimaryKeyValue();
                        BillShowParameter showParameter = new BillShowParameter();
                        showParameter.setFormId(this.formEntityNumber);
                        if ("pm_requirapplybill".equals(this.formEntityNumber)) {
                            showParameter.setAppId("pm");
                        }
                        showParameter.setPkId(id);
                        showParameter.getOpenStyle().setShowType(ShowType.Modal);
                        showParameter.setStatus(OperationStatus.VIEW);
                        control.getView().showForm((FormShowParameter)showParameter);
                    }
                }
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("tabbalance");
        this.initOrgAndScheme();
        this.setBizTimeValue();
        this.showTabByLogStep(false);
    }

    private void initOrgAndScheme() {
        DynamicObject workbenchLog;
        String logId;
        DynamicObject org = null;
        DynamicObject scheme = null;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null && StringUtils.isNotEmpty((CharSequence)(logId = (String)params.get("benchLogId"))) && (workbenchLog = BusinessDataServiceHelper.loadSingle((Object)logId, (String)BalanceInvWorkbenchLogConstant.ENTITY_NUMBER, (String)"balanceorg, scheme")) != null) {
            org = workbenchLog.getDynamicObject(BalanceInvWorkbenchLogConstant.BALANCE_ORG);
            scheme = workbenchLog.getDynamicObject(BalanceInvWorkbenchLogConstant.SCHEME);
        }
        this.setOrgDefaultValue(org);
        this.setSchemeValue(scheme);
        ArrayList<String> tabList = new ArrayList<String>(Arrays.asList("subbalance", "subresultview", "subpush"));
        for (String key : tabList) {
            this.updateBillList(this.getBillListKey(key), Arrays.asList(new QFilter("1", "!=", (Object)1).toArray()), false);
        }
    }

    private void setBizTimeValue() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date now = cal.getTime();
        cal.add(2, -1);
        Date oneMonthAgo = cal.getTime();
        model.setValue("biztime_rfls", (Object)oneMonthAgo);
        model.setValue("biztime_rfle", (Object)now);
    }

    private List<QFilter> buildFilterApFilter(String filterApKey, String activeTabKey) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(16);
        IDataModel model = this.getModel();
        Control control = this.getControl(filterApKey);
        if (control != null) {
            String formNumber = this.getFormEntityNumber(activeTabKey);
            List items = ((Container)control).getItems();
            if (StringUtils.isNotEmpty((CharSequence)formNumber)) {
                MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)formNumber);
                for (Control item : items) {
                    String fieldKey = item.getKey();
                    if ("resultfilter".equals(filterApKey) && "comfirmstatus_fl".equals(fieldKey)) continue;
                    String formFieldKey = this.getFormFieldKey(billEntity, this.parseKey(fieldKey));
                    QFilter filter = null;
                    if (item instanceof MulBasedataEdit) {
                        filter = this.buildMulBaseDataFilter(formFieldKey, model.getValue(fieldKey));
                    } else if (item instanceof DateRangeEdit) {
                        filter = this.buildDateRangeFilter((DateRangeEdit)item, formFieldKey);
                    } else if (item instanceof ComboEdit) {
                        filter = this.buildMulComboFilter(formFieldKey, model.getValue(fieldKey));
                    } else {
                        Object value = model.getValue(fieldKey);
                        if (value != null) {
                            if (("calculatenum_fl".equals(fieldKey) || "calculatenum".equals(fieldKey)) && StringUtils.isEmpty((CharSequence)((String)value))) {
                                filter = new QFilter("1", "!=", (Object)1);
                            } else if (value instanceof DynamicObject) {
                                filter = new QFilter(formFieldKey, "=", ((DynamicObject)value).getPkValue());
                            } else if (value instanceof Boolean || value instanceof String && StringUtils.isNotEmpty((CharSequence)((String)value)) || value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) != 0) {
                                filter = new QFilter(formFieldKey, "=", value);
                            }
                        }
                    }
                    if (filter == null) continue;
                    filterList.add(filter);
                }
            }
        }
        return filterList;
    }

    private void setOrgDefaultValue(Object orgId) {
        IDataModel model = this.getModel();
        if (orgId == null) {
            RequestContext context = RequestContext.get();
            Long curOrgId = context.getOrgId();
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)context.getCurrUserId(), (String)"15", (String)BizAppServiceHelp.getAppIdByAppNumber((String)"im"), (String)"im_balance_workbenches", (String)"47150e89000000ac");
            List orgIds = result.getHasPermOrgs();
            orgId = !orgIds.isEmpty() && !orgIds.contains(curOrgId) ? (orgIds.size() > 1 ? this.getFirstOrgIdAfterSort(orgIds) : orgIds.get(0)) : curOrgId;
        }
        model.setValue("balanceorg", orgId);
        this.getView().updateView("balanceorg");
    }

    private Long getFirstOrgIdAfterSort(List<Long> orgIds) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        String orgSortFields = orgService.getOrgSortFields();
        if (StringUtils.isNotBlank((CharSequence)orgSortFields)) {
            List sortOrgIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter("id", "in", orgIds).toArray(), (String)orgSortFields, (int)1);
            return (Long)sortOrgIds.get(0);
        }
        return orgIds.get(0);
    }

    private void setSchemeValue(Object scheme) {
        DynamicObject org;
        IDataModel model = this.getModel();
        if (scheme == null && (org = (DynamicObject)model.getValue("balanceorg")) != null) {
            QFilter filter = new QFilter("balanceinvorg", "=", org.getPkValue()).and("enable", "=", (Object)"1");
            scheme = BusinessDataServiceHelper.loadSingleFromCache((String)"balanceinv_scheme", (String)"id", (QFilter[])filter.toArray());
        }
        model.setValue("scheme", scheme);
        this.getView().updateView("scheme");
    }

    private void setCalNumValue(String calNumValue) {
        this.getModel().setValue("calculatenum_fl", (Object)calNumValue);
        this.getModel().setValue("calculatenum", (Object)calNumValue);
        this.getView().updateView("calculatenum_fl");
        this.getView().updateView("calculatenum");
    }

    private void showTabByLogStep(boolean clear) {
        DynamicObject log;
        Tab tab = (Tab)this.getView().getControl("subtabap");
        IDataModel model = this.getModel();
        String activeTabKey = "subbalance";
        DynamicObject balanceOrg = (DynamicObject)model.getValue("balanceorg");
        DynamicObject scheme = (DynamicObject)model.getValue("scheme");
        Long userId = RequestContext.get().getCurrUserId();
        String calNum = "";
        if (balanceOrg != null && scheme != null && (log = BalanceInvWorkbenchLog.queryLogObj(userId, balanceOrg.getLong("id"), scheme.getLong("id"), "id,step,calnumber")) != null) {
            String stepStatus = log.getString(BalanceInvWorkbenchLogConstant.STEP);
            calNum = log.getString(BalanceInvWorkbenchLogConstant.CAL_NUMBER);
            if (BalanceInvWorkbenchLogConstant.STEP_RESULT_VIEW.equals(stepStatus)) {
                activeTabKey = "subresultview";
            } else if (BalanceInvWorkbenchLogConstant.STEP_PUSH.equals(stepStatus)) {
                activeTabKey = this.getActiveTabByStep(log);
            }
        }
        model.beginInit();
        this.setCalNumValue(calNum);
        model.endInit();
        tab.activeTab(activeTabKey);
        this.setBillListFilter(activeTabKey, clear);
    }

    private String getActiveTabByStep(DynamicObject log) {
        String calNum = log.getString(BalanceInvWorkbenchLogConstant.CAL_NUMBER);
        QFilter qFilter = new QFilter("calculatenum", "=", (Object)calNum).and("entryentity.pushstatus", "=", (Object)"A");
        boolean exist = QueryServiceHelper.exists((String)"im_balanceinv_advice", (QFilter[])qFilter.toArray());
        if (!exist) {
            log.set(BalanceInvWorkbenchLogConstant.STEP, (Object)BalanceInvWorkbenchLogConstant.STEP_INV);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
            return "subbalance";
        }
        return "subpush";
    }

    private QFilter buildSchemeFilter() {
        IDataModel model = this.getModel();
        QFilter qtyFilter = new QFilter("(billentry.baseqty)-(billentry.promatbaseqty)-(billentry.protranbaseqty)-(billentry.propurbaseqty)-(billentry.applybaseqty)-(billentry.unionsumbaseqty)", ">", (Object)0, true);
        DynamicObject org = (DynamicObject)model.getValue("balanceorg");
        if (org != null) {
            qtyFilter.and("org", "=", org.getPkValue());
        }
        QFilter demandModelFilter = null;
        DynamicObject scheme = (DynamicObject)model.getValue("scheme");
        if (scheme != null) {
            Object demandModelPk = scheme.getDynamicObject("demandmodel").getPkValue();
            DynamicObject modelRegister = BusinessDataServiceHelper.loadSingleFromCache((Object)demandModelPk, (String)"balanceinv_register", (String)"id,entryentityds.srcbillds, entryentityds.filtervalueds");
            if (modelRegister != null) {
                DynamicObjectCollection entryCol = modelRegister.getDynamicObjectCollection("entryentityds");
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"pm_requirapplybill");
                for (DynamicObject entry : entryCol) {
                    String filterStr;
                    String entityNumber = entry.getDynamicObject("srcbillds").getString("number");
                    if (!"pm_requirapplybill".equals(entityNumber) || !StringUtils.isNotEmpty((CharSequence)(filterStr = entry.getString("filtervalueds")))) continue;
                    FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                    FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
                    filterBuilder.buildFilter();
                    QFilter qFilter = filterBuilder.getQFilter();
                    demandModelFilter = demandModelFilter == null ? qFilter : demandModelFilter.and(qFilter);
                }
            }
        } else {
            demandModelFilter = new QFilter("1", "!=", (Object)1);
        }
        if (demandModelFilter != null) {
            return qtyFilter.and(demandModelFilter);
        }
        return qtyFilter;
    }

    private QFilter getPlannerMaterialQFilter() {
        String filter = this.getView().getPageCache().get("filter");
        QFilter allowMaterialQFilter = null;
        if (StringUtils.isEmpty((CharSequence)filter)) {
            try {
                allowMaterialQFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"DataCtrlService", (String)"getQfilter", (Object[])new Object[]{this.getModel().getDataEntity(false), "pm_requirapplybill", "billentry.materialmasterid"});
                this.getView().getPageCache().put("filter", SerializationUtils.toJsonString((Object)allowMaterialQFilter));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u67e5\u8be2\u8fc7\u6ee4\u6761\u4ef6\u5f02\u5e38\uff1a{0}", (String)"IM-E-381733", (String)"scmc-im-formplugin", (Object[])new Object[]{ExceptionUtils.getExceptionStackTraceMessage((Exception)e)}));
            }
        } else {
            allowMaterialQFilter = (QFilter)SerializationUtils.fromJsonString((String)filter, QFilter.class);
        }
        return allowMaterialQFilter;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "balanceorg": {
                break;
            }
            case "scheme": {
                DynamicObject balanceOrg = (DynamicObject)this.getModel().getValue("balanceorg");
                if (balanceOrg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5229\u5e93\u7ec4\u7ec7\u3002", (String)"IM-W-236706", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("balanceinvorg", "=", balanceOrg.getPkValue()));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        String activeKey = this.getActiveTabKey("subtabap");
        if ("balanceorg".equals(key)) {
            this.balanceOrgChanged();
        } else if ("scheme".equals(key)) {
            this.showTabByLogStep(true);
            this.refreshList(true, "billlistap", "matchlistap", "needpushlistap", "pushlistap");
        } else {
            this.setBillListFilter(activeKey, true);
        }
    }

    private void balanceOrgChanged() {
        this.getModel().beginInit();
        this.clearFieldValue("invfilter", "resultfilter", "pushfilter");
        this.getModel().endInit();
        this.setBizTimeValue();
        this.setSchemeValue(null);
    }

    private void clearFieldValue(String ... fieldApKeys) {
        IDataModel model = this.getModel();
        for (String fieldApKey : fieldApKeys) {
            Control control = this.getControl(fieldApKey);
            if (control == null) continue;
            List items = ((Container)control).getItems();
            for (Control item : items) {
                if (item instanceof DateRangeEdit) {
                    model.setValue(((DateRangeEdit)item).getStartDateFieldKey(), null);
                    model.setValue(((DateRangeEdit)item).getEndDateFieldKey(), null);
                    continue;
                }
                model.setValue(item.getKey(), null);
            }
            this.getView().updateView(fieldApKey);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btninvnext": 
            case "btnpushpre": {
                this.tabActive("subresultview", true);
                break;
            }
            case "btnviewpre": 
            case "btnpushreturn": {
                this.tabActive("subbalance", true);
                break;
            }
            case "btnviewnext": {
                this.tabActive("subpush", true);
                break;
            }
        }
    }

    private Map<Long, Set<Long>> getSelectedRowsPkValue(String listApKey) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        ListSelectedRowCollection selectedRows = this.getSelectedRows(listApKey);
        if (!selectedRows.isEmpty()) {
            List pkList = selectedRows.getPKEntryIdValues();
            for (Map map : pkList) {
                for (Map.Entry entry : map.entrySet()) {
                    Long key = (Long)entry.getKey();
                    Long value = (Long)entry.getValue();
                    result.computeIfAbsent(key, k -> new HashSet()).add(value);
                }
            }
        }
        return result;
    }

    private ListSelectedRowCollection getSelectedRows(String listApKey) {
        BillList billList = (BillList)this.getControl(listApKey);
        if (billList != null) {
            return billList.getSelectedRows();
        }
        return new ListSelectedRowCollection();
    }

    private void showInvResultConfirmTips() {
        if (!this.dataExists()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f85\u786e\u8ba4\u7684\u5229\u5e93\u7ed3\u679c\u3002", (String)"SBS-W-243386", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5229\u5e93\u7ed3\u679c\u786e\u8ba4\u540e\u751f\u6210\u5229\u5e93\u5efa\u8bae\uff0c\u4e0d\u53ef\u64a4\u9500\u3002\u786e\u8ba4\u5229\u5e93\u7ed3\u679c\u5df2\u8c03\u6574\u5b8c\u6bd5\uff1f", (String)"SBS-C-300103", (String)"scmc-im-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("invConfirm", (IFormPlugin)this));
        }
    }

    private boolean dataExists() {
        IDataModel model = this.getModel();
        String calNum = (String)model.getValue("calculatenum_fl");
        if (StringUtils.isNotEmpty((CharSequence)calNum)) {
            QFilter filter = new QFilter("calculatenum", "=", (Object)calNum).and("comfirmstatus", "=", (Object)"0").and(new QFilter("ishistory", "=", (Object)false));
            return QueryServiceHelper.exists((String)"im_balanceinv_matchdetail", (QFilter[])filter.toArray());
        }
        return false;
    }

    private DynamicObjectCollection getInvConfirmData() {
        IDataModel model = this.getModel();
        String calNum = (String)model.getValue("calculatenum_fl");
        if (StringUtils.isNotEmpty((CharSequence)calNum)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"im_balanceinv_matchdetail");
            Map propertys = entityType.getAllFields();
            StringBuilder selectedFields = new StringBuilder();
            selectedFields.append("id").append(",").append("entryentity".concat(".").concat("id"));
            for (Map.Entry entry : propertys.entrySet()) {
                if (selectedFields.length() > 0) {
                    selectedFields.append(",");
                }
                String field = (String)entry.getKey();
                IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
                if (property.getParent() instanceof EntryType) {
                    selectedFields.append("entryentity".concat(".").concat(field)).append(" as ").append(field);
                    continue;
                }
                selectedFields.append(field);
            }
            QFilter filter = new QFilter("calculatenum", "=", (Object)calNum).and("comfirmstatus", "=", (Object)"0").and(new QFilter("ishistory", "=", (Object)false));
            return QueryServiceHelper.query((String)"im_balanceinv_matchdetail", (String)selectedFields.toString(), (QFilter[])filter.toArray());
        }
        return new DynamicObjectCollection();
    }

    private String getFormFieldKey(MainEntityType billEntityType, String formFieldKey) {
        IDataEntityProperty property = billEntityType.findProperty(formFieldKey);
        if (property == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53{0}\u4e0d\u5b58\u5728\u6807\u8bc6\u4e3a\uff1a{1}\u7684\u5b57\u6bb5\u3002", (String)"IM-E-705827", (String)"scmc-im-formplugin", (Object[])new Object[]{billEntityType.getName(), formFieldKey}));
        }
        IDataEntityType parent = property.getParent();
        if (parent instanceof EntryType) {
            formFieldKey = parent.getName().concat(".").concat(formFieldKey);
        }
        return formFieldKey;
    }

    private String parseKey(String key) {
        if (key.endsWith("_fl")) {
            return key.substring(0, key.length() - "_fl".length());
        }
        if (key.endsWith("_fls")) {
            return key.substring(0, key.length() - "_fls".length());
        }
        if (key.endsWith("_fle")) {
            return key.substring(0, key.length() - "_fle".length());
        }
        return key;
    }

    private Set<Object> getMultiValuePkSet(DynamicObjectCollection collection) {
        HashSet<Object> pkValue = new HashSet<Object>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            Object pk;
            DynamicObject baseData = dynamicObject.getDynamicObject("fbasedataid");
            if (baseData == null || !((pk = baseData.get("id")) instanceof Long) || pk.equals(0L)) continue;
            pkValue.add(pk);
        }
        return pkValue;
    }

    private String getValidateMsgBeforeInv() {
        IDataModel model = this.getModel();
        DynamicObject balanceOrg = (DynamicObject)model.getValue("balanceorg");
        if (balanceOrg == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5229\u5e93\u7ec4\u7ec7\u3002", (String)"IM-W-236706", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        }
        DynamicObject scheme = (DynamicObject)model.getValue("scheme");
        if (scheme == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e73\u8861\u5229\u5e93\u65b9\u6848\u3002", (String)"IM-W-502741", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        }
        Map<Long, Set<Long>> selectRowsPk = this.getSelectedRowsPkValue("billlistap");
        if (selectRowsPk.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvCountSchemeListPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void doInvBalance() {
        IDataModel model = this.getModel();
        DynamicObject balanceOrg = (DynamicObject)model.getValue("balanceorg");
        DynamicObject scheme = (DynamicObject)model.getValue("scheme");
        Map<Long, Set<Long>> billIds = this.getSelectedRowsPkValue("billlistap");
        HashSet selectedEntryIds = new HashSet(16);
        billIds.values().forEach(o -> selectedEntryIds.addAll(o));
        QFilter filter = new QFilter("id", "in", billIds.keySet()).and("billentry.id", "in", selectedEntryIds);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"pm_requirapplybill", (String)"id, billentry.id", (QFilter[])filter.toArray());
        ArrayList<Long> entryIds = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : collection) {
            entryIds.add(dynamicObject.getLong("billentry.id"));
        }
        if (entryIds.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"IM-W-150507", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            this.refreshList(true, "billlistap");
            return;
        }
        try {
            boolean success = MutexLockHelper.getLock(balanceOrg.getString("id"), balanceOrg.getString("number"));
            if (!success) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5229\u5e93\u7ec4\u7ec7\u6b63\u5728\u8fdb\u884c\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"IM-W-337163", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        catch (Exception e) {
            throw new KDBizException("balanceOrg require lock fail\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        Long orgId = balanceOrg.getLong(BalanceInvWorkbenchLogConstant.ID);
        Long schemeId = scheme.getLong(BalanceInvWorkbenchLogConstant.ID);
        BalanceInvWorkBenchExecutor executor = new BalanceInvWorkBenchExecutor();
        Long invLogId = executor.execute(orgId, schemeId, entryIds);
        String calNum = this.queryInvLogCalNumById(invLogId);
        Long opLogId = BalanceInvWorkbenchLog.getWorkbenchLogId(RequestContext.get().getCurrUserId(), orgId, schemeId, calNum);
        model.beginInit();
        this.setCalNumValue(calNum);
        model.endInit();
        this.showExecutingForm(opLogId, invLogId);
    }

    private String queryInvLogCalNumById(Long logId) {
        String calNum = null;
        DynamicObject invLog = QueryServiceHelper.queryOne((String)"im_balanceinv_log", (String)"calcnum", (QFilter[])new QFilter("id", "=", (Object)logId).toArray());
        if (invLog != null) {
            calNum = invLog.getString("calcnum");
        }
        return calNum;
    }

    private void tabActive(String tabKey, boolean clearSelection) {
        Tab tab = (Tab)this.getView().getControl("subtabap");
        tab.activeTab(tabKey);
        this.setBillListFilter(tabKey, clearSelection);
    }

    private String getActiveTabKey(String tabKey) {
        Tab tab = (Tab)this.getView().getControl(tabKey);
        return tab.getCurrentTab();
    }

    private QFilter buildDateRangeFilter(DateRangeEdit rangeEditProp, String formFieldKey) {
        String endFieldKey;
        Object endDate;
        String startFieldKey;
        QFilter filter = null;
        IDataModel model = this.getModel();
        Object startDate = model.getValue(startFieldKey = rangeEditProp.getStartDateFieldKey());
        if (startDate != null) {
            filter = new QFilter(formFieldKey, ">=", startDate);
        }
        if ((endDate = model.getValue(endFieldKey = rangeEditProp.getEndDateFieldKey())) != null) {
            QFilter endFilter = new QFilter(formFieldKey, "<=", endDate);
            filter = filter == null ? endFilter : filter.and(endFilter);
        }
        return filter;
    }

    private QFilter buildMulComboFilter(String formFieldKey, Object value) {
        String[] values;
        QFilter filter = null;
        if (StringUtils.isNotEmpty((CharSequence)((String)value)) && (values = (String[])Arrays.stream(((String)value).split(",")).filter(str -> StringUtils.isNotEmpty((CharSequence)str)).toArray(String[]::new)).length > 0) {
            filter = new QFilter(formFieldKey, "in", (Object)values);
        }
        return filter;
    }

    private QFilter buildMulBaseDataFilter(String formFieldKey, Object value) {
        QFilter filter = null;
        DynamicObjectCollection collection = (DynamicObjectCollection)value;
        if (!collection.isEmpty()) {
            Set<Object> pk = this.getMultiValuePkSet(collection);
            filter = new QFilter(formFieldKey, "in", pk);
        }
        return filter;
    }

    private String getFormEntityNumber(String tabKey) {
        switch (tabKey) {
            case "subbalance": 
            case "billlistap": {
                return "pm_requirapplybill";
            }
            case "subresultview": 
            case "matchlistap": {
                return "im_balanceinv_matchdetail";
            }
            case "subpush": 
            case "needpush": 
            case "pushed": 
            case "needpushlistap": 
            case "pushlistap": {
                return "im_balanceinv_advice";
            }
        }
        return null;
    }

    private void setBillListFilter(String activeKey, boolean clearSelection) {
        String filterApKey = this.getFilterApKey(activeKey);
        if (StringUtils.isNotEmpty((CharSequence)filterApKey)) {
            String billListKey;
            List<QFilter> filters = this.buildFilterApFilter(filterApKey, activeKey);
            if ("invfilter".equals(filterApKey)) {
                filters.add(this.buildSchemeFilter());
            }
            if ("resultfilter".equals(filterApKey)) {
                filters.add(new QFilter("ishistory", "=", (Object)false));
            }
            if (StringUtils.isNotEmpty((CharSequence)(billListKey = this.getBillListKey(activeKey))) && !filters.isEmpty()) {
                this.updateBillList(billListKey, filters, clearSelection);
                if ("subpush".equals(activeKey)) {
                    this.updateBillList("pushlistap", filters, clearSelection);
                }
            }
        }
    }

    private String getFilterApKey(String activeKey) {
        String filterApKey = null;
        switch (activeKey) {
            case "subbalance": {
                filterApKey = "invfilter";
                break;
            }
            case "subresultview": {
                filterApKey = "resultfilter";
                break;
            }
            case "subpush": {
                filterApKey = "pushfilter";
                break;
            }
        }
        return filterApKey;
    }

    private void updateBillList(String billListKey, List<QFilter> filters, boolean clearSelection) {
        BillList billList = (BillList)this.getControl(billListKey);
        if (billList != null) {
            FilterParameter filterParameter = new FilterParameter();
            filterParameter.setQFilters(filters);
            billList.setClientQueryFilterParameter(filterParameter);
            if (clearSelection) {
                billList.clearSelection();
            }
            billList.refresh();
            if (clearSelection) {
                this.getView().updateView(billListKey);
            }
        }
    }

    private String getBillListKey(String activeKey) {
        switch (activeKey) {
            case "subbalance": {
                return "billlistap";
            }
            case "subresultview": {
                return "matchlistap";
            }
            case "subpush": {
                return "needpushlistap";
            }
        }
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        boolean refresh;
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult boxResult = evt.getResult();
        if ("invConfirm".equals(callBackId) && MessageBoxResult.Yes == boxResult) {
            Long schemeId = ((DynamicObject)this.getModel().getValue("scheme")).getLong(BalanceInvWorkbenchLogConstant.ID);
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"balanceinv_scheme", (QFilter[])new QFilter("id", "=", (Object)schemeId).and("enable", "=", (Object)"1").toArray());
            String validateMsg = this.generateValidate(scheme);
            if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93\u65b9\u6848\u6821\u9a8c\u5931\u8d25\u3002", (String)"IM-N-753288", (String)"scmc-im-formplugin", (Object[])new Object[0]), validateMsg, MessageBoxOptions.OK, null, null);
            } else {
                DynamicObjectCollection matchDetail = this.getInvConfirmData();
                if (!matchDetail.isEmpty()) {
                    BalanceInvGenResult result = new BalanceInvWbConfirm().genBalanceAdvise(matchDetail, schemeId);
                    if (!result.isSuccess()) {
                        String errorMsg = result.getErrorMsg();
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5229\u5e93\u7ed3\u679c\u786e\u8ba4\u5931\u8d25\u3002", (String)"IM-N-177656", (String)"scmc-im-formplugin", (Object[])new Object[0]), errorMsg, MessageBoxOptions.OK, null, null);
                    } else {
                        this.updateMatchDetail(((DynamicObject)matchDetail.get(0)).getLong(BalanceInvWorkbenchLogConstant.ID), result.getMatchDetailEntry());
                        Long orgId = ((DynamicObject)this.getModel().getValue("balanceorg")).getLong(BalanceInvWorkbenchLogConstant.ID);
                        this.updateWbLog(orgId, schemeId, BalanceInvWorkbenchLogConstant.STEP_PUSH);
                        this.tabActive("subpush", true);
                    }
                }
            }
        } else if ("cancelCallback".equals(callBackId) && MessageBoxResult.Yes == boxResult) {
            boolean refresh2 = this.doOperateOption("cancel");
            if (refresh2) {
                this.refreshList(true, "needpushlistap", "pushlistap");
            }
        } else if ("deleteCallback".equals(callBackId) && MessageBoxResult.Yes == boxResult && (refresh = this.doOperateOption("delete"))) {
            this.refreshList(true, "needpushlistap");
        }
    }

    private void updateMatchDetail(Object pk, Map<Long, DynamicObject> matchDetailCol) {
        DynamicObject matchDetail = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"im_balanceinv_matchdetail");
        matchDetail.set("comfirmstatus", (Object)"1");
        for (DynamicObject entry : matchDetail.getDynamicObjectCollection("entryentity")) {
            DynamicObject detail = matchDetailCol.get(entry.getLong("id"));
            if (detail == null) continue;
            entry.set("invadvice", (Object)detail.getString("invadvice"));
            entry.set("invadviceseq", (Object)detail.getInt("invadviceseq"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{matchDetail});
    }

    private void updateWbLog(Long orgId, Long schemeId, String stepStatus) {
        DynamicObject logObj = BalanceInvWorkbenchLog.queryLogObj(RequestContext.get().getCurrUserId(), orgId, schemeId, "id,step");
        if (logObj != null) {
            logObj.set(BalanceInvWorkbenchLogConstant.STEP, (Object)stepStatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
        }
    }

    private String generateValidate(DynamicObject scheme) {
        if (scheme == null) {
            return ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93\u65b9\u6848\u5df2\u88ab\u7981\u7528\u6216\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"IM-N-047717", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        }
        DynamicObjectCollection demandDsCol = scheme.getDynamicObjectCollection("demandsrcentry");
        StringBuilder errorMsg = new StringBuilder();
        for (Object demandDs : demandDsCol) {
            String srcNumber = demandDs.getDynamicObject("demandsrc").getString("number");
            if (!"pm_requirapplybill".equals(srcNumber) || !demandDs.getBoolean("deminbalanceinv")) continue;
            DynamicObject botpRuleObj = demandDs.getDynamicObject("demoutputbotp");
            if (botpRuleObj == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u9700\u6c42\u6570\u636e\u6765\u6e90\u7b2c{0}\u884c\uff0c\u751f\u6210\u8f93\u51fa\u7ed3\u679c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IM-N-737026", (String)"scmc-im-formplugin", (Object[])new Object[]{demandDs.getInt("seq")})).append("\n");
                continue;
            }
            if (!"0".equals(botpRuleObj.getString("enabled"))) continue;
            errorMsg.append(ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u9700\u6c42\u6570\u636e\u6765\u6e90\u7b2c{0}\u884c\uff0c\u751f\u6210\u8f93\u51fa\u7ed3\u679c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IM-N-473858", (String)"scmc-im-formplugin", (Object[])new Object[]{demandDs.getInt("seq")})).append("\n");
        }
        DynamicObjectCollection putParamsObj = scheme.getDynamicObjectCollection("autoputparamentry");
        for (DynamicObject putParam : putParamsObj) {
            if (!putParam.getBoolean("autoput")) continue;
            DynamicObject putBotp = putParam.getDynamicObject("autoputbotp");
            if (putBotp == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u6295\u653e\u53c2\u6570\u7b2c{0}\u884c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IM-N-668008", (String)"scmc-im-formplugin", (Object[])new Object[]{putParam.getInt("seq")})).append("\n");
                continue;
            }
            if (!"0".equals(putBotp.getString("enabled"))) continue;
            errorMsg.append(ResManager.loadKDString((String)"\u6295\u653e\u53c2\u6570\u7b2c{0}\u884c\u5355\u636e\u8f6c\u6362\u89c4\u5219\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IM-N-537353", (String)"scmc-im-formplugin", (Object[])new Object[]{putParam.getInt("seq")})).append("\n");
        }
        DynamicObject splitRule = scheme.getDynamicObject("splitrule");
        if (splitRule != null && "0".equals(splitRule.getString("enable"))) {
            errorMsg.append(ResManager.loadKDString((String)"\u9700\u6c42\u53c2\u6570\u7684\u5206\u5355\u89c4\u5219\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IM-N-522674", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        return errorMsg.toString();
    }

    private void showExecutingForm(Long benchLogId, Object balanceInvLogId) {
        if (balanceInvLogId == null || benchLogId == null) {
            return;
        }
        DynamicObject balanceInvLog = BusinessDataServiceHelper.loadSingle((Object)balanceInvLogId, (String)"im_balanceinv_log", (String)"calcnum");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("im_balanceinv_executing");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("benchLogId", benchLogId);
        params.put("balanceInvLogId", balanceInvLogId);
        params.put("balanceInvLogNum", balanceInvLog.getString("calcnum"));
        params.put("pageId", this.getView().getPageId());
        showParameter.setCustomParams(params);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "executing_progress"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object data = evt.getReturnData();
        if ("executing_progress".equals(actionId)) {
            if ("to_subresultview".equals(data)) {
                this.tabActive("subresultview", false);
            }
        } else if ("manually_adjust".equals(actionId)) {
            this.refreshList(true, "matchlistap");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "balanceinv": {
                String msg = this.getValidateMsgBeforeInv();
                if (!StringUtils.isNotEmpty((CharSequence)msg)) break;
                this.getView().showTipNotification(msg);
                args.setCancel(true);
                break;
            }
            case "confirm": {
                this.showInvResultConfirmTips();
                break;
            }
            case "delete": 
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "scmcreservequery": 
            case "push": 
            case "cancel": {
                if (!this.selectedRowsNotExists("tabpushap", opKey)) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean selectedRowsNotExists(String tabKey, String opKey) {
        String activeKey = this.getActiveTabKey(tabKey);
        String listKey = "needpush".equals(activeKey) ? "needpushlistap" : "pushlistap";
        String pushStatus = "needpush".equals(activeKey) ? "A" : "B";
        Map<Long, Set<Long>> selectedRowsPk = this.getSelectedRowsPkValue(listKey);
        if (selectedRowsPk.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImWorkbenchOpFormPlugin_20", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return true;
        }
        HashSet entryIds = new HashSet(16);
        selectedRowsPk.values().forEach(o -> entryIds.addAll(o));
        QFilter filter = new QFilter("id", "in", selectedRowsPk.keySet()).and("entryentity.id", "in", entryIds).and("entryentity.pushstatus", "=", (Object)pushStatus);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"im_balanceinv_advice", (String)"id, entryentity.id", (QFilter[])filter.toArray());
        for (DynamicObject entry : collection) {
            entryIds.remove(entry.getLong("entryentity.id"));
        }
        if (!entryIds.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"BalanceInvWoekbenchEditPlugin_9", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return true;
        }
        if ("cancel".equals(opKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u8c03\u62e8\u4e3a\u4e0d\u53ef\u9006\u64cd\u4f5c\u3002\u5982\u8bef\u64cd\u4f5c\u53d6\u6d88\u8c03\u62e8\uff0c\u53ef\u5220\u9664\u4e0b\u6e38\u5355\u636e\uff0c\u5e76\u91cd\u65b0\u5e73\u8861\u5229\u5e93\u751f\u6210\u5229\u5e93\u5efa\u8bae\u3002\u8bf7\u786e\u5b9a\u662f\u5426\u7ee7\u7eed?", (String)"IM-C-240413", (String)"scmc-im-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("cancelCallback"));
            return true;
        }
        if ("delete".equals(opKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684{0}\u5f20\u5355\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u5220\u9664\u5417\uff1f", (String)"IM-C-513006", (String)"scmc-im-formplugin", (Object[])new Object[]{selectedRowsPk.size()}), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("deleteCallback"));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        FormOperate operate = (FormOperate)e.getSource();
        OperateOption option = operate.getOption();
        switch (operateKey) {
            case "balanceinv": {
                this.doInvBalance();
                break;
            }
            case "tomatchdetail": {
                String logId = option.getVariableValue("benchLogId");
                this.toMatchDetailOp(logId);
                break;
            }
            case "manualadjust": {
                this.showAdjustmentForm();
                break;
            }
            case "scmcreservequery": 
            case "push": {
                this.doOperateOption(operateKey);
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.doOperateOption(operateKey);
                this.refreshList(false, "needpushlistap");
                break;
            }
            case "refresh": {
                this.refreshList(true, "needpushlistap", "pushlistap");
                break;
            }
            case "trackup": 
            case "trackdown": {
                break;
            }
        }
    }

    private void toMatchDetailOp(String workbenchLogId) {
        DynamicObject workbenchLog;
        if (StringUtils.isNotEmpty((CharSequence)workbenchLogId) && (workbenchLog = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(workbenchLogId), (String)BalanceInvWorkbenchLogConstant.ENTITY_NUMBER, (String)"balanceorg, scheme, calnumber")) != null) {
            DynamicObject org = workbenchLog.getDynamicObject(BalanceInvWorkbenchLogConstant.BALANCE_ORG);
            DynamicObject scheme = workbenchLog.getDynamicObject(BalanceInvWorkbenchLogConstant.SCHEME);
            String calNum = workbenchLog.getString(BalanceInvWorkbenchLogConstant.CAL_NUMBER);
            this.getModel().beginInit();
            this.setOrgDefaultValue(org);
            this.setSchemeValue(scheme);
            this.setCalNumValue(calNum);
            this.getModel().endInit();
        }
        this.tabActive("subresultview", true);
        this.clearBillListSelected("billlistap", "pushlistap", "needpushlistap");
    }

    private void clearBillListSelected(String ... keys) {
        for (String key : keys) {
            BillList billList = (BillList)this.getControl(key);
            if (billList == null) continue;
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if ("subbalance".equals(tabKey) || "subresultview".equals(tabKey) || "subpush".equals(tabKey)) {
            this.setBillListFilter(tabKey, true);
        } else if ("demandsum".equals(tabKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("pssc_reqsum_todo");
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("psscreqsum");
            this.getView().showForm(formShowParameter);
        }
    }

    private void showAdjustmentForm() {
        BillList billList = (BillList)this.getControl("matchlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"IM-W-560682", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] primaryKeys = selectedRows.getPrimaryKeyValues();
        Object[] entryKeys = selectedRows.getEntryPrimaryKeyValues();
        Object scheme = this.getModel().getValue("scheme");
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5e73\u8861\u5229\u5e93\u65b9\u6848\u201d\u3002", (String)"IM-W-355757", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        Long primaryKey = (Long)primaryKeys[0];
        Long entryKey = (Long)entryKeys[0];
        QFilter entryFilter = new QFilter("entryentity.id", "=", (Object)entryKey);
        DynamicObject selectedMatchEntry = QueryServiceHelper.queryOne((String)"im_balanceinv_matchdetail", (String)"entryentity.demandbilltype", (QFilter[])entryFilter.toArray());
        if (selectedMatchEntry == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e73\u8861\u5229\u5e93\u5339\u914d\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u6267\u884c\u624b\u5de5\u8c03\u6574\u3002", (String)"IM-E-667480", (String)"scmc-im-business", (Object[])new Object[0]));
            billList.refresh();
            return;
        }
        String demandBillType = selectedMatchEntry.getString("entryentity.demandbilltype");
        if ("invp_safestock_record".equals(demandBillType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u7c7b\u578b\u4e3a\u5b89\u5168\u5e93\u5b58\u8bb0\u5f55\u7684\u9700\u6c42\u660e\u7ec6\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u8c03\u6574\u3002", (String)"IM-E-744180", (String)"scmc-im-business", (Object[])new Object[0]));
            return;
        }
        BalanceInvAdjustmentHelper adjustmentHelper = new BalanceInvAdjustmentHelper();
        Set matchedEntryPks = adjustmentHelper.getMatchedPkEntryPks((DynamicObject)scheme, primaryKey, entryKey);
        if (matchedEntryPks.isEmpty()) {
            return;
        }
        Object balanceInvOrg = this.getModel().getValue("balanceorg");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("im_balanceinv_adjustment");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("selectedRowPk", primaryKey);
        params.put("selectedRowEntryPks", matchedEntryPks);
        params.put("scheme", ((DynamicObject)scheme).getPkValue());
        params.put("balanceorg", ((DynamicObject)balanceInvOrg).getPkValue());
        showParameter.setCustomParams(params);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "manually_adjust"));
        this.getView().showForm(showParameter);
    }

    private void refreshList(boolean clearSelection, String ... listKeys) {
        for (String listKey : listKeys) {
            BillList billList = (BillList)this.getControl(listKey);
            if (billList == null) continue;
            if (clearSelection) {
                billList.clearSelection();
            }
            billList.refresh();
        }
    }

    private boolean doOperateOption(String opKey) {
        String tabKey = this.getActiveTabKey("tabpushap");
        String listKey = "needpush".equals(tabKey) ? "needpushlistap" : "pushlistap";
        ListSelectedRowCollection selectedRows = this.getSelectedRows(listKey);
        boolean needFresh = false;
        int total = selectedRows.getPrimaryKeyValues().length;
        switch (opKey) {
            case "scmcreservequery": {
                this.reserveQuery(selectedRows);
                break;
            }
            case "push": {
                BalanceInvWbPushHelper.showPushForm(this, selectedRows);
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "delete": 
            case "cancel": {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)opKey, (String)"im_balanceinv_advice", (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)OperateOption.create());
                if (operationResult.isSuccess()) {
                    this.getView().showSuccessNotification(this.buildSuccessTipInfo(opKey));
                    needFresh = true;
                    break;
                }
                List<String> errorMsg = this.getBillOperateErrorMsg(operationResult);
                if (errorMsg.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u751f\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BalanceInvWoekbenchEditPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (total == 1 && errorMsg.size() == 1) {
                    this.getView().showTipNotification(errorMsg.get(0));
                    break;
                }
                int success = operationResult.getSuccessPkIds().size();
                this.showErrorForm(total, success, operationResult.getBillNos(), this.getOpName(opKey), errorMsg);
                needFresh = success > 0;
                break;
            }
        }
        return needFresh;
    }

    private List<String> getBillOperateErrorMsg(OperationResult operateResult) {
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        List allErrorOrValidateInfo = operateResult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo != null && !allErrorOrValidateInfo.isEmpty()) {
            for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                errorMsg.add(operateInfo.getMessage());
            }
        }
        if (errorMsg.isEmpty() && StringUtils.isNotEmpty((CharSequence)operateResult.getMessage())) {
            errorMsg.add(operateResult.getMessage());
        }
        return errorMsg;
    }

    private void showErrorForm(int total, int success, Map<Object, String> billNos, String opName, List<String> errorMsg) {
        String title = this.buildTitle(total, success, errorMsg.size(), billNos, opName);
        HashMap<String, Object> msgInfo = new HashMap<String, Object>(4);
        msgInfo.put("hasMore", false);
        msgInfo.put("title", title);
        msgInfo.put("errorMsg", errorMsg);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(false);
        showParameter.setAppId("im");
        showParameter.setFormId("bos_operationresult");
        showParameter.setCustomParams(msgInfo);
        this.getView().showForm(showParameter);
    }

    private String buildTitle(int total, int success, int errorInfoSize, Map<Object, String> billNos, String opName) {
        if (total == 1 && errorInfoSize > 1) {
            String billNo = billNos.values().stream().findFirst().get();
            return "\u201c" + billNo + "\u201d" + opName + ResManager.loadKDString((String)"\u5931\u8d25", (String)"BalanceInvWoekbenchEditPlugin_8", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c{1}\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761\u3002", (String)"BalanceInvWoekbenchEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[]{total, opName, success, total - success});
    }

    private String buildSuccessTipInfo(String opKey) {
        String opName = this.getOpName(opKey);
        if (opName == null || StringUtils.isEmpty((CharSequence)opName)) {
            return ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"InvInspectBillEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        }
        return opName.concat(ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"BalanceInvWoekbenchEditPlugin_10", (String)"scmc-im-formplugin", (Object[])new Object[0]));
    }

    private String getOpName(String opKey) {
        String opName = null;
        switch (opKey) {
            case "delete": {
                opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"BalanceInvWoekbenchEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                break;
            }
            case "submit": {
                opName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"BalanceInvWoekbenchEditPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                break;
            }
            case "unsubmit": {
                opName = ResManager.loadKDString((String)"\u64a4\u9500", (String)"BalanceInvWoekbenchEditPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                break;
            }
            case "audit": {
                opName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"BalanceInvWoekbenchEditPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                break;
            }
            case "unaudit": {
                opName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"BalanceInvWoekbenchEditPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                break;
            }
            case "cancel": {
                opName = ResManager.loadKDString((String)"\u53d6\u6d88\u8c03\u62e8", (String)"BalanceInvWoekbenchEditPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return opName;
    }

    private void reserveQuery(ListSelectedRowCollection selectedRows) {
        Object[] pkValues = selectedRows.getPrimaryKeyValues();
        Long[] pk = (Long[])Arrays.stream(pkValues).toArray(Long[]::new);
        QFilter fs = null;
        Set<Object> billIds = this.getBOTPLinkBillIds("im_balanceinv_advice", pk);
        QFilter billIdFilter = new QFilter("bill_id", "in", billIds);
        QFilter balIdFilter = new QFilter("bal_id", "in", billIds);
        fs = balIdFilter.or(billIdFilter);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setBillFormId("msmod_reserve_record");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getListFilterParameter().setFilter(fs);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Set<Object> getBOTPLinkBillIds(String billName, Long[] billIdArray) {
        HashSet<Object> ids = new HashSet<Object>(16);
        Map srcBills = BFTrackerServiceHelper.findSourceBills((String)billName, (Long[])billIdArray);
        for (HashSet srcId : srcBills.values()) {
            ids.addAll(srcId);
        }
        ids.addAll(Arrays.asList(billIdArray));
        return ids;
    }
}

