/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv.workbenches.adjustment;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balanceinv.workbench.executor.BalanceInvAdjustResultExecutor;
import kd.scmc.im.business.balanceinv.workbench.helper.BalanceInvAdjustmentHelper;

public class BalanceInvAdjustmentEditPlugin
extends AbstractFormPlugin {
    public static final Log log = LogFactory.getLog(BalanceInvAdjustmentEditPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            this.initAdjustmentData();
        }
        catch (Exception ex) {
            log.error("\u521d\u59cb\u5316\u624b\u5de5\u8c03\u6574\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u624b\u5de5\u8c03\u6574\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7\u3002", (String)"IM-E-524602", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
    }

    private void initAdjustmentData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            this.getView().close();
            return;
        }
        Object selectedRowPk = customParams.get("selectedRowPk");
        Object selectedRowEntryPks = customParams.get("selectedRowEntryPks");
        if (selectedRowPk == null || selectedRowEntryPks == null) {
            this.getView().close();
            return;
        }
        Long selectedRowPkValue = (Long)selectedRowPk;
        JSONArray array = (JSONArray)selectedRowEntryPks;
        Set selectedRowEntryPkValues = array.stream().map(value -> (Long)value).collect(Collectors.toSet());
        BalanceInvAdjustmentHelper balanceInvAdjustmentHelper = new BalanceInvAdjustmentHelper();
        balanceInvAdjustmentHelper.initAdjustmentData(this.getModel(), selectedRowPkValue, selectedRowEntryPkValues);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        int rowIndex = changeSet[0].getRowIndex();
        switch (propName) {
            case "adjustbaseqty": {
                this.changeAdjustQty(newValue, oldValue, rowIndex, true);
                break;
            }
            case "purdemandbaseqty": {
                this.changeAdjustQty(newValue, oldValue, rowIndex, false);
                break;
            }
        }
    }

    private void changeAdjustQty(Object newValue, Object oldValue, int rowIndex, boolean isAdjustQtyChanged) {
        Object demandBaseQty = this.getModel().getValue("demandbaseqty", rowIndex);
        BigDecimal demandBaseQtyValue = (BigDecimal)demandBaseQty;
        BigDecimal adjustBaseQty = (BigDecimal)newValue;
        String validateQtyKey = "adjustbaseqty";
        String updateQtyKey = "purdemandbaseqty";
        String adjustBaseQtyStr = ResManager.loadKDString((String)"\u8c03\u6574\u57fa\u672c\u6570\u91cf", (String)"IM-D-447853", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        if (!isAdjustQtyChanged) {
            validateQtyKey = "purdemandbaseqty";
            updateQtyKey = "adjustbaseqty";
            adjustBaseQtyStr = ResManager.loadKDString((String)"\u51c0\u9700\u6c42\u57fa\u672c\u6570\u91cf", (String)"IM-D-788533", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        }
        if (demandBaseQtyValue.compareTo(adjustBaseQty) < 0 || BigDecimal.ZERO.compareTo(adjustBaseQty) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c{0}\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u9700\u6c42\u57fa\u672c\u6570\u91cf\u201d\u4e14\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"IM-E-361415", (String)"scmc-im-formplugin", (Object[])new Object[]{adjustBaseQtyStr}));
            this.getModel().beginInit();
            this.getModel().setValue(validateQtyKey, oldValue, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(validateQtyKey, rowIndex);
            return;
        }
        BigDecimal purDemandBaseQty = demandBaseQtyValue.subtract(adjustBaseQty);
        this.getModel().beginInit();
        this.getModel().setValue(updateQtyKey, (Object)purDemandBaseQty, rowIndex);
        this.getModel().endInit();
        this.getView().updateView(updateQtyKey, rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && this.canDoReBalanceInv()) {
            this.doReBalanceInv();
            this.getView().close();
        }
    }

    private void doReBalanceInv() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return;
        }
        Object selectedRowPk = customParams.get("selectedRowPk");
        Object selectedRowEntryPks = customParams.get("selectedRowEntryPks");
        Object balanceInvSchemeId = customParams.get("scheme");
        Object balanceInvOrgId = customParams.get("balanceorg");
        if (selectedRowPk == null || selectedRowEntryPks == null || balanceInvSchemeId == null || balanceInvOrgId == null) {
            return;
        }
        Long matchDetailId = (Long)selectedRowPk;
        Long balanceInvSchemeIdValue = (Long)balanceInvSchemeId;
        Long balanceInvOrgIdValue = Long.valueOf(balanceInvOrgId.toString());
        JSONArray array = (JSONArray)selectedRowEntryPks;
        List<Long> matchDetailEntryIds = array.stream().map(value -> (Long)value).collect(Collectors.toList());
        Map<Long, Map<String, Object>> demandEntryInfoMap = this.getDemandEntryInfoMap();
        if (demandEntryInfoMap.isEmpty()) {
            return;
        }
        Map<String, Map<Long, Map<String, Object>>> supplyEntryInfoMap = this.getSupplyEntryInfoMap(matchDetailEntryIds, demandEntryInfoMap.keySet());
        BalanceInvAdjustResultExecutor executor = new BalanceInvAdjustResultExecutor(balanceInvOrgIdValue, balanceInvSchemeIdValue, matchDetailId);
        executor.execute(demandEntryInfoMap, supplyEntryInfoMap, matchDetailEntryIds);
    }

    private Map<String, Map<Long, Map<String, Object>>> getSupplyEntryInfoMap(List<Long> matchDetailEntryIds, Set<Long> demandBillEntryIdSet) {
        HashMap<String, Map<Long, Map<String, Object>>> supplyEntryInfoMap = new HashMap<String, Map<Long, Map<String, Object>>>(matchDetailEntryIds.size());
        QFilter filter = new QFilter("entryentity.id", "in", matchDetailEntryIds);
        filter.and("entryentity.demandentryid", "in", demandBillEntryIdSet);
        DataSet matchDetailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_balanceinv_matchdetail", (String)"entryentity.id entryid,entryentity.advicetype advicetype,entryentity.supplybillentryid supplybillentryid,entryentity.supplybilltype supplybilltype,entryentity.matchbaseqty matchbaseqty", (QFilter[])filter.toArray(), null);
        matchDetailEntryIds.clear();
        for (Row row : matchDetailDataSet) {
            Long entryId = row.getLong("entryid");
            matchDetailEntryIds.add(entryId);
            String adviceType = row.getString("advicetype");
            if ("F".equals(adviceType) || "A".equals(adviceType)) continue;
            Long supplyBillEntryId = row.getLong("supplybillentryid");
            String supplyBillType = row.getString("supplybilltype");
            BigDecimal srcSupplyBaseQty = row.getBigDecimal("matchbaseqty");
            Map supplyEntryIdToQtyInfoMap = supplyEntryInfoMap.computeIfAbsent(supplyBillType, type -> new HashMap(8));
            Map qtyInfoMap = supplyEntryIdToQtyInfoMap.computeIfAbsent(supplyBillEntryId, id -> new HashMap(4));
            BigDecimal supplyQty = qtyInfoMap.getOrDefault("supplyqty", BigDecimal.ZERO);
            BigDecimal supplyQtySum = supplyQty.add(srcSupplyBaseQty);
            qtyInfoMap.put("supplyqty", supplyQtySum);
        }
        return supplyEntryInfoMap;
    }

    private Map<Long, Map<String, Object>> getDemandEntryInfoMap() {
        HashMap<Long, Map<String, Object>> demandEntryInfoMap = new HashMap<Long, Map<String, Object>>(16);
        DynamicObjectCollection demandEntries = this.getModel().getEntryEntity("demandentry");
        if (demandEntries == null || demandEntries.isEmpty()) {
            return demandEntryInfoMap;
        }
        for (DynamicObject demandEntry : demandEntries) {
            BigDecimal matchBaseQty;
            Long demandBillEntryId = demandEntry.getLong("demandbillentryid");
            BigDecimal adjustBaseQty = demandEntry.getBigDecimal("adjustbaseqty");
            if (adjustBaseQty.compareTo(matchBaseQty = demandEntry.getBigDecimal("matchbaseqty")) == 0) continue;
            Map qtyMap = demandEntryInfoMap.computeIfAbsent(demandBillEntryId, id -> new HashMap(8));
            BigDecimal purDemandBaseQty = demandEntry.getBigDecimal("purdemandbaseqty");
            qtyMap.put("adjustedqty", adjustBaseQty);
            qtyMap.put("puredemandqty", purDemandBaseQty);
        }
        return demandEntryInfoMap;
    }

    private boolean canDoReBalanceInv() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return false;
        }
        Object selectedRowPk = customParams.get("selectedRowPk");
        boolean matchDetailExists = QueryServiceHelper.exists((String)"im_balanceinv_matchdetail", selectedRowPk);
        if (!matchDetailExists) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e73\u8861\u5229\u5e93\u5339\u914d\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u6267\u884c\u624b\u5de5\u8c03\u6574\u3002", (String)"IM-E-667480", (String)"scmc-im-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

