/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv.workbenches.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.BillTypeMapParser;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.ConvertRuleKeyPair;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.OpInfo;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.util.CollectionUtils;

public class BalanceInvWbPushHelper {
    public static void showPushForm(AbstractFormPlugin formPlugin, ListSelectedRowCollection selectedRows) {
        String opParameterJson = SerializationUtils.toJsonString((Object)BalanceInvWbPushHelper.buildParameter(selectedRows));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_convertop");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("opinfo", SerializationUtils.toJsonString((Object)BalanceInvWbPushHelper.getOpInfo()));
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"IM-N-215426", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "pushFormClose"));
        formPlugin.getView().showForm(showParameter);
    }

    private static ConvertOpParameter buildParameter(ListSelectedRowCollection selectedRows) {
        ConvertOpParameter opParameter = new ConvertOpParameter();
        opParameter.setOpType(ConvertOpType.Push);
        opParameter.setAppId("im");
        opParameter.setEntityNumber("im_balanceinv_advice");
        List<ConvertBill> bills = BalanceInvWbPushHelper.loadTargetBills();
        if (bills != null) {
            opParameter.getBills().addAll(bills);
        }
        opParameter.setSelectedRows(selectedRows);
        opParameter.setOpInfo(BalanceInvWbPushHelper.getOpInfo());
        return opParameter;
    }

    private static OpInfo getOpInfo() {
        OpInfo opInfo = new OpInfo();
        opInfo.setOpKey("push");
        LocaleString name = new LocaleString(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"IM-N-215426", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        opInfo.setOpName(name);
        opInfo.setOpType("push");
        return opInfo;
    }

    private static List<ConvertBill> loadTargetBills() {
        ArrayList<ConvertBill> list = new ArrayList<ConvertBill>(10);
        String sourceEntityNumber = "im_balanceinv_advice";
        List bills = null;
        bills = ConvertMetaServiceHelper.loadConvertBills((String)sourceEntityNumber, (ConvertOpType)ConvertOpType.Push);
        if (CollectionUtils.isEmpty((Collection)bills)) {
            return bills;
        }
        ArrayList<ConvertRuleKeyPair> crKeys = new ArrayList<ConvertRuleKeyPair>(bills.size());
        for (ConvertBill bill : bills) {
            ConvertRuleKeyPair crKey = new ConvertRuleKeyPair(sourceEntityNumber, bill.getEntityNumber());
            crKeys.add(crKey);
        }
        Map allRules = ConvertRuleCache.batchLoadRules(crKeys);
        HashSet<Long> srcBillTypeIds = new HashSet<Long>(16);
        for (ConvertBill bill : bills) {
            List<ConvertOpRule> opRules = BalanceInvWbPushHelper.filterRules(bill, srcBillTypeIds, allRules);
            if (opRules.isEmpty()) continue;
            bill.getRules().addAll(opRules);
            list.add(bill);
        }
        return list;
    }

    private static List<ConvertOpRule> filterRules(ConvertBill bill, Set<Long> srcBillTypeIds, Map<ConvertRuleKeyPair, List<ConvertRuleElement>> allRules) {
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>(10);
        String sourceEntityNumber = "im_balanceinv_advice";
        List<ConvertRuleElement> rules = BalanceInvWbPushHelper.loadRules(sourceEntityNumber, bill.getEntityNumber(), allRules);
        if (rules.isEmpty()) {
            return opRules;
        }
        boolean existBillTypePolicy = false;
        if (srcBillTypeIds != null && !srcBillTypeIds.isEmpty()) {
            for (ConvertRuleElement rule : rules) {
                if (!rule.isNormual() || rule.getBillTypeMapPolicy().getItems().isEmpty()) continue;
                existBillTypePolicy = true;
                break;
            }
        }
        if (existBillTypePolicy) {
            return BalanceInvWbPushHelper.filterBillType(bill, rules, srcBillTypeIds);
        }
        for (ConvertRuleElement rule : rules) {
            if (!rule.isNormual() || !rule.isVisibled()) continue;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            opRules.add(opRule);
        }
        return opRules;
    }

    private static List<ConvertRuleElement> loadRules(String sourceEntityNumber, String targetEntityNumber, Map<ConvertRuleKeyPair, List<ConvertRuleElement>> allRules) {
        ConvertRuleKeyPair key = new ConvertRuleKeyPair(sourceEntityNumber, targetEntityNumber);
        List<ConvertRuleElement> rules = allRules.get(key);
        if (rules == null) {
            return new ArrayList<ConvertRuleElement>(0);
        }
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isNormual()) continue;
            enableRules.add(rule);
        }
        return enableRules;
    }

    private static List<ConvertOpRule> filterBillType(ConvertBill bill, List<ConvertRuleElement> rules, Set<Long> srcBillTypeIds) {
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)bill.getEntityNumber());
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>();
        IDataEntityProperty targetBillTypeProp = null;
        if (targetMainType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)targetMainType).getBillType())) {
            targetBillTypeProp = targetMainType.findProperty(((BillEntityType)targetMainType).getBillType());
        }
        Map<Object, DynamicObject> objMap = null;
        DynamicObject[] targetBillTypeObjs = null;
        if (targetBillTypeProp != null) {
            objMap = BalanceInvWbPushHelper.loadTargetBillTypeObjs(targetMainType.getName());
            targetBillTypeObjs = objMap.values().toArray(new DynamicObject[0]);
        }
        BillTypeMapParser parser = new BillTypeMapParser();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isNormual() || !rule.isVisibled()) continue;
            boolean enabled = false;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            if (srcBillTypeIds.isEmpty() || targetBillTypeProp == null) {
                enabled = true;
            } else {
                for (Long srcBillTypeId : srcBillTypeIds) {
                    parser.tryGetTargetBillTypeIds(rule.getBillTypeMapPolicy(), srcBillTypeId, targetBillTypeObjs);
                    if (parser.isCannotPushAnyOne()) continue;
                    if (parser.isCanPushAll()) {
                        enabled = true;
                        opRule.setAllBillType(true);
                        opRule.getInvalidBillTypeIds().addAll(parser.getOutCannotPushBillTypeIds());
                        opRule.getBillTypeIds().addAll(parser.getOutBillTypeIds());
                        break;
                    }
                    if (parser.getOutBillTypeIds().isEmpty()) continue;
                    enabled = true;
                    opRule.setDefBillType((Long)parser.getOutBillTypeIds().get(0));
                    opRule.getBillTypeIds().addAll(parser.getOutBillTypeIds());
                    break;
                }
            }
            if (!enabled) continue;
            opRules.add(opRule);
        }
        return opRules;
    }

    private static Map<Object, DynamicObject> loadTargetBillTypeObjs(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return new HashMap<Object, DynamicObject>();
        }
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)entityNumber)};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name, status, enable, isdefault", (QFilter[])filters);
    }
}

