/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateTargetEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.mpscmm.msbd.expense.business.helper.ExpenseBillHelper;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractInvToApCarryExpenseConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(AbstractInvToApCarryExpenseConvertPlugin.class);
    private Map<Long, DynamicObject> srcMap = new HashMap<Long, DynamicObject>(4);
    private MultiValuedMap<Long, DynamicObject> srcExpenseMap = new HashSetValuedHashMap(4);
    protected Map<Object, DynamicObject> taxRateMap = new HashMap<Object, DynamicObject>(4);

    protected abstract String getEntryName();

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("billentry.id");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        List sourceRows = e.getSourceRows();
        if (sourceRows.isEmpty()) {
            return;
        }
        HashSet<Long> srcBillIds = new HashSet<Long>(4);
        for (DynamicObject sourceRow : sourceRows) {
            srcBillIds.add(sourceRow.getLong("id"));
            Long srcEntryId = (Long)((DynamicProperty)e.getFldProperties().get("billentry.id")).getValue((Object)sourceRow);
            this.srcMap.put(srcEntryId, sourceRow);
        }
        Map expenseMap = ExpenseBillHelper.getExpenseByBillIds(srcBillIds);
        if (null == expenseMap || expenseMap.isEmpty()) {
            return;
        }
        this.srcExpenseMap = this.getSrcExpenseMap(expenseMap.values());
        RequestContext requestContext = RequestContext.get();
        if (null != requestContext && StringUtils.contains((CharSequence)requestContext.getQueryString(), (CharSequence)"botp_convertop")) {
            return;
        }
        Iterator iterator = sourceRows.iterator();
        while (iterator.hasNext()) {
            DynamicObject entryRow = (DynamicObject)iterator.next();
            Long srcEntryId = (Long)((DynamicProperty)e.getFldProperties().get("billentry.id")).getValue((Object)entryRow);
            if (this.srcExpenseMap.containsKey((Object)srcEntryId)) continue;
            iterator.remove();
        }
    }

    public void afterCreateTarget(AfterCreateTargetEventArgs e) {
        super.afterCreateTarget(e);
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] extBillEntities = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType);
        ExtendedDataEntity[] extEntryEntities = e.getTargetExtDataEntitySet().FindByEntityKey(this.getEntryName());
        int idSize = extBillEntities.length + extEntryEntities.length;
        long[] newIds = DB.genGlobalLongIds((int)idSize);
        int idx = 0;
        for (ExtendedDataEntity extendedDataEntity : extBillEntities) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            bill.set("id", (Object)newIds[idx++]);
            DynamicObjectCollection entryRows = bill.getDynamicObjectCollection(this.getEntryName());
            for (DynamicObject entryRow : entryRows) {
                entryRow.set("id", (Object)newIds[idx++]);
            }
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        if (this.srcExpenseMap.isEmpty()) {
            log.info("\u6ca1\u6709\u8d39\u7528\u6e05\u5355\uff0c\u4e0d\u9700\u8981\u6267\u884c\u5206\u5355\u8d4b\u503c\u903b\u8f91");
            return;
        }
        try {
            this.doAfterFieldMapping(e);
        }
        catch (Exception err) {
            log.error("\u5355\u636e\u8f6c\u6362\u5931\u8d25\uff1a", (Throwable)err);
        }
    }

    private void doAfterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        BidiMap<Long, Long> tgtSrcMap = this.getTgtSrcEntryMap(e);
        MultiValuedMap<Long, DynamicObject> targetExpenseMap = this.getTargetExpenseMap(this.srcExpenseMap, tgtSrcMap);
        this.loadTaxRateMap();
        String targetEntityKey = this.getTgtMainType().getName();
        ExtendedDataEntity[] targetDataList = targetExtDataEntitySet.FindByEntityKey(targetEntityKey);
        long[] newIds = DB.genGlobalLongIds((int)(this.srcExpenseMap.values().size() * 2));
        int idx = 0;
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(4);
        HashMap<Map<String, Object>, DynamicObject> splitBillMap = new HashMap<Map<String, Object>, DynamicObject>(4);
        HashSetValuedHashMap validateTargetBillIds = new HashSetValuedHashMap(targetDataList.length);
        for (ExtendedDataEntity targetData : targetDataList) {
            DynamicObject targetBill = targetData.getDataEntity();
            DynamicObjectCollection targetEntryRows = targetBill.getDynamicObjectCollection(this.getEntryName());
            int length = targetEntryRows.size();
            for (int rowIdx = 0; rowIdx < length; ++rowIdx) {
                DynamicObject targetEntryRow = (DynamicObject)targetEntryRows.get(rowIdx);
                Long targetEntryId = targetEntryRow.getLong("id");
                Collection expenseList = targetExpenseMap.get((Object)targetEntryId);
                if (null == expenseList) {
                    validateTargetBillIds.put((Object)targetBill.getLong("id"), (Object)targetEntryId);
                    continue;
                }
                for (DynamicObject expense : expenseList) {
                    DynamicObject splitBillEntry;
                    DynamicObjectCollection collection;
                    Long targetBillId = targetBill.getLong("id");
                    Map<String, Object> groupKey = this.buildGroupKey(e, expense);
                    groupKey.put("billid", targetBillId);
                    if (splitBillMap.containsKey(groupKey)) {
                        DynamicObject bill = (DynamicObject)splitBillMap.get(groupKey);
                        collection = bill.getDynamicObjectCollection(this.getEntryName());
                        DynamicObject row = (DynamicObject)collection.get(rowIdx);
                        splitBillEntry = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)row);
                        splitBillEntry.set("id", (Object)newIds[idx++]);
                        collection.add((Object)splitBillEntry);
                        this.buildEntryLink(splitBillEntry, expense);
                    } else if (validateTargetBillIds.containsKey((Object)targetBillId)) {
                        DynamicObject splitBill = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)targetBill);
                        splitBill.set("id", (Object)newIds[idx++]);
                        collection = splitBill.getDynamicObjectCollection(this.getEntryName());
                        DynamicObject newSplitBill = (DynamicObject)collection.get(rowIdx);
                        newSplitBill.set("id", (Object)newIds[idx++]);
                        splitBillEntry = newSplitBill;
                        this.buildEntryLink(splitBillEntry, expense);
                        splitBillMap.put(groupKey, splitBill);
                        dataEntityList.add(new ExtendedDataEntity(splitBill, dataEntityList.size(), 0));
                    } else {
                        splitBillEntry = targetEntryRow;
                        splitBillMap.put(groupKey, targetBill);
                    }
                    Long bid = ((DynamicObject)splitBillEntry.getParent()).getLong("id");
                    Long eid = splitBillEntry.getLong("id");
                    validateTargetBillIds.put((Object)bid, (Object)eid);
                    this.fillExpenseData(splitBillEntry, expense);
                }
            }
        }
        if (!dataEntityList.isEmpty()) {
            targetExtDataEntitySet.AddExtendedDataEntities(targetEntityKey, dataEntityList);
        }
        this.removeInvalidationData(targetExtDataEntitySet, (MultiValuedMap<Long, Long>)validateTargetBillIds);
    }

    private void loadTaxRateMap() {
        if (this.srcExpenseMap.isEmpty()) {
            return;
        }
        HashSet<Object> ids = new HashSet<Object>(4);
        for (DynamicObject expenseEntryRow : this.srcExpenseMap.values()) {
            DynamicObject taxRateDym = expenseEntryRow.getDynamicObject("r_taxrate");
            if (null == taxRateDym) continue;
            ids.add(taxRateDym.getPkValue());
        }
        if (ids.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("id", "in", ids);
        this.taxRateMap = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])filter.toArray());
    }

    private void buildEntryLink(DynamicObject splitBillEntry, DynamicObject expense) {
        Long srcEntryId = expense.getLong("r_bizentryid");
        DynamicObject srcDym = this.srcMap.get(srcEntryId);
        Long srcBillId = srcDym.getLong("id");
        String sourceBillType = this.getSrcMainType().getName();
        Long srcTableId = ConvertMetaServiceHelper.loadTableDefine((String)sourceBillType, (String)"billentry").getTableId();
        String lkName = this.getEntryName() + "_lk";
        DynamicObjectCollection linkRows = (DynamicObjectCollection)splitBillEntry.get(lkName);
        DynamicObject linkRow = linkRows.addNew();
        linkRow.set(lkName + "_stableid", (Object)srcTableId);
        linkRow.set(lkName + "_sbillid", (Object)srcBillId);
        linkRow.set(lkName + "_sid", (Object)srcEntryId);
    }

    private void removeInvalidationData(ExtendedDataEntitySet targetExtDataEntitySet, MultiValuedMap<Long, Long> validateTargetBillIds) {
        ExtendedDataEntity[] dataEntities;
        String targetEntityKey = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : dataEntities = targetExtDataEntitySet.FindByEntityKey(targetEntityKey)) {
            DynamicObject targetBill = dataEntity.getDataEntity();
            Long billId = targetBill.getLong("id");
            DynamicObjectCollection rows = targetBill.getDynamicObjectCollection(this.getEntryName());
            Iterator iterator = rows.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                Long entryId = row.getLong("id");
                if (validateTargetBillIds.containsMapping((Object)billId, (Object)entryId)) continue;
                iterator.remove();
            }
        }
    }

    private MultiValuedMap<Long, DynamicObject> getTargetExpenseMap(MultiValuedMap<Long, DynamicObject> srcExpenseMap, BidiMap<Long, Long> tgtSrcMap) {
        HashSetValuedHashMap targetExpenseMap = new HashSetValuedHashMap();
        for (Map.Entry entry : tgtSrcMap.entrySet()) {
            Long targetEntryId = (Long)entry.getKey();
            Long srcEntryId = (Long)entry.getValue();
            Collection expenseList = srcExpenseMap.get((Object)srcEntryId);
            if (null == expenseList) continue;
            targetExpenseMap.putAll((Object)targetEntryId, (Iterable)expenseList);
        }
        return targetExpenseMap;
    }

    private MultiValuedMap<Long, DynamicObject> getSrcExpenseMap(Collection<DynamicObject> expenseBillList) {
        HashSetValuedHashMap srcExpenseMap = new HashSetValuedHashMap(4);
        for (DynamicObject expenseBill : expenseBillList) {
            DynamicObjectCollection entryRows = expenseBill.getDynamicObjectCollection("rowexpenseentry");
            if (entryRows.isEmpty()) continue;
            for (DynamicObject entryRow : entryRows) {
                Long srcEntryId = entryRow.getLong("r_bizentryid");
                if (null == srcEntryId) continue;
                srcExpenseMap.put((Object)srcEntryId, (Object)entryRow);
            }
        }
        return srcExpenseMap;
    }

    private Map<String, Object> buildGroupKey(AfterFieldMappingEventArgs e, DynamicObject expenseEntry) {
        HashMap<String, Object> groupKey = new HashMap<String, Object>(4);
        Long srcEntryId = expenseEntry.getLong("r_bizentryid");
        DynamicObject srcEntry = this.srcMap.get(srcEntryId);
        String groupByField = this.getRule().getGroupByPolicy().getGroupByField();
        if (null != srcEntry && StringUtils.isNotBlank((CharSequence)groupByField)) {
            String[] fields;
            for (String field : fields = groupByField.split(",")) {
                Object obj = ((DynamicProperty)e.getFldProperties().get(field)).getValue((Object)srcEntry);
                groupKey.put(field, obj);
            }
        }
        Long orgId = expenseEntry.getLong("r_expssup.id");
        Long currencyId = expenseEntry.getLong("r_currency.id");
        if (null == currencyId) {
            currencyId = 0L;
        }
        Boolean isincludetax = expenseEntry.getBoolean("r_istax");
        groupKey.put("receivingsupplierid", orgId);
        groupKey.put("currency", currencyId);
        groupKey.put("isincludetax", isincludetax);
        return groupKey;
    }

    protected abstract void fillExpenseData(DynamicObject var1, DynamicObject var2);

    private BidiMap<Long, Long> getTgtSrcEntryMap(AfterFieldMappingEventArgs e) {
        TreeBidiMap entryIdMap = new TreeBidiMap();
        ExtendedDataEntitySet dataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] targetEntryRows = dataEntitySet.FindByEntityKey(this.getEntryName());
        if (0 == targetEntryRows.length) {
            return entryIdMap;
        }
        for (ExtendedDataEntity targetEntryRow : targetEntryRows) {
            DynamicObject targetBillRow = targetEntryRow.getDataEntity();
            Long targetEntryId = (Long)targetBillRow.getPkValue();
            List srcEntryRows = (List)targetEntryRow.getValue("ConvertSource");
            if (null == srcEntryRows || srcEntryRows.isEmpty()) continue;
            for (DynamicObject srcRow : srcEntryRows) {
                Long srcEntryId = (Long)((DynamicProperty)e.getFldProperties().get("billentry.id")).getValue((Object)srcRow);
                entryIdMap.put((Object)targetEntryId, (Object)srcEntryId);
            }
        }
        return entryIdMap;
    }
}

