/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.InvBillCalcHelper;
import kd.scmc.im.business.helper.MetaDataHelper;

public class InvCountBillBotpPlugin
extends AbstractConvertPlugIn {
    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        String name;
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        List sourceRows = e.getSourceRows();
        BillEntityType tgtMainType2 = this.getTgtMainType();
        switch (name = tgtMainType2.getName()) {
            case "im_surplusbill": {
                this.resetBaseQty("basegainqty", "serialgainqty", "serialunitrate", fldProperties, sourceRows);
                break;
            }
            case "im_deficitbill": {
                this.resetBaseQty("baselossqty", "seriallossqty", "serialunitrate", fldProperties, sourceRows);
            }
        }
    }

    private void resetBaseQty(String baseDifqty, String serialDifqty, String serialunitrate, Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows) {
        String baseqtyField = "";
        String serialqtyField = "";
        String serialunitRateField = "";
        for (Map.Entry<String, DynamicProperty> map : fldProperties.entrySet()) {
            String key = map.getKey();
            DynamicProperty value = map.getValue();
            if (key.equals(baseDifqty)) {
                baseqtyField = value.getName();
                continue;
            }
            if (key.equals(serialDifqty)) {
                serialqtyField = value.getName();
                continue;
            }
            if (!key.equals(serialunitrate)) continue;
            serialunitRateField = value.getName();
        }
        for (int i = 0; i < sourceRows.size(); ++i) {
            DynamicObject dynamicObject = sourceRows.get(i);
            BigDecimal serialunitRate = dynamicObject.getBigDecimal(serialunitRateField);
            if (BigDecimal.ZERO.compareTo(serialunitRate) == 0) continue;
            BigDecimal serialqty = dynamicObject.getBigDecimal(serialqtyField).multiply(serialunitRate);
            dynamicObject.set(baseqtyField, (Object)serialqty);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        for (int i = 0; i < entitys.length; ++i) {
            DynamicObject bill = entitys[i].getDataEntity();
            this.initBillHeadLogic(bill);
        }
    }

    private void initBillHeadLogic(DynamicObject bill) {
        if (MetaDataHelper.isExistField((IDataEntityType)bill.getDataEntityType(), (String)"settlecurrency")) {
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)((DynamicObject)bill.get("org")).getPkValue()));
            if (map == null) {
                return;
            }
            DynamicObject currency = BusinessDataServiceHelper.loadSingle(map.get("baseCurrencyID"), (String)"bd_currency");
            bill.set("settlecurrency", (Object)currency);
        }
    }

    private void initBillEntryLogic(DynamicObject bill) {
        String tgtMainTypeName = this.getTgtMainType().getName();
        DynamicObjectCollection entrycols = bill.getDynamicObjectCollection("billentry");
        if (entrycols.size() > 0) {
            if ("im_otherinbill".equalsIgnoreCase(tgtMainTypeName)) {
                InvBillCalcHelper.qtyCalc((DynamicObjectCollection)entrycols, (String)tgtMainTypeName);
            }
            if ("im_otheroutbill".equalsIgnoreCase(tgtMainTypeName)) {
                InvBillCalcHelper.qtyCalc((DynamicObjectCollection)entrycols, (String)tgtMainTypeName);
            }
        }
    }
}

