/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.enums.PrecisionAccountEnum;
import org.apache.commons.lang3.StringUtils;

public class InvPlanOrderBotpPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(InvPlanOrderBotpPlugin.class);
    private Map<Long, DynamicObject> currencyCache = new HashMap<Long, DynamicObject>(16);
    private Map<String, DynamicObject> rateCache = new HashMap<String, DynamicObject>(16);

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject targitBill = entity.getDataEntity();
            String billNo = targitBill.getString("billno");
            DynamicObject org = targitBill.getDynamicObject("org");
            if (org != null) {
                Long orgId = org.getLong("id");
                DynamicObject currency = this.getCurrencyByOrgId(orgId);
                targitBill.set("currency", (Object)currency);
            }
            DynamicObjectCollection billEntry = targitBill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                this.dealUnitAndQty(billNo, entry);
            }
        }
    }

    private void dealUnitAndQty(String billNo, DynamicObject entry) {
        boolean isConvert;
        DynamicObject purMaterial = entry.getDynamicObject("material");
        DynamicObject material = purMaterial.getDynamicObject("masterid");
        DynamicObject purChaseUnit = purMaterial.getDynamicObject("purchaseunit");
        entry.set("unit", (Object)purChaseUnit);
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        BigDecimal applyQty = this.getDesQtyConv(material, baseUnit, purChaseUnit, baseQty);
        entry.set("applyqty", (Object)applyQty);
        entry.set("qty", (Object)applyQty);
        DynamicObject auxUnit = entry.getDynamicObject("auxunit");
        if (auxUnit == null) {
            return;
        }
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = "A".equals(unitConvertDir) || "C".equals(unitConvertDir);
        if (!isConvert) {
            return;
        }
        BigDecimal qtyUnit2nd = this.getDesQtyConv(material, baseUnit, auxUnit, baseQty);
        entry.set("auxqty", (Object)qtyUnit2nd);
    }

    private BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, DynamicObject desUnit, BigDecimal srcQty) {
        Long desUnitId;
        BigDecimal qty = BigDecimal.ZERO;
        if (material == null || srcUnit == null || desUnit == null || srcQty == null || srcQty.compareTo(BigDecimal.ZERO) <= 0) {
            return qty;
        }
        Long materialId = material.getLong("id");
        Long srcUnitId = srcUnit.getLong("id");
        if (srcUnitId.equals(desUnitId = Long.valueOf(desUnit.getLong("id")))) {
            return srcQty;
        }
        StringBuilder rateCacheBuilder = new StringBuilder("InvPlanOrderRateCache").append("_").append(materialId).append("_").append(srcUnitId).append("_").append(desUnitId);
        String rateCacheKey = rateCacheBuilder.toString();
        boolean containsKey = this.rateCache.containsKey(rateCacheKey);
        DynamicObject muConv = null;
        if (!containsKey) {
            muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            this.rateCache.put(rateCacheKey, muConv);
        } else {
            muConv = this.rateCache.get(rateCacheKey);
        }
        if (muConv != null && muConv.getInt("numerator") != 0) {
            int precision = desUnit.getInt("precision");
            String precisionAccount = desUnit.getString("precisionaccount");
            if (StringUtils.isNotEmpty((CharSequence)precisionAccount)) {
                qty = srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount)));
            }
        }
        return qty;
    }

    private DynamicObject getCurrencyByOrgId(Long orgId) {
        boolean containsKey = this.currencyCache.containsKey(orgId);
        DynamicObject currency = null;
        if (!containsKey) {
            currency = CurrencyHelper.getCurrency((Long)orgId);
            this.currencyCache.put(orgId, currency);
        }
        return currency;
    }
}

