/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.ext.scmc.wirteoff.util.WfAfterBotpPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TransOutToInWarehouseBotpPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(WfAfterBotpPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("inwarehouse");
        e.addSrcField("inlocation");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet dataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entryRows = dataEntitySet.FindByEntityKey("billentry");
        HashSet<Object> inWareHouseIds = new HashSet<Object>();
        HashSet<Object> inLocationIds = new HashSet<Object>();
        for (ExtendedDataEntity entryRow : entryRows) {
            List srcRows = (List)entryRow.getValue("ConvertSource");
            if (srcRows.isEmpty() || srcRows == null) continue;
            Object inWarehouseId = ((DynamicProperty)e.getFldProperties().get("inwarehouse")).getValue(srcRows.get(0));
            Object inLocationId = ((DynamicProperty)e.getFldProperties().get("inlocation")).getValue(srcRows.get(0));
            inWareHouseIds.add(inWarehouseId);
            inLocationIds.add(inLocationId);
        }
        Map wareHouseMap = BusinessDataServiceHelper.loadFromCache((Object[])inWareHouseIds.toArray(), (String)"bd_warehouse");
        Map locationMap = BusinessDataServiceHelper.loadFromCache((Object[])inLocationIds.toArray(), (String)"bd_location");
        for (ExtendedDataEntity entryRow : entryRows) {
            List srcRows = (List)entryRow.getValue("ConvertSource");
            if (srcRows.isEmpty() || srcRows == null) continue;
            Object inWarehouseId = ((DynamicProperty)e.getFldProperties().get("inwarehouse")).getValue(srcRows.get(0));
            Object inlocationId = ((DynamicProperty)e.getFldProperties().get("inlocation")).getValue(srcRows.get(0));
            DynamicObject dataEntity = entryRow.getDataEntity();
            DynamicObject inWarehouse = (DynamicObject)wareHouseMap.get(inWarehouseId);
            DynamicObject inlocation = (DynamicObject)locationMap.get(inlocationId);
            dataEntity.set("outwarehouse", (Object)inWarehouse);
            dataEntity.set("outlocation", (Object)inlocation);
        }
    }
}

