/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.enums.InvalidEnum;

public class WarehouseMgDataInitBotpPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        HashMap cacheMap = new HashMap(16);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject bill = entity.getDataEntity();
            this.initBizDataByOrg(bill, cacheMap);
        }
    }

    private void initBizDataByOrg(DynamicObject billEntry, Map cacheMap) {
        DynamicObject org = billEntry.getDynamicObject("org");
        if (org != null) {
            String operatorCacheKey;
            DynamicObject operator;
            Long orgId = (Long)org.getPkValue();
            this.initDept(orgId, billEntry);
            long userId = UserServiceHelper.getCurrentUserId();
            String operatorGrpType = OperatorGrpTypeEnum.INVENTORYGRP.getValue();
            String operatorGroupCacheKey = orgId + operatorGrpType + "_getOperatorGroupData";
            Map<Object, DynamicObject> map = this.getOperatorGroupData(cacheMap, orgId, operatorGrpType, operatorGroupCacheKey);
            if (map.size() != 0 && (operator = this.getOperator(cacheMap, userId, map, operatorCacheKey = userId + JSONObject.toJSONString(map.keySet()) + "_getOperator")) != null) {
                billEntry.set("operator_id", operator.getPkValue());
                DynamicObject operatorGroup = this.getOperatorGroup(operator);
                Object operatorGroupId = operatorGroup == null ? null : operatorGroup.getPkValue();
                billEntry.set("operatorgroup_id", operatorGroupId);
            }
        }
    }

    private DynamicObject getOperator(Map cacheMap, long userId, Map<Object, DynamicObject> map, String operatorKey) {
        DynamicObject operator;
        if (cacheMap.containsKey(operatorKey)) {
            operator = (DynamicObject)cacheMap.get(operatorKey);
        } else {
            operator = this.getOperatorDb(userId, map);
            cacheMap.put(operatorKey, operator);
        }
        return operator;
    }

    private Map<Object, DynamicObject> getOperatorGroupData(Map cacheMap, Long orgId, String operatorGrpType, String cacheKey) {
        Map<Object, DynamicObject> map;
        if (cacheMap.containsKey(cacheKey)) {
            map = (Map<Object, DynamicObject>)cacheMap.get(cacheKey);
        } else {
            map = this.getOperatorGroupDbData(orgId, operatorGrpType);
            cacheMap.put(cacheKey, map);
        }
        return map;
    }

    private DynamicObject getOperatorGroup(DynamicObject operator) {
        QFilter qFilterOperatorId = new QFilter("id", "=", (Object)operator.getLong("operatorgrpid"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operatorgroup", (String)" id,name,number,enable,operatorgrouptype,createorg", (QFilter[])new QFilter[]{qFilterOperatorId});
    }

    private DynamicObject getOperatorDb(long userId, Map<Object, DynamicObject> map) {
        QFilter qFilter11 = new QFilter("operatorgrpid", "in", map.keySet());
        QFilter qFilter12 = new QFilter("operatorid", "=", (Object)userId);
        QFilter qFilter13 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype", (QFilter[])new QFilter[]{qFilter11, qFilter12, qFilter13});
    }

    private Map<Object, DynamicObject> getOperatorGroupDbData(Long orgId, String operatorGrpType) {
        QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter02 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType);
        qFilter02.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        return BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02});
    }

    private void initDept(Long orgId, DynamicObject billEntry) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        Long deptId = null;
        if (deptIds != null && deptIds.size() > 0) {
            deptId = (Long)deptIds.get(0);
        } else {
            deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
            if (deptIds != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
                deptId = orgId;
            }
        }
        billEntry.set("dept_id", (Object)deptId);
    }
}

