/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.calcost;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ApplyOrgPlugin
extends AbstractFormPlugin {
    public void initialize() {
        this.addClickListeners(new String[]{"btnsave"});
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey().toLowerCase()) {
            case "btnaddline": {
                this.openOrgF7();
                break;
            }
            case "btndeleteline": {
                this.refreshOrgf7();
                break;
            }
        }
    }

    private void refreshOrgf7() {
        DynamicObjectCollection curOrgList = this.getModel().getEntryEntity("orgentry");
        HashSet<Long> orgIds = new HashSet<Long>(curOrgList.size());
        for (DynamicObject obj : curOrgList) {
            DynamicObject org = obj.getDynamicObject("org");
            if (org == null) {
                return;
            }
            orgIds.add(org.getLong("id"));
        }
        this.getModel().beginInit();
        this.getModel().setValue("orgf7", (Object)orgIds.toArray());
        this.getModel().endInit();
        this.getView().updateView("orgf7");
    }

    private void openOrgF7() {
        MulBasedataEdit base = (MulBasedataEdit)this.getControl("orgf7");
        base.setOrgFuncId("15");
        base.click();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String itemkey = c.getKey().toLowerCase();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.isEmpty()) {
            return;
        }
        Object confId = customParams.get("confid");
        String confEntity = (String)customParams.get("confentity");
        String confField = (String)customParams.get("conffield");
        String applyOrgEntity = (String)customParams.get("applyorgentity");
        switch (itemkey) {
            case "btnsave": {
                this.deleteEntry(applyOrgEntity, confField, confId);
                this.saveData(confEntity, confField, applyOrgEntity, confId);
                this.getView().close();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject orgObj;
        this.clearAllEntryRow();
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.isEmpty()) {
            return;
        }
        Object confId = customParams.get("confid");
        String confEntity = (String)customParams.get("confentity");
        if (confId == null || confEntity == null) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", confId);
        DynamicObjectCollection orgEntry = QueryServiceHelper.query((String)confEntity, (String)"id,orgentry.org org,orgentry.isincludesuborg isincludesuborg,orgentry.org.number number,orgentry.org.name name", (QFilter[])qFilter.toArray());
        if (orgEntry == null || orgEntry.isEmpty()) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (int rowIdx = 0; rowIdx < orgEntry.size() && !StringUtils.isBlank((Object)(orgObj = (DynamicObject)orgEntry.get(rowIdx)).get("number")); ++rowIdx) {
            Long applyOrgId = orgObj.getLong("org");
            boolean isIncludeSuborg = orgObj.getBoolean("isincludesuborg");
            model.createNewEntryRow("orgentry");
            model.setValue("org", (Object)applyOrgId, rowIdx);
            model.setValue("isincludesuborg", (Object)isIncludeSuborg, rowIdx);
            orgIds.add(applyOrgId);
        }
        this.getModel().beginInit();
        this.getModel().setValue("orgf7", (Object)orgIds.toArray());
        this.getModel().endInit();
        this.getView().updateView("orgf7");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("orgf7".equals(proName)) {
            this.changeOrgEntity(e);
        }
    }

    private void changeOrgEntity(PropertyChangedArgs e) {
        DynamicObjectCollection curOrgList = this.getModel().getEntryEntity("orgentry");
        HashMap<Long, Object> subOrgMap = new HashMap<Long, Object>(curOrgList.size());
        for (DynamicObject curOrgObj : curOrgList) {
            DynamicObject org = curOrgObj.getDynamicObject("org");
            if (org == null) continue;
            subOrgMap.put(org.getLong("id"), curOrgObj.get("isincludesuborg"));
        }
        this.clearAllEntryRow();
        DynamicObjectCollection orgCol = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
        if (orgCol.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("orgentry", orgCol.size());
        int m = orgCol.size();
        for (int rowIdx = 0; rowIdx < m; ++rowIdx) {
            DynamicObject orgObj = (DynamicObject)orgCol.get(rowIdx);
            DynamicObject org = orgObj.getDynamicObject("fbasedataId");
            if (org == null) continue;
            this.getModel().setValue("org", (Object)org, rowIdx);
            Object isIncludeSubOrg = subOrgMap.get(org.getLong("id"));
            if (isIncludeSubOrg == null) continue;
            this.getModel().setValue("isincludesuborg", isIncludeSubOrg, rowIdx);
        }
    }

    private void saveData(String confEntity, String confField, String applyOrgEntity, Object confId) {
        IDataModel model = this.getModel();
        DynamicObject confDym = BusinessDataServiceHelper.newDynamicObject((String)confEntity);
        confDym.set("id", confId);
        DynamicObjectCollection orgCollection = model.getEntryEntity("orgentry");
        DynamicObject[] orgArr = new DynamicObject[orgCollection.size()];
        for (int rowIdx = 0; rowIdx < orgCollection.size(); ++rowIdx) {
            DynamicObject orgEntity = BusinessDataServiceHelper.newDynamicObject((String)applyOrgEntity);
            orgEntity.set(confField, (Object)confDym);
            orgEntity.set("org", model.getValue("org", rowIdx));
            orgEntity.set("isincludesuborg", model.getValue("isincludesuborg", rowIdx));
            orgEntity.set("seq", (Object)rowIdx);
            orgArr[rowIdx] = orgEntity;
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
        DynamicObject conf = BusinessDataServiceHelper.loadSingle((Object)confId, (String)confEntity);
        SaveServiceHelper.saveOperate((String)confEntity, (DynamicObject[])new DynamicObject[]{conf}, (OperateOption)OperateOption.create());
    }

    private void deleteEntry(String applyOrgEntity, String confField, Object confId) {
        QFilter qFilter = new QFilter(confField, "=", confId);
        DeleteServiceHelper.delete((String)applyOrgEntity, (QFilter[])qFilter.toArray());
    }

    private void clearAllEntryRow() {
        this.getModel().deleteEntryData("orgentry");
    }
}

