/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.calcost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.business.helper.FieldLangFormTranslator;
import kd.scmc.im.business.helper.calcost.FormShowHelper;
import kd.scmc.im.business.helper.calcost.strategy.CalCostEntryStrategy;
import kd.scmc.im.business.helper.calcost.strategy.EntryFieldStrategy;
import kd.scmc.im.consts.QueryCalCostConst;
import kd.scmc.im.utils.FormUtils;
import kd.scmc.im.utils.IMStringUtils;
import kd.scmc.sbs.business.common.colsAssist.IColsSelectStrategy;

public class QueryCalCostEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(QueryCalCostEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billentry", "costrecordfield", "imbillfield", "operation"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"imbill", "costaccount"});
    }

    public void click(EventObject evt) {
        String field;
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        switch (field = control.getKey()) {
            case "billentry": {
                this.clickBillEntry(model);
                break;
            }
            case "costrecordfield": {
                this.clickCostRecordField(model);
                break;
            }
            case "imbillfield": {
                this.clickImBillField(model);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().batchCreateNewEntryRow("costcolsmapentry", 2);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowHelper.setOperationItems((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"imbill", (String)"operation");
        this.updateCommonFilter();
        FilterGrid filterGrid = (FilterGrid)this.getControl("commonfilter");
        String commonFilterJson = this.getModel().getDataEntity().getString("filterjson_tag");
        FilterCondition condition = StringUtils.isBlank((CharSequence)commonFilterJson) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)commonFilterJson, FilterCondition.class);
        filterGrid.SetValue(condition);
        int entryRowCount = this.getModel().getEntryRowCount("costcolsmapentry");
        if (entryRowCount == 2) {
            Object costRecordField1 = this.getModel().getValue("costrecordfieldkey", 0);
            Object costRecordField2 = this.getModel().getValue("costrecordfieldkey", 1);
            if (StringUtils.isBlank((Object)costRecordField1) && StringUtils.isBlank((Object)costRecordField2)) {
                this.setCostRecordField();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setViewEnable();
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue("ispreset", (Object)Boolean.FALSE);
        this.translate();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key)) {
            this.beforeSave();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (propertyName) {
            case "imbill": {
                this.beforeF7Bill(showParameter);
                break;
            }
            case "costaccount": {
                this.beforeF7CostAccount(showParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.isChange(e)) {
            return;
        }
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        int rowIndex = changeSet[0].getRowIndex();
        switch (propertyName) {
            case "imbill": {
                this.imBillChange(oldValue);
                break;
            }
            case "billentry": {
                this.billEntryChange(newValue);
                break;
            }
            case "operation": {
                this.operationChange(newValue);
                break;
            }
            case "iscostmainaccount": {
                this.mainAccountChange(newValue);
                break;
            }
            case "accounttype": {
                this.accountTypeChange(newValue);
                break;
            }
            case "costaccount": {
                this.costAccountChange(newValue);
                break;
            }
            case "costrecordfield": {
                this.entryFieldChange(newValue, "costrecordfieldkey", rowIndex);
                break;
            }
            case "imbillfield": {
                this.entryFieldChange(newValue, "imbillfieldkey", rowIndex);
                break;
            }
            case "billentrykey": {
                this.entryChange(oldValue);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        IDataModel model = this.getModel();
        String returnData = (String)evt.getReturnData();
        String actionId = evt.getActionId();
        IPageCache pageCache = this.getPageCache();
        if (returnData == null || actionId == null) {
            return;
        }
        switch (actionId) {
            case "billentryCB": {
                FormShowHelper.closeCallSetField((IDataModel)model, (String)returnData, (String)"billentry", (String)"billentrykey");
                break;
            }
            case "costrecordfieldCB": {
                FormShowHelper.closeCallSetEntryField((IDataModel)model, (IPageCache)pageCache, (String)returnData, (String)"costrecordfield", (String)"costrecordfieldkey");
                break;
            }
            case "imbillfieldCB": {
                FormShowHelper.closeCallSetEntryField((IDataModel)model, (IPageCache)pageCache, (String)returnData, (String)"imbillfield", (String)"imbillfieldkey");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        String callBackId = closedEvent.getCallBackId();
        MessageBoxResult result = closedEvent.getResult();
        String customValue = closedEvent.getCustomVaule();
        switch (callBackId) {
            case "imbillCB": {
                this.imBillConfirmCb(result, customValue);
                break;
            }
        }
    }

    private void clickBillEntry(IDataModel model) {
        DynamicObject imBill = model.getDataEntity().getDynamicObject("imbill");
        if (imBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e93\u5b58\u5355\u636e\u3002", (String)"QueryCalCostEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String imBillNum = imBill.getString("number");
        FormShowHelper.showEntrySelectForm((AbstractFormPlugin)this, (String)imBillNum, (IColsSelectStrategy)new CalCostEntryStrategy(), (String)"billentryCB");
    }

    private void clickCostRecordField(IDataModel model) {
        int rowIndex = model.getEntryCurrentRowIndex("costcolsmapentry");
        DynamicObjectCollection costEntrys = model.getDataEntity(true).getDynamicObjectCollection("costcolsmapentry");
        ArrayList<String> filterList = new ArrayList<String>(16);
        for (DynamicObject costEntry : costEntrys) {
            String costRecordField = costEntry.getString("costrecordfieldkey");
            if (!StringUtils.isNotBlank((CharSequence)costRecordField)) continue;
            filterList.add(costRecordField);
        }
        FormShowHelper.showColsTreeForm((AbstractFormPlugin)this, (String)"cal_costrecord_subentity", (int)rowIndex, null, (List)QueryCalCostConst.getCostRecordField(), filterList, (String)"costrecordfieldCB");
    }

    private void clickImBillField(IDataModel model) {
        DynamicObject imBill = model.getDataEntity().getDynamicObject("imbill");
        if (imBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e93\u5b58\u5355\u636e\u3002", (String)"QueryCalCostEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = model.getEntryCurrentRowIndex("costcolsmapentry");
        String billEntry = model.getDataEntity().getString("billentrykey");
        String imBillNum = imBill.getString("number");
        String recordField = (String)model.getValue("costrecordfieldkey", rowIndex);
        if (StringUtils.isBlank((CharSequence)recordField)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5b57\u6bb5\u3002", (String)"QueryCalCostEditPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity");
        String[] fields = recordField.split("\\.");
        if (fields.length > 1) {
            recordField = fields[fields.length - 1];
        }
        IDataEntityProperty property = dataEntityType.findProperty(recordField);
        EntryFieldStrategy fieldStrategy = new EntryFieldStrategy(billEntry, new IDataEntityProperty[]{property});
        ArrayList<String> filterList = new ArrayList<String>(16);
        DynamicObjectCollection costEntrys = model.getDataEntity(true).getDynamicObjectCollection("costcolsmapentry");
        for (DynamicObject costEntry : costEntrys) {
            String imBillField = costEntry.getString("imbillfieldkey");
            if (!StringUtils.isNotBlank((CharSequence)imBillField)) continue;
            filterList.add(imBillField);
        }
        FormShowHelper.showColsTreeForm((AbstractFormPlugin)this, (String)imBillNum, (int)rowIndex, (IColsSelectStrategy)fieldStrategy, null, filterList, (String)"imbillfieldCB");
    }

    private void beforeF7Bill(ListShowParameter showParameter) {
        QFilter billFilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        billFilter.and("bizappid.number", "=", (Object)"im");
        showParameter.getListFilterParameter().setFilter(billFilter);
    }

    private void beforeF7CostAccount(ListShowParameter showParameter) {
        QFilter accountFilter = new QFilter("enable", "=", (Object)"1");
        accountFilter.and("ismainaccount", "=", (Object)"0");
        showParameter.getListFilterParameter().setFilter(accountFilter);
    }

    private void imBillChange(Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldImBill = (DynamicObject)oldValue;
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(16);
            confirmInfo.put("imbill", oldImBill.getPkValue());
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u5e93\u5b58\u5355\u636e\u5c06\u6e05\u9664\u9875\u9762\u7684\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"QueryCalCostEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("imbillCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            this.updateCommonFilter();
            FormShowHelper.setOperationItems((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"imbill", (String)"operation");
        }
    }

    private void entryChange(Object oldValue) {
        if (oldValue != null) {
            this.getModel().deleteEntryData("costcolsmapentry");
            this.getModel().batchCreateNewEntryRow("costcolsmapentry", 2);
            this.setCostRecordField();
        }
    }

    private void mainAccountChange(Object newValue) {
        this.getView().setEnable(Boolean.valueOf((Boolean)newValue == false), new String[]{"accounttype", "costaccount"});
        if (Boolean.TRUE.equals(newValue)) {
            this.getModel().setValue("accounttype", null);
            this.getModel().setValue("costaccount", null);
        }
    }

    private void accountTypeChange(Object newValue) {
        if (newValue != null) {
            this.getModel().setValue("costaccount", null);
        }
    }

    private void costAccountChange(Object newValue) {
        if (newValue != null) {
            this.getModel().setValue("accounttype", null);
        }
    }

    private void billEntryChange(Object newValue) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue("billentrykey", null);
        }
    }

    private void operationChange(Object newValue) {
        if (newValue != null) {
            DynamicObject imBill = this.getModel().getDataEntity().getDynamicObject("imbill");
            if (imBill == null) {
                return;
            }
            String imBillNum = imBill.getString("number");
            List operations = EntityMetadataCache.getDataEntityOperate((String)imBillNum);
            for (Map operation : operations) {
                String opKey = (String)operation.get("key");
                if (!opKey.equals(newValue)) continue;
                this.getModel().setValue("operationname", operation.get("name"));
            }
        } else {
            this.getModel().setValue("operationname", null);
        }
    }

    private void entryFieldChange(Object newValue, String fieldKey, int rowIndex) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(fieldKey, null, rowIndex);
        }
    }

    private void imBillConfirmCb(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().setValue("billentry", null);
            FormShowHelper.setOperationItems((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"imbill", (String)"operation");
            this.getModel().setValue("operation", null);
            this.getModel().setValue("description", null);
            this.updateCommonFilter();
            this.getModel().setValue("filterformula_tag", null);
            this.getModel().setValue("filterjson_tag", null);
            this.getModel().setValue("iscostmainaccount", (Object)Boolean.TRUE);
            this.getModel().setValue("accounttype", null);
            this.getModel().setValue("costaccount", null);
            this.getModel().deleteEntryData("costcolsmapentry");
            this.getModel().batchCreateNewEntryRow("costcolsmapentry", 2);
            this.setCostRecordField();
        } else {
            Object imBill = confirmInfo.get("imbill");
            this.getModel().beginInit();
            this.getModel().setValue("imbill", imBill);
            this.getModel().endInit();
            this.getView().updateView("imbill");
        }
    }

    private void setViewEnable() {
        Object mainAccount = this.getModel().getValue("iscostmainaccount");
        this.mainAccountChange(mainAccount);
    }

    private void updateCommonFilter() {
        DynamicObject imBill = this.getModel().getDataEntity().getDynamicObject("imbill");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfilter");
        if (imBill == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList());
            filterGrid.setEntityNumber(null);
        } else {
            String imBillNum = imBill.getString("number");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)imBillNum);
            GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)entityType);
            getFilterFieldsParameter.setNeedFlexField(false);
            List filterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)getFilterFieldsParameter);
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(filterColumns);
            filterGrid.setEntityNumber(entityType.getName());
        }
        this.getView().updateView("commonfilter");
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        FilterGrid filterGrid = (FilterGrid)this.getControl("commonfilter");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)filterCondition);
        DynamicObject imBill = model.getDataEntity().getDynamicObject("imbill");
        if (imBill == null) {
            return;
        }
        String imBillNum = imBill.getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)imBillNum);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
        String[] filterScript = filterBuilder.buildFilterScript();
        String filterValue = filterScript == null ? "" : filterScript[0];
        model.setValue("filterjson_tag", (Object)jsonStr);
        model.setValue("filterformula_tag", (Object)filterValue);
    }

    private void setCostRecordField() {
        MainEntityType costCordType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        DynamicProperty entryProp = costCordType.getProperty("entry");
        IDataEntityProperty unitActProp = costCordType.findProperty("unitactualcost");
        IDataEntityProperty actProp = costCordType.findProperty("actualcost");
        String costRecordField1 = IMStringUtils.append((String)entryProp.getDisplayName().getLocaleValue(), (Object[])new Object[]{Character.valueOf('.'), unitActProp.getDisplayName().getLocaleValue()});
        String costRecordField2 = IMStringUtils.append((String)entryProp.getDisplayName().getLocaleValue(), (Object[])new Object[]{Character.valueOf('.'), actProp.getDisplayName().getLocaleValue()});
        this.getModel().setValue("costrecordfield", (Object)costRecordField1, 0);
        this.getModel().setValue("costrecordfieldkey", (Object)"entry.unitactualcost", 0);
        this.getModel().setValue("costrecordfield", (Object)costRecordField2, 1);
        this.getModel().setValue("costrecordfieldkey", (Object)"entry.actualcost", 1);
    }

    private boolean isChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (newValue instanceof DynamicObject && oldValue instanceof DynamicObject && ((DynamicObject)newValue).getPkValue().equals(((DynamicObject)oldValue).getPkValue())) {
            return false;
        }
        return !(newValue instanceof BigDecimal) || !(oldValue instanceof BigDecimal) || ((BigDecimal)newValue).compareTo((BigDecimal)oldValue) != 0;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.translate();
    }

    private void translate() {
        try {
            IDataModel model = this.getModel();
            Object entityType = model.getValue("imbill");
            String entityKey = entityType instanceof DynamicObject ? ((DynamicObject)entityType).getString("number") : "";
            FieldLangFormTranslator fieldLangFormTranslator = FieldLangFormTranslator.create((IDataModel)this.getModel());
            fieldLangFormTranslator.headFieldTranslate(entityKey, "billentrykey", "billentry");
            fieldLangFormTranslator.entryFieldTranslate("costcolsmapentry", entityKey, "imbillfieldkey", "imbillfield");
            fieldLangFormTranslator.entryFieldTranslate("costcolsmapentry", "cal_costrecord_subentity", "costrecordfieldkey", "costrecordfield");
            model.setDataChanged(false);
        }
        catch (Exception e) {
            log.error("\u591a\u8bed\u8a00\u7ffb\u8bd1\u5931\u8d25", (Throwable)e);
        }
    }
}

