/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.count;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.mservice.ShardingMetadataService;
import kd.scmc.im.business.helper.InvcountSchemeHelper;
import kd.scmc.im.formplugin.count.CrvCondition;
import kd.scmc.im.formplugin.count.InvCountBillAdjustQueryData;

public class InvCountBillAdjustEditPlugin
extends AbstractBillPlugIn {
    private static String algoKey = InvCountBillAdjustEditPlugin.class.getName();
    private static final String BTNOK = "btnok";
    private static final String ADJUST_AFTER_FID_COMB = "im_adjustbill:888882865322900480";
    private static final String ADJUST_BEFORE_FID_COMB = "im_adjustbill:887614333889020928";
    private static final String ASSEMBBILL_BEFORE_FID_COMB = "im_assembbill:888885610822024192";
    private static final String ASSEMBBILL_AFTER_FID_COMB = "im_assembbill:888887504080518144";
    private static final String DISASSBILL_BEFORE_FID_COMB = "im_disassemblebill:949900545089346560";
    private static final String DISASSBILL_AFTER_FID_COMB = "im_disassemblebill:949903151622915072";
    private static final String SOURCE_BILL_COL = "colsmap.sourcebillcol";
    private static final String TARGET_OBJ_COL = "colsmap.targetobjcol";
    private static final String SELECT_BY_CONDITION = "2";
    private static Map<String, Long> MAPPING_MDC_BILLTYPE = new HashMap<String, Long>(8);
    private static final String[] TWO_WAY_LOGO;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void beforeBindData(EventObject e) {
        QFilter qFilterCommon;
        super.beforeBindData(e);
        HashMap<String, Map<String, CrvCondition>> conditonMap = new HashMap<String, Map<String, CrvCondition>>(16);
        HashMap<String, Map<String, Object>> fieldMap = new HashMap<String, Map<String, Object>>(16);
        Map<String, TreeSet<String>> billMapSelectFields = this.getBillMapSelectFields(conditonMap, fieldMap);
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("param");
        if ("invacc".equals(jsonObject.get((Object)"backupcondition"))) {
            Date filterdate = jsonObject.getDate("filterdate");
            qFilterCommon = new QFilter("auditdate", ">", (Object)filterdate);
            boolean isXDBEnable = false;
            ShardingMetadataService shardingMetadataService = ShardingMetadataService.getInstance();
            for (String key : billMapSelectFields.keySet()) {
                String entityName = key.substring(0, key.indexOf(58));
                if (!shardingMetadataService.isXDBEnableByEntity(entityName)) continue;
                isXDBEnable = true;
                break;
            }
            if (!isXDBEnable) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(filterdate);
                calendar.add(2, -2);
                calendar.set(5, 1);
                calendar.set(10, 0);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                qFilterCommon.and("bookdate", ">=", (Object)calendar.getTime());
            }
        } else {
            qFilterCommon = InvcountSchemeHelper.getAdjustBillDateFilter((JSONObject)jsonObject);
        }
        qFilterCommon.and("billstatus", "=", (Object)Character.valueOf('C'));
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        Set<String> allEntryFieldSet = this.getAllEntryFieldSeBytNaturalSort(this.getModel());
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (Map.Entry entry : billMapSelectFields.entrySet()) {
            String entityName = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(58));
            String key = (String)entry.getKey();
            QFilter qFilter = qFilterCommon.copy().and(this.getQFiltersByRowsSelected(jsonObject, entityName, key));
            Map entryCrvConditionMap = (Map)conditonMap.get(entry.getKey());
            HashSet<String> fields = new HashSet<String>(16);
            Map initFields = (Map)fieldMap.get(entry.getKey());
            entryCrvConditionMap.values().stream().forEach(n -> fields.addAll(n.getFieldList()));
            fields.removeAll(initFields.values());
            fields.addAll((Collection)entry.getValue());
            String queryFields = this.getQueryFields(key, fields);
            DataSet billDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)queryFields, (QFilter[])qFilter.toArray(), null);
            if (billDataSet.isEmpty()) {
                billDataSet.close();
                continue;
            }
            while (billDataSet.hasNext()) {
                Row row = billDataSet.next();
                for (String field : allEntryFieldSet) {
                    if (entryCrvConditionMap != null && entryCrvConditionMap.get(field) != null) {
                        CrvCondition condition = (CrvCondition)entryCrvConditionMap.get(field);
                        Map<String, String> conditionFieldMap = condition.getFieldMap();
                        HashMap<String, Object> args = new HashMap<String, Object>(16);
                        for (Map.Entry<String, String> conditonFieldEntry : conditionFieldMap.entrySet()) {
                            String conditonField = conditonFieldEntry.getKey();
                            String tagField = (String)initFields.get(conditonField);
                            Object value = tagField != null ? row.get(tagField) : row.get(conditonField);
                            args.put(conditonFieldEntry.getValue(), value);
                        }
                        Object result = condition.addExp(args);
                        if (result == null) continue;
                        vs.addField(field, new Object[]{result});
                        continue;
                    }
                    vs.addField(field, new Object[]{row.get(field)});
                }
            }
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        abstractFormDataModel.batchCreateNewEntryRow("billentry", vs);
        this.getModel().endInit();
        this.getView().updateView("billentry");
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        switch (key = ((Control)e.getSource()).getKey()) {
            case "btnok": {
                this.handleBtnokEvent();
                break;
            }
        }
    }

    private String getQueryFields(String key, Collection<String> value) {
        StringBuilder sb = new StringBuilder();
        sb.append(InvcountSchemeHelper.collectionToString(value));
        if (key.equals(ADJUST_AFTER_FID_COMB)) {
            sb.append(",billentry.afterentity.material1.masterid.name as materialname,");
            sb.append(" 'im_adjustbill_after' as specialbill");
        } else if (key.equals(ADJUST_BEFORE_FID_COMB)) {
            sb.append(",billentry.material.masterid.name as materialname,");
            sb.append(" 'im_adjustbill_before' as specialbill");
        } else if (key.equals(ASSEMBBILL_BEFORE_FID_COMB)) {
            sb.append(",billentry.afterentity.material1.masterid.name as materialname,");
            sb.append(" 'im_assembbill_before' as specialbill");
        } else if (key.equals(ASSEMBBILL_AFTER_FID_COMB)) {
            sb.append(",billentry.material.masterid.name as materialname,");
            sb.append(" 'im_assembbill_after' as specialbill");
        } else if (key.equals(DISASSBILL_BEFORE_FID_COMB)) {
            sb.append(",billentry.material.masterid.name as materialname,");
            sb.append(" 'im_disassemblebill_before' as specialbill");
        } else if (key.equals(DISASSBILL_AFTER_FID_COMB)) {
            sb.append(",billentry.afterentity.material1.masterid.name as materialname,");
            sb.append(" 'im_disassemblebill_after' as specialbill");
        } else {
            sb.append(",billentry.material.masterid.name as materialname,");
            sb.append(" ' ' as specialbill");
        }
        return sb.toString();
    }

    private void handleBtnokEvent() {
        Map<String, Set<String>> mapSelectData = this.getSelectedRowsInfo();
        if (mapSelectData.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6570\u636e", (String)"InvCountBillAdjustEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("param");
        DataSet billQtyDataSet = InvCountBillAdjustQueryData.getQtyInfoByDymAcc(mapSelectData, jsonObject);
        BigDecimal adjustQty = BigDecimal.ZERO;
        BigDecimal adjustBaseqty = BigDecimal.ZERO;
        BigDecimal adjustQtyunit2nd = BigDecimal.ZERO;
        while (billQtyDataSet.hasNext()) {
            Row row = billQtyDataSet.next();
            adjustQty = adjustQty.add(row.getBigDecimal("qty"));
            adjustBaseqty = adjustBaseqty.add(row.getBigDecimal("baseqty"));
            adjustQtyunit2nd = adjustQtyunit2nd.add(row.getBigDecimal("qtyunit2nd"));
        }
        JSONObject jsonReturnbject = new JSONObject();
        jsonReturnbject.put("adjustqty", (Object)adjustQty);
        jsonReturnbject.put("adjustbaseqty", (Object)adjustBaseqty);
        jsonReturnbject.put("adjustqtyunit2nd", (Object)adjustQtyunit2nd);
        this.getView().returnDataToParent((Object)jsonReturnbject);
        this.getView().close();
    }

    private Map<String, Set<String>> getSelectedRowsInfo() {
        int[] selectedRows;
        EntryGrid grid = (EntryGrid)this.getView().getControl("billentry");
        HashMap<String, Set<String>> mapSelectData = new HashMap<String, Set<String>>();
        for (int rowIndex : selectedRows = grid.getSelectRows()) {
            HashSet<String> listBillNo;
            String billno = (String)this.getModel().getValue("billno", rowIndex);
            String formid = (String)this.getModel().getValue("formid", rowIndex);
            String specialbill = (String)this.getModel().getValue("specialbill", rowIndex);
            if (!specialbill.isEmpty()) {
                formid = formid + ":" + specialbill;
            }
            if ((listBillNo = (HashSet<String>)mapSelectData.get(formid)) == null) {
                listBillNo = new HashSet<String>(16);
                listBillNo.add(billno);
                mapSelectData.put(formid, listBillNo);
                continue;
            }
            listBillNo.add(billno);
        }
        return mapSelectData;
    }

    private QFilter getQFiltersByRowsSelected(JSONObject jsonObject, String entityName, String setBillIdAndFid) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        String prefix = "billentry.";
        char suffix = ' ';
        if (ADJUST_AFTER_FID_COMB.equals(setBillIdAndFid) || ASSEMBBILL_BEFORE_FID_COMB.equals(setBillIdAndFid) || DISASSBILL_AFTER_FID_COMB.equals(setBillIdAndFid)) {
            prefix = "billentry.afterentity.";
            suffix = '1';
        }
        this.setGeneralQFilterByDifBill(jsonObject, qFilter, prefix, suffix);
        ArrayList<QFilter> listQFilterTwoWay = new ArrayList<QFilter>(2);
        switch (entityName) {
            case "im_transdirbill": {
                this.setTransDirBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay);
                break;
            }
            case "im_transoutbill": {
                this.setTransOutBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay);
                break;
            }
            case "im_transinbill": {
                this.setTransInBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay);
                break;
            }
            case "im_locationtransfer": {
                this.setLocationtransferBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_saloutbill": 
            case "im_otheroutbill": 
            case "im_materialreqoutbill": 
            case "im_osmaterialreqoutbill": {
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_mftproorder": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_mftproorder"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_mftfeedorder": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_mftfeedorder"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_mftreturnorder": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_mftreturnorder"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_mftmanuinbill": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_mftmanuinbill"));
                this.setOtherBillSpeicalQFilter1(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_mftreturnbill": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_mftreturnbill"));
                this.setOtherBillSpeicalQFilter1(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_ominbill": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_ominbill"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay);
                break;
            }
            case "im_mdc_omcmplinbill": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_omcmplinbill"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay);
                break;
            }
            case "im_mdc_omfeedorder": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_omfeedorder"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_omproorder": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_omproorder"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_omreturnorder": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_omreturnorder"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_omoutbill": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_omoutbill"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_omreturnbill": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_omreturnbill"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_mdc_omfeedbill": {
                qFilter.and("billtype", "=", (Object)MAPPING_MDC_BILLTYPE.get("im_mdc_omfeedbill"));
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
                break;
            }
            case "im_purinbill": 
            case "im_invinspectbill": {
                this.setOtherBillSpeicalQFilter(jsonObject, prefix, suffix, listQFilterTwoWay);
                break;
            }
            default: {
                this.setOtherBillSpeicalQFilter1(jsonObject, prefix, suffix, listQFilterTwoWay, qFilter);
            }
        }
        if (listQFilterTwoWay.size() == 1) {
            qFilter.and((QFilter)listQFilterTwoWay.get(0));
        } else if (listQFilterTwoWay.size() > 1) {
            QFilter qFilterResult = new QFilter("1", "!=", (Object)1);
            for (QFilter qFilterTwoWay : listQFilterTwoWay) {
                qFilterResult.or(qFilterTwoWay);
            }
            qFilter.and(qFilterResult);
        }
        return qFilter;
    }

    private void setTransInBillSpeicalQFilter(JSONObject jsonObject, String prefix, char suffix, List<QFilter> listQFilterTwoWay) {
        QFilter qFilterIn = this.getKeeperOwnerInvTypeQFilter(jsonObject, prefix, suffix, TWO_WAY_LOGO);
        QFilter qFilterTransOut = this.getTransitOutKeeperOwnerInvTypeQFilter(jsonObject, prefix, suffix, TWO_WAY_LOGO);
        listQFilterTwoWay.add(this.getWarehouseQfilter(jsonObject, prefix, qFilterIn, "org", "warehouse", "location"));
        listQFilterTwoWay.add(this.getWarehouseQfilter(jsonObject, prefix, qFilterTransOut, "org", "outwarehouse", "outlocation"));
        listQFilterTwoWay.add(this.getWarehouseQfilter(jsonObject, prefix, qFilterTransOut, "outorg", "outwarehouse", "outlocation"));
    }

    private void setLocationtransferBillSpeicalQFilter(JSONObject jsonObject, String prefix, char suffix, List<QFilter> listQFilterTwoWay, QFilter qFilter) {
        Long location;
        listQFilterTwoWay.add(this.getKeeperOwnerInvTypeQFilter(jsonObject, prefix, suffix, TWO_WAY_LOGO));
        Long warehouse = jsonObject.getLong("warehouse");
        if (warehouse != null) {
            qFilter.and(prefix + "warehouse" + suffix, "=", (Object)warehouse);
        }
        if ((location = jsonObject.getLong("location")) != null) {
            QFilter qfilter_tmp = new QFilter(prefix + "location" + suffix, "=", (Object)location);
            qfilter_tmp.or(prefix + "outlocation" + suffix, "=", (Object)location);
            qFilter.and(qfilter_tmp);
        }
        qFilter.and("org", "=", (Object)jsonObject.getLong("org"));
    }

    private void setOtherBillSpeicalQFilter1(JSONObject jsonObject, String prefix, char suffix, List<QFilter> listQFilterTwoWay, QFilter qFilter) {
        Long location;
        listQFilterTwoWay.add(this.getKeeperOwnerInvTypeQFilter(jsonObject, prefix, suffix, TWO_WAY_LOGO));
        Long warehouse = jsonObject.getLong("warehouse");
        if (warehouse != null) {
            qFilter.and(prefix + "warehouse" + suffix, "=", (Object)warehouse);
        }
        if ((location = jsonObject.getLong("location")) != null) {
            qFilter.and(prefix + "location" + suffix, "=", (Object)location);
        }
        qFilter.and("org", "=", (Object)jsonObject.getLong("org"));
    }

    private void setOtherBillSpeicalQFilter(JSONObject jsonObject, String prefix, char suffix, List<QFilter> listQFilterTwoWay) {
        QFilter qFilterOrg = this.getPurInWarehouseQfilter(jsonObject, prefix, suffix);
        listQFilterTwoWay.add(qFilterOrg);
        QFilter qFilterOut = this.getPurOutWarehouseQfiter(jsonObject, prefix, suffix);
        listQFilterTwoWay.add(qFilterOut);
    }

    private QFilter getPurOutWarehouseQfiter(JSONObject jsonObject, String prefix, char suffix) {
        Long location;
        QFilter qFilterOut = new QFilter("org", "=", (Object)jsonObject.getLong("org"));
        Long warehouse = jsonObject.getLong("warehouse");
        if (warehouse != null) {
            qFilterOut.and(prefix + "outwarehouse" + suffix, "=", (Object)warehouse);
        }
        if ((location = jsonObject.getLong("outlocation")) != null) {
            qFilterOut.and(prefix + "location" + suffix, "=", (Object)location);
        }
        qFilterOut.and(this.getOutKeeperOwnerInvtypeQFilter(jsonObject, TWO_WAY_LOGO));
        return qFilterOut;
    }

    private void setOtherBillSpeicalQFilter(JSONObject jsonObject, String prefix, char suffix, List<QFilter> listQFilterTwoWay, QFilter qFilter) {
        Long location;
        listQFilterTwoWay.add(this.getOutKeeperOwnerInvtypeQFilter(jsonObject, TWO_WAY_LOGO));
        listQFilterTwoWay.add(this.getKeeperOwnerInvTypeQFilter(jsonObject, prefix, suffix, TWO_WAY_LOGO));
        Long warehouse = jsonObject.getLong("warehouse");
        if (warehouse != null) {
            qFilter.and(prefix + "warehouse" + suffix, "=", (Object)warehouse);
        }
        if ((location = jsonObject.getLong("location")) != null) {
            qFilter.and(prefix + "location" + suffix, "=", (Object)location);
        }
        qFilter.and("org", "=", (Object)jsonObject.getLong("org"));
    }

    private QFilter getPurInWarehouseQfilter(JSONObject jsonObject, String prefix, char suffix) {
        Long location;
        QFilter qFilterOrg = new QFilter("org", "=", (Object)jsonObject.getLong("org"));
        Long warehouse = jsonObject.getLong("warehouse");
        if (warehouse != null) {
            qFilterOrg.and(prefix + "warehouse" + suffix, "=", (Object)warehouse);
        }
        if ((location = jsonObject.getLong("location")) != null) {
            qFilterOrg.and(prefix + "location" + suffix, "=", (Object)location);
        }
        qFilterOrg.and(this.getKeeperOwnerInvTypeQFilter(jsonObject, prefix, suffix, TWO_WAY_LOGO));
        return qFilterOrg;
    }

    private void setTransOutBillSpeicalQFilter(JSONObject jsonObject, String prefix, char suffix, List<QFilter> listQFilterTwoWay) {
        QFilter qFilterOut = this.getOutKeeperOwnerInvtypeQFilter(jsonObject, TWO_WAY_LOGO);
        QFilter qFilterTransIn = this.getTransitKeeperOwnerInvTypeQFilter(jsonObject, prefix, suffix, TWO_WAY_LOGO);
        listQFilterTwoWay.add(this.getWarehouseQfilter(jsonObject, prefix, qFilterOut, "org", "warehouse", "location"));
        listQFilterTwoWay.add(this.getWarehouseQfilter(jsonObject, prefix, qFilterTransIn, "org", "inwarehouse", "inlocation"));
        listQFilterTwoWay.add(this.getWarehouseQfilter(jsonObject, prefix, qFilterTransIn, "inorg", "inwarehouse", "inlocation"));
    }

    private QFilter getWarehouseQfilter(JSONObject jsonObject, String prefix, QFilter commonQfilter, String org, String warehouse, String location) {
        Long outlocation;
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        Long outwarehouse = jsonObject.getLong("warehouse");
        if (outwarehouse != null) {
            qFilter.and(prefix + warehouse, "=", (Object)outwarehouse);
        }
        if ((outlocation = jsonObject.getLong("location")) != null) {
            qFilter.and(prefix + location, "=", (Object)outlocation);
        }
        qFilter.and(org, "=", (Object)jsonObject.getLong("org"));
        return qFilter.and(commonQfilter);
    }

    private void setTransDirBillSpeicalQFilter(JSONObject jsonObject, String prefix, char suffix, List<QFilter> listQFilterTwoWay) {
        Long location;
        Long outlocation;
        QFilter qFilterOut = new QFilter("outorg", "=", (Object)jsonObject.getLong("org"));
        qFilterOut.and(this.getOutKeeperOwnerInvtypeQFilter(jsonObject, TWO_WAY_LOGO));
        Long outwarehouse = jsonObject.getLong("warehouse");
        if (outwarehouse != null) {
            qFilterOut.and(prefix + "out" + "warehouse" + suffix, "=", (Object)outwarehouse);
        }
        if ((outlocation = jsonObject.getLong("location")) != null) {
            qFilterOut.and(prefix + "out" + "location" + suffix, "=", (Object)outlocation);
        }
        listQFilterTwoWay.add(qFilterOut);
        QFilter qFilterIn = new QFilter("org", "=", (Object)jsonObject.getLong("org"));
        qFilterIn.and(this.getKeeperOwnerInvTypeQFilter(jsonObject, prefix, suffix, TWO_WAY_LOGO));
        Long warehouse = jsonObject.getLong("warehouse");
        if (warehouse != null) {
            qFilterIn.and(prefix + "warehouse" + suffix, "=", (Object)warehouse);
        }
        if ((location = jsonObject.getLong("location")) != null) {
            qFilterIn.and(prefix + "location" + suffix, "=", (Object)location);
        }
        listQFilterTwoWay.add(qFilterIn);
    }

    private void setGeneralQFilterByDifBill(JSONObject jsonObject, QFilter qFilter, String prefix, char suffix) {
        Long tracknumber;
        Long configuredcode;
        Long project;
        Date expirydate;
        Date producedate;
        String lotnumber;
        Long unit2nd;
        Long unit;
        Long auxpty;
        Long materialId = jsonObject.getLong("material");
        if (materialId != null) {
            if (suffix == ' ') {
                qFilter.and(prefix + "material" + ".masterid", "=", (Object)materialId);
            } else {
                qFilter.and(prefix + "material" + suffix + ".masterid", "=", (Object)materialId);
            }
        }
        if ((auxpty = jsonObject.getLong("auxpty")) != null) {
            qFilter.and(prefix + "auxpty" + suffix, "=", (Object)auxpty);
        }
        if ((unit = jsonObject.getLong("unit")) != null) {
            qFilter.and(prefix + "unit" + suffix, "=", (Object)unit);
        }
        if ((unit2nd = jsonObject.getLong("unit2nd")) != null) {
            qFilter.and(prefix + "unit2nd" + suffix, "=", (Object)unit2nd);
        }
        if ((lotnumber = jsonObject.getString("lotnumber")) != null) {
            qFilter.and(prefix + "lotnumber" + suffix, "=", (Object)lotnumber);
        }
        if ((producedate = jsonObject.getDate("producedate")) != null) {
            qFilter.and(prefix + "producedate" + suffix, "=", (Object)producedate);
        }
        if ((expirydate = jsonObject.getDate("expirydate")) != null) {
            qFilter.and(prefix + "expirydate" + suffix, "=", (Object)expirydate);
        }
        if ((project = jsonObject.getLong("project")) != null) {
            qFilter.and(prefix + "project" + suffix, "=", (Object)project);
        }
        if ((configuredcode = jsonObject.getLong("configuredcode")) != null) {
            qFilter.and(prefix + "configuredcode" + suffix, "=", (Object)configuredcode);
        }
        if ((tracknumber = jsonObject.getLong("tracknumber")) != null) {
            qFilter.and(prefix + "tracknumber" + suffix, "=", (Object)tracknumber);
        }
    }

    private QFilter getKeeperOwnerInvTypeQFilter(JSONObject jsonObject, String prefix, char suffix, String[] billentryLogos) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        for (String billentryLogo : billentryLogos) {
            Object billentryLogoData = jsonObject.get((Object)billentryLogo);
            if (billentryLogoData == null) continue;
            qFilter.and(prefix + billentryLogo + suffix, "=", billentryLogoData);
        }
        return qFilter;
    }

    private QFilter getTransitKeeperOwnerInvTypeQFilter(JSONObject jsonObject, String prefix, char suffix, String[] billentryLogos) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        for (String billentryLogo : billentryLogos) {
            Object billentryLogoData = jsonObject.get((Object)billentryLogo);
            if (billentryLogoData == null) continue;
            if ("owner".equals(billentryLogo) || "ownertype".equals(billentryLogo)) {
                qFilter.and("billentry.transit" + billentryLogo + suffix, "=", billentryLogoData);
                continue;
            }
            qFilter.and(prefix + billentryLogo + suffix, "=", billentryLogoData);
        }
        return qFilter;
    }

    private QFilter getTransitOutKeeperOwnerInvTypeQFilter(JSONObject jsonObject, String prefix, char suffix, String[] billentryLogos) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        for (String billentryLogo : billentryLogos) {
            Object billentryLogoData = jsonObject.get((Object)billentryLogo);
            if (billentryLogoData == null) continue;
            if ("owner".equals(billentryLogo) || "ownertype".equals(billentryLogo)) {
                qFilter.and("billentry.transit" + billentryLogo + suffix, "=", billentryLogoData);
                continue;
            }
            qFilter.and("billentry.out" + billentryLogo + suffix, "=", billentryLogoData);
        }
        return qFilter;
    }

    private QFilter getOutKeeperOwnerInvtypeQFilter(JSONObject jsonObject, String[] billentryLogos) {
        QFilter qFilterOut = null;
        qFilterOut = new QFilter("1", "=", (Object)1);
        for (String billentryLogo : billentryLogos) {
            Object billentryLogoData = jsonObject.get((Object)billentryLogo);
            if (billentryLogoData == null) continue;
            qFilterOut.and("billentry.out" + billentryLogo, "=", billentryLogoData);
        }
        return qFilterOut;
    }

    private Set<String> getAllEntryFieldSeBytNaturalSort(IDataModel bill) {
        Map allEntry = this.getModel().getDataEntityType().getAllEntities();
        EntityType entityType = (EntityType)allEntry.get("billentry");
        Map map = entityType.getFields();
        TreeSet<String> allEntryFieldSet = new TreeSet<String>();
        for (Map.Entry field : map.entrySet()) {
            allEntryFieldSet.add((String)field.getKey());
        }
        return allEntryFieldSet;
    }

    private Map<String, TreeSet<String>> getBillMapSelectFields(Map<String, Map<String, CrvCondition>> conditonMap, Map<String, Map<String, Object>> initFields) {
        DynamicObjectCollection collection = this.getBillFieldMapping();
        HashMap billMapSelectFields = new HashMap(16);
        ArrayList<String> listSelectFiedls = null;
        HashMap<String, TreeSet<String>> billMapSelectFieldsAlias = new HashMap<String, TreeSet<String>>(16);
        TreeSet<String> setSelectFiedlsAlias = null;
        for (DynamicObject dys : collection) {
            HashSet<String> resultMap = new HashSet<String>(16);
            String sourcebill = dys.getString("sourcebill");
            String fidAndSourceBill = sourcebill + ":" + dys.get("id");
            if (billMapSelectFieldsAlias.get(fidAndSourceBill) == null) {
                setSelectFiedlsAlias = new TreeSet<String>();
                billMapSelectFieldsAlias.put(fidAndSourceBill, setSelectFiedlsAlias);
            }
            conditonMap.putIfAbsent(fidAndSourceBill, new HashMap(16));
            Map<String, CrvCondition> entryCrvConditionMap = conditonMap.get(fidAndSourceBill);
            initFields.putIfAbsent(fidAndSourceBill, new HashMap(16));
            Map<String, Object> initFieldMap = initFields.get(fidAndSourceBill);
            String targetobjcol = dys.getString(TARGET_OBJ_COL);
            if (targetobjcol.equals("billtype") && setSelectFiedlsAlias != null) {
                setSelectFiedlsAlias.add(dys.getString(SOURCE_BILL_COL) + ".billformid.name as " + targetobjcol);
                initFieldMap.put(dys.getString(SOURCE_BILL_COL) + ".billformid.name", targetobjcol);
                setSelectFiedlsAlias.add(dys.getString(SOURCE_BILL_COL) + ".billformid.number as formid");
                initFieldMap.put(dys.getString(SOURCE_BILL_COL) + ".billformid.number", "formid");
            } else if (setSelectFiedlsAlias != null) {
                String selectValue = dys.getString("colsmap.selectvalue");
                String formulaDesc = dys.getString("colsmap.formula_tag");
                String sourceBill = dys.getString(SOURCE_BILL_COL);
                resultMap.add(sourceBill);
                String number = dys.getString("number");
                if (SELECT_BY_CONDITION.equals(selectValue)) {
                    CrvCondition build = CrvCondition.build(targetobjcol, sourcebill, number, formulaDesc);
                    entryCrvConditionMap.put(targetobjcol, build);
                } else {
                    initFieldMap.put(sourceBill, targetobjcol);
                    setSelectFiedlsAlias.add(sourceBill + " as " + targetobjcol);
                }
            }
            if (billMapSelectFields.get(fidAndSourceBill) == null) {
                listSelectFiedls = new ArrayList<String>(25);
                billMapSelectFields.put(fidAndSourceBill, listSelectFiedls);
            }
            if (listSelectFiedls == null) continue;
            listSelectFiedls.add(dys.getString(TARGET_OBJ_COL));
        }
        Set<String> allEntryFieldSet = this.getAllEntryFieldSeBytNaturalSort(this.getModel());
        for (Map.Entry entry : billMapSelectFields.entrySet()) {
            TreeSet<String> diffEntryTmp = new TreeSet<String>(allEntryFieldSet);
            diffEntryTmp.removeAll((Collection)entry.getValue());
            Set billMapSelectFieldsAliasValue = (Set)billMapSelectFieldsAlias.get(entry.getKey());
            Map<String, Object> initFieldMap = initFields.get(entry.getKey());
            for (String field : diffEntryTmp) {
                if (field.equals("rowseq")) {
                    if (((String)entry.getKey()).equals(ADJUST_AFTER_FID_COMB) || ((String)entry.getKey()).equals(ASSEMBBILL_BEFORE_FID_COMB)) {
                        billMapSelectFieldsAliasValue.add("billentry.afterentity.seq as " + field);
                        initFieldMap.put("billentry.afterentity.seq", field);
                        continue;
                    }
                    billMapSelectFieldsAliasValue.add("billentry.seq as " + field);
                    initFieldMap.put("billentry.seq", field);
                    continue;
                }
                if (field.equals("materialname") || field.equals("formid")) continue;
                if (field.endsWith("type")) {
                    billMapSelectFieldsAliasValue.add(" ' ' as " + field);
                    continue;
                }
                if ("specialbill".equals(field)) continue;
                billMapSelectFieldsAliasValue.add("0 as " + field);
            }
        }
        return billMapSelectFieldsAlias;
    }

    private DynamicObjectCollection getBillFieldMapping() {
        QFilter qFilter = new QFilter("isenable", "=", (Object)Character.valueOf('1'));
        qFilter.and("targetobj", "=", (Object)"im_count_adjust_map");
        return QueryServiceHelper.query((String)"sbs_billfieldmapping", (String)"id,number,sourcebill,colsmap.targetobjcol,colsmap.sourcebillcol,colsmap.selectvalue,colsmap.formula_tag", (QFilter[])qFilter.toArray(), (String)"id,colsmap.targetobjcol");
    }

    private void buildQfilterAllFields(QFilter qFilter, Set<String> fields) {
        if (qFilter == null) {
            return;
        }
        String[] properties = qFilter.getProperties();
        fields.addAll(Arrays.asList(properties));
        List nests = qFilter.getNests(false);
        if (CollectionUtils.isEmpty((Collection)nests)) {
            return;
        }
        for (QFilter.QFilterNest nest : nests) {
            QFilter filter = nest.getFilter();
            this.buildQfilterAllFields(filter, fields);
        }
    }

    static {
        MAPPING_MDC_BILLTYPE.put("im_mdc_mftmanuinbill", 920040553033394176L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_mftreturnbill", 920039909711047680L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_mftproorder", 767134553327588352L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_mftfeedorder", 767308634408491008L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_mftreturnorder", 767306684862616576L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_ominbill", 989772873411359744L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_omfeedorder", 989633630873884672L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_omproorder", 988376671919052800L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_omreturnorder", 989633164802705408L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_omoutbill", 1223941460995367936L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_omreturnbill", 1223942014215676928L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_omfeedbill", 1223941729976083456L);
        MAPPING_MDC_BILLTYPE.put("im_mdc_omcmplinbill", 1228835943272797184L);
        TWO_WAY_LOGO = new String[]{"invtype", "invstatus", "ownertype", "owner", "keepertype", "keeper"};
    }
}

