/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.count;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.DymAccDSMappingBill;
import kd.scmc.im.business.helper.DymAccDataSourceHelper;
import kd.scmc.im.business.helper.InvcountSchemeHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.consts.InvCountSchemeConst;
import kd.scmc.im.utils.IMStringUtils;

public class InvCountBillAdjustQueryData {
    private static final String TRASCEIVER_RECEIVE = "0";
    private static final String TRASCEIVER_SEND = "1";
    private static final String TRASCEIVER_RECEIVE_AND_SEND = "2";
    private static String ALGOKEY = InvCountBillAdjustQueryData.class.getName();

    public static DataSet getQtyInfoByDymAcc(Map<String, Set<String>> mapSelectData, JSONObject jsonObject) {
        QFilter dateQFilter;
        if ("invacc".equals(jsonObject.get((Object)"backupcondition"))) {
            Date filterdate = jsonObject.getDate("filterdate");
            dateQFilter = new QFilter("auditdate", ">", (Object)filterdate);
        } else {
            dateQFilter = InvcountSchemeHelper.getAdjustBillDateFilter((JSONObject)jsonObject);
        }
        HashMap<String, List<QFilter>> mapSelectBillNoAndListQfilter = new HashMap<String, List<QFilter>>(16);
        for (Map.Entry<String, Set<String>> mapSelectEntry : mapSelectData.entrySet()) {
            List<QFilter> listCommonQFilter = InvCountBillAdjustQueryData.getQFiltersByRowsSelected(jsonObject);
            listCommonQFilter.add(new QFilter("billno", "in", mapSelectEntry.getValue()));
            listCommonQFilter.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
            listCommonQFilter.add(dateQFilter);
            mapSelectBillNoAndListQfilter.put(mapSelectEntry.getKey(), listCommonQFilter);
        }
        List<DymAccDSMappingBill> listDymAccDSMappingBill = InvCountBillAdjustQueryData.getUpdateBillFromDymAccDS();
        DataSet billQtyDataSet = InvCountBillAdjustQueryData.getBillQtyDataSet(listDymAccDSMappingBill, mapSelectBillNoAndListQfilter);
        billQtyDataSet = billQtyDataSet.select("inqty-outqty as qty,inbaseqty-outbaseqty as baseqty,inqty2nd-outqty2nd as qtyunit2nd");
        return billQtyDataSet;
    }

    private static List<QFilter> getQFiltersByRowsSelected(JSONObject jsonObject) {
        Long tracknumber;
        Long configuredcode;
        Long project;
        Long keeper;
        String keepertype;
        Long owner;
        String ownertype;
        Long invstatus;
        Long invtype;
        Long location;
        Long warehouse;
        Date expirydate;
        Date producedate;
        String lotnumber;
        Long unit2nd;
        Long unit;
        Long auxpty;
        ArrayList<QFilter> listQFilter = new ArrayList<QFilter>(20);
        listQFilter.add(new QFilter("org", "=", (Object)jsonObject.getLong("org")));
        Long materialId = jsonObject.getLong("material");
        if (materialId != null) {
            listQFilter.add(new QFilter("material", "=", (Object)materialId));
        }
        if ((auxpty = jsonObject.getLong("auxpty")) != null) {
            listQFilter.add(new QFilter("auxpty", "=", (Object)auxpty));
        }
        if ((unit = jsonObject.getLong("unit")) != null) {
            listQFilter.add(new QFilter("unit", "=", (Object)unit));
        }
        if ((unit2nd = jsonObject.getLong("unit2nd")) != null) {
            listQFilter.add(new QFilter("unit2nd", "=", (Object)unit2nd));
        }
        if ((lotnumber = jsonObject.getString("lotnumber")) != null) {
            listQFilter.add(new QFilter("lotnumber", "=", (Object)lotnumber));
        }
        if ((producedate = jsonObject.getDate("producedate")) != null) {
            listQFilter.add(new QFilter("producedate", "=", (Object)producedate));
        }
        if ((expirydate = jsonObject.getDate("expirydate")) != null) {
            listQFilter.add(new QFilter("expirydate", "=", (Object)expirydate));
        }
        if ((warehouse = jsonObject.getLong("warehouse")) != null) {
            listQFilter.add(new QFilter("warehouse", "=", (Object)warehouse));
        }
        if ((location = jsonObject.getLong("location")) != null) {
            listQFilter.add(new QFilter("location", "=", (Object)location));
        }
        if ((invtype = jsonObject.getLong("invtype")) != null) {
            listQFilter.add(new QFilter("invtype", "=", (Object)invtype));
        }
        if ((invstatus = jsonObject.getLong("invstatus")) != null) {
            listQFilter.add(new QFilter("invstatus", "=", (Object)invstatus));
        }
        if ((ownertype = jsonObject.getString("ownertype")) != null) {
            listQFilter.add(new QFilter("ownertype", "=", (Object)ownertype));
        }
        if ((owner = jsonObject.getLong("owner")) != null) {
            listQFilter.add(new QFilter("owner", "=", (Object)owner));
        }
        if ((keepertype = jsonObject.getString("keepertype")) != null) {
            listQFilter.add(new QFilter("keepertype", "=", (Object)keepertype));
        }
        if ((keeper = jsonObject.getLong("keeper")) != null) {
            listQFilter.add(new QFilter("keeper", "=", (Object)keeper));
        }
        if ((project = jsonObject.getLong("project")) != null) {
            listQFilter.add(new QFilter("project", "=", (Object)project));
        }
        if ((configuredcode = jsonObject.getLong("configuredcode")) != null) {
            listQFilter.add(new QFilter("configuredcode", "=", (Object)configuredcode));
        }
        if ((tracknumber = jsonObject.getLong("tracknumber")) != null) {
            listQFilter.add(new QFilter("tracknumber", "=", (Object)tracknumber));
        }
        return listQFilter;
    }

    private static DataSet getBillQtyDataSet(List<DymAccDSMappingBill> listDymAccDSMappingBill, Map<String, List<QFilter>> mapSelectBillNoAndListQfilter) {
        DataSet billSet = null;
        for (DymAccDSMappingBill dymAccDSMappingBill : listDymAccDSMappingBill) {
            String formid = dymAccDSMappingBill.getSrcbill();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formid);
            boolean isNeedInvScheme = true;
            if ("im_adjustbill".equals(formid) || "im_locationtransfer".equals(formid) || "im_assembbill".equals(formid) || "im_disassemblebill".equals(formid)) {
                isNeedInvScheme = false;
            } else {
                if (!MetaDataHelper.isExistField((IDataEntityType)mainEntityType, (String)"invscheme")) continue;
                isNeedInvScheme = true;
            }
            InvCountBillAdjustQueryData.setSelectedFiledsByFromId(dymAccDSMappingBill, isNeedInvScheme);
            try {
                DataSet billSetTmp;
                if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
                    if (billSet != null) {
                        billSetTmp = InvCountBillAdjustQueryData.handleUpdateBillRecByRecAndSendType(dymAccDSMappingBill, mapSelectBillNoAndListQfilter, isNeedInvScheme);
                        if (billSetTmp == null) continue;
                        billSet = billSet.union(billSetTmp);
                        continue;
                    }
                    billSet = InvCountBillAdjustQueryData.handleUpdateBillRecByRecAndSendType(dymAccDSMappingBill, mapSelectBillNoAndListQfilter, isNeedInvScheme);
                    continue;
                }
                if (!"SUB".equals(dymAccDSMappingBill.getUpdateType())) continue;
                if (billSet != null) {
                    billSetTmp = InvCountBillAdjustQueryData.handleUpdateBillSendByRecAndSendType(dymAccDSMappingBill, mapSelectBillNoAndListQfilter, isNeedInvScheme);
                    if (billSetTmp == null) continue;
                    billSet = billSet.union(billSetTmp);
                    continue;
                }
                billSet = InvCountBillAdjustQueryData.handleUpdateBillSendByRecAndSendType(dymAccDSMappingBill, mapSelectBillNoAndListQfilter, isNeedInvScheme);
            }
            catch (AlgoException algoException) {
                throw new KDBizException(IMStringUtils.append((String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u95f4\u6570\u636eunion\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u201c%s\u201d\u7684\u4f59\u989d\u89c4\u5219\u6620\u5c04\u914d\u7f6e\u3002", (String)"InvCountBillAdjustQueryData_0", (String)"scmc-im-formplugin", (Object[])new Object[0]), algoException.getMessage()), (Object[])new Object[]{formid}));
            }
            catch (Exception e) {
                throw e;
            }
        }
        return billSet;
    }

    private static DataSet handleUpdateBillRecByRecAndSendType(DymAccDSMappingBill dymAccDSMappingBill, Map<String, List<QFilter>> mapSelectBillNoAndListQfilter, boolean isNeedInvScheme) {
        String formid = dymAccDSMappingBill.getSrcbill();
        List<QFilter> recListQFilterTmp = null;
        if ("im_adjustbill".equals(formid)) {
            recListQFilterTmp = mapSelectBillNoAndListQfilter.get("im_adjustbill:im_adjustbill_after");
        } else if ("im_assembbill".equals(formid)) {
            recListQFilterTmp = mapSelectBillNoAndListQfilter.get("im_assembbill:im_assembbill_after");
        } else if ("im_disassemblebill".equals(formid)) {
            recListQFilterTmp = mapSelectBillNoAndListQfilter.get("im_disassemblebill:im_disassemblebill_after");
        } else {
            if (!mapSelectBillNoAndListQfilter.containsKey(formid)) {
                return null;
            }
            recListQFilterTmp = mapSelectBillNoAndListQfilter.get(formid);
        }
        Map selectFiledMap = dymAccDSMappingBill.getMapping();
        if (recListQFilterTmp == null) {
            return null;
        }
        ArrayList<QFilter> recListQFilter = new ArrayList<QFilter>(16);
        for (QFilter qFilter : recListQFilterTmp) {
            recListQFilter.add(qFilter.copy());
        }
        for (QFilter qFilter : recListQFilter) {
            String property = (String)selectFiledMap.get(qFilter.getProperty());
            if (property == null) continue;
            qFilter.__setProperty(property);
        }
        recListQFilter.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        recListQFilter.add(dymAccDSMappingBill.getqFilter());
        if (isNeedInvScheme && !"im_initbill".equals(formid)) {
            recListQFilter.add(new QFilter("invscheme.isnotupdate", "=", (Object)Character.valueOf('0')));
            recListQFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_RECEIVE, TRASCEIVER_RECEIVE_AND_SEND}));
        }
        DataSet billSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)formid, (String)dymAccDSMappingBill.getSelectedFileds(), (QFilter[])recListQFilter.toArray(new QFilter[recListQFilter.size()]), (String)"id asc");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outbaseqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty2nd");
        billSet = billSet.addField("qty", "inqty");
        billSet = billSet.addField("baseqty", "inbaseqty");
        billSet = billSet.addField("qtyunit2nd", "inqty2nd");
        return billSet;
    }

    private static DataSet handleUpdateBillSendByRecAndSendType(DymAccDSMappingBill dymAccDSMappingBill, Map<String, List<QFilter>> mapSelectBillNoAndListQfilter, boolean isNeedInvScheme) {
        String formid = dymAccDSMappingBill.getSrcbill();
        List<QFilter> sendListQFilterTmp = null;
        if ("im_adjustbill".equals(formid)) {
            sendListQFilterTmp = mapSelectBillNoAndListQfilter.get("im_adjustbill:im_adjustbill_before");
        } else if ("im_assembbill".equals(formid)) {
            sendListQFilterTmp = mapSelectBillNoAndListQfilter.get("im_assembbill:im_assembbill_before");
        } else if ("im_disassemblebill".equals(formid)) {
            sendListQFilterTmp = mapSelectBillNoAndListQfilter.get("im_disassemblebill:im_disassemblebill_before");
        } else {
            if (!mapSelectBillNoAndListQfilter.containsKey(formid)) {
                return null;
            }
            sendListQFilterTmp = mapSelectBillNoAndListQfilter.get(formid);
        }
        Map selectFiledMap = dymAccDSMappingBill.getMapping();
        if (sendListQFilterTmp == null) {
            return null;
        }
        ArrayList<QFilter> sendListQFilter = new ArrayList<QFilter>(16);
        for (QFilter qFilter : sendListQFilterTmp) {
            sendListQFilter.add(qFilter.copy());
        }
        for (QFilter qFilter : sendListQFilter) {
            String property = (String)selectFiledMap.get(qFilter.getProperty());
            if (property == null) continue;
            qFilter.__setProperty(property);
        }
        sendListQFilter.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        sendListQFilter.add(dymAccDSMappingBill.getqFilter());
        if (isNeedInvScheme) {
            sendListQFilter.add(new QFilter("invscheme.isnotupdate", "=", (Object)Character.valueOf('0')));
            sendListQFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_SEND, TRASCEIVER_RECEIVE_AND_SEND}));
        }
        DataSet billSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)formid, (String)dymAccDSMappingBill.getSelectedFileds(), (QFilter[])sendListQFilter.toArray(new QFilter[sendListQFilter.size()]), (String)"id asc");
        billSet = billSet.addField("qty", "outqty");
        billSet = billSet.addField("baseqty", "outbaseqty");
        billSet = billSet.addField("qtyunit2nd", "outqty2nd");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "inqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "inbaseqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "inqty2nd");
        return billSet;
    }

    private static List<DymAccDSMappingBill> getUpdateBillFromDymAccDS() {
        List dymAccDSMappingBillList = DymAccDataSourceHelper.getUpdateBillFromDymAccDS((boolean)true);
        for (DymAccDSMappingBill dymAccDSMappingBill : dymAccDSMappingBillList) {
            Set dimensionSetStrs = InvCountSchemeConst.getDymaccModelDimension();
            Map mapping_old = dymAccDSMappingBill.getMapping();
            HashMap<String, String> mapping_new = new HashMap<String, String>(mapping_old.size());
            for (Map.Entry entry : mapping_old.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (dimensionSetStrs.contains(key)) {
                    mapping_new.put(key, value);
                    continue;
                }
                if ("lotnum".equals(key)) {
                    mapping_new.put("lotnumber", value);
                    continue;
                }
                if (!"qty2nd".equals(key)) continue;
                mapping_new.put("qtyunit2nd", value);
            }
            dymAccDSMappingBill.setMapping(mapping_new);
        }
        return dymAccDSMappingBillList;
    }

    private static void setSelectedFiledsByFromId(DymAccDSMappingBill dymAccDSMappingBill, boolean isNeedInvScheme) {
        String[] columnFileds = InvCountSchemeConst.getQtyfileds();
        Map mapping = dymAccDSMappingBill.getMapping();
        Set keySet = mapping.keySet();
        ArrayList<String> selectFiledFromDB = new ArrayList<String>();
        for (String columnFiled : columnFileds) {
            if (!keySet.contains(columnFiled)) continue;
            selectFiledFromDB.add((String)mapping.get(columnFiled) + " as " + columnFiled);
        }
        dymAccDSMappingBill.setSelectedFileds(String.join((CharSequence)",", selectFiledFromDB.toArray(new String[selectFiledFromDB.size()])));
    }
}

