/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.count;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.ErrorCode;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MaterialWhRelationHelper;
import kd.scmc.im.business.helper.OperatorGroupHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class InvCountBillBeforeF7Select {
    private IFormView view = null;
    private IDataModel model;

    public InvCountBillBeforeF7Select(IFormView view) {
        this.view = view;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        int rowIndex = e.getRow();
        switch (key) {
            case "material": {
                MaterialWhRelationHelper.addWarehouseSetupFilter((BeforeF7SelectEvent)e, (ListShowParameter)showParameter, (IDataModel)this.getModel(), (String)"warehouse");
                break;
            }
            case "unit": {
                this.beforeUnit(showParameter, this.getModel(), rowIndex);
                break;
            }
            case "operator": 
            case "checker": 
            case "checker2nd": {
                this.handleOperatorF7SelectEvent(showParameter);
                break;
            }
            case "operatorgroup": {
                this.handleOperatorGroupF7SelectEvent(showParameter);
                break;
            }
            case "owner": {
                this.handleOwnerF7SelectEvent(showParameter, org, rowIndex);
                break;
            }
            case "warehouse": {
                this.handleWarehouseF7SelectEvent(showParameter, org, this.getModel(), e);
                break;
            }
            case "location": {
                this.handleLocationF7SelectEvent(e, showParameter, rowIndex);
                break;
            }
            case "lot": {
                this.beforeLotSelectF7(rowIndex, e, key);
                break;
            }
            case "configuredcode": 
            case "tracknumber": {
                this.beforeTrackNumOrConfigCode(showParameter, rowIndex, key);
                break;
            }
        }
    }

    private void beforeTrackNumOrConfigCode(ListShowParameter showParameter, int rowIndex, String field) {
        QFilter qFilter = null;
        if (field.equalsIgnoreCase("configuredcode")) {
            Object value = this.getModel().getValue("material", rowIndex);
            if (value != null) {
                DynamicObject material = (DynamicObject)value;
                qFilter = InvBillHelper.getConfigureCodeFilter((Object)material.get("masterid.id"));
            }
        } else {
            qFilter = InvBillHelper.getTrackNumberFilter();
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeLotSelectF7(int rowIndex, BeforeF7SelectEvent e, String fieldKey) {
        IDataModel bill = this.getModel();
        DynamicObject dynamicObject = bill.getDataEntity();
        DynamicObject selectEntry = bill.getEntryRowEntity("billentry", rowIndex);
        String lotidField = "billentry." + fieldKey;
        LotMainFileHelper.setLotMainfFileF7Filter((BeforeF7SelectEvent)e, (DynamicObject)dynamicObject, (DynamicObject)selectEntry, (String)lotidField);
    }

    private void beforeUnit(ListShowParameter showParameter, IDataModel bill, int rowIndex) {
        DynamicObject baseUnit;
        Long masterMaterialId = 0L;
        Object material = bill.getValue("material", rowIndex);
        if (material instanceof DynamicObject) {
            DynamicObject masterid = ((DynamicObject)material).getDynamicObject("masterid");
            masterMaterialId = (Long)masterid.getPkValue();
        }
        Long srcmuId = (baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex)) == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
        List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1", (Boolean)Boolean.FALSE);
        QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void handleLocationF7SelectEvent(BeforeF7SelectEvent e, ListShowParameter showParameter, int rowIndex) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", rowIndex);
        if (warehouse == null) {
            this.view.showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_WAREHOUSE(), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter qFilter1 = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
        showParameter.getListFilterParameter().setFilter(qFilter1);
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(String.valueOf(location.getPkValue())));
        }
        return ids;
    }

    private void handleWarehouseF7SelectEvent(ListShowParameter showParameter, DynamicObject org, IDataModel bill, BeforeF7SelectEvent e) {
        String formId = this.getModel().getDataEntityType().getName();
        int rowIdx = bill.getEntryCurrentRowIndex("billentry");
        DynamicObject entity = bill.getEntryRowEntity("billentry", rowIdx);
        QFilter qFilter = WareHouseIsolateHelper.getWarehouseIsolateQFilterByDataCtrl((DynamicObject)entity, (String)formId, (String)e.getProperty().getName());
        if (null != qFilter) {
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else {
            Long[] allFinishInitWarehouseIDs = WarehouseHelper.getAllFinishInitWarehouseIDs((Long)((Long)org.getPkValue()));
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allFinishInitWarehouseIDs));
        }
    }

    private void handleOwnerF7SelectEvent(ListShowParameter showParameter, DynamicObject org, int rowIndex) {
        String ownerType;
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        ArrayList array = new ArrayList();
        DynamicObject rowData = this.getModel().getEntryRowEntity("billentry", rowIndex);
        switch (ownerType = rowData.getString("ownertype")) {
            case "bd_customer": 
            case "bd_supplier": {
                return;
            }
        }
        array = OwnerHelper.getOwners((Long)((Long)org.getPkValue()), (Long)((Long)billType.getPkValue()));
        if (array.size() != 0) {
            QFilter ownerFilter = new QFilter("id", "in", (Object)array);
            showParameter.getListFilterParameter().setFilter(ownerFilter);
        }
    }

    private IDataModel getModel() {
        this.model = this.view.getModel();
        return this.model;
    }

    private void handleOperatorGroupF7SelectEvent(ListShowParameter showParameter) {
        DynamicObject operator = (DynamicObject)this.getModel().getValue("operator");
        if (operator == null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0));
        } else {
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
            QFilter qFilter = new QFilter("id", "in", this.getOperatorGroupByUser((Long)operator.getDynamicObject("operatorid").getPkValue()));
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void handleOperatorF7SelectEvent(ListShowParameter showParameter) {
        Object operatorGroupIsolate;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("1", "=", (Object)2));
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        String formId = this.getModel().getDataEntityType().getName();
        Map customParas = showParameter.getCustomParams();
        if (customParas != null && customParas.get("sourceformid") != null && customParas.get("orgViewType") != null) {
            formId = (String)customParas.get("sourceformid");
        }
        if ((operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)formId, (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate")) instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
            QFilter qFilter1 = OperatorGroupHelper.getOperatorGroupByUserForAll((long)userId, (DynamicObject)org);
            QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType());
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setFilter(qFilter2.and(qFilter3).and(qFilter1));
        } else {
            QFilter qFilter1 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg((Long)org.getPkValue()));
            QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType());
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2, qFilter3));
        }
    }

    private String getOperatorGroupType() {
        return OperatorGrpTypeEnum.INVENTORYGRP.getValue();
    }

    private ArrayList<Long> getOperatorGroupByUser(long userID) {
        String formId = this.getModel().getDataEntityType().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userID);
        QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType(formId, this.getOrgViewType()));
        qFilter2.and(new QFilter("invalid", "=", (Object)"0"));
        QFilter qFilter3 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg((Long)org.getPkValue()));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        if (map != null && map.size() > 0) {
            ArrayList list = new ArrayList(map.values());
            for (int i = 0; i < list.size(); ++i) {
                operatorGroupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }

    private String getOrgViewType() {
        String orgViewType = null;
        String formId = this.getModel().getDataEntityType().getName();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        OrgProp org = (OrgProp)dataEntityType.getProperty("org");
        orgViewType = org.getOrgFunc();
        return orgViewType;
    }

    private String getOperatorGroupType(String formId, String orgFunc) {
        if (orgFunc == null || orgFunc.isEmpty()) {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)formConfig.getAppId());
            orgFunc = appInfo.getOrgFunc();
        }
        String operatorGrpType = null;
        if ("02".equals(orgFunc)) {
            operatorGrpType = OperatorGrpTypeEnum.PURCHASEGRP.getValue();
        } else if ("03".equals(orgFunc)) {
            operatorGrpType = OperatorGrpTypeEnum.SALEGRP.getValue();
        } else if ("05".equals(orgFunc)) {
            operatorGrpType = OperatorGrpTypeEnum.INVENTORYGRP.getValue();
        }
        return operatorGrpType;
    }

    private ArrayList<Long> getOperatorGroupByOrg(long orgID) {
        QFilter operatorFilter;
        QFilter enableFilter;
        QFilter qFilter2;
        String formId = this.getModel().getDataEntityType().getName();
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgID);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("operatorgrouptype", "=", (Object)this.getOperatorGroupType(formId, this.getOrgViewType())), enableFilter = new QFilter("enable", "=", (Object)"1"), operatorFilter = new QFilter("entryentity.operator.enable", "=", (Object)"1")});
        if (map != null && map.size() > 0) {
            ArrayList list = new ArrayList(map.values());
            for (int i = 0; i < list.size(); ++i) {
                operatorGroupList.add((Long)((DynamicObject)list.get(i)).getPkValue());
            }
        }
        return operatorGroupList;
    }
}

