/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.count;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.BillQtyAndUnitHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.PrecisionAccountHelper;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.helper.ShelfLifeDateUtil;
import kd.scmc.im.utils.BigDecimalUtils;
import kd.scmc.im.utils.CommonUtils;

public class InvCountBillPropChanged {
    private IFormPlugin plugin;
    private IFormView view = null;
    private static Log logger = LogFactory.getLog(InvCountBillPropChanged.class);

    public InvCountBillPropChanged(IFormView view, IFormPlugin plugin) {
        this.view = view;
        this.plugin = plugin;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "material": {
                this.changeMaterialEvent((DynamicObject)newValue, rowIndex);
                break;
            }
            case "qty": 
            case "unit": 
            case "baseqty": 
            case "gainqty": 
            case "lossqty": 
            case "qtyacc": 
            case "checkqty": {
                this.changeQtyOrUnit(propName, newValue, rowIndex);
                break;
            }
            case "checkqtyunit2nd": 
            case "qtyunit2nd": 
            case "qty2ndacc": {
                this.changGainAndLossQty2nd(propName, rowIndex);
                break;
            }
            case "operator": {
                this.changeOperator((DynamicObject)newValue);
                break;
            }
            case "operatorgroup": {
                this.changeOperatorGroup((DynamicObject)newValue);
                break;
            }
            case "ownertype": {
                this.changeOwnerAndKeeperType(newValue, "owner", rowIndex);
                break;
            }
            case "keepertype": {
                this.changeOwnerAndKeeperType(newValue, "keeper", rowIndex);
                break;
            }
            case "warehouse": {
                this.changeWarehouse(valueSet);
                break;
            }
            case "producedate": {
                this.changeProduceDate(oldValue, (Date)newValue, rowIndex);
                break;
            }
            case "expirydate": {
                this.changeExpirydate(oldValue, (Date)newValue, rowIndex);
                break;
            }
            case "lot": {
                this.changeLot(e, propName, rowIndex);
                break;
            }
            case "lotnumber": {
                this.changeLotNumber(rowIndex);
                break;
            }
        }
    }

    private void changeLot(PropertyChangedArgs e, String fieldKey, int rowIndex) {
        String entryName = "billentry";
        String lotidField = "billentry." + fieldKey;
        String lotnumberField = "lotnumber";
        LotMainFileHelper.changeLot((PropertyChangedArgs)e, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)entryName, (int)rowIndex, (String)lotidField, (String)lotnumberField);
    }

    private void changeLotNumber(int rowIndex) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"lot", null, (int)rowIndex, (boolean)false);
    }

    private void changeProduceDate(Object oldValue, Date date, int rowIndex) {
        String calculationForEndDate;
        int shelflife;
        if (date == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", rowIndex);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)true)) {
            Date expirydate = (Date)model.getValue("expirydate", rowIndex);
            this.checkShelflifeDate(date, expirydate, rowIndex, "producedate", materialInvInfo);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        Date expirydate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife = materialInvInfo.getInt("shelflife")), (Date)date, (String)(calculationForEndDate = materialInvInfo.getString("calculationforenddate")));
        if (expirydate.before(date)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(date);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImBillPropChanged_9", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue("producedate", null, rowIndex, false);
            return;
        }
        Date oldExpirydate = (Date)model.getValue("expirydate", rowIndex);
        this.showExpiryDateConfirm(rowIndex, materialInvInfo, oldExpirydate, expirydate, (Date)oldValue, date);
    }

    private void changeExpirydate(Object oldValue, Date date, int rowIndex) {
        if (date == null) {
            return;
        }
        IDataModel model = this.getModel();
        Date oldProducedate = (Date)model.getValue("producedate", rowIndex);
        DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", rowIndex);
        if (!MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)false)) {
            this.checkShelflifeDate(oldProducedate, date, rowIndex, "expirydate", materialInvInfo);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        int shelflife = materialInvInfo.getInt("shelflife");
        String calculationForEndDate = materialInvInfo.getString("calculationforenddate");
        Date producedate = oldProducedate;
        if (!"2".equals(calculationForEndDate)) {
            producedate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife * -1), (Date)date, (String)calculationForEndDate);
        } else if (producedate != null && date.before(producedate)) {
            Date oldExpirydate = (Date)oldValue;
            if (oldExpirydate != null && oldExpirydate.before(producedate)) {
                oldExpirydate = null;
            }
            String newExpirydateStr = this.getDateStr(date);
            String newProduceDateStr = this.getDateStr(producedate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u3002\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"ImBillPropChanged_99", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue("expirydate", oldExpirydate, rowIndex, false);
            return;
        }
        this.showExpiryDateConfirm(rowIndex, materialInvInfo, (Date)oldValue, date, oldProducedate, producedate);
    }

    private void showExpiryDateConfirm(int rowIndex, DynamicObject materialInvInfo, Date oldExpiryDate, Date newExpiryDate, Date oldProducedate, Date newProducedate) {
        String billName = this.getModel().getDataEntityType().getName();
        String entryName = "billentry";
        boolean isOutBill = InvBillHelper.isOutEntry((String)billName, (String)entryName);
        boolean isInBill = InvBillHelper.isInEntry((String)billName, (String)entryName);
        String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
        int dateOfOverdueForIn = materialInvInfo.getInt("dateofoverdueforin");
        int dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout");
        int dateOfOverdue = 0;
        if (isOutBill && isInBill) {
            dateOfOverdue = dateOfOverdueForOut > dateOfOverdueForIn ? dateOfOverdueForOut : dateOfOverdueForIn;
        } else if (isOutBill) {
            dateOfOverdue = dateOfOverdueForOut;
        } else if (isInBill) {
            dateOfOverdue = dateOfOverdueForIn;
        }
        Date overdueDate = ShelfLifeDateUtil.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdue, (Date)newExpiryDate);
        Date nowDate = new Date();
        boolean dateOver = nowDate.after(overdueDate);
        ArrayList alertMsgList = new ArrayList(2);
        if (dateOver) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String newExpirydateStr = this.getDateStr(newExpiryDate);
            String oldExpirydateStr = this.getDateStr(oldExpiryDate);
            String newProducedateStr = this.getDateStr(newProducedate);
            String oldProducedateStr = this.getDateStr(oldProducedate);
            params.put("newProduceDate", newProducedateStr);
            params.put("oldProduceDate", oldProducedateStr);
            params.put("newExpiryDate", newExpirydateStr);
            params.put("oldExpiryDate", oldExpirydateStr);
            params.put("index", rowIndex);
            alertMsgList.add(params);
            ConfirmCallBackListener cb = new ConfirmCallBackListener("MaterialLifeDate", this.plugin);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u4e3a\u201c%3$s\u201d,\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"ImBillPropChanged_7", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        } else {
            this.setValue("producedate", newProducedate, rowIndex, false);
            this.setValue("expirydate", newExpiryDate, rowIndex, false);
        }
    }

    private void changGainAndLossQty2nd(String propName, int index) {
        IDataModel bill = this.getModel();
        DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material", index);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInvInfo);
        if (material == null) {
            return;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        IPageCache pageCache = ((AbstractFormPlugin)this.plugin).getPageCache();
        this.changeAuxptyQty(bill, index, material, propName, pageCache);
        BigDecimal qtyunit2nd = (BigDecimal)bill.getValue("qtyunit2nd", index);
        bill.beginInit();
        this.changeGainAndLossQtly(qtyunit2nd, bill, "qty2ndacc", "gainqty2nd", "lossqty2nd", "adjustqtyunit2nd", "checkqtyunit2nd", index);
        bill.endInit();
        BillViewHelper.updateViewRow((IFormView)this.view, (int)index, (String)"billentry");
    }

    private void changeAuxptyQty(IDataModel bill, int rowindex, DynamicObject material, String propName, IPageCache pageCache) {
        boolean isConvert;
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (!isConvert) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        BigDecimal qtyUnit2nd = (BigDecimal)bill.getValue(propName, rowindex);
        String baseQtyField = InvCountBillPropChanged.getBaseQtyField(propName);
        BigDecimal baseQty = (BigDecimal)bill.getValue(baseQtyField, rowindex);
        BigDecimal unit2ndRate = InvCountBillPropChanged.getAuxptyRateCache(pageCache, material);
        if (unit2ndRate == null || BigDecimal.ZERO.compareTo(unit2ndRate) == 0) {
            return;
        }
        unit2ndRate = unit2ndRate.setScale(10);
        baseQty = qtyUnit2nd.multiply(unit2ndRate);
        baseQty = PrecisionAccountHelper.dealWithprecision((IDataModel)bill, (String)"baseunit", (int)rowindex, (BigDecimal)baseQty);
        BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)baseQty, (String)"baseqty");
        bill.beginInit();
        bill.setValue(baseQtyField, (Object)baseQty, rowindex);
        bill.endInit();
        this.setQtyByBaseQtyChange(bill, rowindex, material, baseUnit, baseQty, propName);
    }

    private static String getBaseQtyField(String propName) {
        String baseQtyField = "baseqty";
        switch (propName) {
            case "checkqtyunit2nd": {
                baseQtyField = "checkbaseqty";
                break;
            }
            case "qty2ndacc": {
                baseQtyField = "baseqtyacc";
                break;
            }
        }
        return baseQtyField;
    }

    public static void showQtyErrorTip(BigDecimal qtyAmount) {
        CommonUtils.showQtyErrorTip((BigDecimal)qtyAmount);
    }

    private void setQtyByBaseQtyChange(IDataModel bill, int rowindex, DynamicObject material, DynamicObject baseUnit, BigDecimal baseQty, String propName) {
        BigDecimal qty = BigDecimal.ZERO;
        if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObject unit = (DynamicObject)bill.getValue("unit", rowindex);
            if (unit == null) {
                return;
            }
            BigDecimal unitRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)((Long)unit.getPkValue()), (Long)((Long)baseUnit.getPkValue()));
            if (unitRate == null || unitRate.compareTo(BigDecimal.ZERO) == 0 || baseQty.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            unitRate = unitRate.setScale(10);
            qty = baseQty.divide(unitRate, unit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)unit.getInt("precisionaccount")));
        }
        InvCountBillPropChanged.showQtyErrorTip(qty);
        String qtyField = InvCountBillPropChanged.getQtyField(propName);
        this.setValue(qtyField, qty, rowindex, false);
        this.calculateGainAndLossQty(bill, true, rowindex);
    }

    private static String getQtyField(String propName) {
        String qtyField = "qty";
        switch (propName) {
            case "checkqtyunit2nd": {
                qtyField = "checkqty";
                break;
            }
            case "qty2ndacc": {
                qtyField = "qtyacc";
                break;
            }
        }
        return qtyField;
    }

    public static BigDecimal getAuxptyRateCache(IPageCache pageCache, DynamicObject material) {
        if (material == null) {
            return null;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        DynamicObject baseUnit = material.getDynamicObject("baseunit");
        if (auxptyUnit == null || baseUnit == null) {
            return null;
        }
        BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)((Long)auxptyUnit.getPkValue()), (Long)((Long)baseUnit.getPkValue()), (IPageCache)pageCache);
        return unit2ndRate;
    }

    private void changeWarehouse(ChangeData[] valueSet) {
        for (int i = 0; i < valueSet.length; ++i) {
            Object oldValue;
            Object newValue = valueSet[i].getNewValue();
            if (newValue == (oldValue = valueSet[i].getOldValue())) {
                return;
            }
            int rowindex = valueSet[i].getRowIndex();
            this.getModel().setValue("location", null, rowindex);
            if (newValue == null) continue;
            boolean isopenlocation = ((DynamicObject)newValue).getBoolean("isopenlocation");
            this.view.setEnable(Boolean.valueOf(isopenlocation), rowindex, new String[]{"location"});
        }
    }

    private void changeOwnerAndKeeperType(Object newValue, String field, int rowIndex) {
        if ("bos_org".equals(newValue)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.dealOwnerAndKeeper(org, Boolean.FALSE, field, rowIndex);
        } else {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{field});
        }
    }

    private void changeOperator(DynamicObject operator) {
        if (operator != null) {
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
            this.getModel().setValue("operatorgroup", operator.get("operatorgrpid"));
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            List deptids = OrgServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)((Long)org.getPkValue()), (Long)0L);
            if (deptids != null && deptids.size() > 0) {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)false);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    for (Long deptId : userdeptIds) {
                        if (!deptids.contains(deptId)) continue;
                        this.getModel().setValue("dept", (Object)deptId);
                        break;
                    }
                }
            } else {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)false);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    this.getModel().setValue("dept", userdeptIds.get(0));
                }
            }
        } else {
            this.getModel().setValue("operatorgroup", null);
            this.getModel().setValue("dept", null);
        }
    }

    private void changeOperatorGroup(DynamicObject operatorGroup) {
        if (operatorGroup == null) {
            this.getModel().setValue("operator", null);
        }
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    private void changeMaterialEvent(DynamicObject materialInvInfo, int rowIndex) {
        this.clearMaterialInfo(this.getModel(), rowIndex);
        this.getView().setEnable(Boolean.valueOf(materialInvInfo != null), rowIndex, new String[]{"configuredcode"});
        if (materialInvInfo != null) {
            this.resetMaterialInfo(this.getModel(), materialInvInfo, rowIndex);
        } else {
            this.getModel().setValue("materialmasterid", null, rowIndex);
        }
    }

    private void changeQtyOrUnit(String propName, Object newValue, int rowIndex) {
        Object material = this.getModel().getValue("material", rowIndex);
        if (material == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"BillBizQtyPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        this.calculateGainAndLossQty(this.getModel(), false, rowIndex);
    }

    private void calculateGainAndLossQty(IDataModel model, Boolean fromQty2ndChanged, int entryCurrentRowIndex) {
        boolean isConvert;
        DynamicObject materialInvInfo = (DynamicObject)model.getEntryRowEntity("billentry", entryCurrentRowIndex).get("material");
        DynamicObject material = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInvInfo);
        if (material == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"BillBizQtyPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        DynamicObject unit = (DynamicObject)model.getEntryRowEntity("billentry", entryCurrentRowIndex).get("unit");
        DynamicObject baseunit = (DynamicObject)model.getEntryRowEntity("billentry", entryCurrentRowIndex).get("baseunit");
        DynamicObject unit2nd = (DynamicObject)model.getEntryRowEntity("billentry", entryCurrentRowIndex).get("unit2nd");
        BigDecimal baseunitRate = BillQtyAndUnitHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)(unit == null ? null : (Long)unit.getPkValue()), baseunit == null ? null : (Long)baseunit.getPkValue());
        BigDecimal unit2ndRate = BillQtyAndUnitHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)(unit == null ? null : (Long)unit.getPkValue()), unit2nd == null ? null : (Long)unit2nd.getPkValue());
        BigDecimal qty = (BigDecimal)model.getValue("qty", entryCurrentRowIndex);
        BigDecimal qtyacc = (BigDecimal)model.getValue("qtyacc", entryCurrentRowIndex);
        BigDecimal checkqty = (BigDecimal)model.getValue("checkqty", entryCurrentRowIndex);
        BigDecimal adjustqty = (BigDecimal)model.getValue("adjustqty", entryCurrentRowIndex);
        BigDecimal baseQty = qty.multiply(baseunitRate);
        baseQty = PrecisionAccountHelper.dealWithprecision((IDataModel)model, (String)"baseunit", (int)entryCurrentRowIndex, (BigDecimal)baseQty);
        this.setValue("baseqty", baseQty, entryCurrentRowIndex, false);
        BigDecimal checkBaseQty = checkqty.multiply(baseunitRate);
        checkBaseQty = PrecisionAccountHelper.dealWithprecision((IDataModel)model, (String)"baseunit", (int)entryCurrentRowIndex, (BigDecimal)checkBaseQty);
        this.setValue("checkbaseqty", checkBaseQty, entryCurrentRowIndex, false);
        model.beginInit();
        this.changeGainAndLossQtly(qty, model, "qtyacc", "gainqty", "lossqty", "adjustqty", "checkqty", entryCurrentRowIndex);
        model.endInit();
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (isConvert && !fromQty2ndChanged.booleanValue()) {
            model.beginInit();
            BigDecimal qtyunit2nd = qty.multiply(unit2ndRate);
            qtyunit2nd = PrecisionAccountHelper.dealWithprecision((IDataModel)model, (String)"unit2nd", (int)entryCurrentRowIndex, (BigDecimal)qtyunit2nd);
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)model, (BigDecimal)qtyunit2nd, (String)"qtyunit2nd");
            this.setValue("qtyunit2nd", qtyunit2nd, entryCurrentRowIndex, false);
            BigDecimal checkqtyunit2nd = checkqty.multiply(unit2ndRate);
            checkqtyunit2nd = PrecisionAccountHelper.dealWithprecision((IDataModel)model, (String)"unit2nd", (int)entryCurrentRowIndex, (BigDecimal)checkqtyunit2nd);
            this.setValue("checkqtyunit2nd", checkqtyunit2nd, entryCurrentRowIndex, false);
            BigDecimal adjustqtyunit2nd = adjustqty.multiply(unit2ndRate);
            adjustqtyunit2nd = PrecisionAccountHelper.dealWithprecision((IDataModel)model, (String)"unit2nd", (int)entryCurrentRowIndex, (BigDecimal)adjustqtyunit2nd);
            this.setValue("adjustqtyunit2nd", adjustqtyunit2nd, entryCurrentRowIndex, false);
            this.changeGainAndLossQtly(qtyunit2nd, model, "qty2ndacc", "gainqty2nd", "lossqty2nd", "adjustqtyunit2nd", "checkqtyunit2nd", entryCurrentRowIndex);
            model.endInit();
        }
        this.changeGainAndLossQtly(qty.multiply(baseunitRate), model, "baseqtyacc", "basegainqty", "baselossqty", "adjustbaseqty", "checkbaseqty", entryCurrentRowIndex);
        BillViewHelper.updateViewRow((IFormView)this.view, (int)entryCurrentRowIndex, (String)"billentry");
    }

    private void changeGainAndLossQtly(BigDecimal newValue, IDataModel model, String accField, String gainField, String lossField, String adjustField, String checkField, int currentRow) {
        boolean enablecheck = (Boolean)model.getValue("enablecheck");
        BigDecimal gainQty = BigDecimal.ZERO;
        BigDecimal lossQty = BigDecimal.ZERO;
        BigDecimal checkqty = (BigDecimal)model.getValue(checkField, currentRow);
        BigDecimal adjustqty = (BigDecimal)model.getValue(adjustField, currentRow);
        BigDecimal acc = (BigDecimal)model.getValue(accField, currentRow);
        BigDecimal countAcc = acc.add(adjustqty);
        if (enablecheck) {
            newValue = checkqty;
        }
        gainQty = lossQty = newValue.subtract(acc).subtract(adjustqty);
        if (newValue.compareTo(BigDecimal.ZERO) >= 0 && countAcc.compareTo(BigDecimal.ZERO) < 0) {
            model.setValue(gainField, (Object)gainQty, currentRow);
            model.setValue(lossField, (Object)BigDecimal.ZERO, currentRow);
        }
        if (newValue.compareTo(countAcc) >= 0 && countAcc.compareTo(BigDecimal.ZERO) >= 0) {
            model.setValue(gainField, (Object)gainQty, currentRow);
            model.setValue(lossField, (Object)BigDecimal.ZERO, currentRow);
        }
        if (newValue.compareTo(countAcc) < 0 && countAcc.compareTo(BigDecimal.ZERO) >= 0) {
            model.setValue(gainField, (Object)BigDecimal.ZERO, currentRow);
            model.setValue(lossField, (Object)lossQty.abs(), currentRow);
        }
    }

    private void clearMaterialInfo(IDataModel bill, int rowindex) {
        bill.beginInit();
        bill.setValue("unit", null, rowindex);
        bill.setValue("qty", null, rowindex);
        bill.setValue("baseunit", null, rowindex);
        bill.setValue("baseqty", null, rowindex);
        bill.setValue("auxpty", null, rowindex);
        bill.setValue("unit2nd", null, rowindex);
        bill.setValue("qtyunit2nd", null, rowindex);
        bill.setValue("producedate", null, rowindex);
        bill.setValue("expirydate", null, rowindex);
        bill.setValue("lotnumber", null, rowindex);
        bill.setValue("lot", null, rowindex);
        bill.setValue("configuredcode", null, rowindex);
        bill.endInit();
        BillViewHelper.updateViewRow((IFormView)this.view, (int)rowindex, (String)"billentry");
    }

    private void resetMaterialInfo(IDataModel bill, DynamicObject materialInvInfo, int rowIndex) {
        DynamicObject masterMaterial = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInvInfo);
        bill.setValue("materialmasterid", (Object)masterMaterial, rowIndex);
        this.getView().setEnable(Boolean.valueOf("2".equals(masterMaterial.get("configproperties"))), rowIndex, new String[]{"configuredcode"});
        DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
        bill.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
        boolean isOnShelf = materialInvInfo.getBoolean("enableshelflifemgr");
        this.view.setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"producedate"});
        this.view.setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"expirydate"});
        boolean isuseauxpty = masterMaterial.getBoolean("isuseauxpty");
        if (isuseauxpty) {
            this.view.setVisible(Boolean.valueOf(isuseauxpty), new String[]{"auxpty"});
            this.view.setEnable(Boolean.valueOf(isuseauxpty), rowIndex, new String[]{"auxpty"});
        } else {
            this.view.setEnable(Boolean.valueOf(isuseauxpty), rowIndex, new String[]{"auxpty"});
        }
        DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
        if (auxptyUnit != null) {
            BigDecimal unit2ndRate = BillQtyAndUnitHelper.getUnitRateConv((Long)((Long)masterMaterial.getPkValue()), (Long)((Long)auxptyUnit.getPkValue()), (Long)((Long)baseUnit.getPkValue()));
            logger.info("\u7269\u6599\u6539\u53d8\uff0c\u8ba1\u7b97\u51fa\u7684\u8f85\u52a9\u6362\u7b97\u7387\u4e3a\uff1a" + unit2ndRate);
            unit2ndRate = unit2ndRate == null ? BigDecimal.ZERO : unit2ndRate;
            bill.setValue("unit2nd", auxptyUnit.getPkValue(), rowIndex);
            this.view.setVisible(Boolean.TRUE, new String[]{"unit2nd"});
            this.view.setVisible(Boolean.TRUE, new String[]{"qtyunit2nd"});
            this.view.setEnable(Boolean.TRUE, rowIndex, new String[]{"qtyunit2nd"});
        } else {
            this.view.setEnable(Boolean.FALSE, rowIndex, new String[]{"qtyunit2nd"});
            this.view.setEnable(Boolean.FALSE, rowIndex, new String[]{"checkqtyunit2nd"});
        }
        boolean enablelot = materialInvInfo.getBoolean("enablelot");
        if (enablelot) {
            this.view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{"lotnumber"});
            this.view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{"lot"});
        } else {
            this.view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"lotnumber"});
            this.getModel().setValue("lotnumber", null);
            this.view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"lot"});
            this.getModel().setValue("lot", null);
        }
        DynamicObject unit = materialInvInfo.getDynamicObject("inventoryunit");
        bill.setValue("unit", unit.getPkValue(), rowIndex);
        BillViewHelper.updateViewRow((IFormView)this.view, (int)rowIndex, (String)"billentry");
    }

    private void dealOwnerAndKeeper(DynamicObject org, boolean isCreateNew, String field, int rowIndex) {
        String typeField = "ownertype";
        Long orgId = (Long)org.getPkValue();
        Long ownerID = OwnerHelper.getDefaultOwner((Long)orgId);
        if ("keeper".equals(field)) {
            typeField = "keepertype";
            ownerID = orgId;
        }
        if (isCreateNew) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                Object type = this.getModel().getValue(typeField, i);
                if (!"bos_org".equals(type)) continue;
                this.getModel().setValue(field, (Object)ownerID, rowIndex);
            }
        } else {
            Object type = this.getModel().getValue(typeField, rowIndex);
            if ("bos_org".equals(type)) {
                this.getModel().setValue(field, (Object)ownerID, rowIndex);
                if ("keeper".equals(field)) {
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{field});
                }
            }
        }
    }

    private IFormView getView() {
        return this.view;
    }

    public void setValue(String key, Object value, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (boolean)isTriggerChangeEvent);
    }

    public void setValue(String key, Object value, int i, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (int)i, (boolean)isTriggerChangeEvent);
    }

    private String getDateStr(Date date) {
        String dateStr = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        dateStr = sd.format(date);
        return dateStr;
    }

    public void handleNewImportEntry(int rowIndex) {
        DynamicObject materialInvInfo = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (materialInvInfo == null) {
            return;
        }
        if (!materialInvInfo.getBoolean("enableshelflifemgr")) {
            this.setValue("producedate", null, rowIndex, false);
            this.setValue("expirydate", null, rowIndex, false);
        }
        this.calculateGainAndLossQty(this.getModel(), false, rowIndex);
    }

    private void checkShelflifeDate(Date produceDate, Date expirydate, int rowIndex, String key, DynamicObject materialInvInfo) {
        if (expirydate != null && produceDate != null && expirydate.before(produceDate)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(produceDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImBillPropChanged_9", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue(key, null, rowIndex, false);
        }
    }
}

