/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.disassemblebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImTransformBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public class DisassembleBillEdit
extends ImTransformBillEditPlugin
implements RowClickEventListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"scmcgenlotnum"});
        EntryGrid grid = (EntryGrid)this.getControl("billentry");
        grid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        EntryGrid afterGrid = (EntryGrid)this.getControl("afterentity");
        afterGrid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAfterMaterialEntryKeeperEnable();
        this.setBeforeMaterialEntryLocationEnable();
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        this.setBeforeMaterialEntryLocationEnable();
    }

    private void setBeforeMaterialEntryLocationEnable() {
        IDataModel model = this.getModel();
        DynamicObjectCollection collections = model.getEntryEntity("afterentity");
        if (collections != null && collections.size() != 0) {
            for (int i = 0; i < collections.size(); ++i) {
                DynamicObject single = (DynamicObject)collections.get(i);
                DynamicObject warehouse = single.getDynamicObject("warehouse1");
                if (warehouse != null && !warehouse.getBoolean("isopenlocation")) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"location1"});
                }
                DynamicObject material = single.getDynamicObject("material1");
                DynamicObject masterMaterial = null;
                if (material != null) {
                    masterMaterial = material.getDynamicObject("masterid");
                }
                this.setSubEntryByMaterial(material, masterMaterial, i);
            }
        }
    }

    private void setAfterMaterialEntryKeeperEnable() {
        IDataModel model = this.getModel();
        DynamicObjectCollection collections = model.getEntryEntity("billentry");
        if (collections != null && collections.size() != 0) {
            for (int i = 0; i < collections.size(); ++i) {
                DynamicObject single = (DynamicObject)collections.get(i);
                String keeperType = single.getString("keepertype");
                if (keeperType == null || !"bos_org".equals(keeperType)) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"keeper"});
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel model = this.getView().getModel();
        switch (itemKey) {
            case "scmcgenlotnum": {
                this.getLotCode(model);
                this.saveLotMainFileInfo(itemKey, model);
                break;
            }
        }
    }

    private void getLotCode(IDataModel model) {
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("entryfield", "afterentity");
        param.put("material", "material1");
        param.put("lotmap", "lotnumber1");
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntity = model.getEntryEntity("afterentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u62c6\u5378\u540e\u7269\u6599\u660e\u7ec6\u6570\u636e\u3002", (String)"DisassembleBillEdit_5", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        int selectIndex = (Integer)((DynamicObject)((DynamicObject)entryEntity.get(0)).getParent()).get("seq");
        param.put("seq", String.valueOf(selectIndex + 1));
        boolean flag = false;
        if (dataEntity != null) {
            for (DynamicObject row : entryEntity) {
                String lotnum = row.getString("lotnumber1");
                if (!row.getBoolean("material1.enablelot") || lotnum == null || !StringUtils.isEmpty((CharSequence)lotnum.trim())) continue;
                flag = true;
                break;
            }
        }
        if (!flag) {
            return;
        }
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"getLotCode", (Object[])new Object[]{dataEntity, entryEntity, param});
        String lotKey = "lotnumber1";
        StringBuilder sb = new StringBuilder();
        this.getView().getModel().beginInit();
        ArrayList<Integer> index = new ArrayList<Integer>();
        for (Map.Entry entry : map.entrySet()) {
            Integer seq = (Integer)entry.getKey();
            String msg = (String)entry.getValue();
            if (msg.startsWith("ERROR")) {
                sb.append(msg.substring("ERROR".length())).append('\n');
                continue;
            }
            this.getView().getModel().setValue(lotKey, (Object)msg, seq - 1);
            index.add(seq - 1);
        }
        this.getView().getModel().endInit();
        index.forEach(p -> this.getView().updateView(lotKey, p.intValue()));
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6279\u53f7\u5f02\u5e38", (String)"DisassembleBillEdit_3", (String)"scmc-im-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Commit);
        }
    }

    private void saveLotMainFileInfo(String itemKey, IDataModel model) {
        String lotidField = "billentry.afterentity.lot1";
        String lotnumber = "lotnumber1";
        DynamicObject bill = model.getDataEntity();
        DynamicObjectCollection entryEntity = model.getEntryEntity("afterentity");
        if (entryEntity.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u62c6\u5378\u540e\u7269\u6599\u660e\u7ec6\u6570\u636e\u3002", (String)"DisassembleBillEdit_5", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        LotMainFileHelper.handleLotMainFileNumber((IFormView)this.getView(), (DynamicObject)bill, (DynamicObjectCollection)entryEntity, (String)itemKey, (String)lotidField, (String)lotnumber);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCurrency();
    }

    private void setCurrency() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (map == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        this.getModel().setValue("currency", map.get("baseCurrencyID"));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        super.beforeF7Select(e);
        switch (name = e.getProperty().getName()) {
            case "lot": 
            case "lot1": {
                Object org = this.getModel().getValue("org");
                if (org != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"DisassembleBillEdit_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "warehouse1": {
                this.beforeWarehouseSelect(e);
                break;
            }
            case "material1": {
                this.beforeMaterial1Select(e);
                break;
            }
        }
    }

    private void beforeMaterial1Select(BeforeF7SelectEvent e) {
        int parentindex;
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material", parentindex = model.getEntryCurrentRowIndex("billentry"));
        if (material == null) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("masterid.id", "!=", (Object)material.getLong("masterid.id")));
    }

    private void beforeWarehouseSelect(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG(), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String formId = this.getModel().getDataEntityType().getName();
        Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)formId, (DynamicObject)org, (ListShowParameter)showParameter);
        if (!result.booleanValue()) {
            Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(org.getPkValue().toString()));
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
        }
    }

    public ArrayList<Object> getOwnerList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Object> array = new ArrayList<Object>();
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            ArrayList ownerArray = OwnerHelper.getOwners((Long)orgId);
            array.addAll(ownerArray);
            Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            Object settleOrgId = null;
            if (companyByOrg != null) {
                settleOrgId = companyByOrg.get("id");
                array.add(settleOrgId);
            }
        }
        return array;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "qty": {
                this.qtyPropetyChange(e);
                break;
            }
            case "qtyunit2nd": {
                this.qtyUnit2PropetyChange(e);
                break;
            }
            case "usagerate": 
            case "material1": {
                this.useageratePropertyChange(e);
                break;
            }
            case "material": {
                this.materialPropertyChange(e);
                break;
            }
            case "invtype": 
            case "invstatus": 
            case "owner": 
            case "keeper": {
                this.setAllSubEntryValueAsParent(propName, e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "qty1": {
                this.afterQtyPropertyChange(e);
                break;
            }
            case "qtyunit2nd1": {
                this.afterQtyUnit2PropertyChange(e);
                break;
            }
            case "warehouse1": {
                this.afterWarehousePropertyChange(e);
                break;
            }
        }
    }

    private void setAllSubEntryValueAsParent(String parentKey, int parentIndex) {
        IDataModel model = this.getModel();
        model.beginInit();
        DynamicObject row = model.getEntryRowEntity("billentry", parentIndex);
        DynamicObjectCollection entries = row.getDynamicObjectCollection("afterentity");
        String subkey = parentKey + "1";
        Object value = row.get(parentKey);
        for (int i = 0; i < entries.size(); ++i) {
            ((DynamicObject)entries.get(i)).set(subkey, value);
        }
        model.endInit();
        int entryRowCount = this.getModel().getEntryRowCount("afterentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getView().updateView(subkey, i);
        }
    }

    private void afterWarehousePropertyChange(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        DynamicObject newWarehouse = (DynamicObject)data.getNewValue();
        if (newWarehouse != null && newWarehouse.getBoolean("isopenlocation")) {
            this.getView().setEnable(Boolean.TRUE, data.getRowIndex(), new String[]{"location1"});
        } else {
            this.getView().setEnable(Boolean.FALSE, data.getRowIndex(), new String[]{"location1"});
        }
        this.setValue("location1", null, data.getRowIndex(), false);
    }

    private void afterQtyPropertyChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData data = e.getChangeSet()[0];
        BigDecimal beforeMaterialQty = (BigDecimal)data.getNewValue();
        int parentRowIndex = data.getParentRowIndex();
        BigDecimal qty = (BigDecimal)model.getValue("qty", parentRowIndex);
        BigDecimal useageRate = null;
        useageRate = qty == null || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : beforeMaterialQty.divide(qty, 10, 4);
        int rowIndex = data.getRowIndex();
        model.beginInit();
        model.setValue("usagerate", (Object)useageRate, rowIndex, parentRowIndex);
        model.endInit();
        this.getView().updateView("usagerate", rowIndex, parentRowIndex);
    }

    private void afterQtyUnit2PropertyChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData data = e.getChangeSet()[0];
        BigDecimal beforeMaterialQty = data.getDataEntity().getBigDecimal("qty1");
        int parentRowIndex = data.getParentRowIndex();
        BigDecimal qty = (BigDecimal)model.getValue("qty", parentRowIndex);
        BigDecimal useageRate = null;
        useageRate = qty == null || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : beforeMaterialQty.divide(qty, 10, 4);
        int rowIndex = data.getRowIndex();
        this.setValue("usagerate", useageRate, rowIndex, false);
    }

    private void materialPropertyChange(PropertyChangedArgs e) {
        this.getModel().deleteEntryData("afterentity");
    }

    private void qtyPropetyChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        BigDecimal qty = (BigDecimal)changeData.getNewValue();
        int parentRowIndex = changeData.getRowIndex();
        DynamicObjectCollection subEntrys = (DynamicObjectCollection)model.getValue("afterentity", parentRowIndex);
        int size = subEntrys.size();
        for (int i = 0; i < size; ++i) {
            this.setBeforeDisassembleQty(i, qty, parentRowIndex);
        }
    }

    private void qtyUnit2PropetyChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        BigDecimal qty = changeData.getDataEntity().getBigDecimal("qty");
        int size = model.getEntryEntity("afterentity").size();
        for (int i = 0; i < size; ++i) {
            this.setBeforeDisassembleQty(i, qty, changeData.getRowIndex());
        }
    }

    private void useageratePropertyChange(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int parentRowIndex = changeData.getParentRowIndex();
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", parentRowIndex);
        int rowIndex = changeData.getRowIndex();
        this.setBeforeDisassembleQty(rowIndex, qty, parentRowIndex);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = FormUtils.getOpKey((BeforeDoOperationEventArgs)args)) {
            case "newafterentry": 
            case "after_scmcinvquery": {
                IDataModel model = this.getModel();
                int parentindex = model.getEntryCurrentRowIndex("billentry");
                Object material = model.getValue("material", parentindex);
                if (material != null) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62c6\u5378\u524d\u7684\u7269\u6599\u3002", (String)"DisassembleBillEdit_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        String name;
        super.afterAddRow(e);
        switch (name = e.getEntryProp().getName()) {
            case "afterentity": {
                this.afterentryAddRow(e);
                break;
            }
        }
    }

    private void afterentryAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        IDataModel model = this.getModel();
        int parentRowIndex = model.getEntryCurrentRowIndex("billentry");
        BigDecimal qty = (BigDecimal)model.getValue("qty", parentRowIndex);
        for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
            int rowIndex = rowDataEntity.getRowIndex();
            this.setBeforeDisassembleQty(rowIndex, qty, parentRowIndex);
            this.setSubEntryValueFromParent(rowIndex, parentRowIndex, "invtype", "invstatus", "ownertype", "owner", "keepertype", "keeper");
        }
    }

    private BigDecimal setBeforeDisassembleQty(int rowIndex, BigDecimal qty, int parentRowIndex) {
        IDataModel model = this.getModel();
        BigDecimal useageRate = (BigDecimal)model.getValue("usagerate", rowIndex, parentRowIndex);
        BigDecimal beforeDisassembleQty = qty.multiply(useageRate);
        DisassembleBillEdit.showQtyErrorTip(beforeDisassembleQty);
        model.setValue("qty1", (Object)beforeDisassembleQty, rowIndex, parentRowIndex);
        return beforeDisassembleQty;
    }

    public static void showQtyErrorTip(BigDecimal qtyAmount) {
        CommonUtils.showQtyErrorTip((BigDecimal)qtyAmount);
    }

    private void setSubEntryValueFromParent(int rowIndex, int parentIndex, String ... parentKey) {
        IDataModel model = this.getModel();
        for (String key : parentKey) {
            String subkey = key + "1";
            Object value = model.getValue(key, parentIndex);
            this.setValue(subkey, value, rowIndex, true);
        }
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.setCurrency();
    }
}

