/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.handle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ImBillImportHandle {
    private List<Map<String, Object>> dataEntities;
    private List<String> importlogs = new ArrayList<String>();
    private Map<String, Map<String, DynamicObject>> materialDymOrgMap = new HashMap<String, Map<String, DynamicObject>>();
    private Map<String, Map<DynamicObject, QFilter>> orgAndBaseFilter = new HashMap<String, Map<DynamicObject, QFilter>>();
    private Map<String, Object> proLinkMansMap = new HashMap<String, Object>();
    private Map<String, Object> cusLinkMansMap = new HashMap<String, Object>();

    public ImBillImportHandle(List<Map<String, Object>> dataEntities) {
        this.dataEntities = dataEntities;
    }

    public void beforehandle() {
        this.cacheDatahandle(this.dataEntities);
        for (Map<String, Object> data : this.dataEntities) {
            this.billDatahandle(data);
        }
    }

    private void cacheDatahandle(List<Map<String, Object>> dataEntities) {
        HashMap<String, HashSet<String>> materialNumsMap = new HashMap<String, HashSet<String>>();
        HashSet<Object> proSupplierNums = new HashSet<Object>();
        HashSet<Object> recCustomerNums = new HashSet<Object>();
        for (Map<String, Object> data : dataEntities) {
            Map orgMap = (Map)data.get("org");
            String billno = (String)data.get("billno");
            if (orgMap == null) {
                this.importlogs.add("\u5355\u636e" + billno + "\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a");
                continue;
            }
            String orgNum = (String)orgMap.get("number");
            if (StringUtils.isBlank((CharSequence)orgNum)) {
                this.importlogs.add("\u5355\u636e" + billno + "\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a");
                continue;
            }
            if (!this.orgAndBaseFilter.containsKey(orgNum)) {
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNum)});
                if (org == null) {
                    this.importlogs.add("\u5355\u636e" + billno + "\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a");
                    continue;
                }
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
                HashMap<DynamicObject, QFilter> orgAndFilter = new HashMap<DynamicObject, QFilter>();
                orgAndFilter.put(org, baseDataFilter);
                this.orgAndBaseFilter.put(orgNum, orgAndFilter);
            }
            List listData = (List)data.get("billentry");
            for (Map row : listData) {
                Map reccustomer;
                Map material = (Map)row.get("material");
                String materialNum = (String)material.get("number");
                HashSet<String> materialNums = (HashSet<String>)materialNumsMap.get(orgNum);
                if (materialNums == null) {
                    materialNums = new HashSet<String>();
                    materialNumsMap.put(orgNum, materialNums);
                }
                materialNums.add(materialNum);
                Map providersupplier = (Map)row.get("providersupplier");
                if (providersupplier != null && providersupplier.get("number") != null) {
                    proSupplierNums.add(providersupplier.get("number"));
                }
                if ((reccustomer = (Map)row.get("reccustomer")) == null || reccustomer.get("number") == null) continue;
                recCustomerNums.add(reccustomer.get("number"));
            }
        }
        if (materialNumsMap.size() > 0) {
            for (Map.Entry next : materialNumsMap.entrySet()) {
                String orgNum = (String)next.getKey();
                Set materialNums = (Set)next.getValue();
                Map<DynamicObject, QFilter> orgAndFilter = this.orgAndBaseFilter.get(orgNum);
                if (orgAndFilter == null) continue;
                QFilter baseDataFilter = orgAndFilter.values().iterator().next();
                Map materialDymLoad = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"id,masterid.number", (QFilter[])new QFilter[]{new QFilter("masterid.number", "in", (Object)materialNums), baseDataFilter});
                for (DynamicObject materialDym : materialDymLoad.values()) {
                    Map<String, DynamicObject> materialDymMap = this.materialDymOrgMap.get(orgNum);
                    if (materialDymMap == null) {
                        materialDymMap = new HashMap<String, DynamicObject>();
                        this.materialDymOrgMap.put(orgNum, materialDymMap);
                    }
                    materialDymMap.put(materialDym.getString("masterid.number"), materialDym);
                }
            }
        }
        this.cache4Provider(proSupplierNums);
        this.cache4Customer(recCustomerNums);
    }

    public List<String> getImportlogs() {
        return this.importlogs;
    }

    private void billDatahandle(Map<String, Object> data) {
        data.put("billstatus", "A");
        data.put("billcretype", "1");
        Map orgMap = (Map)data.get("org");
        String billno = (String)data.get("billno");
        if (orgMap == null) {
            return;
        }
        String orgNum = (String)orgMap.get("number");
        if (StringUtils.isBlank((CharSequence)orgNum)) {
            return;
        }
        Map<String, DynamicObject> materialDymMap = this.materialDymOrgMap.get(orgNum);
        if (materialDymMap == null) {
            return;
        }
        if (materialDymMap.isEmpty()) {
            this.importlogs.add("\u5355\u636e:" + billno + " \u5bf9\u5e94\u7ec4\u7ec7\u4e0b\u5bfc\u5165\u7269\u6599\u4e0d\u5b58\u5728");
            return;
        }
        List listData = (List)data.get("billentry");
        for (Map row : listData) {
            Map material = (Map)row.get("material");
            String materialNum = (String)material.get("number");
            DynamicObject materialDym = materialDymMap.get(materialNum);
            if (materialDym == null) {
                this.importlogs.add("\u5355\u636e:" + billno + " \u7f16\u7801\u4e3a" + materialNum + "\u7684\u7269\u6599\u4e0d\u5b58\u5728");
                continue;
            }
            material.put("id", materialDym.getPkValue());
            this.update4Customer(row);
        }
        this.initBill2Qty(data, listData, this.importlogs);
        data.put("billentry", listData);
    }

    private void cache4Customer(Set<Object> recCustomerNums) {
        if (recCustomerNums.isEmpty()) {
            return;
        }
        DynamicObject[] recCustomers = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", recCustomerNums)});
        HashMap<Object, String> cusMap = new HashMap<Object, String>(recCustomers.length);
        for (DynamicObject recCustomer : recCustomers) {
            cusMap.put(recCustomer.getPkValue(), recCustomer.getString("number"));
        }
        if (!cusMap.isEmpty()) {
            DynamicObject[] providerLinkMans;
            for (DynamicObject providerLinkMan : providerLinkMans = BusinessDataServiceHelper.load((String)"bd_customerlinkman", (String)"customerid,id,contactperson,phone", (QFilter[])new QFilter[]{new QFilter("customerid", "in", cusMap.keySet())})) {
                String key = (String)cusMap.get(providerLinkMan.get("customerid")) + "_" + providerLinkMan.getString("phone");
                this.cusLinkMansMap.put(key, providerLinkMan.getPkValue());
            }
        }
    }

    private void cache4Provider(Set<Object> proSupplierNums) {
        if (proSupplierNums.isEmpty()) {
            return;
        }
        DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", proSupplierNums)});
        HashMap<Object, String> supMap = new HashMap<Object, String>(suppliers.length);
        for (DynamicObject supplier : suppliers) {
            supMap.put(supplier.getPkValue(), supplier.getString("number"));
        }
        if (!supMap.isEmpty()) {
            DynamicObject[] providerLinkMans;
            for (DynamicObject providerLinkMan : providerLinkMans = BusinessDataServiceHelper.load((String)"bd_supplierlinkman", (String)"supplierid,id,contactperson,phone", (QFilter[])new QFilter[]{new QFilter("supplierid", "in", supMap.keySet())})) {
                String key = (String)supMap.get(providerLinkMan.get("supplierid")) + "_" + providerLinkMan.getString("phone");
                this.proLinkMansMap.put(key, providerLinkMan.getPkValue());
            }
        }
    }

    public void initBill2Qty(Map<String, Object> data, List<Map<String, Object>> listData, List<String> importlogs) {
    }

    public BigDecimal convert2BigDecimal(Object qty) {
        if (qty instanceof BigDecimal) {
            return (BigDecimal)qty;
        }
        if (qty == null) {
            qty = 0;
        }
        return new BigDecimal((Integer)qty);
    }

    private void update4Customer(Map<String, Object> entry) {
        String key;
        Map providerlinkman = (Map)entry.get("providerlinkman");
        Map providersupplier = (Map)entry.get("providersupplier");
        Map reclinkman = (Map)entry.get("reclinkman");
        Map reccustomer = (Map)entry.get("reccustomer");
        if (providerlinkman != null) {
            if (providersupplier == null) {
                entry.remove("providerlinkman");
                return;
            }
            Object prosupNum = providersupplier.get("number");
            Object prolinkmanNum = providerlinkman.get("number");
            key = prosupNum + "_" + prolinkmanNum;
            Object prolinkManId = this.proLinkMansMap.get(key);
            if (prolinkManId == null) {
                entry.remove("providerlinkman");
                return;
            }
            providerlinkman.put("id", prolinkManId);
        }
        if (reclinkman != null) {
            if (reccustomer == null) {
                entry.remove("reclinkman");
                return;
            }
            Object recCusNum = reccustomer.get("number");
            Object recLinkmanNum = reclinkman.get("number");
            key = recCusNum + "_" + recLinkmanNum;
            Object cuslinkManId = this.cusLinkMansMap.get(key);
            if (cuslinkManId == null) {
                entry.remove("providerlinkman");
                return;
            }
            reclinkman.put("id", cuslinkManId);
        }
    }
}

