/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.inbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexType;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.MeasureDeviationAdjustHelper;
import kd.scmc.im.business.helper.TailDiffAdjustBillHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class OtherInBillEditPlugin
extends ImBillEditPlugin {
    public static final String BTN_GENERATELOT = "generatelot";
    private static final String ISMEASUREADJUST = "isMeasureAdjust";
    private boolean isMeasureAdjust = false;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"owner", "outowner", "bizdept"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel bill = this.getModel();
        switch (key) {
            case "bizdept": {
                this.handleBizDeptF7Logic(showParameter);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        String key = e.getProperty().getName();
        int rowIndex = valueSet[0].getRowIndex();
        switch (key) {
            case "material": {
                this.handleMaterialChangeEvent(newValue);
                break;
            }
            case "price": {
                this.handlePriceChangeEvent(rowIndex);
                break;
            }
            case "amount": {
                this.handleAmountChangeEvent(rowIndex);
                break;
            }
            case "qty": {
                this.handleQtyChangeEvent(rowIndex);
                break;
            }
            case "qtyunit2nd": {
                this.handleQtyUnit2ndChangeEvent(rowIndex);
                break;
            }
            case "supplier": {
                this.handleSupplierChangeEvent();
                break;
            }
            case "biztype": {
                this.setQtyMustinput();
                this.setQtyEnable();
                break;
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get(ISMEASUREADJUST) != null && ((Boolean)customParams.get(ISMEASUREADJUST)).booleanValue()) {
            this.dealTailAdjust(customParams);
        } else {
            super.afterCreateNewData(e);
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!CommonUtils.isNull((Object)org)) {
            long orgId = (Long)org.getPkValue();
            this.initCurrency(orgId);
        }
        this.handleFlexCache();
        if (this.isMeasureAdjust) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbldraw"});
        }
    }

    private void dealTailAdjust(Map<String, Object> customParams) {
        this.isMeasureAdjust = true;
        DynamicObject billType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (String)"id", (QFilter[])new QFilter("number", "=", (Object)"im_OtherInBill_STD_BT_S").toArray());
        this.getModel().setValue("billtype", (Object)billType);
        boolean idNewAdjust = customParams.get("isNewAdjust") != null && (Boolean)customParams.get("isNewAdjust") != false;
        TailDiffAdjustBillHelper adjustHelper = idNewAdjust ? new TailDiffAdjustBillHelper(this.getView(), customParams) : new MeasureDeviationAdjustHelper(this.getView(), customParams);
        adjustHelper.dealMeasureDeviAdjust();
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.initNewEntryLineType(i);
            this.initMaterialName(i);
        }
        CloseDateHelper.initBookDate((String)this.getView().getEntityId(), (DynamicObject)this.getModel().getDataEntity(true));
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setQtyMustinput();
    }

    @Override
    protected void setEnable4IsDraw(boolean isDraw) {
        boolean isMeasureAdjustBizType;
        IFormView view = this.getView();
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        boolean bl = isMeasureAdjustBizType = bizType != null && "370".equals(bizType.get("number"));
        if (!this.isMeasureAdjust && !isMeasureAdjustBizType) {
            super.setEnable4IsDraw(isDraw);
            if (isDraw) {
                view.setEnable(Boolean.FALSE, new String[]{"invscheme", "settlecurrency"});
                view.setEnable(Boolean.TRUE, new String[]{"bizdept"});
            }
            return;
        }
        view.setEnable(Boolean.TRUE, new String[]{"dept", "bizdept", "operator", "operatorgroup", "supplier", "biztime", "comment"});
        view.setEnable(Boolean.FALSE, new String[]{"org", "billtype", "biztype", "invscheme", "billstatus", "settlecurrency", "addrow", "splitrow", "fillbatch", BTN_GENERATELOT, "qinvacc", "snnumber", "entersnnumber", "importsnnumber", "checksnnumber"});
        view.setVisible(Boolean.FALSE, new String[]{"snnumber", "bar_copy"});
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rows = e.getRowDataEntities();
            IFormView view = this.getView();
            for (RowDataEntity row : rows) {
                int rowIndex = row.getRowIndex();
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"baseqty"});
            }
        }
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        List rows = e.getRows();
        if (!rows.isEmpty()) {
            long bizTypeId;
            IFormView view = this.getView();
            DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
            if (this.isDrawByBOTP() && bizType != null && 688865344802319360L == (bizTypeId = ((Long)bizType.getPkValue()).longValue())) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"im_otherinbill");
                Map billentryFields = ((EntityType)dt.getAllEntities().get("billentry")).getFields();
                if (billentryFields.isEmpty()) {
                    return;
                }
                for (int i = 0; i < rows.size(); ++i) {
                    for (String key : billentryFields.keySet()) {
                        if ("ecostcenter".equals(key)) continue;
                        if ("amount".equals(key) || "price".equals(key)) {
                            view.setEnable(Boolean.TRUE, i, new String[]{key});
                            continue;
                        }
                        view.setEnable(Boolean.FALSE, i, new String[]{key});
                    }
                }
            }
        }
    }

    @Override
    protected void setBillEntryEnable(RowDataEntity row) {
        String outKeeperType;
        boolean isMeasureAdjustBizType;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        boolean bl = isMeasureAdjustBizType = bizType != null && "370".equals(bizType.get("number"));
        if (this.isMeasureAdjust || isMeasureAdjustBizType) {
            int rowIndex = row.getRowIndex();
            IFormView view = this.getView();
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"material", "auxpty", "unit", "baseunit", "auxpty", "lotnumber", "producedate", "expirydate", "location", "warehouse", "invtype", "invstatus", "ownertype", "owner", "keepertype", "keeper", "outinvtype", "outinvstatus", "outownertype", "outowner", "outkeepertype", "outkeeper", "project", "logisticsbill", "linetype", "materialname", "configuredcode", "tracknumber"});
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("billentry");
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
            BigDecimal qty = dynamicObject.getBigDecimal("qty");
            BigDecimal baseQty = dynamicObject.getBigDecimal("baseqty");
            BigDecimal qty2nd = dynamicObject.getBigDecimal("qtyunit2nd");
            view.setEnable(Boolean.valueOf(qty.compareTo(BigDecimal.ZERO) != 0), rowIndex, new String[]{"qty"});
            view.setEnable(Boolean.valueOf(baseQty.compareTo(BigDecimal.ZERO) != 0), rowIndex, new String[]{"baseqty"});
            view.setEnable(Boolean.valueOf(qty2nd.compareTo(BigDecimal.ZERO) != 0), rowIndex, new String[]{"qtyunit2nd"});
            return;
        }
        super.setBillEntryEnable(row);
        IFormView view = this.getView();
        view.setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"baseqty"});
        String keeperType = row.getDataEntity().getString("keepertype");
        if (keeperType != null) {
            boolean isAccountOrg = "bd_supplier".equalsIgnoreCase(keeperType) || "bd_customer".equalsIgnoreCase(keeperType);
            view.setEnable(Boolean.valueOf(isAccountOrg), new String[]{"keeper"});
        }
        if ((outKeeperType = row.getDataEntity().getString("outkeepertype")) != null) {
            boolean isAccountOrg = "bd_supplier".equalsIgnoreCase(outKeeperType) || "bd_customer".equalsIgnoreCase(outKeeperType);
            view.setEnable(Boolean.valueOf(isAccountOrg), new String[]{"outkeeper"});
        }
    }

    @Override
    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        if (isDraw) {
            IFormView view = this.getView();
            view.setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"materialtype", "outowner", "owner", "outkeeper", "keeper", "baseqty"});
        }
    }

    private void setQtyMustinput() {
        String[] inCheckFields = new String[]{"qty", "baseqty"};
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject biztype = (DynamicObject)model.getValue("biztype");
        if (null == biztype) {
            OtherInBillEditPlugin.setControlMustInput(view, true, inCheckFields);
            return;
        }
        String biztypeNum = biztype.getString("number");
        if ("370".equals(biztypeNum)) {
            OtherInBillEditPlugin.setControlMustInput(view, true, "materialname");
            return;
        }
        if (!"350".equals(biztypeNum)) {
            OtherInBillEditPlugin.setControlMustInput(view, true, inCheckFields);
        } else {
            OtherInBillEditPlugin.setControlMustInput(view, false, inCheckFields);
        }
    }

    private void setQtyEnable() {
        int size = this.getModel().getEntryEntity("billentry").size();
        for (int index = 0; index < size; ++index) {
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"qty"});
        }
    }

    private void handleMaterialChangeEvent(Object newValue) {
        if (newValue == null) {
            return;
        }
        if (((DynamicObject)newValue).getBoolean("enablelot")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_GENERATELOT});
        }
    }

    private void handleSupplierChangeEvent() {
        DynamicObject invScheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (invScheme == null) {
            this.getModel().setValue("supplier", (Object)"");
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u4e8b\u52a1\u3002", (String)"OtherInBillEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        String ownerType = invScheme.getString("ownertype");
        String outOwnerType = invScheme.getString("outownertype");
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
        if (!"bd_supplier".equals(ownerType) && !"bd_supplier".equals(outOwnerType)) {
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            if (isInUpdate) {
                this.getModel().setValue("owner", (Object)supplier, rowIndex);
            }
            if (!isOutUpdate) continue;
            this.getModel().setValue("outowner", (Object)supplier, rowIndex);
        }
    }

    private void handleQtyChangeEvent(int rowIndex) {
        this.calAmonutByQtyChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handleQtyUnit2ndChangeEvent(int rowIndex) {
        this.calAmonutByQtyChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handleAmountChangeEvent(int rowIndex) {
        this.calPriceByAmountChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handlePriceChangeEvent(int rowIndex) {
        this.calAmonutByPriceChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handleBizDeptF7Logic(ListShowParameter showParameter) {
        DynamicObject orgDyc = (DynamicObject)this.getModel().getValue("org");
        if (orgDyc == null) {
            return;
        }
        long orgId = (Long)orgDyc.getPkValue();
        List depts = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (depts != null && depts.size() > 0) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)depts));
        }
    }

    private void initCurrency(Long bizOrg) {
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)bizOrg);
        if (map == null) {
            return;
        }
        this.getModel().setValue("settlecurrency", map.get("baseCurrencyID"));
    }

    private void handleFlexCache() {
        IDataEntityType type = OrmUtils.getDataEntityType(FlexType.class);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
        cacheManager.removeByDt();
    }

    private void initNewEntryLineType(int rowIndex) {
        ArrayList<Long> bizTypes = new ArrayList<Long>();
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType == null) {
            return;
        }
        Long bizTypeId = (Long)bizType.getPkValue();
        Long lineType = null;
        bizTypes.add(bizTypeId);
        Map lineTypeByBillType = BillTypeMaterialHelper.getLineTypeByBillType(bizTypes);
        if (lineTypeByBillType.size() != 0) {
            LineTypeParam lineTypeParam = (LineTypeParam)lineTypeByBillType.get(bizTypeId);
            lineType = lineTypeParam.getDeafaultLineType();
        }
        this.getModel().beginInit();
        this.getModel().setValue("linetype", (Object)lineType, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("linetype", rowIndex);
    }

    private void initMaterialName(int rowIndex) {
        DynamicObject materialInvInfo = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material != null) {
            String materialName = material.getString("name");
            this.getModel().setValue("materialname", (Object)materialName, rowIndex);
        }
    }
}

