/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.inbill;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class ProductInBillEditPlugin
extends ImBillEditPlugin {
    private static final String BTN_GENERATELOT = "generatelot";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!CommonUtils.isNull((Object)org)) {
            long orgId = (Long)org.getPkValue();
            this.initBizOrg();
            DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
            this.dealBizDeptIsNull(bizOrg);
            this.initCurrency(orgId);
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int rowIndex = 0; rowIndex < entryRowCount; ++rowIndex) {
                this.handleOwnerOrkeeper(orgId, rowIndex);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"owner", "outowner", "maindept", "bizdept"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel bill = this.getModel();
        switch (key) {
            case "owner": 
            case "outowner": {
                this.handleOwnerAndOutOwnerF7Logic(showParameter, rowIndex);
                break;
            }
            case "bizdept": {
                this.handleBizDeptF7Logic(showParameter);
                break;
            }
            case "maindept": {
                this.handleMainDeptF7Logic(showParameter);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        String key = e.getProperty().getName();
        int rowIndex = valueSet[0].getRowIndex();
        switch (key) {
            case "invscheme": {
                this.handleInvschemeChangeEvent(newValue);
                break;
            }
            case "material": {
                this.hanldeMaterialChageEvent(newValue);
                break;
            }
            case "price": {
                this.handlePriceChangeEvent(rowIndex);
                break;
            }
            case "amount": {
                this.handleAmountChangeEvent(rowIndex);
                break;
            }
            case "qty": {
                this.handleQtyChangeEvent(rowIndex);
                break;
            }
            case "qtyunit2nd": {
                this.handleQtyunit2ndChangeEvent(rowIndex);
                break;
            }
            case "bizorg": {
                this.handleBizOrgChangeEvent();
                break;
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            DynamicObject orgDyc = (DynamicObject)this.getModel().getValue("org");
            if (orgDyc == null) {
                return;
            }
            long orgId = (Long)orgDyc.getPkValue();
            int rowCount = this.getModel().getEntryRowCount("billentry");
            int rowsEffect = e.getRowDataEntities().length;
            for (int i = 0; i < rowsEffect; ++i) {
                this.handleOwnerOrkeeper(orgId, rowCount - 1 - i);
            }
        }
    }

    private void handleQtyChangeEvent(int rowIndex) {
        this.calAmonutByQtyChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handleQtyunit2ndChangeEvent(int rowIndex) {
        this.calAmonutByQtyChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handleBizOrgChangeEvent() {
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
        DynamicObject bizDept = (DynamicObject)this.getModel().getValue("bizdept");
        if (bizDept == null) {
            this.dealBizDeptIsNull(bizOrg);
        } else {
            this.dealBizDeptIsNotNull(bizOrg, bizDept);
        }
    }

    private void dealBizDeptIsNotNull(DynamicObject bizOrg, DynamicObject bizDept) {
        List deptIds;
        if (bizOrg != null && (deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList((Long)bizOrg.getPkValue()), (boolean)true)) != null && !deptIds.contains(bizDept.getPkValue())) {
            this.getModel().setValue("bizdept", null);
        }
    }

    private void dealBizDeptIsNull(DynamicObject bizOrg) {
        List deptIds;
        if (bizOrg != null && (deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList((Long)bizOrg.getPkValue()), (boolean)true)) != null && deptIds.size() > 0) {
            this.getModel().setValue("bizdept", deptIds.get(0));
        }
    }

    private void initBizOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.getModel().setValue("bizorg", org == null ? null : org.getPkValue());
    }

    private void handleAmountChangeEvent(int rowIndex) {
        this.calPriceByAmountChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handlePriceChangeEvent(int rowIndex) {
        this.calAmonutByPriceChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handleOwnerOrkeeper(long orgId, int rowIndex) {
        this.handleOwnerOrkeeperDetail(orgId, rowIndex, "ownertype", "owner");
        this.handleOwnerOrkeeperDetail(orgId, rowIndex, "keepertype", "keeper");
        this.handleOwnerOrkeeperDetail(orgId, rowIndex, "outownertype", "outowner");
        this.handleOwnerOrkeeperDetail(orgId, rowIndex, "outkeepertype", "outkeeper");
    }

    private void hanldeMaterialChageEvent(Object newValue) {
        if (newValue == null) {
            return;
        }
        if (((DynamicObject)newValue).getBoolean("enablelot")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_GENERATELOT});
        }
    }

    private void handleInvschemeChangeEvent(Object newValue) {
        if (CommonUtils.isNull((Object)newValue)) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"ProductInBillEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        long orgId = (Long)org.getPkValue();
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int rowIndex = 0; rowIndex < entryRowCount; ++rowIndex) {
            this.handleOwnerOrkeeper(orgId, rowIndex);
        }
    }

    private void handleMainDeptF7Logic(ListShowParameter showParameter) {
        DynamicObject orgDyc = (DynamicObject)this.getModel().getValue("org");
        this.handleOrgF7(showParameter, orgDyc);
    }

    private void handleOrgF7(ListShowParameter showParameter, DynamicObject org) {
        if (org == null) {
            return;
        }
        List depts = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList((Long)org.getPkValue()), (boolean)true);
        if (depts != null && depts.size() > 0) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)depts));
        }
    }

    private void handleBizDeptF7Logic(ListShowParameter showParameter) {
        DynamicObject orgDyc = (DynamicObject)this.getModel().getValue("bizorg");
        this.handleOrgF7(showParameter, orgDyc);
    }

    private void handleOwnerOrkeeperDetail(long orgId, int rowIndex, String type, String field) {
        Object typeBaseData = this.getModel().getValue(type, rowIndex);
        if (type.equals("keepertype") || type.equals("outkeepertype")) {
            if ("bos_org".equals(typeBaseData)) {
                this.getModel().setValue(field, (Object)orgId, rowIndex);
            }
        } else if ("bos_org".equals(typeBaseData)) {
            String ownerCache = this.getOwnerCache(orgId);
            this.getModel().setValue(field, (Object)Arrays.asList(ownerCache.split(",")).get(0), rowIndex);
        }
        if ("bd_supplier".equals(typeBaseData)) {
            // empty if block
        }
        if ("bos_org".equals(typeBaseData)) {
            // empty if block
        }
    }

    private String getOwnerCache(Long orgId) {
        IPageCache pageCache = this.getPageCache();
        String ownerCache = pageCache.get(String.valueOf(orgId));
        if (ownerCache != null) {
            return ownerCache;
        }
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        ArrayList list = new ArrayList();
        list = OwnerHelper.getOwners((Long)orgId, (Long)((Long)billType.getPkValue()));
        long defaultOwner = OwnerHelper.getDefaultOwner((Long)orgId);
        if (defaultOwner != 0L) {
            list.add(defaultOwner);
        }
        list.add(OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE).get("id"));
        if (list.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5e93\u5b58\u7ec4\u7ec7\u6ca1\u6709\u76f8\u5173\u8054\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProductInBillEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        String str = list.toString();
        ownerCache = str.substring(str.indexOf(91) + 1, str.indexOf(93)).replaceAll(" ", "");
        pageCache.put(String.valueOf(orgId), ownerCache);
        return pageCache.get(String.valueOf(orgId));
    }

    private void handleOwnerAndOutOwnerF7Logic(ListShowParameter showParameter, int rowIndex) {
        Object OwnerType = this.getModel().getValue("ownertype", rowIndex);
        Object outOwnerType = this.getModel().getValue("outownertype", rowIndex);
        if ("bd_customer".equals(OwnerType) || "bd_customer".equals(outOwnerType)) {
            return;
        }
        if ("bd_supplier".equals(OwnerType) || "bd_supplier".equals(outOwnerType)) {
            return;
        }
        DynamicObject orgDyc = (DynamicObject)this.getModel().getValue("org");
        if (orgDyc == null) {
            return;
        }
        long orgId = (Long)orgDyc.getPkValue();
        String ownerCache = this.getOwnerCache(orgId);
        List<String> strList = Arrays.asList(ownerCache.split(","));
        List idList = strList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        QFilter ownerFilter = new QFilter("id", "in", idList);
        showParameter.getListFilterParameter().setFilter(ownerFilter);
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        Object dt = sourceData.get("billentry");
        if (dt instanceof JSONArray) {
            JSONArray entry = (JSONArray)dt;
            for (Object obj : entry) {
                Object outInvType;
                Map map = (Map)obj;
                Object invType = map.get("invtype");
                if (invType == null) {
                    this.getModel().setValue("invtype", null);
                }
                if ((outInvType = map.get("outinvtype")) != null) continue;
                this.getModel().setValue("outinvtype", null);
            }
        }
    }

    private void initCurrency(Long bizOrg) {
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)bizOrg);
        if (map == null) {
            return;
        }
        this.getModel().setValue("settlecurrency", map.get("baseCurrencyID"));
    }
}

