/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.invplan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.im.business.helper.invplan.InvPlanInitHelper;
import kd.scmc.im.business.helper.invplan.PlanViewOrgHelper;
import kd.scmc.im.enums.InitContextEnum;

public class InvPlanInitListPlugin
extends AbstractListPlugin {
    private static final String INIT_CONFIG = "init_config";
    private static final String INIT = "init";
    private static final String REFRESH = "refresh";
    private static final String IM_INITDATA = "im_invplaninit";
    private static final String CALC_PLAN_ID = "calcPlanId";
    private static final String INIT_IDS = "init_ids";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ArrayList<Object> orgPks = new ArrayList<Object>(16);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn columnFilter = (CommonFilterColumn)filterColumn;
            if (!columnFilter.getFieldName().startsWith("org")) continue;
            Set orgIds = PlanViewOrgHelper.getOrgIdsByPlanView();
            Long uid = RequestContext.get().getCurrUserId();
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)uid, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"im"), (String)IM_INITDATA, (String)"47150e89000000ac");
            columnFilter.getComboItems().clear();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
            if (!result.hasAllOrgPerm()) {
                QFilter permFilter = new QFilter("id", "in", (Object)result.getHasPermOrgs());
                qFilters.add(permFilter);
            }
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIds);
            qFilters.add(enableFilter);
            qFilters.add(pkFilter);
            Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])qFilters.toArray(new QFilter[0]));
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bos_org");
            DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)mainEntityType, null);
            if (orgMap != null) {
                orgColl.addAll(orgMap.values());
            }
            for (DynamicObject org : orgColl) {
                Object orgPk = org.getPkValue();
                orgPks.add(orgPk);
                comboItems.add(new ComboItem(new LocaleString(org.getLocaleString("name").getLocaleValue()), orgPk.toString()));
            }
            columnFilter.setComboItems(comboItems);
            ArrayList<String> defaultOrg = new ArrayList<String>();
            long currentOrgId = RequestContext.get().getOrgId();
            boolean match = orgPks.stream().map(orgx -> Long.valueOf(orgx.toString())).anyMatch(orgx -> orgx.equals(currentOrgId));
            if (!match && !ObjectUtils.isEmpty((Object)orgColl)) {
                defaultOrg.add(String.valueOf(((DynamicObject)orgColl.get(0)).getPkValue()));
            } else {
                defaultOrg.add(String.valueOf(currentOrgId));
            }
            columnFilter.setDefaultValues(defaultOrg);
            break;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field != null && field.contains("org")) {
            Set orgIds = PlanViewOrgHelper.getOrgIdsByPlanView();
            QFilter orgFilter = new QFilter("id", "in", (Object)orgIds);
            args.addCustomQFilter(orgFilter);
        }
    }

    private void processInit() {
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Long useOrgId = (Long)selectedMainOrgIds.get(0);
        StringBuilder msg = new StringBuilder();
        StringBuilder grassMsg = new StringBuilder();
        StringBuilder calcMsg = new StringBuilder();
        List<Long> ids = this.getPkValues(selectedRows);
        QFilter qFilter = new QFilter("id", "in", ids);
        Long calcId = 0L;
        QFilter otherFilter = new QFilter("entryentity.runtype", "=", (Object)"im_inventoryplan");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)IM_INITDATA, (String)"id,inittype,initstatus", (QFilter[])new QFilter[]{qFilter}, (String)null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String initType = row.getString("inittype");
            String initStatus = row.getString("initstatus");
            Long id = row.getLong("id");
            InitContextEnum initContextEnum = InitContextEnum.fromName((String)initType);
            if (initContextEnum == InitContextEnum.AlgoModule && this.checkIsExist("mrp_calplanconfig", useOrgId, true, otherFilter)) {
                calcMsg.append(ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u6848\u914d\u7f6e\u5b58\u5728\u8fd0\u884c\u65b9\u5f0f\u4e3a\u201c\u5e93\u5b58\u8ba1\u5212\u201d\uff0c\u4e14\u5df2\u5ba1\u6838\u3001\u53ef\u7528\u7684\u6570\u636e\uff0c\u4e0d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\u3002\r\n\u7b97\u6cd5\u6a21\u578b\u4e2d\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u3001\u7b97\u6cd5\u6ce8\u518c\u914d\u7f6e\u5df2\u521d\u59cb\u5316\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u521d\u59cb\u5316\uff1f\u5982\u9009\u62e9\u662f\uff0c\u5219\u8986\u76d6\u5df2\u6709\u6570\u636e\u3002", (String)"InvPlanInitListPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                calcId = id;
                continue;
            }
            if (!StringUtils.equals((CharSequence)initStatus, (CharSequence)"1")) continue;
            if (msg.length() > 0) {
                msg.append('\uff0c');
            }
            msg.append(initType);
        }
        if (ids.isEmpty()) {
            this.getView().showMessage(grassMsg.toString());
            return;
        }
        this.getPageCache().put(CALC_PLAN_ID, calcId.toString());
        this.getPageCache().put(INIT_IDS, SerializationUtils.toJsonString(ids));
        if (msg.length() > 0 || grassMsg.length() > 0 || calcMsg.length() > 0) {
            if (msg.length() > 0) {
                msg.append(ResManager.loadKDString((String)"\u5df2\u521d\u59cb\u5316\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u521d\u59cb\u5316\uff1f\u5982\u9009\u62e9\u662f\uff0c\u5219\u8986\u76d6\u5df2\u6709\u6570\u636e\u3002", (String)"InvPlanInitListPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(INIT, (IFormPlugin)this);
            confirmCallBack.setView(this.getView());
            StringBuilder tip = new StringBuilder();
            if (grassMsg.length() > 0) {
                tip.append((CharSequence)grassMsg).append("\r\n");
            }
            if (calcMsg.length() > 0) {
                tip.append((CharSequence)calcMsg).append("\r\n");
            }
            if (msg.length() > 0) {
                tip.append((CharSequence)msg).append("\r\n");
            }
            this.getView().showConfirm(tip.toString(), MessageBoxOptions.YesNo, confirmCallBack);
            return;
        }
        this.invokeInitOp();
    }

    private boolean checkUseOrg(List<Long> selectedMainOrgIds) {
        if (selectedMainOrgIds.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u7ec4\u7ec7\u3002", (String)"InvPlanInitListPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<Long> getPkValues(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> ids = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            Long id = (Long)selectedRow.getPrimaryKeyValue();
            ids.add(id);
        }
        return ids;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)INIT_CONFIG) && e.getOperationResult().isSuccess()) {
            this.invokeInitConfigOp();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)INIT) && e.getOperationResult().isSuccess() && this.checkUseOrg(selectedMainOrgIds)) {
            this.processInit();
        }
    }

    private void invokeInitConfigOp() {
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (!selectedMainOrgIds.isEmpty()) {
            InvPlanInitHelper.initConfigData((long)((Long)selectedMainOrgIds.get(0)));
            this.getView().invokeOperation(REFRESH);
        }
    }

    private void invokeInitOp() {
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        List ids = null;
        if (!selectedMainOrgIds.isEmpty()) {
            String jsonStr;
            Long useOrgId = (Long)selectedMainOrgIds.get(0);
            String calcStr = this.getPageCache().get(CALC_PLAN_ID);
            long calcId = 0L;
            if (StringUtils.isNotBlank((CharSequence)calcStr)) {
                calcId = Long.parseLong(calcStr);
            }
            if (StringUtils.isNotBlank((CharSequence)(jsonStr = this.getPageCache().get(INIT_IDS)))) {
                ids = SerializationUtils.fromJsonStringToList((String)jsonStr, Long.class);
            }
            if (ids == null || ids.isEmpty()) {
                return;
            }
            InvPlanInitHelper.initMrpData((long)useOrgId, (List)ids, (long)calcId);
        }
        this.getView().invokeOperation(REFRESH);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InvPlanInitListPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
    }

    private boolean checkIsExist(String entity, long org, boolean isCheckStatus, QFilter otherFilter) {
        QFilter qFilter = new QFilter("createorg", "=", (Object)org);
        if (isCheckStatus) {
            qFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        if (otherFilter != null) {
            qFilter.and(otherFilter);
        }
        return QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{qFilter});
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && INIT.equals(e.getCallBackId())) {
            this.invokeInitOp();
        }
    }
}

