/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.invquery;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class InvQueryCfgConditionPlugin
extends AbstractFormPlugin {
    public static final String FILTERGRIDAP = "filtergridap";

    public void createNewData(BizDataEventArgs e) {
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        String billEntity = (String)customParams.get("billEntity");
        Boolean showEntryField = (Boolean)customParams.get("showEntryField");
        FilterGrid filterGrid = (FilterGrid)view.getControl(FILTERGRIDAP);
        filterGrid.setEntityNumber(billEntity);
        List<Map<String, Object>> headFields = InvQueryCfgConditionPlugin.getFields(billEntity, showEntryField);
        filterGrid.setFieldColumns(headFields);
        filterGrid.setFilterColumns(headFields);
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        String conditionJson = (String)customParams.get("conditionJson");
        FilterGrid filterGrid = (FilterGrid)view.getControl(FILTERGRIDAP);
        if (!StringUtils.isEmpty((String)conditionJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
            filterGrid.getFilterGridState();
            view.updateView(FILTERGRIDAP);
        }
    }

    private static List<Map<String, Object>> getFields(String entityNumber, boolean needEntryField) {
        MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        List<Map<String, Object>> filterColumns = EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)billEntity);
        filterColumns = filterColumns.stream().filter(columInfo -> {
            if ("auxpty".equals(columInfo.get("fieldName"))) {
                return false;
            }
            return needEntryField || columInfo.get("entryEntity").equals(entityNumber);
        }).collect(Collectors.toList());
        return filterColumns;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("confirm".equals(operateKey)) {
            HashMap<String, String> result = new HashMap<String, String>();
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String billEntity = (String)customParams.get("billEntity");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billEntity);
            FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
            try {
                String[] strings = filterBuilder.buildFilterScript();
                result.put("conditionDescription", strings[1]);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FormulaEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), e.getMessage()));
                return;
            }
            result.put("filterCondition", SerializationUtils.toJsonString((Object)filterCondition));
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }
}

