/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.invquery;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.IBillPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.helper.invquery.InvqueryHelper;
import kd.scmc.im.consts.InvqueryCfgConst;
import kd.scmc.im.formplugin.invquery.CRConditionFormTranslator;
import kd.scmc.im.formplugin.invquery.FieldFormTranslator;
import kd.scmc.sbs.business.common.colsAssist.CompositeStrategy;
import kd.scmc.sbs.business.common.colsAssist.EntryNodeStrategy;
import kd.scmc.sbs.business.common.colsAssist.EntryStrategy;
import kd.scmc.sbs.business.common.colsAssist.FilterStrategy;
import kd.scmc.sbs.business.common.colsAssist.IColsSelectStrategy;
import kd.scmc.sbs.business.common.colsAssist.MetaHelper;
import kd.scmc.sbs.business.common.colsAssist.SelectParams;
import kd.scmc.sbs.business.common.colsAssist.SimpleStrategy;
import kd.scmc.sbs.business.common.colsAssist.TypeSelectStategy;
import kd.scmc.sbs.common.util.ColsTreeUtil;
import kd.scmc.sbs.common.util.FormUtil;

public class InvqueryCfgEditPlugin
extends AbstractBasePlugIn
implements EntryGridBindDataListener,
IBillPlugin {
    private static final String SRCBILLENTRYCB = "srcbillentryCB";
    private static final String INVACC_COLCB = "invaccColCB";
    private static final String SRCBILL_COLCB = "srcbillColCB";
    private static final String RETURNBILL_COLCB = "returnbillColCB";
    private static final String MATERIAL = "material";
    private static final String ORG = "org";
    private static final List<String> invaccFixCols = Collections.singletonList("keycol");
    public static final String INVFILTER_CB = "invfilterCB";
    public static final String PREFILTER_CB = "prefilterCB";
    private static final Log logger = LogFactory.getLog(InvqueryCfgEditPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            String number = (String)this.getModel().getValue("number");
            this.getModel().setValue("number", (Object)number.trim());
        }
        super.beforeDoOperation(args);
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String useType = (String)this.getView().getFormShowParameter().getCustomParams().get("usetype");
        if (StringUtils.isNotEmpty((CharSequence)useType)) {
            this.getModel().setValue("usetype", (Object)useType);
            if ("B".equals(useType)) {
                int orgIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("invacccolno", (Object)this.getInvAccPropName(ORG), orgIndex);
                this.getModel().setValue("invacccol", (Object)ORG, orgIndex);
                this.getModel().setValue("qfilter", (Object)Boolean.TRUE, orgIndex);
                this.getModel().setValue("returnorder", (Object)InvqueryHelper.getDefaultReturnOrder((String)ORG), orgIndex);
                this.getModel().setValue("fieldmustinput", (Object)Boolean.TRUE, orgIndex);
                int matIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("invacccolno", (Object)this.getInvAccPropName(MATERIAL), matIndex);
                this.getModel().setValue("invacccol", (Object)MATERIAL, matIndex);
                this.getModel().setValue("qfilter", (Object)Boolean.TRUE, matIndex);
                this.getModel().setValue("update", (Object)Boolean.TRUE, matIndex);
                this.getModel().setValue("returnorder", (Object)InvqueryHelper.getDefaultReturnOrder((String)MATERIAL), matIndex);
                this.getModel().setValue("fieldmustinput", (Object)Boolean.TRUE, matIndex);
                int unitIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("invacccolno", (Object)this.getInvAccPropName("unit"), unitIndex);
                this.getModel().setValue("invacccol", (Object)"unit", unitIndex);
                this.getModel().setValue("qfilter", (Object)Boolean.TRUE, unitIndex);
                this.getModel().setValue("update", (Object)Boolean.TRUE, unitIndex);
                this.getModel().setValue("returnorder", (Object)InvqueryHelper.getDefaultReturnOrder((String)"unit"), unitIndex);
                this.getModel().setValue("fieldmustinput", (Object)Boolean.TRUE, unitIndex);
                String proQtyField = (String)this.getModel().getValue("proqtyfield");
                if ("avbqty".equals(proQtyField)) {
                    int newRowIndex = this.getModel().createNewEntryRow("entryentity");
                    this.getModel().setValue("invacccolno", (Object)this.getInvAccPropName("avbqty"), newRowIndex);
                    this.getModel().setValue("invacccol", (Object)"avbqty", newRowIndex);
                    this.getModel().setValue("update", (Object)Boolean.TRUE, newRowIndex);
                    this.getModel().setValue("returnorder", (Object)InvqueryHelper.getDefaultReturnOrder((String)"avbqty"), newRowIndex);
                    this.getModel().setValue("fieldmustinput", (Object)Boolean.TRUE, newRowIndex);
                } else if ("qty".equals(proQtyField)) {
                    int newRowIndex = this.getModel().createNewEntryRow("entryentity");
                    this.getModel().setValue("invacccolno", (Object)this.getInvAccPropName("qty"), newRowIndex);
                    this.getModel().setValue("invacccol", (Object)"qty", newRowIndex);
                    this.getModel().setValue("update", (Object)Boolean.TRUE, newRowIndex);
                    this.getModel().setValue("returnorder", (Object)InvqueryHelper.getDefaultReturnOrder((String)"qty"), newRowIndex);
                    this.getModel().setValue("fieldmustinput", (Object)Boolean.TRUE, newRowIndex);
                }
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.translateFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateFields() {
        IDataModel model = this.getModel();
        try {
            DynamicObject sourceBill;
            if (!Lang.zh_CN.equals((Object)RequestContext.get().getLang()) && (sourceBill = model.getDataEntity().getDynamicObject("srcbillobj")) != null) {
                String metaDataNo = sourceBill.getString("number");
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
                String srcEntryKey = (String)this.getModel().getValue("srcbillentry");
                if (StringUtils.isNotBlank((CharSequence)srcEntryKey)) {
                    String localeEntryName = mainEntityType.findProperty(srcEntryKey).getDisplayName().getLocaleValue();
                    if (localeEntryName.length() > 50) {
                        localeEntryName = localeEntryName.substring(0, 50);
                    }
                    this.getModel().setValue("srcbillentryname", (Object)localeEntryName);
                }
                FieldFormTranslator fieldFormTranslator = FieldFormTranslator.create(model);
                fieldFormTranslator.entryFieldTranslate("entryentity", "im_inv_realbalance", "invacccol", "invacccolno");
                fieldFormTranslator.entryFieldTranslate("entryentity", metaDataNo, "srcbillcol", "srcbillcolno");
                CRConditionFormTranslator crConditionFormTranslator = CRConditionFormTranslator.create(model);
                crConditionFormTranslator.entryFieldTranslate("filterentry", metaDataNo, "prefilterjson_tag", "prefilter");
                crConditionFormTranslator.entryFieldTranslate("filterentry", "im_inv_realbalance", "invfilterjson_tag", "invfilter");
            }
        }
        catch (Exception ex) {
            logger.error("\u7ffb\u8bd1\u9519\u8bef", (Throwable)ex);
        }
        finally {
            model.setDataChanged(false);
        }
    }

    private void setQtyComboItem(String useType) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(4);
        ComboEdit proQtyField = (ComboEdit)this.getView().getControl("proqtyfield");
        ComboItem comboItem1 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u53ef\u7528\u91cf\uff08\u5e93\u5b58\u5355\u4f4d\uff09", (String)"InvqueryCfgEditPlugin_8", (String)"scmc-im-formplugin", (Object[])new Object[0])), "avbqty");
        ComboItem comboItem2 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e93\u5b58\u91cf\uff08\u5e93\u5b58\u5355\u4f4d\uff09", (String)"InvqueryCfgEditPlugin_9", (String)"scmc-im-formplugin", (Object[])new Object[0])), "qty");
        comboItems.add(comboItem1);
        comboItems.add(comboItem2);
        if ("B".equals(useType)) {
            ComboItem comboItem3 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u53ef\u7528\u91cf\uff08\u8f85\u52a9\u5355\u4f4d\uff09", (String)"InvqueryCfgEditPlugin_10", (String)"scmc-im-formplugin", (Object[])new Object[0])), "avbqty2nd");
            ComboItem comboItem4 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e93\u5b58\u91cf\uff08\u8f85\u52a9\u5355\u4f4d\uff09", (String)"InvqueryCfgEditPlugin_11", (String)"scmc-im-formplugin", (Object[])new Object[0])), "qty2nd");
            comboItems.add(comboItem3);
            comboItems.add(comboItem4);
        }
        proQtyField.setComboItems(comboItems);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        boolean outRule = this.isOutRule();
        entities.forEach(entry -> {
            DynamicObject entryObj = entry.getDataEntity();
            if (outRule) {
                this.setMatchRuleOutEntryEnable(entryObj);
            } else {
                this.setInvQueryEntryEnable(entryObj);
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setEnable();
        String useType = (String)this.getModel().getValue("usetype");
        if (StringUtils.isNotEmpty((CharSequence)useType)) {
            this.setQtyComboItem(useType);
        }
    }

    private void setEnable() {
        IDataModel model = this.getModel();
        Boolean isPreset = model.getDataEntity().getBoolean("ispreset");
        this.getView().setEnable(Boolean.valueOf(isPreset == false), new String[]{"conentpanel"});
        boolean isMatchRuleOut = this.isOutRule();
        this.getView().setVisible(Boolean.valueOf(!isMatchRuleOut), new String[]{"returntype", "dealtype", "qtyrule", "actionid", "pluginname", "newdeal", "unittran", "middleinsert", "match", "mustselectentry"});
        this.getView().setVisible(Boolean.valueOf(isMatchRuleOut), new String[]{"matchshortage", "saveshortagerow", "fristout"});
        if (isMatchRuleOut) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entryEntity) {
                this.setMatchRuleOutEntryEnable(entry);
            }
        }
    }

    private void setMatchRuleOutEntryEnable(DynamicObject entry) {
        String invAccCol = entry.getString("invacccol");
        int rowIndex = entry.getInt("seq") - 1;
        if (MATERIAL.equals(invAccCol)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"invacccolno", "invacccol", "qfilter", "fristout", "fieldmustinput", "update"});
        } else if (ORG.equals(invAccCol)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"invacccolno", "invacccol", "qfilter", "fristout", "fieldmustinput"});
        } else if ("unit".equals(invAccCol)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"invacccolno", "invacccol", "qfilter", "fristout", "fieldmustinput", "update"});
        } else if (InvqueryCfgConst.ALLQTYFIELDS.contains(invAccCol)) {
            String proQty = (String)this.getModel().getValue("proqtyfield");
            if ("avbqty".equals(proQty) && "avbqty".equals(invAccCol) || "qty".equals(proQty) && "qty".equals(invAccCol)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"invacccolno", "invacccol", "fieldmustinput"});
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"qfilter", "update", "fristout"});
        }
        String srcBillObj = entry.getString("srcbillcol");
        if (StringUtils.isNotEmpty((CharSequence)srcBillObj) && srcBillObj.split("\\.").length < 2) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"update"});
        }
    }

    private void setInvQueryEntryEnable(DynamicObject entryObj) {
        IFormView view = this.getView();
        int rowIndex = entryObj.getInt("seq") - 1;
        String invacccol = entryObj.getString("invacccol");
        if (MATERIAL.equals(invacccol)) {
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"qfilter", "update", "match", "fieldmustinput"});
        } else if (ORG.equals(invacccol)) {
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"fieldmustinput"});
        } else if (InvqueryCfgConst.ALLQTYFIELDS.contains(invacccol)) {
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"qfilter"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcbillentry", "invacccolno", "srcbillcolno", "prefilter", "invfilter", "returncolno"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "srcbillentry": {
                this.clickSrcBillEntry();
                break;
            }
            case "invacccolno": {
                this.clickTargetObjCol(key);
                break;
            }
            case "srcbillcolno": {
                this.clickSourceObjCol(key);
                break;
            }
            case "prefilter": {
                this.clickPreFilterCol();
                break;
            }
            case "invfilter": {
                this.clickInvFilterCol();
                break;
            }
            case "returncolno": {
                this.clickReturnFilterCol();
                break;
            }
        }
    }

    private void clickInvFilterCol() {
        int index = this.getModel().getEntryCurrentRowIndex("filterentry");
        Object invFilterJson = this.getModel().getValue("invfilterjson_tag", index);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("im_invquerycondition");
        showParameter.setCustomParam("billEntity", (Object)"im_inv_realbalance");
        showParameter.setCustomParam("conditionJson", invFilterJson);
        showParameter.setCustomParam("showEntryField", (Object)true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, INVFILTER_CB));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5e93\u5b58\u8fc7\u6ee4", (String)"InvqueryCfgEditPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void clickPreFilterCol() {
        int index = this.getModel().getEntryCurrentRowIndex("filterentry");
        Object preFilterJson = this.getModel().getValue("prefilterjson_tag", index);
        String entityNum = this.checkSrcbilltype(this.getModel());
        if (StringUtils.isEmpty((CharSequence)entityNum)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("im_invquerycondition");
        showParameter.setCustomParam("billEntity", (Object)entityNum);
        showParameter.setCustomParam("conditionJson", preFilterJson);
        showParameter.setCustomParam("showEntryField", (Object)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PREFILTER_CB));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u524d\u7f6e\u6761\u4ef6", (String)"InvqueryCfgEditPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void clickSrcBillEntry() {
        IDataModel model = this.getModel();
        String sourcebilltype = this.checkSrcbilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        this.showColsTreePage(sourcebilltype, (IColsSelectStrategy)new EntryStrategy(), SRCBILLENTRYCB, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53", (String)"InvqueryCfgEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
    }

    private void clickTargetObjCol(String key) {
        ArrayList<String> existCols = new ArrayList<String>(16);
        DynamicObjectCollection colsMap = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject colMap : colsMap) {
            String targetObjCol = colMap.getString("invacccol");
            if (!StringUtils.isNotEmpty((CharSequence)targetObjCol)) continue;
            existCols.add(targetObjCol);
        }
        existCols.addAll(invaccFixCols);
        this.showColsTreePage("im_inv_realbalance", (IColsSelectStrategy)new FilterStrategy(existCols), INVACC_COLCB, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"InvqueryCfgEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
    }

    private void clickSourceObjCol(String key) {
        IDataModel model = this.getModel();
        String sourcebilltype = this.checkSrcbilltype(model);
        if (sourcebilltype == null) {
            return;
        }
        String sourceBillEntry = this.checkSrcBillEntry(model);
        if (sourceBillEntry == null) {
            return;
        }
        int index = model.getEntryCurrentRowIndex("entryentity");
        String prop = (String)model.getValue("invacccol", index);
        if (StringUtils.isEmpty((CharSequence)prop)) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5373\u65f6\u5e93\u5b58\u5b57\u6bb5\u3002", (String)"InvqueryCfgEditPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"im_inv_realbalance");
        String[] props = prop.split("\\.");
        if (props.length > 1) {
            prop = props[props.length - 1];
        }
        IDataEntityProperty property = dataEntityType.findProperty(prop);
        String caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%s\u201d\u7684\u6620\u5c04\u5b57\u6bb5\u3002", (String)"InvqueryCfgEditPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[]{property.getDisplayName().getLocaleValue()}), new Object[0]);
        TypeSelectStategy typeSelectStategy = new TypeSelectStategy(property);
        ArrayList<String> chooseEntries = new ArrayList<String>(2);
        chooseEntries.add(sourceBillEntry);
        EntryNodeStrategy entrynodeStategy = new EntryNodeStrategy(chooseEntries, true);
        CompositeStrategy compStrategy = new CompositeStrategy(Arrays.asList(typeSelectStategy, entrynodeStategy));
        this.showColsTreePage(sourcebilltype, (IColsSelectStrategy)compStrategy, SRCBILL_COLCB, caption);
    }

    private void clickReturnFilterCol() {
        IDataModel model = this.getModel();
        String sourceBillType = this.checkSrcbilltype(model);
        if (StringUtils.isEmpty((CharSequence)sourceBillType)) {
            return;
        }
        String sourceBillEntry = this.checkSrcBillEntry(model);
        if (StringUtils.isEmpty((CharSequence)sourceBillEntry)) {
            return;
        }
        int index = model.getEntryCurrentRowIndex("entryentity");
        String prop = (String)model.getValue("invacccol", index);
        if (StringUtils.isEmpty((CharSequence)prop)) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5373\u65f6\u5e93\u5b58\u5b57\u6bb5\u3002", (String)"InvqueryCfgEditPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        String billProp = (String)model.getValue("srcbillcol", index);
        if (StringUtils.isEmpty((CharSequence)billProp)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5355\u636e\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5373\u5355\u636e\u5b57\u6bb5\u3002", (String)"InvqueryCfgListPlugin_12", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"im_inv_realbalance");
        String[] props = prop.split("\\.");
        if (props.length > 1) {
            prop = props[props.length - 1];
        }
        IDataEntityProperty property = dataEntityType.findProperty(prop);
        String caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%s\u201d\u7684\u6620\u5c04\u5b57\u6bb5\u3002", (String)"InvqueryCfgEditPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[]{property.getDisplayName().getLocaleValue()}), new Object[0]);
        TypeSelectStategy typeSelectStategy = new TypeSelectStategy(property);
        ArrayList<String> chooseEntries = new ArrayList<String>(2);
        chooseEntries.add(sourceBillEntry);
        EntryNodeStrategy entrynodeStategy = new EntryNodeStrategy(chooseEntries, true);
        DynamicObjectCollection colsMap = this.getModel().getEntryEntity("entryentity");
        HashSet<String> usedSrcCol = new HashSet<String>();
        int currentIndex = 0;
        for (DynamicObject col : colsMap) {
            String srcCol = col.getString("srcbillcol");
            if (StringUtils.isNotEmpty((CharSequence)srcCol)) {
                usedSrcCol.add(this.colDeal(srcCol));
            }
            if (currentIndex == index) {
                ++currentIndex;
                continue;
            }
            String returnCol = col.getString("returncol");
            if (!StringUtils.isNotEmpty((CharSequence)returnCol)) continue;
            usedSrcCol.add(this.colDeal(returnCol));
        }
        FilterStrategy usedStrategy = new FilterStrategy(new ArrayList(usedSrcCol));
        CompositeStrategy compStrategy = new CompositeStrategy(Arrays.asList(typeSelectStategy, entrynodeStategy, usedStrategy));
        this.showColsTreePage(sourceBillType, (IColsSelectStrategy)compStrategy, RETURNBILL_COLCB, caption);
    }

    private String colDeal(String srcCol) {
        String[] srcCols = srcCol.split("\\.");
        if (srcCols.length > 0) {
            return srcCols[srcCols.length - 1];
        }
        return srcCol;
    }

    private String checkSrcbilltype(IDataModel model) {
        DynamicObject sourceBill = (DynamicObject)model.getValue("srcbillobj");
        if (sourceBill == null) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"InvqueryCfgEditPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return null;
        }
        return sourceBill.getString("number");
    }

    private String checkSrcBillEntry(IDataModel model) {
        String sourceBillEntry = model.getDataEntity().getString("srcbillentry");
        if (sourceBillEntry == null || sourceBillEntry.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53\u3002", (String)"InvqueryCfgEditPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return null;
        }
        return sourceBillEntry;
    }

    private void showColsTreePage(String entityNumber, IColsSelectStrategy strategy, String key, String caption) {
        IColsSelectStrategy selectStrategy = strategy;
        if (selectStrategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = FormUtil.readyColsTreePage((SelectParams)params, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            fp.setCaption(caption);
        }
        this.getView().showForm(fp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "srcbillentryCB": {
                this.objCloseCallBack(e, actionId);
                break;
            }
            case "invaccColCB": 
            case "srcbillColCB": 
            case "returnbillColCB": {
                this.objColCloseCallBack(e, actionId);
                break;
            }
            case "invfilterCB": {
                this.invFilterCallBack(e);
                break;
            }
            case "prefilterCB": {
                this.preFilterCallBack(e);
                break;
            }
        }
    }

    private void preFilterCallBack(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        if (returnData == null || returnData.isEmpty()) {
            return;
        }
        String filterCondition = (String)returnData.get("filterCondition");
        String conditionDescription = (String)returnData.get("conditionDescription");
        if (StringUtils.isNotEmpty((CharSequence)conditionDescription) && conditionDescription.length() > 255) {
            conditionDescription = conditionDescription.substring(0, 200) + "...";
        }
        int index = this.getModel().getEntryCurrentRowIndex("filterentry");
        this.getModel().setValue("prefilter", (Object)conditionDescription, index);
        this.getModel().setValue("prefilterjson_tag", (Object)filterCondition, index);
    }

    private void invFilterCallBack(ClosedCallBackEvent e) {
        Map returnData = (Map)e.getReturnData();
        if (returnData == null || returnData.isEmpty()) {
            return;
        }
        String filterCondition = (String)returnData.get("filterCondition");
        String conditionDescription = (String)returnData.get("conditionDescription");
        if (StringUtils.isNotEmpty((CharSequence)conditionDescription) && conditionDescription.length() > 255) {
            conditionDescription = conditionDescription.substring(0, 200) + "...";
        }
        int index = this.getModel().getEntryCurrentRowIndex("filterentry");
        this.getModel().setValue("invfilter", (Object)conditionDescription, index);
        this.getModel().setValue("invfilterjson_tag", (Object)filterCondition, index);
    }

    private void objCloseCallBack(ClosedCallBackEvent e, String actionId) {
        IDataModel model = this.getModel();
        JSONArray data = ColsTreeUtil.parseReturnData((ClosedCallBackEvent)e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        model.setValue("srcbillentry", (Object)id);
        model.setValue("srcbillentryname", (Object)info.getString("text"));
    }

    private void objColCloseCallBack(ClosedCallBackEvent e, String actionId) {
        String colNo = null;
        String col = null;
        String clrColNo = null;
        String clrCol = null;
        boolean valSrcEntry = false;
        switch (actionId) {
            case "invaccColCB": {
                colNo = "invacccolno";
                col = "invacccol";
                clrColNo = "srcbillcolno";
                clrCol = "srcbillcol";
                break;
            }
            case "srcbillColCB": {
                colNo = "srcbillcolno";
                col = "srcbillcol";
                valSrcEntry = true;
                break;
            }
            case "returnbillColCB": {
                colNo = "returncolno";
                col = "returncol";
                valSrcEntry = true;
                break;
            }
            default: {
                return;
            }
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("entryentity");
        JSONArray data = ColsTreeUtil.parseReturnData((ClosedCallBackEvent)e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        String id = info.getString("id");
        if (valSrcEntry && this.checkChooseEntity(id)) {
            return;
        }
        model.beginInit();
        model.setValue(col, (Object)id, index);
        model.setValue(colNo, (Object)info.getString("text"), index);
        if (clrColNo != null) {
            model.setValue(clrColNo, null, index);
        }
        if (clrCol != null) {
            model.setValue(clrCol, null, index);
        }
        if (INVACC_COLCB.equals(actionId)) {
            if (MATERIAL.equals(id)) {
                model.setValue("qfilter", (Object)true, index);
                model.setValue("update", (Object)true, index);
                model.setValue("match", (Object)true, index);
                model.setValue("fieldmustinput", (Object)true, index);
            } else if (ORG.equals(id)) {
                model.setValue("fieldmustinput", (Object)true, index);
            } else if (InvqueryCfgConst.ALLQTYFIELDS.contains(id)) {
                if (this.isOutRule()) {
                    model.setValue("update", (Object)true, index);
                    model.setValue("fristout", (Object)false, index);
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"qfilter", "update"});
                }
                model.setValue("qfilter", (Object)false, index);
            }
            model.setValue("returnorder", (Object)InvqueryHelper.getDefaultReturnOrder((String)id), index);
        } else if (SRCBILL_COLCB.equals(actionId) && this.isOutRule() && !id.contains(".")) {
            model.setValue("update", (Object)Boolean.FALSE, index);
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"update"});
        }
        model.endInit();
        view.updateView("entryentity");
    }

    private boolean checkChooseEntity(String prop) {
        MainEntityType meta = this.getSrcBillMainEntityType();
        if (meta != null) {
            return meta.getAllEntities().containsKey(prop);
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "srcbillobj": 
            case "srcbillentry": {
                this.changeSourceBill(e, key);
                break;
            }
            case "invacccolno": 
            case "srcbillcolno": 
            case "returncolno": {
                this.changeTargetObjCol(e, key);
                break;
            }
            case "qfilter": {
                this.changeQFilter(e);
                break;
            }
            case "fristout": {
                this.changeFristOut(e);
                break;
            }
            case "proqtyfield": {
                this.changeProQtyField(e);
                break;
            }
            case "proqty2ndfield": {
                this.changeProQty2ndField(e);
                break;
            }
            case "prefilter": {
                this.changePreFilter(e);
                break;
            }
            case "invfilter": {
                this.changeInvFilter(e);
                break;
            }
        }
    }

    private void changeInvFilter(PropertyChangedArgs e) {
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            this.getModel().setValue("invfilterjson_tag", null, rowIndex);
        }
    }

    private void changePreFilter(PropertyChangedArgs e) {
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            this.getModel().setValue("prefilterjson_tag", null, rowIndex);
        }
    }

    private void changeProQtyField(PropertyChangedArgs e) {
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String addField = null;
        boolean isUnit2nd = false;
        ArrayList<String> removeLists = new ArrayList<String>(Arrays.asList("avbqty", "qty", "avbqty2nd", "qty2nd"));
        if ("avbqty".equals(newValue)) {
            addField = "avbqty";
            removeLists.remove("avbqty");
        } else if ("qty".equals(newValue)) {
            addField = "qty";
            removeLists.remove("qty");
        } else if ("avbqty2nd".equals(newValue)) {
            addField = "avbqty2nd";
            removeLists.remove("avbqty2nd");
            isUnit2nd = true;
        } else if ("qty2nd".equals(newValue)) {
            addField = "qty2nd";
            removeLists.remove("qty2nd");
            isUnit2nd = true;
        } else {
            return;
        }
        if (!isUnit2nd) {
            this.getModel().setValue("proqty2ndfield", null);
        } else if (isUnit2nd && this.getModel().getValue("proqty2ndfield") == null) {
            this.getModel().setValue("proqty2ndfield", (Object)"avbqty");
        }
        boolean isExist = false;
        boolean isExist2nd = false;
        ArrayList<Integer> removeIndex = new ArrayList<Integer>(removeLists.size());
        for (DynamicObject entry : entryEntity) {
            String invAccClo = entry.getString("invacccol");
            if (invAccClo.equals(addField)) {
                isExist = true;
                continue;
            }
            if (isUnit2nd && (invAccClo.equals("avbqty") || invAccClo.equals("qty"))) {
                isExist2nd = true;
                continue;
            }
            if (!removeLists.contains(invAccClo)) continue;
            removeIndex.add(entry.getInt("seq") - 1);
        }
        this.getModel().beginInit();
        if (!removeIndex.isEmpty()) {
            int[] ints = Arrays.stream(removeIndex.toArray(new Integer[removeIndex.size()])).mapToInt(Integer::intValue).toArray();
            this.getModel().deleteEntryRows("entryentity", ints);
        }
        if (!isExist) {
            int newRowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("invacccolno", (Object)this.getInvAccPropName(addField), newRowIndex);
            this.getModel().setValue("invacccol", (Object)addField, newRowIndex);
            this.getModel().setValue("update", (Object)Boolean.TRUE, newRowIndex);
            this.getModel().setValue("returnorder", (Object)InvqueryHelper.getDefaultReturnOrder((String)addField), newRowIndex);
            this.getModel().setValue("fieldmustinput", (Object)Boolean.TRUE, newRowIndex);
            if (!isExist2nd && isUnit2nd) {
                int newRowIndex2 = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("invacccolno", (Object)this.getInvAccPropName("avbqty"), newRowIndex2);
                this.getModel().setValue("invacccol", (Object)"avbqty", newRowIndex2);
                this.getModel().setValue("update", (Object)Boolean.TRUE, newRowIndex2);
                this.getModel().setValue("returnorder", (Object)InvqueryHelper.getDefaultReturnOrder((String)"avbqty"), newRowIndex2);
                this.getModel().setValue("fieldmustinput", (Object)Boolean.TRUE, newRowIndex2);
            }
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void changeProQty2ndField(PropertyChangedArgs e) {
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String removeField = null;
        String addField = null;
        if ("avbqty".equals(newValue)) {
            addField = "avbqty";
            removeField = "qty";
        } else if ("qty".equals(newValue)) {
            addField = "qty";
            removeField = "avbqty";
        } else {
            return;
        }
        boolean isExist = false;
        Integer removeIndex = null;
        for (DynamicObject entry : entryEntity) {
            String invAccClo = entry.getString("invacccol");
            if (invAccClo.equals(addField)) {
                isExist = true;
                continue;
            }
            if (!removeField.equals(invAccClo)) continue;
            removeIndex = entry.getInt("seq") - 1;
        }
        this.getModel().beginInit();
        if (removeIndex != null) {
            this.getModel().deleteEntryRow("entryentity", removeIndex.intValue());
        }
        if (!isExist) {
            int newRowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("invacccolno", (Object)this.getInvAccPropName(addField), newRowIndex);
            this.getModel().setValue("invacccol", (Object)addField, newRowIndex);
            this.getModel().setValue("update", (Object)Boolean.TRUE, newRowIndex);
            this.getModel().setValue("returnorder", (Object)InvqueryHelper.getDefaultReturnOrder((String)addField), newRowIndex);
            this.getModel().setValue("fieldmustinput", (Object)Boolean.TRUE, newRowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void changeFristOut(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            if (!Boolean.TRUE.equals(newValue)) continue;
            this.getModel().setValue("qfilter", (Object)Boolean.FALSE, changeData.getRowIndex());
        }
    }

    private void changeQFilter(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            if (!Boolean.TRUE.equals(newValue)) continue;
            this.getModel().setValue("fristout", (Object)Boolean.FALSE, changeData.getRowIndex());
        }
    }

    private void changeTargetObjCol(PropertyChangedArgs e, String key) {
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int rowIndex = changeData.getRowIndex();
            if ("invacccolno".equals(key)) {
                model.setValue("invacccol", null, rowIndex);
                model.setValue("srcbillcolno", null, rowIndex);
                model.setValue("srcbillcol", null, rowIndex);
                model.setValue("returncol", null, rowIndex);
                model.setValue("returncolno", null, rowIndex);
                continue;
            }
            if ("srcbillcolno".equals(key)) {
                model.setValue("srcbillcol", null, rowIndex);
                model.setValue("returncol", null, rowIndex);
                model.setValue("returncolno", null, rowIndex);
                continue;
            }
            if (!"returncolno".equals(key)) continue;
            model.setValue("returncol", null, rowIndex);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void changeSourceBill(PropertyChangedArgs e, String key) {
        DynamicObjectCollection entryentity;
        IDataModel model = this.getModel();
        model.beginInit();
        if ("srcbillobj".equals(key)) {
            model.setValue("srcbillentry", null);
            model.setValue("srcbillentryname", null);
            model.deleteEntryData("filterentry");
        }
        if ("srcbillentry".equals(key)) {
            model.setValue("srcbillentryname", null);
        }
        if (!(entryentity = model.getEntryEntity("entryentity")).isEmpty()) {
            for (int i = 0; i < entryentity.size(); ++i) {
                model.setValue("srcbillcolno", null, i);
                model.setValue("srcbillcol", null, i);
                model.setValue("returncolno", null, i);
                model.setValue("returncol", null, i);
            }
        }
        model.endInit();
        this.getView().updateView();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if ("deleteentry".equals(evt.getItemKey()) && this.isOutRule()) {
            int[] selectRows;
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            for (int i : selectRows = grid.getSelectRows()) {
                DynamicObject row = this.getModel().getEntryRowEntity("entryentity", i);
                String proQty = (String)this.getModel().getValue("proqtyfield");
                String srcCol = row.getString("invacccol");
                if (MATERIAL.equals(srcCol) || ORG.equals(srcCol) || "unit".equals(srcCol)) {
                    this.fieldIsNotAllowDelete(srcCol, evt);
                    continue;
                }
                if ("avbqty".equals(proQty) && "avbqty".equals(srcCol)) {
                    this.fieldIsNotAllowDelete(srcCol, evt);
                    continue;
                }
                if (!"qty".equals(proQty) || !"qty".equals(srcCol)) continue;
                this.fieldIsNotAllowDelete(srcCol, evt);
            }
        }
    }

    private void fieldIsNotAllowDelete(String field, BeforeItemClickEvent evt) {
        String tip = String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u6620\u5c04\u662f\u7cfb\u7edf\u5fc5\u8981\u7684\u914d\u7f6e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"fieldNotAllDelete", (String)"scmc-im-formplugin", (Object[])new Object[0]), this.getInvAccPropName(field));
        this.getView().showErrorNotification(tip);
        evt.setCancel(true);
    }

    private MainEntityType getSrcBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject sourceBill = model.getDataEntity().getDynamicObject("srcbillobj");
        if (sourceBill == null) {
            return null;
        }
        String metaDataNo = sourceBill.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
        return mainEntityType;
    }

    private boolean isOutRule() {
        return "B".equals(this.getModel().getValue("usetype"));
    }

    private String getInvAccPropName(String field) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"im_inv_realbalance");
        IDataEntityProperty prop = dataEntityType.findProperty(field);
        if (prop != null) {
            return prop.getDisplayName().getLocaleValue();
        }
        return "";
    }
}

