/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.invquery;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.invquery.InvqueryCfgUpgradeHelper;
import org.apache.commons.lang.StringUtils;

public class InvqueryCfgListPlugin
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
        String useType = (String)this.getView().getFormShowParameter().getCustomParams().get("usetype");
        if (StringUtils.equals((String)"A", (String)useType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"upgradecfg"});
        } else if (StringUtils.equals((String)"B", (String)useType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"upgradecfg"});
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tblnew"});
        super.registerListener(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List columns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : columns) {
            if (!"srcbillobj.number".equals(filterColumn.getFieldName())) continue;
            DynamicObjectCollection judgements = QueryServiceHelper.query((String)"bos_billmainentity", (String)"id,name", (QFilter[])this.getSrcBillObjFilter().toArray());
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(judgements.size());
            for (DynamicObject judgement : judgements) {
                ComboItem customFiter = new ComboItem();
                customFiter.setCaption(new LocaleString(judgement.getString("name")));
                customFiter.setValue(String.valueOf(judgement.get("id")));
                combos.add(customFiter);
            }
            CommonFilterColumn billColumn = (CommonFilterColumn)filterColumn;
            billColumn.setComboItems(combos);
            billColumn.setType("enum");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("srcbillobj.name".equals(args.getFieldName()) || "srcbillobj.id".equals(args.getFieldName())) {
            args.addCustomQFilter(this.getSrcBillObjFilter());
        }
    }

    private QFilter getSrcBillObjFilter() {
        DataSet srcbillDataset = QueryServiceHelper.queryDataSet((String)InvqueryCfgListPlugin.class.getName(), (String)"im_invqueryconf", (String)"srcbillobj", (QFilter[])new QFilter[0], (String)"").distinct();
        HashSet<String> objs = new HashSet<String>(50);
        for (Row row : srcbillDataset) {
            objs.add(row.getString("srcbillobj"));
        }
        return new QFilter("number", "in", objs);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "upgradecfg": {
                this.handleUpgradecfg();
                break;
            }
        }
    }

    private void handleUpgradecfg() {
        DynamicObject invdbParam = BusinessDataServiceHelper.loadSingleFromCache((String)"im_invdbparam", (String)"value", (QFilter[])new QFilter("key", "=", (Object)"newInvqryCfg").toArray());
        if (invdbParam != null) {
            if ("1".equals(invdbParam.getString("value"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5347\u7ea7\u81f3\u65b0\u5e93\u5b58\u67e5\u8be2\u914d\u7f6e\uff0c\u65e0\u9700\u91cd\u590d\u5347\u7ea7\u3002", (String)"InvqueryCfgListPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else {
                InvqueryCfgUpgradeHelper.syncAllMetadataCfg();
                invdbParam.set("value", (Object)"1");
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{invdbParam});
                this.getView().updateView();
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        Object useType = this.getView().getFormShowParameter().getCustomParams().get("usetype");
        if (useType != null) {
            List filters = e.getQFilters();
            filters.add(new QFilter("usetype", "=", useType));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("newinvmap".equals(e.getOperateKey())) {
            this.handleNew();
        }
    }

    private void handleNew() {
        Object useType = this.getView().getFormShowParameter().getCustomParams().get("usetype");
        if (useType == null) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("im_invmappingtype");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invquerymaptype"));
            this.getView().showForm(parameter);
        } else {
            this.showAddInvqueryConfForm(useType, null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if ("invquerymaptype".equals(e.getActionId()) && StringUtil.isNotEmpty((CharSequence)((String)returnData))) {
            this.showAddInvqueryConfForm(returnData, null);
        }
    }

    private void showAddInvqueryConfForm(Object useType, ListSelectedRow row) {
        BaseShowParameter param = new BaseShowParameter();
        if (row != null) {
            param.setPkId(row.getPrimaryKeyValue());
        }
        param.setFormId("im_invqueryconf");
        param.setBillTypeId("im_invqueryconf");
        param.setCustomParam("usetype", useType);
        param.setStatus(OperationStatus.ADDNEW);
        if ("B".equals(useType)) {
            param.setCaption(ResManager.loadKDString((String)"\u5339\u914d\u5e93\u5b58\u914d\u7f6e", (String)"SBS-D-018630", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String name;
        switch (name = args.getFieldName()) {
            case "number": {
                BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
                ListSelectedRow row = event.getCurrentRow();
                Object useType = this.getView().getFormShowParameter().getCustomParams().get("usetype");
                if (!"B".equals(useType)) break;
                this.showAddInvqueryConfForm(useType, row);
                args.setCancel(true);
                break;
            }
        }
        super.billListHyperLinkClick(args);
    }
}

