/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.outbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.ImBillEditHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.consts.BizTypeConsts;
import kd.scmc.im.enums.MaterialTypeEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImApplyBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public class MaterialReqBillPlugin
extends ImApplyBillEditPlugin {
    private static final String algoKey = MaterialReqBillPlugin.class.getName();
    private static final String FDATAID = "FDATAID";
    private static final String FUSEORGID = "FUSEORGID";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"bizorg", "org", "supplyowner", "applydept", "warehouse", "location"});
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"seradvcontoolbarap"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DynamicObject bizType;
        DynamicObject bizOrg;
        super.afterCreateNewData(e);
        this.applyUserInit();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            Object settleOrgId = null;
            if (map != null) {
                settleOrgId = map.get("id");
            }
            this.getModel().setValue("settleorg", settleOrgId);
            if (org.getBoolean("fisinventory") && NewInvOrgHelper.isStartInv((Long)orgId)) {
                this.getModel().setValue("bizorg", (Object)orgId);
            }
        }
        if ((bizOrg = (DynamicObject)this.getModel().getValue("bizorg")) != null) {
            this.setDefaultOwner((Long)bizOrg.getPkValue());
        }
        if ((bizType = this.getModel().getDataEntity().getDynamicObject("biztype")) != null && "6".equals(bizType.get("domain"))) {
            this.getModel().setValue("supplyownertype", (Object)"bd_supplier");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setMaterialName();
    }

    private void setMaterialName() {
        IDataModel model = this.getModel();
        DynamicObjectCollection billEntries = model.getDataEntity().getDynamicObjectCollection("billentry");
        if (billEntries != null && !billEntries.isEmpty()) {
            model.beginInit();
            DataEntityPropertyCollection properties = ((DynamicObject)billEntries.get(0)).getDynamicObjectType().getProperties();
            DynamicProperty materialNameProp = (DynamicProperty)properties.get((Object)"materialname");
            for (DynamicObject billEntry : billEntries) {
                DynamicObject masterid;
                DynamicObject material = billEntry.getDynamicObject("material");
                String materialName = billEntry.getString("materialname");
                if (material == null || !StringUtils.isEmpty((CharSequence)materialName) || (masterid = material.getDynamicObject("masterid")) == null) continue;
                materialName = masterid.getLocaleString("name").toString();
                materialNameProp.setValueFast((Object)billEntry, (Object)materialName);
            }
            model.endInit();
            model.setDataChanged(false);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefaultStatus();
        int size = this.getModel().getEntryEntity("billentry").size();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            boolean uncontrolledqty = (Boolean)this.getModel().getValue("uncontrolledqty", rowIndex);
            this.getView().setEnable(Boolean.valueOf(!uncontrolledqty), rowIndex, new String[]{"excessratio"});
            this.getView().setEnable(Boolean.valueOf(!uncontrolledqty), rowIndex, new String[]{"shortageratio"});
        }
        String status = (String)this.getModel().getValue("billstatus");
        if ("D".equals(status)) {
            this.disableAll();
        } else if ("A".equals(status)) {
            this.enableAll();
        }
    }

    @Override
    public void afterCopyData(EventObject e) {
        this.enableAll();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "closed": {
                this.disableAll();
                break;
            }
            case "bar_unclosestatus": 
            case "unsubmit": 
            case "unaudit": {
                this.enableAll();
                this.handleEnable();
                this.setDefaultStatus();
                break;
            }
        }
    }

    private ArrayList<Object> getOwnerList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("bizorg");
        ArrayList<Object> array = new ArrayList<Object>();
        if (!CommonUtils.isNull((Object)org)) {
            Long orgId = (Long)org.getPkValue();
            ArrayList ownerArray = OwnerHelper.getOwners((Long)orgId);
            array.addAll(ownerArray);
            Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (companyByOrg != null) {
                array.add(companyByOrg.get("id"));
            }
        }
        return array;
    }

    private void disableAll() {
        if ("D".equals(this.getModel().getValue("billstatus"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billentry", "org", "biztype", "transtype", "biztime", "applyuser", "settlecurrency", "comment", "settleorg", "bizorg", "supplyownertype", "supplyowner", "applydept", "applyuser", "costcenterorg", "addrow", "deleterow", "fillbatch", "attachmentpanel"});
        }
    }

    @Override
    protected void setEnable4IsDraw(boolean isDraw) {
        super.setEnable4IsDraw(isDraw);
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(!isDraw), new String[]{"org", "biztype", "billtype"});
    }

    private void enableAll() {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"billentry", "transtype", "biztime", "applyuser", "settlecurrency", "comment", "settleorg", "bizorg", "supplyownertype", "supplyowner", "applydept", "applyuser", "costcenterorg", "addrow", "deleterow", "fillbatch", "attachmentpanel"});
    }

    private void setDefaultStatus() {
        boolean draw = this.isDraw();
        if (draw) {
            this.setMaterialEnable();
            IFormView view = this.getView();
            view.setEnable(Boolean.valueOf(false), new String[]{"addrow"});
            view.setEnable(Boolean.valueOf(false), new String[]{"biztype"});
            view.setEnable(Boolean.valueOf(false), new String[]{"org"});
            view.setEnable(Boolean.valueOf(false), new String[]{"settleorg"});
        }
    }

    private void setMaterialEnable() {
        int size = this.getModel().getEntryRowCount("billentry");
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"material"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"unit"});
        }
    }

    @Override
    protected void setEntryOtherEnable(DynamicObject billEntry, int rowIndex) {
        super.setEntryOtherEnable(billEntry, rowIndex);
        IFormView view = this.getView();
        boolean isUncontrolledQty = billEntry.getBoolean("uncontrolledqty");
        view.setEnable(Boolean.valueOf(!isUncontrolledQty), rowIndex, new String[]{"excessratio"});
        view.setEnable(Boolean.valueOf(!isUncontrolledQty), rowIndex, new String[]{"shortageratio"});
    }

    private void dealWithEntry(Long bizOrgId, DynamicObject oldBizOrg) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        boolean match = false;
        HashSet<Long> materialidSet = new HashSet<Long>(entryEntity.size());
        HashMap<Long, Long> materialInvMap = new HashMap<Long, Long>(entryEntity.size());
        HashMap<String, Long> matchMaterialInvMap = new HashMap<String, Long>(entryEntity.size());
        ArrayList<Integer> indexList = new ArrayList<Integer>(entryEntity.size());
        ArrayList<DynamicObject> materialList = new ArrayList<DynamicObject>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject material = (DynamicObject)entry.get("material");
            Long materialId = material.getLong("masterid.id");
            materialidSet.add(materialId);
        }
        QFilter materialFilter = new QFilter("masterid", "in", materialidSet);
        HashSet<Long> orgidSet = new HashSet<Long>(2);
        orgidSet.add(bizOrgId);
        orgidSet.add((Long)oldBizOrg.get("id"));
        BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_materialinventoryinfo", new ArrayList(orgidSet));
        DataSet matchMaterialInvSet = this.getMaterialInvSet(materialFilter, bizOrgId);
        while (matchMaterialInvSet.hasNext()) {
            Row row = matchMaterialInvSet.next();
            Long materialInvId = row.getLong("id");
            Long materialIId = row.getLong("masterid");
            materialInvMap.put(materialIId, materialInvId);
        }
        if (!materialInvMap.isEmpty()) {
            match = true;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject material = (DynamicObject)entry.get("material");
            Long materialIId = material.getLong("masterid.id");
            Long matchMaterialInvId = (Long)materialInvMap.get(materialIId);
            if (match && null != matchMaterialInvId) {
                matchMaterialInvMap.put(String.valueOf(materialIId), matchMaterialInvId);
                continue;
            }
            indexList.add(i);
            materialList.add(material);
        }
        if (!materialList.isEmpty()) {
            this.showMessage(materialList, indexList, oldBizOrg, matchMaterialInvMap);
        } else {
            this.changeMaterial(entryEntity, matchMaterialInvMap);
        }
    }

    private DataSet getMaterialInvSet(QFilter materialFilter, Long bizOrgId) {
        DataSet materialInvInfo = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_materialinventoryinfo", (String)"id,masterid", (QFilter[])materialFilter.toArray(), null);
        String sql = "select FDATAID,FUSEORGID from T_BD_MATERIALINVINFO_U WHERE FUSEORGID = " + bizOrgId;
        DataSet materialInvInfo_U = DB.queryDataSet((String)algoKey, (DBRoute)new DBRoute("sys"), (String)sql);
        DataSet matchMaterialInvSet = materialInvInfo.join(materialInvInfo_U, JoinType.INNER).on("id", FDATAID).select(new String[]{"masterid", FUSEORGID, "id"}).finish();
        return matchMaterialInvSet;
    }

    private void showMessage(List<DynamicObject> materialList, List<Integer> indexList, DynamicObject oldBizOrg, Map<String, Long> matchMaterialInvMap) {
        StringBuilder detailMsg = new StringBuilder();
        DynamicObject org = (DynamicObject)this.getModel().getValue("bizorg");
        Object orgname = org.get("name");
        for (int i = 0; i < materialList.size(); ++i) {
            DynamicObject materialInv = materialList.get(i);
            DynamicObject material = (DynamicObject)materialInv.get("masterid");
            Object materialNumber = material.get("number");
            Object materialName = material.get("name");
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s %3$s\u201d\uff0c\u5728%4$s\u4e2d\u6ca1\u6709\u7ef4\u62a4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"MaterialReqBillPlugin_17", (String)"scmc-im-formplugin", (Object[])new Object[0]), i + 1, materialNumber, materialName, orgname);
            detailMsg.append(msg);
        }
        HashMap<String, Object> infoMap = new HashMap<String, Object>(2);
        infoMap.put("indexList", indexList);
        infoMap.put("oldBizOrg", oldBizOrg);
        infoMap.put("matchMaterialInvMap", matchMaterialInvMap);
        ConfirmCallBackListener cb = new ConfirmCallBackListener("dealEntry", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7269\u6599\u6ca1\u6709\u7ef4\u62a4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MaterialReqBillPlugin_18", (String)"scmc-im-formplugin", (Object[])new Object[0]), detailMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(infoMap));
    }

    private void changeMaterial(DynamicObjectCollection entryEntity, Map<String, Long> matchMaterialInvMap) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject material = (DynamicObject)entry.get("material");
            Long materialIId = material.getLong("masterid.id");
            Long matchMaterialInvId = matchMaterialInvMap.get(String.valueOf(materialIId));
            DynamicObject matarial = BusinessDataServiceHelper.loadSingle((Object)matchMaterialInvId, (String)"bd_materialinventoryinfo");
            entry.set("material", (Object)matarial);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        switch (callBackId = e.getCallBackId()) {
            case "dealEntry": {
                String customVaule = e.getCustomVaule();
                if (null == customVaule) break;
                Map infoMap = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
                List indexList = (List)infoMap.get("indexList");
                Map oldBizOrg = (Map)infoMap.get("oldBizOrg");
                Map matchMaterialInvMap = (Map)infoMap.get("matchMaterialInvMap");
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.deleteEntryRows(indexList, matchMaterialInvMap);
                    break;
                }
                if (!MessageBoxResult.Cancel.equals((Object)result)) break;
                this.changeOldOrg(oldBizOrg.get("id"));
                break;
            }
        }
    }

    private void dealWithMaterial(Map<Object, Object> confirmInfo) {
        if (confirmInfo.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        List clearEntryIndexList = (List)confirmInfo.get("clearEntryIndexList");
        if (clearEntryIndexList.size() != 0) {
            int[] clearEntryIndex = new int[clearEntryIndexList.size()];
            for (int i = 0; i < clearEntryIndexList.size(); ++i) {
                clearEntryIndex[i] = (Integer)clearEntryIndexList.get(i);
            }
            model.deleteEntryRows("billentry", clearEntryIndex);
        }
    }

    private void dealWithSupplier(Map<Object, Object> confirmInfo) {
        if (confirmInfo.isEmpty()) {
            return;
        }
        boolean clearSupplier = false;
        Object clear = confirmInfo.get("clearSupplier");
        if (null != clear) {
            clearSupplier = (Boolean)clear;
        }
        if (clearSupplier) {
            this.getModel().setValue("supplyowner", null);
        }
    }

    private void changeOldOrg(Object oldBizOrg) {
        this.getModel().beginInit();
        this.getModel().setValue("bizorg", oldBizOrg);
        this.getView().updateView("bizorg");
        this.getModel().endInit();
    }

    private void deleteEntryRows(List<Integer> indexList, Map<String, Long> matchMaterialInvMap) {
        if (!CommonUtils.isNull(indexList)) {
            int[] rows = new int[indexList.size()];
            for (int j = 0; j < rows.length; ++j) {
                rows[j] = indexList.get(j);
            }
            this.getModel().deleteEntryRows("billentry", rows);
        }
        if (null != matchMaterialInvMap) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
            this.changeMaterial(entryEntity, matchMaterialInvMap);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        block12: for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[0].getRowIndex();
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue != null && newValue != null && oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue != null && newValue != null && oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldName) {
                case "bizorg": {
                    DynamicObject bizOrg = (DynamicObject)newValue;
                    DynamicObject oldBizOrg = (DynamicObject)oldValue;
                    this.changeBizOrg(bizOrg, oldBizOrg);
                    continue block12;
                }
                case "org": {
                    this.changeOrg(newValue);
                    continue block12;
                }
                case "warehouse": {
                    this.changeWarehouse(valueSet);
                    continue block12;
                }
                case "uncontrolledqty": {
                    boolean uncontrolledqty = (Boolean)this.getModel().getValue("uncontrolledqty");
                    this.getView().setEnable(Boolean.valueOf(!uncontrolledqty), rowIndex, new String[]{"excessratio"});
                    this.getView().setEnable(Boolean.valueOf(!uncontrolledqty), rowIndex, new String[]{"shortageratio"});
                    continue block12;
                }
            }
        }
    }

    private void changeBizType(Object oldValue) {
        boolean bizTypeIsVMI = false;
        boolean bizTypeIsAsset = false;
        IDataModel model = this.getModel();
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        if (bizType == null) {
            return;
        }
        Object bizTypeId = bizType.getPkValue();
        if (bizTypeId.equals(BizTypeConsts.BIZTYPE_MOUT_VMI) || bizTypeId.equals(BizTypeConsts.BIZTYPE_MOUTRETURN_VMI)) {
            bizTypeIsVMI = true;
        }
        if (bizTypeId.equals(BizTypeConsts.BIZTYPE_MROUT_ASSET)) {
            bizTypeIsAsset = true;
        }
        if (!bizTypeIsVMI && !bizTypeIsAsset) {
            return;
        }
        DynamicObject oldBizType = oldValue == null ? null : (DynamicObject)oldValue;
        this.validateBizTypeAndConfirm(bizTypeIsVMI, bizTypeIsAsset, oldBizType);
    }

    private void validateBizTypeAndConfirm(boolean bizTypeIsVMI, boolean bizTypeIsAsset, DynamicObject oldBizType) {
        Map<Object, Object> confirmInfo = new HashMap(4);
        if (bizTypeIsAsset) {
            confirmInfo = this.getEntryIndexMap4Asset(oldBizType);
        } else if (bizTypeIsVMI) {
            confirmInfo = this.getClearConfirmInfo4VMI(oldBizType);
        }
        boolean alertMsg = (Boolean)confirmInfo.get("alertMsg");
        if (alertMsg) {
            ConfirmCallBackListener cb = new ConfirmCallBackListener("clearSupplierOrEntry", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u7c7b\u578b\u540e\uff0c\u4f9b\u5e94\u5546\u6216\u7269\u6599\u4fe1\u606f\u5c06\u88ab\u6e05\u9664\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ImBillPropChanged_13", (String)"scmc-im-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(confirmInfo));
        }
    }

    private Map<Object, Object> getClearConfirmInfo4VMI(DynamicObject oldBizType) {
        List<Object> clearEntryIndexList = new ArrayList();
        HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(4);
        boolean clearSupplier = this.checkIfClearSupplier();
        confirmInfo.put("clearSupplier", clearSupplier);
        Map<String, List<Integer>> infoMap = this.getMaterialIndexInfoMap();
        clearEntryIndexList = infoMap.get("clearEntryIndexList");
        confirmInfo.put("alertMsg", false);
        confirmInfo.put("clearEntryIndexList", clearEntryIndexList);
        confirmInfo.put("oldBizTypeId", oldBizType == null ? null : oldBizType.getPkValue());
        if (clearSupplier || clearEntryIndexList.size() != 0) {
            confirmInfo.put("alertMsg", true);
        }
        return confirmInfo;
    }

    private boolean checkIfClearSupplier() {
        IDataModel model = this.getModel();
        boolean clearSupplier = false;
        DynamicObject supplier = (DynamicObject)model.getValue("supplyowner");
        String supplyownerType = (String)model.getValue("supplyownertype");
        if (supplier != null && "bd_supplier".equals(supplyownerType)) {
            clearSupplier = !(supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier", (String)"id,enablevmi")).getBoolean("enablevmi");
        }
        return clearSupplier;
    }

    private Map<Object, Object> getEntryIndexMap4Asset(DynamicObject oldBizType) {
        HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(4);
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("billentry");
        ArrayList<Integer> clearEntryIndexList = new ArrayList<Integer>();
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject materialInfo = (DynamicObject)model.getValue("material", i);
            if (null == materialInfo) continue;
            DynamicObject material = (DynamicObject)materialInfo.get("masterid");
            String materialtype = (String)material.get("materialtype");
            if (null == material || MaterialTypeEnum.ASSET.getValue().equals(materialtype)) continue;
            clearEntryIndexList.add(i);
        }
        confirmInfo.put("alertMsg", false);
        confirmInfo.put("clearEntryIndexList", clearEntryIndexList);
        confirmInfo.put("oldBizTypeId", oldBizType == null ? null : oldBizType.getPkValue());
        if (clearEntryIndexList.size() != 0) {
            confirmInfo.put("alertMsg", true);
        }
        return confirmInfo;
    }

    private Map<String, List<Integer>> getMaterialIndexInfoMap() {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("billentry");
        HashMap<String, List<Integer>> infoMap = new HashMap<String, List<Integer>>(2);
        ArrayList<Integer> clearEntryIndexList = new ArrayList<Integer>();
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject material;
            DynamicObject materialInfo = (DynamicObject)model.getValue("material", i);
            if (null == materialInfo || null == (material = (DynamicObject)materialInfo.get("masterid")) || material.getBoolean("enablevmi")) continue;
            clearEntryIndexList.add(i);
        }
        infoMap.put("clearEntryIndexList", clearEntryIndexList);
        return infoMap;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        boolean isMainOrg = ImBillEditHelper.isMainOrgByF7((IFormView)this.getView(), (IDataModel)bill, (String)key);
        if (!isMainOrg) {
            e.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject bizOrg = (DynamicObject)bill.getValue("bizorg");
        switch (key) {
            case "bizorg": {
                this.bizOrgSelect(e, showParameter, bizOrg);
                break;
            }
            case "warehouse": {
                this.beforeWarehouse(e);
                break;
            }
            case "location": {
                this.beforeLocation(e);
                break;
            }
            case "supplyowner": {
                this.supplyOwnerSelect(e, showParameter);
                break;
            }
        }
    }

    private void supplyOwnerSelect(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        IDataModel model = this.getModel();
        String type = (String)this.getModel().getValue("supplyownertype");
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject bizorg = (DynamicObject)model.getValue("bizorg");
        switch (type) {
            case "bos_org": {
                if (bizorg == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                f = new QFilter("id", "in", this.getOwnerList());
                showParameter.setCustomParam("orgFuncId", (Object)"10");
                break;
            }
            case "bd_customer": {
                if (bizorg != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (bizorg == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                this.addVMISelect(e);
                break;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    private void addVMISelect(BeforeF7SelectEvent e) {
        String domain;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && "6".equals(domain = bizType.getString("domain"))) {
            QFilter q = new QFilter("enablevmi", "=", (Object)"1");
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)q);
        }
    }

    private void beforeWarehouse(BeforeF7SelectEvent e) {
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)bill.getValue("bizorg");
        if (org == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG(), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String formId = this.getModel().getDataEntityType().getName();
        Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)formId, (DynamicObject)org, (ListShowParameter)showParameter);
        if (!result.booleanValue()) {
            Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(org.getPkValue().toString()));
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
        }
    }

    private void beforeLocation(BeforeF7SelectEvent e) {
        IDataModel bill = this.getModel();
        int rowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject warehouse = (DynamicObject)bill.getValue("warehouse", rowIndex);
        if (CommonUtils.isNull((Object)warehouse)) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_WAREHOUSE(), (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            QFilter qFilter1 = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
            showParameter.getListFilterParameter().setFilter(qFilter1);
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (CommonUtils.isNull((Object)locationCol) || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    private void bizOrgSelect(BeforeF7SelectEvent e, ListShowParameter showParameter, DynamicObject bizOrg) {
        Long[] startedInvOrgsIds = NewInvOrgHelper.getStartedInvOrgsIds();
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)startedInvOrgsIds));
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if ("billentry".equals(entryName)) {
            int rowIndex;
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                rowIndex = rowDataEntity.getRowIndex();
                this.initNewEntry(rowIndex);
            }
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                rowIndex = rowDataEntity.getRowIndex();
                boolean uncontrolledqty = (Boolean)this.getModel().getValue("uncontrolledqty", rowIndex);
                this.getView().setEnable(Boolean.valueOf(!uncontrolledqty), rowIndex, new String[]{"excessratio"});
                this.getView().setEnable(Boolean.valueOf(!uncontrolledqty), rowIndex, new String[]{"shortageratio"});
            }
        }
    }

    private void changeBizOrg(DynamicObject bizOrg, DynamicObject oldBizOrg) {
        boolean isDraw;
        Long bizOrgId = null;
        if (bizOrg != null) {
            bizOrgId = (Long)bizOrg.getPkValue();
        }
        if (isDraw = this.isDraw()) {
            if (null == bizOrg) {
                if (oldBizOrg == null) {
                    return;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u4e3a\u4e0b\u63a8\u751f\u6210\u5355\u636e\uff0c\u4e0d\u53ef\u6e05\u7a7a\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MaterialReqBillPlugin_19", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                this.setValue("bizorg", oldBizOrg.get("id"), false);
            } else {
                this.dealWithEntry(bizOrgId, oldBizOrg);
            }
        } else {
            this.getModel().deleteEntryData("billentry");
            this.getModel().createNewEntryRow("billentry");
        }
        this.setDefaultOwner(bizOrgId);
    }

    private void setDefaultOwner(Long bizOrgId) {
        String supplyOwnerType;
        if (bizOrgId != null && "bos_org".equals(supplyOwnerType = (String)this.getModel().getValue("supplyownertype"))) {
            Object defaultOwner = OwnerHelper.getOwnerDefValue((Long)bizOrgId);
            this.getModel().setValue("supplyowner", defaultOwner);
        }
    }

    private void changeOrg(Object newValue) {
    }

    private void initNewEntry(int rowIndex) {
        IDataModel bill = this.getModel();
        DynamicObject bizorg = (DynamicObject)bill.getValue("bizorg");
        if (bizorg != null) {
            bill.setValue("bizorg", (Object)bizorg, rowIndex);
        }
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"location"});
    }

    private void changeWarehouse(ChangeData[] valueSet) {
        for (int i = 0; i < valueSet.length; ++i) {
            Object oldValue;
            Object newValue = valueSet[i].getNewValue();
            if (newValue == (oldValue = valueSet[i].getOldValue())) continue;
            int rowindex = valueSet[i].getRowIndex();
            this.setValue("location", null, rowindex, false);
            if (!CommonUtils.isNull((Object)newValue)) {
                boolean isopenlocation = ((DynamicObject)newValue).getBoolean("isopenlocation");
                if (isopenlocation) {
                    this.getView().setEnable(Boolean.TRUE, rowindex, new String[]{"location"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"location"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"location"});
        }
    }
}

