/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.outbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.InverseBillHelper;
import kd.scmc.im.business.helper.MeasureDeviationAdjustHelper;
import kd.scmc.im.business.helper.TailDiffAdjustBillHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class OtherOutBillPlugin
extends ImBillEditPlugin {
    private static final String ISMEASUREAJUST = "isMeasureAdjust";
    private boolean isMeasureAdjust = false;

    @Override
    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get(ISMEASUREAJUST) != null && ((Boolean)customParams.get(ISMEASUREAJUST)).booleanValue()) {
            this.dealTailAdjust(customParams);
        } else {
            super.afterCreateNewData(e);
        }
        this.initCurrency();
        if (this.isMeasureAdjust) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbldraw"});
        }
    }

    private void dealTailAdjust(Map<String, Object> customParams) {
        this.isMeasureAdjust = true;
        DynamicObject billType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (String)"id", (QFilter[])new QFilter("number", "=", (Object)"im_OtherOutBill_STD_BT_S").toArray());
        this.getModel().setValue("billtype", (Object)billType);
        boolean idNewAdjust = customParams.get("isNewAdjust") != null && (Boolean)customParams.get("isNewAdjust") != false;
        TailDiffAdjustBillHelper adjustHelper = idNewAdjust ? new TailDiffAdjustBillHelper(this.getView(), customParams) : new MeasureDeviationAdjustHelper(this.getView(), customParams);
        adjustHelper.dealMeasureDeviAdjust();
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.initNewEntryLineType(i);
            this.initMaterialName(i);
        }
        CloseDateHelper.initBookDate((String)this.getView().getEntityId(), (DynamicObject)this.getModel().getDataEntity(true));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"owner", "outowner", "bizdept"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (e.getProperty().getName()) {
            case "owner": {
                this.setOwnerFilter(e, "ownertype");
                break;
            }
            case "outowner": {
                this.setOwnerFilter(e, "outownertype");
                break;
            }
            case "bizdept": {
                this.setBizDeptFilter(e);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        int index = e.getChangeSet()[0].getRowIndex();
        String key = e.getProperty().getName();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "customer": {
                this.setDefCoustomer();
                break;
            }
            case "price": {
                this.handlePriceChangeEvent(index);
                break;
            }
            case "amount": {
                this.handleAmountChangeEvent(index);
                break;
            }
            case "qty": {
                this.handleQtyChangeEvent(index);
                break;
            }
            case "qtyunit2nd": {
                this.handleQtyunit2ndChangeEvent(index);
                break;
            }
            case "biztype": {
                this.setQtyMustinput();
                this.SetQtyEnable();
                break;
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setQtyMustinput();
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rows = e.getRowDataEntities();
            IFormView view = this.getView();
            for (RowDataEntity row : rows) {
                int rowIndex = row.getRowIndex();
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"baseqty"});
            }
        }
    }

    private void setQtyMustinput() {
        String[] inCheckFields = new String[]{"qty", "baseqty"};
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject biztype = (DynamicObject)model.getValue("biztype");
        if (null == biztype) {
            OtherOutBillPlugin.setControlMustInput(view, true, inCheckFields);
            return;
        }
        String biztypeNum = biztype.getString("number");
        if ("380".equals(biztypeNum)) {
            OtherOutBillPlugin.setControlMustInput(view, true, "materialname");
            return;
        }
        if (!"351".equals(biztypeNum)) {
            OtherOutBillPlugin.setControlMustInput(view, true, inCheckFields);
            boolean negativeBill = InverseBillHelper.isNegativeBill((IDataModel)this.getModel());
            if (negativeBill) {
                this.handleMatchingRuleEnable(false);
            } else {
                this.handleMatchingRuleEnable(true);
            }
        } else {
            OtherOutBillPlugin.setControlMustInput(view, false, inCheckFields);
            this.handleMatchingRuleEnable(false);
        }
    }

    private void handleMatchingRuleEnable(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"matchingruleout"});
    }

    @Override
    protected void setHeadEnable() {
        super.setHeadEnable();
    }

    @Override
    protected void setEntryEnable(IFormView view, int rowIndex, boolean enable, String ... fieldName) {
        super.setEntryEnable(view, rowIndex, enable, fieldName);
        DynamicObject bill = this.getBill();
        DynamicObject invScheme = bill.getDynamicObject("invscheme");
        if (invScheme != null) {
            boolean isInUpdate = invScheme.getBoolean("isinupdate");
            boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
            boolean isNotUpdate = invScheme.getBoolean("isnotupdate");
            view.setEnable(Boolean.valueOf(isInUpdate && !isNotUpdate), rowIndex, new String[]{"invtype", "invstatus", "owner", "ownertype", "keeper", "keepertype"});
            view.setEnable(Boolean.valueOf(isOutUpdate && !isNotUpdate), rowIndex, new String[]{"outinvtype", "outinvstatus", "outowner", "outownertype", "outkeeper", "outkeepertype"});
        }
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        List rows = e.getRows();
        if (!rows.isEmpty()) {
            long bizTypeId;
            IFormView view = this.getView();
            DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
            if (this.isDrawByBOTP() && bizType != null && 688865858117916672L == (bizTypeId = ((Long)bizType.getPkValue()).longValue())) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"im_otheroutbill");
                Map billentryFields = ((EntityType)dt.getAllEntities().get("billentry")).getFields();
                if (billentryFields.isEmpty()) {
                    return;
                }
                for (int i = 0; i < rows.size(); ++i) {
                    for (String key : billentryFields.keySet()) {
                        if ("ecostcenter".equals(key)) continue;
                        if ("amount".equals(key) || "price".equals(key)) {
                            view.setEnable(Boolean.TRUE, i, new String[]{key});
                            continue;
                        }
                        view.setEnable(Boolean.FALSE, i, new String[]{key});
                    }
                }
            }
        }
    }

    @Override
    protected void setBillEntryEnable(RowDataEntity row) {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        boolean isMeasureAdjustBizType = bizType != null && "380".equals(bizType.get("number"));
        IFormView view = this.getView();
        if (this.isMeasureAdjust || isMeasureAdjustBizType) {
            int rowIndex = row.getRowIndex();
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"material", "auxpty", "unit", "baseunit", "auxpty", "lotnumber", "producedate", "expirydate", "location", "warehouse", "invtype", "invstatus", "ownertype", "owner", "keepertype", "keeper", "outinvtype", "outinvstatus", "outownertype", "outowner", "outkeepertype", "outkeeper", "project", "logisticsbill", "linetype", "materialname", "lot", "tracknumber", "configuredcode"});
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("billentry");
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
            BigDecimal qty = dynamicObject.getBigDecimal("qty");
            BigDecimal baseQty = dynamicObject.getBigDecimal("baseqty");
            BigDecimal qty2nd = dynamicObject.getBigDecimal("qtyunit2nd");
            view.setEnable(Boolean.valueOf(qty.compareTo(BigDecimal.ZERO) != 0), rowIndex, new String[]{"qty"});
            view.setEnable(Boolean.valueOf(baseQty.compareTo(BigDecimal.ZERO) != 0), rowIndex, new String[]{"baseqty"});
            view.setEnable(Boolean.valueOf(qty2nd.compareTo(BigDecimal.ZERO) != 0), rowIndex, new String[]{"qtyunit2nd"});
            return;
        }
        super.setBillEntryEnable(row);
        view.setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"baseqty"});
    }

    @Override
    protected void setEnable4IsDraw(boolean isDraw) {
        boolean isMeasureAdjustBizType;
        IFormView view = this.getView();
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        boolean bl = isMeasureAdjustBizType = bizType != null && "380".equals(bizType.get("number"));
        if (!this.isMeasureAdjust && !isMeasureAdjustBizType) {
            super.setEnable4IsDraw(isDraw);
            view.setEnable(Boolean.TRUE, new String[]{"bizdept"});
            return;
        }
        view.setEnable(Boolean.TRUE, new String[]{"dept", "bizdept", "operator", "operatorgroup", "supplier", "biztime", "comment"});
        view.setEnable(Boolean.FALSE, new String[]{"org", "billtype", "biztype", "invscheme", "billstatus", "settlecurrency", "addrow", "splitrow", "fillbatch", "generatelot", "qinvacc", "snnumber", "matchingruleout"});
        view.setVisible(Boolean.FALSE, new String[]{"snnumber", "bar_copy"});
    }

    private void SetQtyEnable() {
        int size = this.getModel().getEntryEntity("billentry").size();
        for (int index = 0; index < size; ++index) {
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"qty"});
        }
    }

    private void handleQtyChangeEvent(int rowIndex) {
        this.calAmonutByQtyChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handleQtyunit2ndChangeEvent(int rowIndex) {
        this.calAmonutByQtyChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handleAmountChangeEvent(int rowIndex) {
        this.calPriceByAmountChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    private void handlePriceChangeEvent(int rowIndex) {
        this.calAmonutByPriceChange(rowIndex, "price", "qty", "amount", "settlecurrency");
    }

    protected void setDefCoustomer() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            if (this.isPushOrDraw(i)) continue;
            this.setDefCoustomerByType(i, "ownertype", "owner");
            this.setDefCoustomerByType(i, "outownertype", "outowner");
            this.setDefCoustomerByType(i, "keepertype", "keeper");
            this.setDefCoustomerByType(i, "outkeepertype", "outkeeper");
        }
    }

    protected void setDefCoustomerByType(int row, String type, String basef) {
        if ("bd_customer".equals(this.getModel().getValue(type, row))) {
            this.getModel().setValue(basef, this.getModel().getValue("customer"), row);
        }
    }

    protected void setBizDeptFilter(BeforeF7SelectEvent e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        List depts = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList((Long)org.getPkValue()), (boolean)true);
        if (depts != null && depts.size() > 0) {
            this.setF7IdFilter(e, depts.toArray());
        }
    }

    protected void initCurrency() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = CommonUtils.isNull((Object)org) ? 0L : org.getLong("id");
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (map != null) {
            this.getModel().setValue("settlecurrency", map.get("baseCurrencyID"));
        }
    }

    private void initNewEntryLineType(int rowIndex) {
        ArrayList<Long> bizTypes = new ArrayList<Long>();
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType == null) {
            return;
        }
        Long bizTypeId = (Long)bizType.getPkValue();
        Long lineType = null;
        bizTypes.add(bizTypeId);
        Map lineTypeByBillType = BillTypeMaterialHelper.getLineTypeByBillType(bizTypes);
        if (lineTypeByBillType.size() != 0) {
            LineTypeParam lineTypeParam = (LineTypeParam)lineTypeByBillType.get(bizTypeId);
            lineType = lineTypeParam.getDeafaultLineType();
        }
        this.getModel().beginInit();
        this.getModel().setValue("linetype", (Object)lineType, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("linetype", rowIndex);
    }

    private void initMaterialName(int rowIndex) {
        DynamicObject materialInvInfo = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material != null) {
            String materialName = material.getString("name");
            this.getModel().setValue("materialname", (Object)materialName, rowIndex);
        }
    }
}

