/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.recbill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.algorithm.TaxAlgorithmForForm;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.DefaultTaxRateHelper;
import kd.scmc.im.business.helper.ExchangeRateHelper;
import kd.scmc.im.business.helper.FarmProductsHelper;
import kd.scmc.im.business.helper.InspectionHelper;
import kd.scmc.im.business.helper.InvoiceBizHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.SupplierHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.business.service.InvSchemeService;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;

public class PurReceBillPlugin
extends ImBillEditPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String PROP_INVOICESUPPLIER = "invoicesupplierid";
    private static final String PROP_RECEIVINGSUPPLIER = "receivingsupplierid";
    private static final String PROP_DELIVERSUPPLIER = "deliversupplierid";
    private static final String PROP_SETTLEMENTCY = "settlementcyid";
    private static final String PROP_SETTLEMENTTYPE = "settlementtypeid";
    private static final String PROP_PAYCOND = "paycond";
    private static final String PROP_ENTRY_LINKMAN = "entry_linkman";
    private static final String PROP_ISDEFAULT_LINKMAN = "isdefault_linkman";
    private static final String PROP_SUPPLIERID = "supplierid";
    public static final String BTN_CHANGESUPPLIER = "changesupplier";
    public static final String BTN_ADDSUPPLIER = "addsupplier";
    public static final String LAB_ADDSUPPLIER = "addlb";
    public static final String TXT_ADDSUPPLIER = "addsupplierlb";
    public static final String PURBILLENRTYID = "purbillentryid";
    public static final String PURORDERBILLNUMBER = "purorderbillnumber";
    private static final String PURREC_BILLTYPE_NUMBER = "im_purreceivebill_STD_BT_S";
    private static final String IM_PURRECEIVEBILL_WW_BT_S = "im_purreceivebill_WW_BT_S";
    private static final Long DEFAULT_INVOICE_BIZ = 1533341968170710016L;
    private TaxAlgorithmForForm algo = null;

    protected TaxAlgorithmForForm getAlgorithm() {
        if (this.algo == null) {
            this.algo = new TaxAlgorithmForForm(this.getView());
        }
        return this.algo;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"providersupplier", "receivesupplier", "invoicesupplier", "providerlinkman", BTN_ADDSUPPLIER, BTN_CHANGESUPPLIER, LAB_ADDSUPPLIER, TXT_ADDSUPPLIER, "bizoperatorgroup", "bizoperator", "bizdept", "entrysettleorg", "owner", "outowner", "keeper", "outkeeper", "entrysettleorg", "supplier", "taxrateid", "invoicebiztype"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initNewData();
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.initOwnerAndKeep(i);
            this.initNewDataEntry(this.getView(), i);
        }
        this.handleProductTypeVisible();
        boolean fromWebApi = ((BillModel)this.getModel()).isFromWebApi();
        if (!fromWebApi) {
            this.getModel().setValue("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
        }
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.handleProductTypeVisible();
    }

    @Override
    protected void setEntryRow(IFormView view, int rowIndex) {
        this.setEntryEnable(view, rowIndex, false, "acceptancedate", "qualifiedqty", "unqualifiedqty", "qualifiedunit2nd", "unqualifiedunit2nd", "unqualifiedbaseqty", "qualifiedbaseqty");
        Boolean isInspect = (Boolean)this.getModel().getValue("isinspect", rowIndex);
        this.getView().setEnable(isInspect, rowIndex, new String[]{"emrelease"});
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        this.handleProductTypeVisible();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            this.initCurrencyAndExrateTable((Long)org.getPkValue());
        }
        Date bizDate = (Date)this.getModel().getValue("biztime");
        model.setValue("exratedate", (Object)bizDate);
        Map exchangeRateMap = ExchangeRateHelper.getExRateMap((Object)this.getModel().getValue("currency"), (Object)this.getModel().getValue("settlecurrency"), (Object)this.getModel().getValue("exratetable"), (Date)bizDate);
        if (exchangeRateMap != null) {
            Object quoteType = exchangeRateMap.get("quoteType");
            Object exchangeRate = exchangeRateMap.get("exchangeRate");
            if (quoteType != null) {
                this.getModel().setValue("quotation", (Object)((Boolean)quoteType != false ? "1" : "0"));
            }
            this.getModel().setValue("exchangerate", exchangeRate);
        }
        this.checkExchangeRate(true, exchangeRateMap == null ? null : exchangeRateMap.get("exchangeRate"));
        this.getAlgorithm().calByChange("exchangerate");
        model.setValue("ischargeoff", (Object)Boolean.FALSE);
        model.setValue("ischargeoffed", (Object)Boolean.FALSE);
        String appId = this.getView().getFormShowParameter().getAppId();
        DynamicObject bill = model.getDataEntity();
        InvoiceBizHelper.handleInvoiceBizNull((DynamicObject)bill, (String)appId);
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        boolean isTax = (Boolean)this.getModel().getValue("istax");
        IFormView view = this.getView();
        DynamicObject supplier = this.getModel().getValue("supplier") == null ? null : (DynamicObject)this.getModel().getValue("supplier");
        ILocaleString providerAddress = SupplierHelper.getValidDefaultMultilingualAddress(supplier);
        DynamicObject linkman = SupplierHelper.getDefaultLinkMan((DynamicObject)supplier);
        if ("billentry".equals(entryName)) {
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.initPriceField(isTax, false, rowIndex);
                this.initNewEntry(rowIndex);
                this.setEntryRow(view, rowIndex);
                this.getModel().setValue("provideraddress", (Object)providerAddress, rowIndex);
                this.getModel().setValue("providerlinkman", (Object)linkman, rowIndex);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            if ("supplier".equals(propName)) {
                this.changeSupplier(newValue);
                this.setOwnerAndKeeperBySupplier();
                this.markIsInspectByBill();
            } else if ("providersupplier".equals(propName)) {
                DynamicObject providerSupplier = (DynamicObject)newValue;
                this.changeProviderSupplier(providerSupplier, rowIndex);
            } else if ("istax".equals(propName)) {
                this.changeIsTax(newValue);
            } else if ("ispresent".equals(propName)) {
                this.changeIsPresent(newValue, rowIndex);
            } else if ("priceandtax".equals(propName) || "price".equals(propName)) {
                this.setByIspresent(newValue, (Boolean)this.getModel().getValue("ispresent", rowIndex), rowIndex);
            } else if ("actualprice".equals(propName)) {
                this.changeActualPrice(rowIndex, newValue, oldValue);
            } else if ("actualtaxprice".equals(propName)) {
                this.changeActualTaxPrice(oldValue, newValue, rowIndex);
            } else if ("discounttype".equals(propName)) {
                this.changeDiscountType(newValue, rowIndex);
            } else if ("discountrate".equals(propName)) {
                this.changeDisCountRate(propName, oldValue, rowIndex);
            } else if ("discountamount".equals(propName)) {
                BigDecimal discountAmount = (BigDecimal)newValue;
                this.changeDiscountAmount(propName, oldValue, discountAmount, rowIndex);
            } else if ("taxrateid".equals(propName)) {
                if (null != newValue) {
                    DynamicObject taxRateID = (DynamicObject)newValue;
                    this.changeTaxRateID(taxRateID, rowIndex);
                } else {
                    IDataModel model = this.getModel();
                    model.setValue("taxrate", (Object)0, rowIndex);
                }
            } else if ("taxamount".equals(propName)) {
                this.changeTaxMount(oldValue, rowIndex);
            } else if ("exchangerate".equals(propName)) {
                this.changeExChangeRate(propName, oldValue, newValue);
            } else if ("bizoperator".equals(propName)) {
                if (null != newValue) {
                    DynamicObject bizOperator = (DynamicObject)newValue;
                    this.changeBizOperator(bizOperator);
                } else {
                    this.getModel().setValue("bizoperatorgroup", null);
                }
            } else if ("bizoperatorgroup".equals(propName)) {
                DynamicObject bizGrp = (DynamicObject)newValue;
                this.changeBizOperatorGroup(bizGrp);
            } else if ("bizorg".equals(propName)) {
                DynamicObject bizOrg = (DynamicObject)newValue;
                this.changeBizOrg(newValue);
                this.change4BizOrg(bizOrg);
            } else if ("entryreqorg".equals(propName)) {
                this.setDefaltOwnerAndKeeper(rowIndex);
                this.getModel().setValue("insporg", (Object)InspectionHelper.getInspOrg((DynamicObject)((DynamicObject)newValue)));
            } else if ("entrysettleorg".equals(propName)) {
                this.setDefaltOwnerAndKeeper(rowIndex);
            } else if ("ownertype".equals(propName) || "keepertype".equals(propName) || "outkeepertype".equals(propName)) {
                this.setDefaltOwnerAndKeeper(rowIndex);
            } else if ("qty".equals(propName) || "qtyunit2nd".equals(propName)) {
                this.setQualifiedQty(rowIndex);
            } else if ("qualifiedqty".equals(propName) || "unqualifiedqty".equals(propName) || "qualifiedbaseqty".equals(propName) || "unqualifiedbaseqty".equals(propName) || "qualifiedunit2nd".equals(propName) || "unqualifiedunit2nd".equals(propName)) {
                BigDecimal curQty = (BigDecimal)newValue;
                this.calculateQualifiedQty(propName, curQty, rowIndex);
            } else if ("biztime".equals(propName)) {
                this.changeBizTime(this.getModel());
            } else if ("isinspect".equals(propName)) {
                this.changeIsInspect((Boolean)newValue, rowIndex);
            } else if ("insporg".equals(propName)) {
                this.markIsInspectByInspOrg((DynamicObject)newValue, rowIndex);
            } else if ("material".equals(propName)) {
                this.markIsInspectByMaterial((DynamicObject)newValue, rowIndex);
                DefaultTaxRateHelper.changeMaterial((IDataModel)this.getModel(), (String)"supplier", (DynamicObject)((DynamicObject)newValue), (int)rowIndex);
            } else if ("currency".equals(propName) || "settlecurrency".equals(propName) || "exratetable".equals(propName) || "exratedate".equals(propName)) {
                this.checkExchangeRate(false, null);
            }
            if ("settlecurrency".equals(propName)) {
                this.changeSettleCurrency(oldValue, newValue);
            }
            this.getAlgorithm().calByChange(e);
        }
    }

    private void changeBizTime(IDataModel model) {
        int rowCount = model.getEntryRowCount("billentry");
        Date bizTime = (Date)model.getValue("biztime");
        if (rowCount > 0) {
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("billentry");
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                boolean needClear;
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                DynamicObject taxrate = dynamicObject.getDynamicObject("taxrateid");
                if (taxrate == null) continue;
                Date activedate = taxrate.getDate("activedate");
                Date expdate = taxrate.getDate("expdate");
                boolean bl = needClear = bizTime == null || bizTime.before(activedate) || expdate != null && bizTime.after(expdate);
                if (!needClear) continue;
                this.setValue("taxrateid", null, i, false);
                this.changeTaxRateID(null, i);
            }
        }
    }

    private void setQualifiedQty(int rowIndex) {
        IDataModel bill = this.getModel();
        bill.beginInit();
        bill.setValue("qualifiedqty", bill.getValue("qty", rowIndex), rowIndex);
        bill.setValue("qualifiedbaseqty", bill.getValue("baseqty", rowIndex), rowIndex);
        bill.setValue("qualifiedunit2nd", bill.getValue("qtyunit2nd", rowIndex), rowIndex);
        bill.endInit();
    }

    private void calculateQualifiedQty(String propName, BigDecimal curQty, int rowIndex) {
        IDataModel bill = this.getModel();
        BigDecimal baseQty = (BigDecimal)bill.getValue("baseqty", rowIndex);
        BigDecimal qty = (BigDecimal)bill.getValue("qty", rowIndex);
        BigDecimal qtyunit2nd = (BigDecimal)bill.getValue("qtyunit2nd", rowIndex);
        bill.beginInit();
        if ("qualifiedqty".equals(propName)) {
            if (curQty.compareTo(qty) > 0) {
                curQty = BigDecimal.ZERO;
                bill.setValue(propName, (Object)curQty, rowIndex);
                this.getView().updateView(propName, rowIndex);
            }
            bill.setValue("unqualifiedqty", (Object)qty.subtract(curQty), rowIndex);
            this.getView().updateView("unqualifiedqty", rowIndex);
        } else if ("unqualifiedqty".equals(propName)) {
            if (curQty.compareTo(qty) > 0) {
                curQty = BigDecimal.ZERO;
                bill.setValue(propName, (Object)curQty, rowIndex);
                this.getView().updateView(propName, rowIndex);
            }
            bill.setValue("qualifiedqty", (Object)qty.subtract(curQty), rowIndex);
            this.getView().updateView("qualifiedqty", rowIndex);
        } else if ("qualifiedbaseqty".equals(propName)) {
            if (curQty.compareTo(baseQty) > 0) {
                curQty = BigDecimal.ZERO;
                bill.setValue(propName, (Object)curQty, rowIndex);
                this.getView().updateView(propName, rowIndex);
            }
            bill.setValue("unqualifiedbaseqty", (Object)baseQty.subtract(curQty), rowIndex);
            this.getView().updateView("unqualifiedbaseqty", rowIndex);
        } else if ("unqualifiedbaseqty".equals(propName)) {
            if (curQty.compareTo(baseQty) > 0) {
                curQty = BigDecimal.ZERO;
                bill.setValue(propName, (Object)curQty, rowIndex);
                this.getView().updateView(propName, rowIndex);
            }
            bill.setValue("qualifiedbaseqty", (Object)baseQty.subtract(curQty), rowIndex);
            this.getView().updateView("qualifiedbaseqty", rowIndex);
        } else if ("qualifiedunit2nd".equals(propName)) {
            if (qtyunit2nd.compareTo(BigDecimal.ZERO) == 0) {
                bill.setValue("qualifiedunit2nd", (Object)BigDecimal.ZERO, rowIndex);
                bill.setValue("unqualifiedunit2nd", (Object)BigDecimal.ZERO, rowIndex);
                this.getView().updateView("qualifiedunit2nd", rowIndex);
                this.getView().updateView("unqualifiedunit2nd", rowIndex);
            } else {
                if (curQty.compareTo(qtyunit2nd) > 0) {
                    curQty = BigDecimal.ZERO;
                    bill.setValue(propName, (Object)curQty, rowIndex);
                    this.getView().updateView(propName, rowIndex);
                }
                bill.setValue("unqualifiedunit2nd", (Object)qtyunit2nd.subtract(curQty), rowIndex);
                this.getView().updateView("unqualifiedunit2nd", rowIndex);
            }
        } else if ("unqualifiedunit2nd".equals(propName)) {
            if (qtyunit2nd.compareTo(BigDecimal.ZERO) == 0) {
                bill.setValue("qualifiedunit2nd", (Object)BigDecimal.ZERO, rowIndex);
                bill.setValue("unqualifiedunit2nd", (Object)BigDecimal.ZERO, rowIndex);
                this.getView().updateView("qualifiedunit2nd", rowIndex);
                this.getView().updateView("unqualifiedunit2nd", rowIndex);
            } else {
                if (curQty.compareTo(qtyunit2nd) > 0) {
                    curQty = BigDecimal.ZERO;
                    bill.setValue(propName, (Object)curQty, rowIndex);
                    this.getView().updateView(propName, rowIndex);
                }
                bill.setValue("qualifiedunit2nd", (Object)qtyunit2nd.subtract(curQty), rowIndex);
                this.getView().updateView("qualifiedunit2nd", rowIndex);
            }
        }
        bill.endInit();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String btnKey = op.getOperateKey();
        if ("confirmacceptance".equals(btnKey) || "cancelacceptance".equals(btnKey)) {
            String entryIds = this.getSelectEntryID();
            if (entryIds.length() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u6570\u636e\u3002", (String)"PurReceBillPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            ((AbstractOperate)e.getSource()).getOption().setVariableValue("entrySelectIds", entryIds);
        }
    }

    private String getSelectEntryID() {
        StringBuilder selectEntryIds = new StringBuilder();
        EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
        int[] index = entryGrid.getSelectRows();
        for (int i = 0; i < index.length; ++i) {
            int rowIndex = index[i];
            String id = this.getModel().getEntryRowEntity("billentry", rowIndex).get("id").toString();
            if (id == null || id.length() <= 1) continue;
            selectEntryIds.append(id).append('$');
        }
        return selectEntryIds.toString();
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate key = (FormOperate)e.getSource();
        switch (key.getOperateKey()) {
            case "acceptance": {
                this.doAcceptance();
                break;
            }
            case "cancelacceptance": 
            case "confirmacceptance": {
                this.handleEntryEnable();
                break;
            }
        }
    }

    @Override
    protected void handleEntryEnable() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.setEntryRow(view, i);
        }
    }

    private void doAcceptance() {
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObjectCollection billentry = entity.getDynamicObjectCollection("billentry");
        int entrySize = billentry.size();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.beginInit();
        Date now = new Date();
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("acceptancedate");
        fields.add("qualifiedqty");
        fields.add("unqualifiedqty");
        fields.add("qualifiedbaseqty");
        fields.add("unqualifiedbaseqty");
        ArrayList<String> fieldUnit2nds = new ArrayList<String>();
        fieldUnit2nds.add("qualifiedunit2nd");
        fieldUnit2nds.add("unqualifiedunit2nd");
        InvBillErrorCode invBillErrorCode = new InvBillErrorCode();
        for (int i = 0; i < entrySize; ++i) {
            model.setValue("acceptancedate", (Object)now, i);
            String field = (String)fields.get(i);
            view.setEnable(Boolean.TRUE, new String[]{field});
            view.updateView("acceptancedate", i);
            DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", i);
            DynamicObject material = materialInvInfo.getDynamicObject("masterid");
            if (material == null) {
                ErrorCode errorCode = invBillErrorCode.getERROR_MATERIAL_INV();
                throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)errorCode));
            }
            DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
            Boolean isUseAuxptyUnit = auxptyUnit != null;
            if (!isUseAuxptyUnit.booleanValue()) continue;
            String fieldUnit2nd = (String)fieldUnit2nds.get(i);
            view.setEnable(Boolean.TRUE, new String[]{fieldUnit2nd});
        }
        model.endInit();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleProductTypeVisible();
        this.handleEntryEnable();
        IDataModel model = this.getModel();
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        if (currency != null && settleCurrency != null && currency.getPkValue().equals(settleCurrency.getPkValue())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"exchangerate"});
        }
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        this.setClientViewScale();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel bill = this.getModel();
        DynamicObject bizOrg = (DynamicObject)bill.getValue("bizorg");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        switch (fieldKey) {
            case "material": {
                FarmProductsHelper.materialSelect((IDataModel)this.getModel(), (ListShowParameter)showParameter);
                this.handleOutSourceFilter(showParameter, bill);
                break;
            }
            case "supplier": {
                this.supplierSelect(e);
                break;
            }
            case "bizoperatorgroup": {
                this.bizOperatorGroupSelect(e, bizOrg, showParameter);
                break;
            }
            case "bizoperator": {
                this.bizOperatorSelect(e, bizOrg, showParameter);
                break;
            }
            case "bizdept": {
                this.bizDeptSelect(e, bizOrg, showParameter);
                break;
            }
            case "providersupplier": 
            case "invoicesupplier": 
            case "receivesupplier": {
                this.supplierInfoSelect(e, fieldKey);
                break;
            }
            case "providerlinkman": {
                this.providerLinkmanSelect(e, rowIndex, showParameter);
                break;
            }
            case "owner": {
                this.ownerSelect(e);
                break;
            }
            case "keeper": {
                this.keeperSelect(rowIndex, showParameter);
                break;
            }
            case "outkeeper": {
                this.outKeeperSelect(rowIndex, showParameter);
                break;
            }
            case "taxrateid": {
                this.taxrateSelect(e, showParameter);
                break;
            }
            case "invoicebiztype": {
                InvoiceBizHelper.invoiceBizSelect((IFormView)this.getView(), (ListShowParameter)showParameter);
                break;
            }
        }
    }

    private void handleOutSourceFilter(ListShowParameter showParameter, IDataModel bill) {
        String billNumber;
        DynamicObject billType = bill.getDataEntity().getDynamicObject("billtype");
        if (billType != null && IM_PURRECEIVEBILL_WW_BT_S.equals(billNumber = billType.getString("number"))) {
            QFilter qFilter = new QFilter("masterid.enableoutsource", "=", (Object)Boolean.TRUE);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void supplierSelect(BeforeF7SelectEvent e) {
        this.addVMISelect(e);
        this.addBizFunctionFilter(e, "supplier");
    }

    private void addVMISelect(BeforeF7SelectEvent e) {
        String domain;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && "6".equals(domain = bizType.getString("domain"))) {
            QFilter q = new QFilter("enablevmi", "=", (Object)"1");
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)q);
        }
    }

    private void initNewData() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            this.initCurrencyAndExrateTable((Long)org.getPkValue());
        }
        Date bizDate = (Date)this.getModel().getValue("biztime");
        this.getModel().setValue("exratedate", (Object)bizDate);
    }

    private void initCurrencyAndExrateTable(Long bizOrg) {
        if (bizOrg != 0L) {
            DynamicObject exRateTable;
            IDataModel model = this.getModel();
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)bizOrg);
            if (map == null) {
                return;
            }
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            if (currency == null) {
                model.setValue("currency", map.get("baseCurrencyID"));
            }
            if ((exRateTable = (DynamicObject)model.getValue("exratetable")) == null) {
                model.setValue("exratetable", map.get("exchangeRateTableID"));
            }
        }
    }

    private void initOwnerAndKeep(int rowIndex) {
        String keepType;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        String ownerType = (String)model.getValue("ownertype", rowIndex);
        if ("bd_supplier".equals(ownerType)) {
            DynamicObject supplier = (DynamicObject)model.getValue("supplier");
            model.setValue("owner", supplier == null ? null : supplier.getPkValue(), rowIndex);
        }
        if ("bos_org".equals(keepType = (String)model.getValue("keepertype", rowIndex))) {
            model.setValue("keeper", org == null ? null : org.getPkValue(), rowIndex);
        }
    }

    private void handleProductTypeVisible() {
        IDataModel model = this.getModel();
        DynamicObject billType = model.getDataEntity().getDynamicObject("billtype");
        if (billType != null) {
            String billNumber = billType.getString("number");
            if (PURREC_BILLTYPE_NUMBER.equals(billNumber)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"producttype"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"producttype"});
            }
        }
    }

    private void changeBizOrg(Object newValue) {
        if (newValue instanceof DynamicObject) {
            DynamicObject bizOrg = (DynamicObject)newValue;
            Long bizOrgId = (Long)bizOrg.getPkValue();
            this.initCurrencyAndExrateTable(bizOrgId);
            this.changeBizDept(bizOrgId);
            this.getModel().setValue("bizoperator", null);
            this.getModel().setValue("bizoperatorgroup", null);
        }
    }

    private void changeBizDept(Long orgId) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && deptIds.size() > 0) {
            this.getModel().setValue("bizdept", deptIds.get(0));
        }
        if ((deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true)) != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
            this.getModel().setValue("bizdept", (Object)orgId);
            return;
        }
        this.getModel().setValue("bizdept", null);
    }

    private void bizOperatorGroupSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\u3002", (String)"PurReceBillPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        DynamicObject bizoperator = (DynamicObject)this.getModel().getValue("bizoperator");
        if (bizoperator == null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0));
        } else {
            bizoperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizoperator.getPkValue(), (String)"bd_operator");
            QFilter qFilter01 = new QFilter("operatorid", "=", bizoperator.getDynamicObject("operatorid").getPkValue());
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter01});
            if (map.size() != 0) {
                ArrayList list = new ArrayList(map.values());
                ArrayList<Long> groupList = new ArrayList<Long>();
                for (int i = 0; i < list.size(); ++i) {
                    groupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", groupList));
            }
        }
    }

    private void bizOperatorSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
        QFilter enableFilter;
        long bizOrgId;
        QFilter operatorGroupIdFilter;
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\u3002", (String)"PurReceBillPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        BasedataEdit control = (BasedataEdit)this.getControl("bizoperatorgroup");
        BasedataProp property = (BasedataProp)control.getProperty();
        FilterBuilder buildCoreFilter = property.buildCoreFilter(this.getModel());
        QFilter filterGridFilter = buildCoreFilter.getQFilter();
        Map currentBizOrgBizOperatorGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{filterGridFilter, operatorGroupIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)(bizOrgId = Long.parseLong(bizOrg.getPkValue().toString()))), enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (currentBizOrgBizOperatorGroup != null && !currentBizOrgBizOperatorGroup.isEmpty()) {
            HashSet keySet = new HashSet(currentBizOrgBizOperatorGroup.keySet());
            QFilter qFilter = new QFilter("operatorgrpid", "in", new ArrayList(keySet));
            QFilter qFilter1 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter, qFilter1));
        } else {
            showParameter.getListFilterParameter().setFilter(new QFilter("operatorgrpid", "in", null));
        }
    }

    private void bizDeptSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
    }

    private String getBizOrgDisplayName() {
        BasedataEdit bizOrgEdit = (BasedataEdit)this.getControl("bizorg");
        IDataEntityProperty orgProp = bizOrgEdit.getProperty();
        LocaleString displayName = orgProp.getDisplayName();
        return displayName.toString();
    }

    private void changeBizOperatorGroup(DynamicObject bizGrp) {
        if (bizGrp == null) {
            this.getModel().setValue("bizoperator", null);
            return;
        }
    }

    private void changeBizOperator(DynamicObject bizOperator) {
        if (bizOperator != null) {
            bizOperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizOperator.getPkValue(), (String)"bd_operator");
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", bizOperator.get("operatorgrpid"));
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
            if (bizOrg == null) {
                return;
            }
            List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)((Long)bizOrg.getPkValue()), (boolean)true);
            if (deptids != null && deptids.size() > 0) {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    for (Long deptId : userdeptIds) {
                        if (!deptids.contains(deptId)) continue;
                        this.getModel().beginInit();
                        this.getModel().setValue("bizdept", (Object)deptId);
                        this.getModel().endInit();
                        this.getView().updateView("bizdept");
                        break;
                    }
                }
            } else {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    this.getModel().beginInit();
                    this.getModel().setValue("bizdept", userdeptIds.get(0));
                    this.getModel().endInit();
                    this.getView().updateView("bizdept");
                }
            }
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", null);
            this.getModel().setValue("bizdept", null);
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            this.getView().updateView("bizdept");
        }
    }

    protected void initPriceField(boolean isTax, boolean inputAmount, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)model.getValue("ispresent", rowIndex);
        view.setEnable(Boolean.valueOf(!isPresent), rowIndex, new String[]{"taxrateid"});
        view.setEnable(Boolean.valueOf(!isPresent && !this.isDrawByBOTP()), rowIndex, new String[]{"discounttype"});
        boolean isDiscount = DiscountTypeEnum.NULL.getValue().equals(model.getValue("discounttype", rowIndex));
        view.setEnable(Boolean.valueOf(!isDiscount && !isPresent), rowIndex, new String[]{"discountrate"});
        view.setEnable(Boolean.valueOf(!isDiscount && !isPresent), rowIndex, new String[]{"discountamount"});
        boolean isEnable = !isPresent && !isTax;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"actualprice"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amount"});
        isEnable = !isPresent && isTax;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"actualtaxprice"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amountandtax"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"taxamount"});
        this.setPriceEnable(isPresent, isTax, rowIndex);
    }

    private void changeExChangeRate(String propName, Object oldValue, Object newValue) {
    }

    private void changeSupplier(Object newValue) {
        DynamicObject supplier = (DynamicObject)newValue;
        DynamicObject invoiceSupplier = null;
        DynamicObject receivingSupplier = null;
        DynamicObject settlementCy = null;
        DynamicObject settlementType = null;
        DynamicObject payCond = null;
        IDataModel bill = this.getModel();
        int size = bill.getEntryEntity("billentry").size();
        if (supplier == null) {
            bill.setValue("paycondition", null);
            bill.setValue("settletype", null);
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                bill.setValue("invoicesupplier", null, rowIndex);
                bill.setValue("receivesupplier", null, rowIndex);
                bill.setValue("providersupplier", null, rowIndex);
                bill.setValue("provideraddress", null, rowIndex);
                bill.setValue("providerlinkman", null, rowIndex);
            }
            return;
        }
        invoiceSupplier = supplier.getDynamicObject(PROP_INVOICESUPPLIER);
        receivingSupplier = supplier.getDynamicObject(PROP_RECEIVINGSUPPLIER);
        settlementCy = supplier.getDynamicObject(PROP_SETTLEMENTCY);
        settlementType = supplier.getDynamicObject(PROP_SETTLEMENTTYPE);
        payCond = supplier.getDynamicObject(PROP_PAYCOND);
        if (MetaDataHelper.isExistField((IDataModel)bill, (String)"paycondition")) {
            bill.setValue("paycondition", payCond == null ? null : payCond.getPkValue());
        }
        if (MetaDataHelper.isExistField((IDataModel)bill, (String)"settletype")) {
            bill.setValue("settletype", settlementType == null ? null : settlementType.getPkValue());
        }
        if (MetaDataHelper.isExistField((IDataModel)bill, (String)"settlecurrency")) {
            if (settlementCy != null) {
                bill.setValue("settlecurrency", settlementCy.getPkValue());
            } else {
                DynamicObject currency = (DynamicObject)bill.getValue("currency");
                bill.setValue("settlecurrency", currency == null ? null : currency.getPkValue());
            }
        }
        DynamicObject invoiceType = (DynamicObject)supplier.get("invoicecategory");
        String appId = this.getView().getFormShowParameter().getAppId();
        if (invoiceType != null && appId != null) {
            Long invoiceTypeId = invoiceType.getLong("id");
            DynamicObject invoiceBizType = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"CommonHelperService", (String)"getInvoiceBizType", (Object[])new Object[]{invoiceTypeId, appId});
            if (invoiceBizType != null) {
                bill.setValue("invoicebiztype", (Object)invoiceBizType);
            } else {
                bill.setValue("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
            }
        } else {
            bill.setValue("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
        }
        Object bizFunction = supplier.get("bizfunction");
        String bizFunctionStr = bizFunction == null ? "" : bizFunction.toString();
        ILocaleString providerAddress = SupplierHelper.getValidDefaultMultilingualAddress((DynamicObject)supplier);
        DynamicObject linkman = SupplierHelper.getDefaultLinkMan((DynamicObject)supplier);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            bill.setValue("invoicesupplier", invoiceSupplier == null ? (bizFunctionStr.contains("2") ? supplier.getPkValue() : null) : invoiceSupplier.getPkValue(), rowIndex);
            bill.setValue("receivesupplier", receivingSupplier == null ? (bizFunctionStr.contains("3") ? supplier.getPkValue() : null) : receivingSupplier.getPkValue(), rowIndex);
            bill.setValue("providersupplier", bizFunctionStr.contains("1") ? supplier.getPkValue() : null, rowIndex);
            bill.setValue("provideraddress", (Object)providerAddress, rowIndex);
            bill.setValue("providerlinkman", (Object)linkman, rowIndex);
        }
    }

    private void changeProviderSupplier(DynamicObject providerSupplier, int rowIndex) {
    }

    private void changeIsTax(Object newValue) {
        if (newValue instanceof Boolean) {
            boolean isTax = (Boolean)newValue;
            IDataModel model = this.getModel();
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            int discountRateScale = this.getDiscountRateScale();
            for (int i = 0; i < entryRowCount; ++i) {
                this.initPriceField(isTax, false, i);
                this.checkAndSetDiscountRate(isTax, model, discountRateScale, i);
            }
        }
    }

    @Override
    protected void setBillEntryEnable(RowDataEntity entry) {
        super.setBillEntryEnable(entry);
        DynamicObject bill = this.getBill();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int index = entry.getRowIndex();
        boolean isTax = bill.getBoolean("istax");
        this.initPriceField(isTax, false, index);
        String discountType = (String)model.getValue("discounttype", index);
        if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            view.setEnable(Boolean.FALSE, index, new String[]{"discountrate"});
            view.setEnable(Boolean.FALSE, index, new String[]{"discountamount"});
        }
        Boolean isInspect = (Boolean)this.getModel().getValue("isinspect", index);
        this.getView().setEnable(isInspect, index, new String[]{"emrelease"});
    }

    @Override
    protected void setEnable4IsDraw(boolean isDraw) {
        super.setEnable4IsDraw(isDraw);
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(!isDraw), new String[]{"billtype", "bizorg", "settlecurrency", "exratetable", "transactepath", "supplier"});
    }

    @Override
    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        IFormView view = this.getView();
        int index = row.getRowIndex();
        if (isDraw) {
            view.setEnable(Boolean.FALSE, index, new String[]{"entrysettleorg", "ownertype", "taxrate", "discounttype", "discountrate", "discountamount", "producttype", "providersupplier"});
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)newValue;
        boolean isTax = (Boolean)model.getValue("istax");
        this.initPriceField(isTax, false, rowIndex);
        Object price = this.getModel().getValue("price", rowIndex);
        this.presentChange(price, isPresent, rowIndex);
    }

    protected void changeActualPrice(int rowIndex, Object newValue, Object oldValue) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal actualPrice = (BigDecimal)newValue;
        if (price != null && actualPrice != null && price.compareTo(actualPrice) < 0) {
            model.setValue("actualprice", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5355\u4ef7\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurReceBillPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setDefaultDiscountType(rowIndex);
    }

    private void setDefaultDiscountType(int i) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String discountType = (String)model.getValue("discounttype", i);
        if (StringUtils.isEmpty((String)discountType) || DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            model.beginInit();
            model.setValue("discounttype", (Object)DiscountTypeEnum.UNITDIS.getValue(), i);
            model.endInit();
            BillViewHelper.updateViewField((IFormView)this.getView(), (int)i, (String)"discounttype", (String[])new String[0]);
            view.setEnable(Boolean.TRUE, i, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, i, new String[]{"discountamount"});
        }
    }

    protected void changeActualTaxPrice(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal actualPrice = (BigDecimal)newValue;
        if (price != null && actualPrice != null && price.compareTo(actualPrice) < 0) {
            model.setValue("actualtaxprice", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurReceBillPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setDefaultDiscountType(rowIndex);
    }

    private void changeDiscountType(Object newValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        model.setValue("discountrate", null, rowIndex);
        model.setValue("discountamount", null, rowIndex);
        if (DiscountTypeEnum.NULL.getValue().equals(newValue)) {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountamount"});
        } else {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountamount"});
        }
    }

    private void changeDisCountRate(String fieldName, Object oldValue, int rowIndex) {
        DynamicObject settleCurrency;
        IDataModel model = this.getModel();
        int discountRateScale = 4;
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate == null) {
            discountRate = BigDecimal.ZERO;
        }
        if ((settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency")) != null) {
            discountRateScale = settleCurrency.getInt("priceprecision");
        }
        if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            discountRate = discountRate.setScale(discountRateScale, 4);
            model.setValue("discountrate", (Object)discountRate, rowIndex);
            if (discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) > 0) {
                model.setValue(fieldName, oldValue, rowIndex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e100%\u3002", (String)"PurReceBillPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else if (discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) == 0) {
                model.setValue("ispresent", (Object)true, rowIndex);
            }
        } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            boolean isTax = (Boolean)model.getValue("istax");
            BigDecimal amount = discountRate;
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                if (amount.compareTo(priceAndTax) > 0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurReceBillPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                if (amount.compareTo(price) > 0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurReceBillPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            model.setValue("discountrate", (Object)discountRate.doubleValue(), rowIndex);
        }
    }

    private void changeTaxMount(Object oldValue, int rowIndex) {
        boolean taxAmountCheck;
        IDataModel model = this.getModel();
        BigDecimal amountAndTax = (BigDecimal)model.getValue("amountandtax", rowIndex);
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
        boolean bl = taxAmountCheck = taxAmount.compareTo(amountAndTax) > 0 || taxAmount.compareTo(BigDecimal.ZERO) < 0;
        if (taxAmountCheck) {
            model.setValue("taxamount", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u4e14\u4e0d\u80fd\u5927\u4e8e\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"PurInBillEditPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void changeDiscountAmount(String fieldName, Object oldValue, BigDecimal discountAmount, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal priceAndPrice = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        int amountPrecision = 2;
        DynamicObject currency = (DynamicObject)model.getValue("settlecurrency");
        if (currency != null) {
            amountPrecision = currency.getInt("amtprecision");
        }
        BigDecimal amoutAndTax = BigDecimal.ZERO;
        amoutAndTax = isTax ? qty.multiply(priceAndPrice).setScale(amountPrecision, RoundingMode.HALF_UP) : qty.multiply(price).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimalConstants.ONEHUNDRED))).setScale(amountPrecision, RoundingMode.HALF_UP);
        if (discountAmount.compareTo(amoutAndTax) > 0 || discountAmount.compareTo(BigDecimal.ZERO) < 0) {
            model.setValue("discountamount", oldValue, rowIndex);
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_UNITDISAMOUNT()));
            return;
        }
    }

    private void changeTaxRateID(DynamicObject taxRateID, int rowIndex) {
        if (taxRateID == null) {
            this.getModel().setValue("taxrate", (Object)0, rowIndex);
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
    }

    private void change4BizOrg(DynamicObject bizOrg) {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        if (bizOrg != null) {
            for (int i = 0; i < entryRowCount; ++i) {
                this.setDefaltOwnerAndKeeper(i);
            }
        }
    }

    private void setDefaltOwnerAndKeeper(int rowIndex) {
        this.setOwner(rowIndex);
        this.setKeeper(rowIndex);
        this.setOutOwner(rowIndex);
        this.setOutKeeper(rowIndex);
    }

    private void setOwnerAndKeeperBySupplier() {
        int size = this.getModel().getEntryEntity("billentry").size();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            this.setDefaltOwnerAndKeeper(rowIndex);
        }
    }

    private Long setOwner(int rowIndex) {
        Long owner = null;
        IDataModel bill = this.getModel();
        DynamicObject supplier = (DynamicObject)bill.getValue("supplier");
        String outOwnerType = (String)this.getModel().getValue("ownertype", rowIndex);
        if (StringUtils.isEmpty((String)outOwnerType)) {
            bill.setValue("owner", null, rowIndex);
            return null;
        }
        switch (outOwnerType) {
            case "bos_org": {
                InvSchemeService service = this.getInvSchemeService();
                Object defalutOwner = service.getDefalutOwner("bos_org", rowIndex);
                owner = defalutOwner == null ? null : Long.valueOf(defalutOwner.toString());
                break;
            }
            case "bd_customer": {
                DynamicObject ownerDyn = (DynamicObject)bill.getValue("owner", rowIndex);
                if (ownerDyn != null) {
                    owner = (Long)ownerDyn.getPkValue();
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"owner"});
                break;
            }
            case "bd_supplier": {
                if (supplier != null) {
                    owner = (Long)supplier.getPkValue();
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"owner"});
                break;
            }
        }
        bill.setValue("owner", owner, rowIndex);
        return owner;
    }

    private void setOutOwner(int rowIndex) {
        Object outOwner = null;
        IDataModel bill = this.getModel();
        DynamicObject supplier = (DynamicObject)bill.getValue("supplier");
        String outOwnerType = (String)this.getModel().getValue("outownertype", rowIndex);
        if (StringUtils.isEmpty((String)outOwnerType)) {
            bill.setValue("outowner", null, rowIndex);
            return;
        }
        switch (outOwnerType) {
            case "bos_org": {
                InvSchemeService service = this.getInvSchemeService();
                Object defalutOwner = service.getDefalutOutOwner("bos_org", rowIndex);
                outOwner = defalutOwner == null ? null : Long.valueOf(defalutOwner.toString());
                break;
            }
            case "bd_customer": {
                DynamicObject outOwnerDyn = (DynamicObject)bill.getValue("outowner", rowIndex);
                if (outOwnerDyn != null) {
                    outOwner = outOwnerDyn.getPkValue();
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"owner"});
                break;
            }
            case "bd_supplier": {
                if (supplier == null) break;
                outOwner = supplier.getPkValue();
                break;
            }
        }
        bill.setValue("outowner", outOwner, rowIndex);
    }

    private Long setKeeper(int rowIndex) {
        Long keeperId = null;
        IDataModel bill = this.getModel();
        DynamicObject org = (DynamicObject)bill.getValue("org");
        DynamicObject supplier = (DynamicObject)bill.getValue("supplier");
        String keeperType = (String)this.getModel().getValue("keepertype", rowIndex);
        if (StringUtils.isEmpty((String)keeperType)) {
            bill.setValue("keeper", keeperId, rowIndex);
            return keeperId;
        }
        switch (keeperType) {
            case "bos_org": {
                if (org != null) {
                    keeperId = (Long)org.getPkValue();
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keeper"});
                break;
            }
            case "bd_customer": {
                DynamicObject keeper = (DynamicObject)bill.getValue("keeper", rowIndex);
                if (keeper != null) {
                    keeperId = (Long)keeper.getPkValue();
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"keeper"});
                break;
            }
            case "bd_supplier": {
                if (supplier != null) {
                    keeperId = (Long)supplier.getPkValue();
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"keeper"});
                break;
            }
        }
        bill.setValue("keeper", keeperId, rowIndex);
        return keeperId;
    }

    private Long setOutKeeper(int rowIndex) {
        Long outKeeperId = null;
        IDataModel bill = this.getModel();
        DynamicObject supplier = (DynamicObject)bill.getValue("supplier");
        String keeperType = (String)this.getModel().getValue("outkeepertype", rowIndex);
        if (StringUtils.isEmpty((String)keeperType)) {
            bill.setValue("outkeeper", outKeeperId, rowIndex);
            return outKeeperId;
        }
        switch (keeperType) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)bill.getValue("org");
                if (org != null) {
                    outKeeperId = (Long)org.getPkValue();
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"outkeeper"});
                break;
            }
            case "bd_customer": {
                DynamicObject outKeeper = (DynamicObject)bill.getValue("outkeeper", rowIndex);
                if (outKeeper != null) {
                    outKeeperId = (Long)outKeeper.getPkValue();
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"outkeeper"});
                break;
            }
            case "bd_supplier": {
                if (supplier != null) {
                    outKeeperId = (Long)supplier.getPkValue();
                }
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"outkeeper"});
                break;
            }
        }
        bill.setValue("outkeeper", outKeeperId, rowIndex);
        return outKeeperId;
    }

    private void initNewEntry(int rowIndex) {
        IDataModel bill = this.getModel();
        DynamicObject bizorg = (DynamicObject)bill.getValue("bizorg");
        if (bizorg != null) {
            bill.setValue("bizorg", (Object)bizorg, rowIndex);
            this.setDefaltOwnerAndKeeper(rowIndex);
        }
        this.setDefaultSupplierInfo(rowIndex);
        bill.setValue(PURORDERBILLNUMBER, null, rowIndex);
        bill.setValue(PURBILLENRTYID, (Object)0, rowIndex);
    }

    private void setDefaultSupplierInfo(int rowIndex) {
        IDataModel bill = this.getModel();
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
        DynamicObject invoiceSupplier = null;
        DynamicObject receivingSupplier = null;
        DynamicObject deliverSupplier = null;
        if (supplier != null) {
            String bizFunction = supplier.get("bizfunction") == null ? "" : supplier.get("bizfunction").toString();
            invoiceSupplier = supplier.getDynamicObject(PROP_INVOICESUPPLIER);
            invoiceSupplier = invoiceSupplier == null ? (bizFunction.contains("2") ? supplier : null) : invoiceSupplier;
            receivingSupplier = supplier.getDynamicObject(PROP_RECEIVINGSUPPLIER);
            receivingSupplier = receivingSupplier == null ? (bizFunction.contains("3") ? supplier : null) : receivingSupplier;
            deliverSupplier = bizFunction.contains("1") ? supplier : null;
        }
        bill.setValue("providersupplier", deliverSupplier == null ? null : deliverSupplier.getPkValue(), rowIndex);
        bill.setValue("invoicesupplier", invoiceSupplier == null ? null : invoiceSupplier.getPkValue(), rowIndex);
        bill.setValue("receivesupplier", receivingSupplier == null ? null : receivingSupplier.getPkValue(), rowIndex);
    }

    private void supplierInfoSelect(BeforeF7SelectEvent e, String propName) {
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
        if (supplier == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_NEWSUPPLIER(), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.addBizFunctionFilter(e, propName);
    }

    private void providerLinkmanSelect(BeforeF7SelectEvent e, int rowIndex, ListShowParameter showParameter) {
        DynamicObject providerSupplier = (DynamicObject)this.getModel().getValue("supplier", rowIndex);
        if (providerSupplier == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_PROVIDERSUPPLIER(), (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter(PROP_SUPPLIERID, "=", providerSupplier.getPkValue()).and("invalid", "=", (Object)false)));
        }
    }

    private void ownerSelect(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        String type = (String)this.getModel().getValue("ownertype", rowIndex);
        if (StringUtils.isEmpty((String)type)) {
            return;
        }
        QFilter f = null;
        switch (type) {
            case "bos_org": {
                break;
            }
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                this.addVMISelect(e);
                break;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    protected void keeperSelect(int rowIndex, ListShowParameter showParameter) {
        QFilter f = null;
        showParameter.getListFilterParameter().setFilter(f);
    }

    protected void outKeeperSelect(int rowIndex, ListShowParameter showParameter) {
        QFilter f = null;
        showParameter.getListFilterParameter().setFilter(f);
    }

    protected void taxrateSelect(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        IDataModel dataModel = this.getModel();
        Object bizTime = dataModel.getValue("biztime");
        if (bizTime == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_BIZTIME()));
            e.setCancel(true);
            return;
        }
        QFilter f = new QFilter("activedate", "<=", bizTime);
        QFilter fExpdate = new QFilter("expdate", ">=", bizTime);
        fExpdate.or(new QFilter("expdate", "is null", null));
        f.and(fExpdate);
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "checkinspection": {
                this.itemClickCheckInspection(evt);
                break;
            }
        }
    }

    private void itemClickCheckInspection(ItemClickEvent evt) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("billentry");
        int[] rows = grid.getSelectRows();
        ArrayList<Long> entryIds = new ArrayList<Long>(rows.length);
        for (int i : rows) {
            Long entryId = this.getModel().getEntryRowEntity("billentry", i).getLong("id");
            entryIds.add(entryId);
        }
        if (entryIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u7269\u6599\u660e\u7ec6\u5206\u5f55\u3002", (String)"plsSelectEntry", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("im_inspectiondetail");
        showParameter.getCustomParams().put("recbillentryid", SerializationUtils.toJsonString(entryIds));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void markIsInspectByBill() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("billentry");
        ArrayList<Integer> list = new ArrayList<Integer>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            list.add(i);
        }
        Map inspParams = InspectionHelper.buildInspectionParams((DynamicObject)this.getBill(true), list);
        this.handleInsp(list, inspParams);
    }

    private void markIsInspectByMaterial(DynamicObject material, int rowIndex) {
        JSONObject inspParam = InspectionHelper.buildInspectionParam((DynamicObject)((DynamicObject)this.getModel().getValue("supplier")), (DynamicObject)material, (DynamicObject)((DynamicObject)this.getModel().getValue("insporg", rowIndex)));
        if (inspParam == null) {
            this.getModel().setValue("isinspect", (Object)Boolean.FALSE, rowIndex);
        } else {
            this.handleInsp(Collections.singletonList(rowIndex), Collections.singletonMap(String.valueOf(rowIndex), inspParam));
        }
    }

    private void markIsInspectByInspOrg(DynamicObject InspOrg, int rowIndex) {
        JSONObject inspParam = InspectionHelper.buildInspectionParam((DynamicObject)((DynamicObject)this.getModel().getValue("supplier")), (DynamicObject)((DynamicObject)this.getModel().getValue("material", rowIndex)), (DynamicObject)InspOrg);
        if (inspParam == null) {
            this.getModel().setValue("isinspect", (Object)Boolean.FALSE, rowIndex);
        } else {
            this.handleInsp(Collections.singletonList(rowIndex), Collections.singletonMap(String.valueOf(rowIndex), inspParam));
        }
    }

    private void handleInsp(List<Integer> list, Map<String, JSONObject> inspParams) {
        Set needInspect = InspectionHelper.calInspect(inspParams);
        this.getModel().beginInit();
        boolean enableImQmc = SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0003");
        Map matInvMap = new HashMap();
        if (!enableImQmc) {
            ArrayList<Object> matPkList = new ArrayList<Object>();
            for (Integer index : list) {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", index.intValue());
                if (material == null) continue;
                matPkList.add(material.getPkValue());
            }
            QFilter invMasterQ = new QFilter("id", "in", matPkList);
            QFilter purInspectQ = new QFilter("ispurchaseinspect", "=", (Object)Boolean.TRUE);
            matInvMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"id", (QFilter[])new QFilter[]{invMasterQ, purInspectQ});
        }
        for (Integer index : list) {
            boolean oldIsInspect;
            boolean newIsInspect = needInspect.contains(String.valueOf(index));
            if (!enableImQmc) {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", index.intValue());
                newIsInspect = false;
                if (material != null && matInvMap.containsKey(material.getPkValue())) {
                    newIsInspect = true;
                }
            }
            if (newIsInspect == (oldIsInspect = ((Boolean)this.getModel().getValue("isinspect", index.intValue())).booleanValue())) continue;
            this.getModel().setValue("isinspect", (Object)newIsInspect, index.intValue());
            this.changeIsInspect(newIsInspect, index);
        }
        this.getModel().endInit();
        for (Integer refreshIndex : list) {
            this.getView().updateView("isinspect", refreshIndex.intValue());
            this.getView().updateView("emrelease", refreshIndex.intValue());
        }
    }

    private void changeIsInspect(Boolean newValue, int rowIndex) {
        this.getView().setEnable(newValue, rowIndex, new String[]{"emrelease"});
        if (!newValue.booleanValue()) {
            this.getModel().setValue("emrelease", (Object)Boolean.FALSE, rowIndex);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        super.beforeFieldPostBack(e);
        switch (key = e.getKey()) {
            case "price": 
            case "priceandtax": 
            case "actualprice": 
            case "actualtaxprice": 
            case "amount": 
            case "taxamount": 
            case "discountrate": 
            case "amountandtax": {
                this.checkSettleCurrencyNotNull(e);
                break;
            }
        }
    }
}

