/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.setup;

import java.util.EventObject;
import kd.bd.sbd.business.helper.BillTreeBuildParameter;
import kd.bd.sbd.business.helper.EntityParseHelper;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.utils.FormUtils;

public class ImBillFieldSettingPlugin
extends AbstractBasePlugIn {
    private static final String BILL = "bill";
    private static final String ENTRY = "entry";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD = "field";
    private static final String FULLFIELD = "fullfield";
    private static final String ENTRYENTITYID = "entryentityid";
    protected volatile boolean triggerChangeEvent = true;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addClickListener((ClickListener)this, (String[])new String[]{FIELD_NAME});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (BILL.equals(name)) {
            this.getModel().deleteEntryData(ENTRY);
            this.getModel().createNewEntryRow(ENTRY);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "fieldname": {
                this.createAppBillFieldList();
                break;
            }
        }
    }

    private void createAppBillFieldList() {
        DynamicObject appBillDO = (DynamicObject)this.getModel().getValue(BILL);
        if (appBillDO == null || appBillDO.getPkValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"ImBillFieldSettingPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String appBill = appBillDO.getString("number");
        MainEntityType appBillMainType = MetadataServiceHelper.getDataEntityType((String)appBill);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(appBillMainType);
        TreeNode appBillNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        this.showSelectFieldForm(appBillNode, FIELD_NAME);
    }

    private void showSelectFieldForm(TreeNode billNode, String fieldCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bd_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (FIELD_NAME.equalsIgnoreCase(sourceFldKey) && StringUtils.isNotNull((Object)returnData)) {
            String fieldId = returnData.toString();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
            int size = this.getModel().getEntryRowCount(ENTRY);
            for (int i = 0; i < size; ++i) {
                String value;
                if (rowIndex == i || (value = (String)this.getModel().getValue(FULLFIELD, i)) == null || !value.equals(fieldId)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u91cd\u590d\u5b57\u6bb5\u3002", (String)"ImBillFieldSettingPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue(FULLFIELD, (Object)fieldId, rowIndex);
            DynamicObject appBillDO = (DynamicObject)this.getModel().getValue(BILL);
            String appBill = appBillDO.getString("number");
            MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)appBill);
            if (fieldId.indexOf(46) > 0) {
                String firstProp = fieldId.substring(0, fieldId.indexOf(46));
                fieldId = fieldId.substring(fieldId.indexOf(46) + 1);
                if ("billhead".equals(firstProp)) {
                    firstProp = null;
                }
                this.getModel().setValue(ENTRYENTITYID, (Object)firstProp, rowIndex);
            }
            String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcbillMainType, (String)fieldId);
            this.getModel().setValue(FIELD_NAME, (Object)fieldCaption, rowIndex);
            this.getModel().setValue(FIELD, (Object)fieldId, rowIndex);
        }
    }
}

