/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.setup;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public class InvOperatorMatPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String CLEAROPERATORANDMATERIAL = "clearOperatorAndMaterial";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"operator", "operatorgroup", "material", "materialgroup"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        switch (fieldName = e.getProperty().getName()) {
            case "controldimension": {
                this.showControlDimensionChangeConfirm(changeData);
                break;
            }
            case "operator": {
                this.operatorChanged();
                break;
            }
        }
    }

    private void operatorChanged() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject operator = dataEntity.getDynamicObject("operator");
        if (operator == null) {
            this.getModel().setValue("operatorgroup", null);
            return;
        }
        Object operatorGrpId = operator.get("operatorgrpid");
        this.getModel().setValue("operatorgroup", operatorGrpId);
    }

    private void showControlDimensionChangeConfirm(ChangeData changeData) {
        HashMap<String, Object> confirmInfo = new HashMap<String, Object>(4);
        confirmInfo.put("controlDimension", changeData.getOldValue());
        ConfirmCallBackListener cb = new ConfirmCallBackListener(CLEAROPERATORANDMATERIAL, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u63a7\u5236\u7ef4\u5ea6\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5173\u7cfb\u8bbe\u7f6e\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"InvOperatorMatPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(confirmInfo));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InvOperatorMatPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "operator": 
            case "operatorgroup": {
                List<Long> allOperatorGroupIdList = this.getAllOperatorGroupByOrg(org.getLong("id"));
                QFilter groupIdQ = new QFilter("operator".equals(fieldKey) ? "operatorgrpid" : "id", "in", allOperatorGroupIdList);
                showParameter.getListFilterParameter().setFilter(groupIdQ);
                break;
            }
        }
    }

    private List<Long> getAllOperatorGroupByOrg(Long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List allOperatorGroupIdList = OperatorGroupHelper.getAllOperatorGroupByOrgs(orgIds, (String)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
        return allOperatorGroupIdList;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if (CLEAROPERATORANDMATERIAL.equals(callBackId)) {
            String customValue = e.getCustomVaule();
            if (StringUtils.isBlank((CharSequence)customValue)) {
                return;
            }
            Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
            IDataModel model = this.getModel();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                model.setValue("operator", null);
                model.setValue("operatorgroup", null);
                model.setValue("dept", null);
                model.setValue("material", null);
                model.setValue("materialgroup", null);
            } else {
                Object controlDimension = confirmInfo.get("controlDimension");
                model.beginInit();
                model.setValue("controldimension", controlDimension);
                model.endInit();
                this.getView().updateView("controldimension");
            }
            this.initPage(Boolean.TRUE);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initPage(Boolean.FALSE);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("dept", null);
    }

    private void initPage(boolean setValue) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        FieldEdit operator = (FieldEdit)view.getControl("operator");
        FieldEdit material = (FieldEdit)view.getControl("material");
        FieldEdit operatorGroup = (FieldEdit)view.getControl("operatorgroup");
        FieldEdit materialGroup = (FieldEdit)view.getControl("materialgroup");
        FieldEdit dept = (FieldEdit)view.getControl("dept");
        operator.setMustInput(false);
        material.setMustInput(false);
        operatorGroup.setMustInput(false);
        materialGroup.setMustInput(false);
        dept.setMustInput(false);
        view.setVisible(Boolean.valueOf(false), new String[]{"operator", "material", "operatorgroup", "materialgroup", "dept"});
        String controlDimension = this.getModel().getDataEntity().getString("controldimension");
        view.setEnable(Boolean.valueOf(true), new String[]{"operatorgroup"});
        if ("OPER_MATER".equals(controlDimension)) {
            operator.setMustInput(true);
            material.setMustInput(true);
            view.setEnable(Boolean.valueOf(false), new String[]{"operatorgroup"});
            view.setVisible(Boolean.valueOf(true), new String[]{"operator", "material", "operatorgroup"});
            if (setValue) {
                model.setValue("dept", null);
                model.setValue("materialgroup", null);
            }
        } else if ("OPER_MATERGRP".equals(controlDimension)) {
            operator.setMustInput(true);
            materialGroup.setMustInput(true);
            view.setEnable(Boolean.valueOf(false), new String[]{"operatorgroup"});
            view.setVisible(Boolean.valueOf(true), new String[]{"operator", "materialgroup", "operatorgroup"});
            if (setValue) {
                model.setValue("dept", null);
                model.setValue("material", null);
            }
        } else if ("OPERGRP_MATER".equals(controlDimension)) {
            operatorGroup.setMustInput(true);
            material.setMustInput(true);
            view.setVisible(Boolean.valueOf(true), new String[]{"material", "operatorgroup"});
            if (setValue) {
                model.setValue("operator", null);
                model.setValue("dept", null);
                model.setValue("materialgroup", null);
            }
        } else if ("OPERGRP_MATERGRP".equals(controlDimension)) {
            operatorGroup.setMustInput(true);
            materialGroup.setMustInput(true);
            view.setVisible(Boolean.valueOf(true), new String[]{"materialgroup", "operatorgroup"});
            if (setValue) {
                model.setValue("operator", null);
                model.setValue("dept", null);
                model.setValue("material", null);
            }
        } else if ("DEPT_MATER".equals(controlDimension)) {
            dept.setMustInput(true);
            material.setMustInput(true);
            view.setVisible(Boolean.valueOf(true), new String[]{"material", "dept"});
            if (setValue) {
                model.setValue("operator", null);
                model.setValue("operatorgroup", null);
                model.setValue("materialgroup", null);
            }
        } else if ("DEPT_MATERGRP".equals(controlDimension)) {
            dept.setMustInput(true);
            materialGroup.setMustInput(true);
            view.setVisible(Boolean.valueOf(true), new String[]{"materialgroup", "dept"});
            if (setValue) {
                model.setValue("operator", null);
                model.setValue("operatorgroup", null);
                model.setValue("material", null);
            }
        }
    }
}

