/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.setup;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.utils.FormUtils;
import kd.scmc.im.utils.IMStringUtils;
import org.apache.commons.lang3.StringUtils;

public class InvSchemePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    protected volatile boolean triggerChangeEvent = true;

    public void initialize() {
        EntryGrid bizTypeGrid;
        EntryGrid outInvStatusGrid;
        EntryGrid invStatusGrid;
        EntryGrid outInvTypeGrid;
        super.initialize();
        EntryGrid invTypeGrid = (EntryGrid)this.getView().getControl("invtypeentry");
        if (invTypeGrid != null) {
            invTypeGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((outInvTypeGrid = (EntryGrid)this.getView().getControl("outinvtypeentry")) != null) {
            outInvTypeGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((invStatusGrid = (EntryGrid)this.getView().getControl("invstatusentry")) != null) {
            invStatusGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((outInvStatusGrid = (EntryGrid)this.getView().getControl("outinvstatusentry")) != null) {
            outInvStatusGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((bizTypeGrid = (EntryGrid)this.getView().getControl("bitypeentry")) != null) {
            bizTypeGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"invstatus", "invtype", "outinvstatus", "outinvtype"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        int rowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "invtype": {
                this.handleEntryRowF7FilterAndDefaultValue(rowIndex, "invtypeentry", "invtype", showParameter, "invtypeisdefault");
                break;
            }
            case "outinvtype": {
                this.handleEntryRowF7FilterAndDefaultValue(rowIndex, "outinvtypeentry", "outinvtype", showParameter, "outinvtypeisdefault");
                break;
            }
            case "invstatus": {
                this.handleEntryRowF7FilterAndDefaultValue(rowIndex, "invstatusentry", "invstatus", showParameter, "invstatusisdefault");
                break;
            }
            case "outinvstatus": {
                this.handleEntryRowF7FilterAndDefaultValue(rowIndex, "outinvstatusentry", "outinvstatus", showParameter, "outinvstatusisdefault");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = false;
        switch (propName) {
            case "invtypeisdefault": {
                this.handleEntryDefaultValueStrategy(rowIndex, "invtypeentry", "invtypeispreset", propName);
                break;
            }
            case "outinvtypeisdefault": {
                this.handleEntryDefaultValueStrategy(rowIndex, "outinvtypeentry", "outinvtypeispreset", propName);
                break;
            }
            case "invstatusisdefault": {
                this.handleEntryDefaultValueStrategy(rowIndex, "invstatusentry", "invstatusispreset", propName);
                break;
            }
            case "outinvstatusisdefault": {
                this.handleEntryDefaultValueStrategy(rowIndex, "outinvstatusentry", "outinvstatusispreset", propName);
                break;
            }
            case "isinupdate": {
                this.handleIsInAndOutUpdateOp(propName);
                break;
            }
            case "isoutupdate": {
                this.handleIsInAndOutUpdateOp(propName);
                break;
            }
            case "isnotupdate": {
                this.clearData(propName);
                break;
            }
            case "transceivertype": {
                this.setTransceiverAndBizDirection(valueSet[0].getNewValue());
                break;
            }
        }
    }

    private void setTransceiverAndBizDirection(Object transceiverType) {
        IDataModel model = this.getModel();
        model.setValue("transceiver", transceiverType == null ? "0" : ((DynamicObject)transceiverType).get("transceiver"));
        model.setValue("bizdirection", transceiverType == null ? "0" : ((DynamicObject)transceiverType).get("bizdirection"));
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        EntryGrid grid = (EntryGrid)e.getSource();
        String entryKey = grid.getEntryKey();
        this.setEntryEnable(entryKey);
    }

    public void afterBindData(EventObject e) {
        OperationStatus status;
        super.afterBindData(e);
        Boolean isInUpdate = (Boolean)this.getModel().getValue("isinupdate");
        Boolean isOutUpdate = (Boolean)this.getModel().getValue("isoutupdate");
        if (isInUpdate.booleanValue() || isOutUpdate.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isnotupdate"});
        }
        if (OperationStatus.VIEW.equals((Object)(status = this.getView().getFormShowParameter().getStatus()))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"invtypenewentry", "invtypedeleteentry", "invstatusnewentry", "invstatusdeleteentry", "outinvtypenewentry", "outinvtypedeleteentry", "outinvstatusnewentry", "outinvstatusdeleteentry", "biztypenewentry", "biztypedeleteentry"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = FormUtils.getOpKey((BeforeDoOperationEventArgs)args);
        if ("save".equals(opKey)) {
            this.dealEmptyRows();
        }
        this.showConfirm(opKey, args);
    }

    private void dealEmptyRows() {
        IDataModel model = this.getModel();
        DynamicObjectCollection invType = model.getEntryEntity("invtypeentry");
        DynamicObjectCollection invStatus = model.getEntryEntity("invstatusentry");
        DynamicObjectCollection outInvType = model.getEntryEntity("outinvtypeentry");
        DynamicObjectCollection outInvStatus = model.getEntryEntity("outinvstatusentry");
        DynamicObjectCollection bizType = model.getEntryEntity("bitypeentry");
        if (!invType.isEmpty()) {
            this.clearEmptyRows(invType, "invtypeentry", "invtype");
        }
        if (!invStatus.isEmpty()) {
            this.clearEmptyRows(invStatus, "invstatusentry", "invstatus");
        }
        if (!outInvType.isEmpty()) {
            this.clearEmptyRows(outInvType, "outinvtypeentry", "outinvtype");
        }
        if (!outInvStatus.isEmpty()) {
            this.clearEmptyRows(outInvStatus, "outinvstatusentry", "outinvstatus");
        }
        if (!bizType.isEmpty()) {
            this.clearEmptyRows(bizType, "bitypeentry", "biztype");
        }
    }

    private void clearEmptyRows(DynamicObjectCollection entry, String entryId, String field) {
        ArrayList<Integer> idx = new ArrayList<Integer>();
        for (int i = 0; i < entry.size(); ++i) {
            boolean empty;
            boolean bl = empty = ((DynamicObject)entry.get(i)).get(field) == null;
            if (!empty) continue;
            idx.add(i);
        }
        if (idx.isEmpty()) {
            return;
        }
        int[] index = idx.stream().mapToInt(Integer::intValue).toArray();
        this.getModel().deleteEntryRows(entryId, index);
    }

    private void showConfirm(String opKey, BeforeDoOperationEventArgs args) {
        String deleteKey;
        String isPreset;
        String billEntry;
        if ("invtypedeleteentry".equals(opKey)) {
            billEntry = "invtypeentry";
            isPreset = "invtypeispreset";
            deleteKey = "invtypedeleteentry";
        } else if ("outinvtypedeleteentry".equals(opKey)) {
            billEntry = "outinvtypeentry";
            isPreset = "outinvtypeispreset";
            deleteKey = "outinvtypedeleteentry";
        } else if ("invstatusdeleteentry".equals(opKey)) {
            billEntry = "invstatusentry";
            isPreset = "invstatusispreset";
            deleteKey = "invstatusdeleteentry";
        } else if ("outinvstatusdeleteentry".equals(opKey)) {
            billEntry = "outinvstatusentry";
            isPreset = "outinvstatusispreset";
            deleteKey = "outinvstatusdeleteentry";
        } else if ("biztypedeleteentry".equals(opKey)) {
            billEntry = "bitypeentry";
            isPreset = "biztypeispreset";
            deleteKey = "biztypedeleteentry";
        } else {
            return;
        }
        EntryGrid control = (EntryGrid)this.getControl(billEntry);
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        ArrayList entryInfoList = new ArrayList(4);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("entrykey", billEntry);
        map.put("deletekey", deleteKey);
        map.put("ispresetkey", isPreset);
        entryInfoList.add(map);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u884c\uff1f", (String)"InvSchemePlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(deleteKey, (IFormPlugin)this), null, SerializationUtils.toJsonString(entryInfoList));
        args.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        String customValue = e.getCustomVaule();
        List entryInfoList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)customValue)) {
            entryInfoList = (List)SerializationUtils.fromJsonString((String)customValue, ArrayList.class);
        }
        if (entryInfoList.isEmpty()) {
            return;
        }
        Map map = (Map)entryInfoList.get(0);
        Object entryKey = map.get("entrykey");
        Object deletekey = map.get("deletekey");
        Object ispresetkey = map.get("ispresetkey");
        if (entryKey == null || ispresetkey == null || deletekey == null) {
            return;
        }
        if (deletekey.equals(callBackId) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            EntryGrid control = (EntryGrid)this.getControl(entryKey.toString());
            int[] selectRows = control.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"InvSchemePlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryData entryData = control.getEntryData();
            DynamicObject[] dataEntities = entryData.getDataEntitys();
            for (int i : selectRows) {
                DynamicObject dataEntity = dataEntities[i];
                boolean isEntryPreset = dataEntity.getBoolean(ispresetkey.toString());
                if (!isEntryPreset) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u8bbe\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"InvSchemePlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryRows(entryKey.toString(), selectRows);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"InvSchemePlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
    }

    private void setEntryEnable(String entryKey) {
        Object isPreset = this.getModel().getValue("ispreset");
        if (((Boolean)isPreset).booleanValue()) {
            switch (entryKey) {
                case "invtypeentry": {
                    this.dealPresetEntries("invtypeentry", "invtypeispreset", "invtype", "invtypeisdefault", "ownertype1", "keepertype1");
                    break;
                }
                case "outinvtypeentry": {
                    this.dealPresetEntries("outinvtypeentry", "outinvtypeispreset", "outinvtype", "outinvtypeisdefault", "outownertype1", "outkeepertype1");
                    break;
                }
                case "invstatusentry": {
                    this.dealPresetEntries("invstatusentry", "invstatusispreset", "invstatus", "invstatusisdefault");
                    break;
                }
                case "outinvstatusentry": {
                    this.dealPresetEntries("outinvstatusentry", "outinvstatusispreset", "outinvstatus", "outinvstatusisdefault");
                    break;
                }
                case "bitypeentry": {
                    this.dealPresetEntries("bitypeentry", "biztypeispreset", "biztype", "allowmanualadd");
                    break;
                }
            }
        }
    }

    private void dealPresetEntries(String entry, String entryPreset, String ... fields) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entry);
        for (int i = 0; i < entryEntity.size(); ++i) {
            Object isEntryPreset = this.getModel().getValue(entryPreset, i);
            if (!((Boolean)isEntryPreset).booleanValue()) continue;
            this.getView().setEnable(Boolean.FALSE, i, fields);
        }
    }

    private void handleEntryRowF7FilterAndDefaultValue(int rowIndex, String entry, String f7Logo, ListShowParameter showParameter, String isDefault) {
        DynamicObjectCollection entryInfo = this.getModel().getEntryEntity(entry);
        HashSet<Long> idSet = new HashSet<Long>();
        int size = entryInfo.size();
        for (int i = 0; i < size; ++i) {
            if (i == rowIndex || null == ((DynamicObject)entryInfo.get(i)).getDynamicObject(f7Logo)) continue;
            idSet.add((Long)((DynamicObject)entryInfo.get(i)).getDynamicObject(f7Logo).getPkValue());
        }
        HashSet<Integer> preIdDefault = new HashSet<Integer>(16);
        for (int i = 0; i < entryInfo.size(); ++i) {
            if (!((DynamicObject)entryInfo.get(i)).getBoolean(isDefault)) continue;
            preIdDefault.add(i);
            break;
        }
        if (preIdDefault.isEmpty()) {
            this.getModel().setValue(isDefault, (Object)Boolean.TRUE, 0);
        }
        QFilter qFilters = new QFilter("id", "not in", idSet);
        showParameter.getListFilterParameter().setFilter(qFilters);
    }

    private void handleEntryDefaultValueStrategy(int rowIndex, String entry, String preSetField, String isDefault) {
        int i;
        DynamicObjectCollection entryInfo = this.getModel().getEntryEntity(entry);
        for (i = 0; i < entryInfo.size(); ++i) {
            DynamicObject row = (DynamicObject)entryInfo.get(i);
            boolean preset = row.getBoolean(preSetField);
            boolean isdefault = row.getBoolean(isDefault);
            if (i == rowIndex || !preset || !isdefault) continue;
            if ("invtypeentry".equals(entry)) {
                this.getView().showTipNotification(IMStringUtils.append((String)ResManager.loadKDString((String)"\u5f53\u524d\u5165\u5e93\u5e93\u5b58\u7c7b\u578b", (String)"InvSchemePlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]), (Object[])new Object[]{ResManager.loadKDString((String)"\u5df2\u6709\u7cfb\u7edf\u9884\u8bbe\u7684\u9ed8\u8ba4\u503c\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u9ed8\u8ba4\u3002", (String)"InvSchemePlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0])}));
            } else if ("outinvtypeentry".equals(entry)) {
                this.getView().showTipNotification(IMStringUtils.append((String)ResManager.loadKDString((String)"\u5f53\u524d\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b", (String)"InvSchemePlugin_8", (String)"scmc-im-formplugin", (Object[])new Object[0]), (Object[])new Object[]{ResManager.loadKDString((String)"\u5df2\u6709\u7cfb\u7edf\u9884\u8bbe\u7684\u9ed8\u8ba4\u503c\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u9ed8\u8ba4\u3002", (String)"InvSchemePlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0])}));
            } else if ("invstatusentry".equals(entry)) {
                this.getView().showTipNotification(IMStringUtils.append((String)ResManager.loadKDString((String)"\u5f53\u524d\u5165\u5e93\u5e93\u5b58\u72b6\u6001", (String)"InvSchemePlugin_9", (String)"scmc-im-formplugin", (Object[])new Object[0]), (Object[])new Object[]{ResManager.loadKDString((String)"\u5df2\u6709\u7cfb\u7edf\u9884\u8bbe\u7684\u9ed8\u8ba4\u503c\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u9ed8\u8ba4\u3002", (String)"InvSchemePlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0])}));
            } else {
                this.getView().showTipNotification(IMStringUtils.append((String)ResManager.loadKDString((String)"\u5f53\u524d\u51fa\u5e93\u5e93\u5b58\u72b6\u6001", (String)"InvSchemePlugin_10", (String)"scmc-im-formplugin", (Object[])new Object[0]), (Object[])new Object[]{ResManager.loadKDString((String)"\u5df2\u6709\u7cfb\u7edf\u9884\u8bbe\u7684\u9ed8\u8ba4\u503c\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u9ed8\u8ba4\u3002", (String)"InvSchemePlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0])}));
            }
            this.getModel().setValue(isDefault, (Object)Boolean.FALSE, rowIndex);
            return;
        }
        for (i = 0; i < entryInfo.size(); ++i) {
            if (i == rowIndex) continue;
            this.getModel().setValue(isDefault, (Object)Boolean.FALSE, i);
        }
    }

    private void handleIsInAndOutUpdateOp(String propName) {
        boolean isInUpdate = (Boolean)this.getModel().getValue("isinupdate");
        boolean isOutUpdate = (Boolean)this.getModel().getValue("isoutupdate");
        if (isInUpdate || isOutUpdate) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isnotupdate"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"ispreset"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isnotupdate"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"ispreset"});
        }
        this.clearData(propName);
    }

    private void clearData(String propName) {
        IDataModel bill = this.getModel();
        if (((Boolean)bill.getValue(propName)).booleanValue()) {
            if ("isnotupdate".equals(propName)) {
                bill.deleteEntryData("invtypeentry");
                bill.deleteEntryData("outinvtypeentry");
                bill.deleteEntryData("invstatusentry");
                bill.deleteEntryData("outinvstatusentry");
                bill.setValue("ownertype", null);
                bill.setValue("keepertype", null);
                bill.setValue("outownertype", null);
                bill.setValue("outkeepertype", null);
            }
            return;
        }
        if ("isinupdate".equals(propName)) {
            bill.deleteEntryData("invtypeentry");
            bill.deleteEntryData("invstatusentry");
            bill.setValue("ownertype", null);
            bill.setValue("keepertype", null);
        } else if ("isoutupdate".equals(propName)) {
            bill.deleteEntryData("outinvtypeentry");
            bill.deleteEntryData("outinvstatusentry");
            bill.setValue("outownertype", null);
            bill.setValue("outkeepertype", null);
        }
    }
}

