/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.setup;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.utils.FormUtils;

public class WarehouseSetupMaterialRelPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String ORG_CLEAR_CALLBACK = "ORG_CLEAR_CALLBACK";

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        this.beforeImportBill(sourceData);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"org", "warehouse", "materialnumber", "materialgrpnumber"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName;
        switch (propertyName = evt.getProperty().getName()) {
            case "org": {
                this.initOrg(evt);
                break;
            }
            case "warehouse": {
                this.initWarehouse(evt);
                break;
            }
            case "materialnumber": {
                this.initMaterial(evt);
                break;
            }
            case "materialgrpnumber": {
                this.initMaterialGroup(evt);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object selectOrgId = parameter.getCustomParam("SELECT_ORG_ID");
        if (selectOrgId != null) {
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(selectOrgId.toString()));
            DynamicObject[] firstOrg = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])qFilter.toArray(), (String)"id asc", (int)1);
            this.getModel().setValue("org", (Object)firstOrg[0]);
        }
    }

    public void beforeBindData(EventObject e) {
        DynamicObject setUp = (DynamicObject)this.getModel().getValue("warehousesetup");
        if (setUp != null) {
            DynamicObject org = setUp.getDynamicObject("org");
            DynamicObject warehouse = setUp.getDynamicObject("warehouse");
            this.getModel().beginInit();
            this.getModel().setValue("org", (Object)org);
            this.getModel().setValue("warehouse", (Object)warehouse);
            this.getModel().endInit();
            this.getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        if ("org".equalsIgnoreCase(key)) {
            ChangeData changeData = changeSet[0];
            this.handleOrgChanged(changeData);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        String customValue = event.getCustomVaule();
        if (ORG_CLEAR_CALLBACK.equals(callBackId)) {
            this.clearAllFieldExcludeOrg(result, customValue);
        }
    }

    private void beforeImportBill(Map<String, Object> sourceData) {
        JSONObject orgJson = (JSONObject)sourceData.get("org");
        if (orgJson == null) {
            return;
        }
        String orgNum = (String)orgJson.get((Object)"number");
        QFilter qFilter = new QFilter("number", "=", (Object)orgNum);
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])qFilter.toArray());
        if (org == null) {
            return;
        }
        JSONObject material = (JSONObject)sourceData.get("materialnumber");
        if (material == null) {
            return;
        }
        String materialNum = (String)material.get((Object)"number");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue())).and(new QFilter("masterid.number", "=", (Object)materialNum));
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"bd_materialinventoryinfo", (QFilter[])baseDataFilter.toArray(), null, (int)1);
        if (!idList.isEmpty()) {
            Object id = idList.get(0);
            material.put("id", id);
        }
    }

    private void initMaterialGroup(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"IM-W-177186", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            evt.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.setUseOrgId(org.getLong("id"));
    }

    private void initMaterial(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"IM-W-177186", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            evt.setCancel(true);
            return;
        }
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)Long.valueOf(org.getPkValue().toString()));
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private Object[] getPermissionOrgIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        Object[] ids = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)"im_warehousesetupmate_rel", (String)appId);
        return ids;
    }

    private QFilter getFirstOrgFilter() {
        Long firstOrgId = this.getFirstOrgId();
        QFilter qFilter = new QFilter("id", "=", (Object)firstOrgId);
        return qFilter;
    }

    private Long getFirstOrgId() {
        Object[] ids = this.getPermissionOrgIds();
        if (ids != null && ids.length > 0) {
            return (Long)ids[0];
        }
        return null;
    }

    private void handleOrgChanged(ChangeData changeData) {
        Object oldValue = changeData.getOldValue();
        if (oldValue != null) {
            String orgId = ((DynamicObject)oldValue).getString("id");
            String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"ImWorkbenchOpFormPlugin_38", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(ORG_CLEAR_CALLBACK, (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, orgId);
        }
    }

    private void clearAllFieldExcludeOrg(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        this.getModel().beginInit();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            HashSet<String> keySet = new HashSet<String>();
            keySet.add("warehouse");
            keySet.add("materialnumber");
            keySet.add("materialgrpnumber");
            for (String fieldKey : keySet) {
                this.getModel().setValue(fieldKey, null);
            }
        } else {
            this.getModel().setValue("org", (Object)customValue);
        }
        this.getView().updateView();
        this.getModel().endInit();
    }

    private QFilter getPermissionOrgFilter() {
        Object[] ids = this.getPermissionOrgIds();
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return qFilter;
    }

    private void initOrg(BeforeF7SelectEvent evt) {
        QFilter qFilter = this.getPermissionOrgFilter();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void initWarehouse(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"IM-W-177186", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            evt.setCancel(true);
            return;
        }
        Object orgId = org.getPkValue();
        QFilter qFilter = new QFilter("org", "=", orgId);
        DynamicObject[] setUpList = BusinessDataServiceHelper.load((String)"im_warehousesetup", (String)"warehouse", (QFilter[])qFilter.toArray());
        if (setUpList != null && setUpList.length > 0) {
            HashSet<Object> warehouseIds = new HashSet<Object>(16);
            for (DynamicObject setup : setUpList) {
                DynamicObject warehouse = setup.getDynamicObject("warehouse");
                Object pkValue = warehouse.getPkValue();
                warehouseIds.add(pkValue);
            }
            QFilter warehouseFilter = new QFilter("id", "in", warehouseIds);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(warehouseFilter);
        }
    }
}

