/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.transbill;

import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.logisticsbill.LogisticsBillModel;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.formplugin.transbill.TransBillCommonBeforeF7SelectListener;
import kd.scmc.im.utils.CommonUtils;

public abstract class AbstractTransBill
extends ImBillEditPlugin {
    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "org": 
            case "inorg": 
            case "outorg": 
            case "owner": 
            case "outowner": 
            case "inowner": 
            case "keeper": 
            case "inkeepertype": 
            case "outkeeper": 
            case "warehouse": 
            case "outwarehouse": 
            case "location": 
            case "outlocation": {
                TransBillCommonBeforeF7SelectListener listener = new TransBillCommonBeforeF7SelectListener(this.getView());
                listener.beforeF7Select(e);
                break;
            }
            default: {
                super.beforeF7Select(e);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        Object op = e.getSource();
        if (op instanceof Save || op instanceof Submit || op instanceof Audit) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            String formId = this.getModel().getDataEntityType().getName();
            if ("im_transdirbill".equals(formId) && model.getValue("outorg") == null || "im_transoutbill".equals(formId) && model.getValue("org") == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8c03\u51fa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u8c03\u51fa\u7ec4\u7ec7\u3002", (String)"AbstractTransBill_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (MetaDataHelper.isExistField((IDataEntityType)model.getDataEntityType(), (String)"org") && model.getValue("org") == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8c03\u5165\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u8c03\u5165\u7ec4\u7ec7\u3002", (String)"AbstractTransBill_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
        super.beforeDoOperation(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.isPropertyChange(e)) {
            return;
        }
        String key = e.getProperty().getName();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "warehouse": {
                this.changeWarehouse(e, "location");
                break;
            }
            case "outwarehouse": {
                this.changeOutWarehouse(e);
                break;
            }
            case "price": {
                this.changePrice(e);
                break;
            }
            case "amount": {
                this.changeAmount(e);
                break;
            }
            case "qty": {
                this.changeQty(e);
                break;
            }
            case "qtyunit2nd": {
                this.changeQtyunit2nd(e);
                break;
            }
            case "invscheme": {
                this.changeInvScheme(e);
                break;
            }
            case "outkeepertype": {
                this.changeOutKeepertype(e);
                break;
            }
            case "keepertype": {
                this.changeKeepertype(e);
                break;
            }
            case "outownertype": {
                this.changeOutOwnertype(e);
                break;
            }
            case "ownertype": {
                this.changeOwnertype(e);
                break;
            }
            case "inlotnumber": {
                this.relLotnumberSpace(e);
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    protected void changeOwnertype(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        int index = changeSet.getRowIndex();
        if ("bos_org".equals(newValue)) {
            this.dealOwner("ownertype", index);
        }
    }

    protected void changeOutOwnertype(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        int index = changeSet.getRowIndex();
        if ("bos_org".equals(newValue)) {
            this.dealOwner("outownertype", index);
        }
    }

    protected void changeKeepertype(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        int index = changeSet.getRowIndex();
        this.dealKeeper("keepertype", index);
    }

    protected void changeOutKeepertype(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        int index = changeSet.getRowIndex();
        this.dealKeeper("outkeepertype", index);
    }

    protected void changeInvScheme(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    protected void changeOutWarehouse(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        int index = changeSet.getRowIndex();
        this.setOutLocationIsEnableByWarehouse((DynamicObject)newValue, index);
    }

    protected void changeWarehouse(PropertyChangedArgs e, String location) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        int index = changeSet.getRowIndex();
        this.setLocationIsEnableByWarehouse((DynamicObject)newValue, index, location);
    }

    protected void changeAmount(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        this.setPrice(data.getRowIndex());
    }

    private void changeQty(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        this.setAmount(data.getRowIndex());
        super.propertyChanged(e);
    }

    protected void changePrice(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        this.setAmount(data.getRowIndex());
    }

    protected void changeQtyunit2nd(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData data = e.getChangeSet()[0];
        this.setAmount(data.getRowIndex());
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        Object matchingrule = this.getView().getFormShowParameter().getCustomParam("matchingrule");
        if (null != matchingrule) {
            return;
        }
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int i = row.getRowIndex();
                this.dealKeeper("keepertype", i);
                this.dealKeeper("outkeepertype", i);
                this.dealOwner("ownertype", i);
                this.dealOwner("outownertype", i);
            }
        }
    }

    protected void setLocationIsEnableByWarehouse(DynamicObject warehouse, int rowindex, String location) {
        this.getModel().setValue(location, null, rowindex);
        if (!CommonUtils.isNull((Object)warehouse)) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowindex, new String[]{location});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{location});
        }
    }

    protected void setOutLocationIsEnableByWarehouse(DynamicObject warehouse, int rowindex) {
        this.getModel().setValue("outlocation", null, rowindex);
        if (!CommonUtils.isNull((Object)warehouse)) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowindex, new String[]{"outlocation"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"outlocation"});
        }
    }

    protected void setPrice(int index) {
        this.calPriceByAmountChange(index, "price", "qty", "amount", "settlescurrency");
    }

    protected void setAmount(int index) {
        this.calAmonutByQtyChange(index, "price", "qty", "amount", "settlescurrency");
    }

    protected void setSettleCurrency(DynamicObject org) {
        Map currencyinfo;
        IDataModel model = this.getModel();
        if (org != null && (currencyinfo = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getLong("id"))) != null) {
            model.setValue("settlescurrency", currencyinfo.get("baseCurrencyID"));
            return;
        }
        model.setValue("settlescurrency", (Object)1L);
    }

    @Override
    public String getCurrencyKey() {
        return "settlescurrency";
    }

    protected void clearDTFiled(String entryfiledKey) {
        DynamicObjectCollection appEntry = this.getModel().getEntryEntity("billentry");
        if (CommonUtils.isNull((Object)appEntry)) {
            return;
        }
        for (int i = 0; i < appEntry.size(); ++i) {
            this.getModel().setValue(entryfiledKey, null, i);
        }
    }

    protected void dealOwner(String field, int rowIndex) {
        Object ownerType = this.getModel().getValue(field, rowIndex);
        DynamicObject org = null;
        String ownerkey = null;
        switch (field) {
            case "ownertype": {
                org = this.getModel().getDataEntity().getDynamicObject(this.getTransInOrgKey());
                ownerkey = "owner";
                break;
            }
            case "outownertype": {
                org = this.getModel().getDataEntity().getDynamicObject(this.getTransOutOrgKey());
                ownerkey = "outowner";
                break;
            }
        }
        if (!"bos_org".equals(ownerType)) {
            return;
        }
        if (org == null) {
            this.getModel().setValue(ownerkey, (Object)null, rowIndex);
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Object ownerID = this.getDefaultOwner(ownerkey, orgId);
        this.getModel().setValue(ownerkey, ownerID, rowIndex);
    }

    private Object getDefaultOwner(String ownerKey, Long defOrgId) {
        String formId;
        Object ownerID = null;
        switch (formId = this.getModel().getDataEntityType().getName()) {
            case "im_transoutbill": {
                if (this.isOutOrgAndisInUpdate() && "owner".equals(ownerKey)) {
                    DynamicObject inOrg = this.getModel().getDataEntity().getDynamicObject("inorg");
                    if (inOrg == null) break;
                    ownerID = OwnerHelper.getOwnerDefValue((Long)((Long)inOrg.getPkValue()));
                    break;
                }
                if ("A".equals(this.getModel().getValue("transit")) && "owner".equals(ownerKey)) {
                    DynamicObject outOrg = this.getModel().getDataEntity().getDynamicObject(this.getTransOutOrgKey());
                    if (outOrg == null) break;
                    ownerID = OwnerHelper.getOwnerDefValue((Long)((Long)outOrg.getPkValue()));
                    break;
                }
                ownerID = OwnerHelper.getOwnerDefValue((Long)defOrgId);
                break;
            }
            case "im_transinbill": {
                if ("B".equals(this.getModel().getValue("transit")) && "outowner".equals(ownerKey)) {
                    DynamicObject inOrg = this.getModel().getDataEntity().getDynamicObject(this.getTransInOrgKey());
                    if (inOrg == null) break;
                    ownerID = OwnerHelper.getOwnerDefValue((Long)((Long)inOrg.getPkValue()));
                    break;
                }
                ownerID = OwnerHelper.getOwnerDefValue((Long)defOrgId);
                break;
            }
            default: {
                ownerID = OwnerHelper.getOwnerDefValue((Long)defOrgId);
            }
        }
        return ownerID;
    }

    private boolean isOutOrgAndisInUpdate() {
        DynamicObject invScheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (invScheme != null) {
            boolean isInUpdate = invScheme.getBoolean("isinupdate");
            String value = (String)this.getModel().getValue("transtype");
            if ("B".equals(value) && isInUpdate) {
                return true;
            }
        }
        return false;
    }

    protected void dealKeeper(String field, int index) {
        this.dealKeeper(field, index, true);
    }

    protected void dealKeeper(String field, int index, boolean isSetValue) {
        IDataModel model = this.getModel();
        String keeper = "";
        DynamicObject org = null;
        if (field == null) {
            return;
        }
        switch (field) {
            case "outkeepertype": {
                keeper = "outkeeper";
                if ("im_transinbill".equals(this.getModel().getDataEntityType().getName()) && "B".equals(model.getValue("transit"))) {
                    org = (DynamicObject)model.getValue(this.getTransInOrgKey());
                    break;
                }
                org = (DynamicObject)model.getValue(this.getTransOutOrgKey());
                break;
            }
            default: {
                keeper = "keeper";
                org = "im_transoutbill".equals(this.getModel().getDataEntityType().getName()) && "A".equals(model.getValue("transit")) ? (DynamicObject)model.getValue(this.getTransOutOrgKey()) : (DynamicObject)model.getValue(this.getTransInOrgKey());
            }
        }
        Object keeperTypeObj = model.getValue(field, index);
        if (keeperTypeObj != null) {
            switch (keeperTypeObj.toString()) {
                case "bos_org": {
                    if (isSetValue) {
                        model.setValue(keeper, org == null ? null : org.getPkValue(), index);
                    }
                    if (!"im_transdirbill".equals(this.getModel().getDataEntityType().getName())) break;
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{keeper});
                    break;
                }
                case "bd_supplier": 
                case "bd_customer": {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{keeper});
                    break;
                }
            }
        } else {
            if (isSetValue) {
                model.setValue(keeper, null, index);
            }
            if ("im_transdirbill".equals(this.getModel().getDataEntityType().getName())) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{keeper});
            }
        }
    }

    protected boolean isPropertyChange(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return false;
        }
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        return CommonUtils.isNull((Object)newValue) || !newValue.equals(oldValue);
    }

    protected void initEntry(DynamicObject inorg, DynamicObject outorg) {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.dealKeeper("keepertype", i);
            this.dealKeeper("outkeepertype", i);
            this.dealOwner("ownertype", i);
            this.dealOwner("outownertype", i);
            this.updateEnableLocation("location", (DynamicObject)this.getModel().getValue("warehouse", i), i);
        }
    }

    protected void updateEnableLocation(String location, DynamicObject warehouse, int rowindex) {
        if (!CommonUtils.isNull((Object)warehouse)) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowindex, new String[]{location});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{location});
        }
    }

    protected void initOutDeptAndOperator(DynamicObject outorg) {
    }

    protected Object getAccountOrgId(DynamicObject org) {
        Long orgId = (Long)org.getPkValue();
        Long accountingId = null;
        Boolean isaccounting = org.getBoolean("fisaccounting");
        if (isaccounting.booleanValue()) {
            accountingId = orgId;
        } else {
            Map companys = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            accountingId = companys.get("id");
        }
        return accountingId;
    }

    protected void changeOutorg(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        Object transType = model.getValue("transtype");
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        this.setSettleCurrency((DynamicObject)newValue);
        if ("A".equals(transType)) {
            model.setValue("org", newValue);
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entry.size(); ++i) {
            this.dealKeeper("outkeepertype", i);
            this.dealOwner("outownertype", i);
        }
    }

    protected abstract String getTransOutOrgKey();

    protected abstract String getTransInOrgKey();

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        IDataModel model = this.getModel();
        for (int i = 0; i < entryRowCount; ++i) {
            this.dealKeeper("keepertype", i, false);
            this.dealKeeper("outkeepertype", i, false);
            this.updateEnableLocation("location", (DynamicObject)model.getValue("warehouse", i), i);
        }
    }

    private void relLotnumberSpace(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        int row = changeSet.getRowIndex();
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("billentry", row);
        String lotnumber = dynamicObject.getString("inlotnumber");
        if (lotnumber != null) {
            lotnumber = lotnumber.replaceAll("\u3000", " ").trim();
            this.setValue("inlotnumber", lotnumber, row, false);
        }
    }

    @Override
    protected void setEnable4IsDraw(boolean isDraw) {
        super.setEnable4IsDraw(isDraw);
        IFormView view = this.getView();
        String formId = this.getModel().getDataEntityType().getName();
        boolean isTransIn = "im_transinbill".equals(formId);
        boolean isTransOut = "im_transoutbill".equals(formId);
        if (isDraw && (isTransIn || isTransOut)) {
            String org = "";
            if (isTransIn) {
                org = "outorg";
            } else if (isTransOut) {
                org = "inorg";
            }
            view.setEnable(Boolean.FALSE, new String[]{"transtype", org});
        } else if (isTransOut && "B".equals(this.getModel().getValue("transtype"))) {
            view.setEnable(Boolean.TRUE, new String[]{"inorg"});
            view.updateView("inorg");
        }
    }

    protected void updateLogisticBill(String propName) {
        String formId;
        LogisticsBillModel logisticsBillModel = LogisticsBillModel.getInstance();
        Set keySet = logisticsBillModel.getKeySet(formId = this.getModel().getDataEntityType().getName());
        if (!keySet.isEmpty() && keySet.contains(propName)) {
            logisticsBillModel.matchLogisticsBill(this.getModel());
        }
    }
}

