/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.transbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.OrgHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.utils.CommonUtils;

public class ApplyBillBeforeF7SelectListener
implements BeforeF7SelectListener {
    private static final String MASTERID_ENABLEVMI = "masterid.enablevmi";
    private static final String APPLYDEPT = "applydept";
    private IFormView view = null;

    public ApplyBillBeforeF7SelectListener(IFormView view) {
        this.view = view;
    }

    public IDataModel getModel() {
        return this.view.getModel();
    }

    public IFormView getView() {
        return this.view;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowindex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material", rowindex);
        switch (fieldKey) {
            case "org": {
                this.beforeSelectOrg(e);
                break;
            }
            case "location": {
                this.beforeSelectLocation(e);
                break;
            }
            case "unit": {
                this.beforeSelectUnit(e);
                break;
            }
            case "material": {
                this.beforeSelectMaterial(e);
                break;
            }
            case "materialmasterid": {
                this.beforeSelectMaterialmasterid(e);
                break;
            }
            case "lot": {
                this.beforeSelectLot(e, fieldKey);
                break;
            }
            case "biztype": {
                this.beforeSelectBiztype(e);
                break;
            }
            case "linetype": {
                this.beforeLineType(e, this.getModel().getDataEntityType().getName());
                break;
            }
            case "bizoperatorgroup": {
                this.beforeSelectOperatorGroup(e);
                break;
            }
            case "bizoperator": {
                this.beforeSelectOperator(e);
                break;
            }
            case "bizdept": {
                this.beforeSelectBizDept(e);
                break;
            }
            case "applyuser": {
                DynamicObject org = (DynamicObject)bill.getValue("org");
                this.applyUsertSelect(e, showParameter, org);
                break;
            }
            case "mversion": {
                if (materialInvInfo == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599", (String)"ApplyBillBeforeF7SelectListener_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("material", "=", (Object)materialInvInfo.getLong("masterid_id")));
                break;
            }
            case "configuredcode": 
            case "tracknumber": {
                this.beforeTrackNumOrConfigCode(showParameter, rowindex, fieldKey);
                break;
            }
        }
    }

    private void beforeTrackNumOrConfigCode(ListShowParameter showParameter, int rowIndex, String field) {
        QFilter qFilter = null;
        if (field.equalsIgnoreCase("configuredcode")) {
            Object value = this.getModel().getValue("material", rowIndex);
            if (value != null) {
                DynamicObject material = (DynamicObject)value;
                qFilter = InvBillHelper.getConfigureCodeFilter((Object)material.get("masterid.id"));
            }
        } else {
            qFilter = InvBillHelper.getTrackNumberFilter();
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void beforeSelectBizDept(BeforeF7SelectEvent e) {
        this.commonDeptFilter(e, "bizorg");
    }

    private void commonDeptFilter(BeforeF7SelectEvent e, String orgkey) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue(orgkey);
        if (CommonUtils.isNull((Object)bizOrg)) {
            String displayName = this.getControlDisplayName(orgkey);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\u3002", (String)"ApplyBillBeforeF7SelectListener_4", (String)"scmc-im-formplugin", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        List orgIdlist = OrgServiceHelper.getOrgAllSubIds((Long)Long.parseLong(bizOrg.getPkValue().toString()), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (boolean)false);
        if (!CommonUtils.isNull((Object)orgIdlist)) {
            orgIdlist.add(Long.valueOf(bizOrg.getPkValue().toString()));
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgIdlist));
        }
    }

    public void beforeSelectOperator(BeforeF7SelectEvent e) {
        this.commonOperatorFilter(e, "bizorg", "bizoperatorgroup");
    }

    private void commonOperatorFilter(BeforeF7SelectEvent e, String orgkey, String operatorgroupkey) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue(orgkey);
        if (CommonUtils.isNull((Object)bizOrg)) {
            String displayName = this.getControlDisplayName(orgkey);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\u3002", (String)"ApplyBillBeforeF7SelectListener_4", (String)"scmc-im-formplugin", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        BasedataEdit control = (BasedataEdit)this.getView().getControl(operatorgroupkey);
        BasedataProp property = (BasedataProp)control.getProperty();
        FilterBuilder buildCoreFilter = property.buildCoreFilter(this.getModel());
        QFilter filterGridFilter = buildCoreFilter.getQFilter();
        long bizOrgId = Long.parseLong(bizOrg.getPkValue().toString());
        QFilter operatorGroupIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)bizOrgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map currentBizOrgBizOperatorGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{filterGridFilter, operatorGroupIdFilter, enableFilter});
        if (!CommonUtils.isNull((Object)currentBizOrgBizOperatorGroup)) {
            HashSet keySet = new HashSet(currentBizOrgBizOperatorGroup.keySet());
            QFilter qFilter = new QFilter("operatorgrpid", "in", new ArrayList(keySet));
            qFilter.and(new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue()));
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeSelectOperatorGroup(BeforeF7SelectEvent e) {
        this.commonOperatorGroupFilter(e, "bizorg", "bizoperator");
    }

    private void commonOperatorGroupFilter(BeforeF7SelectEvent e, String orgkey, String operatorkey) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue(orgkey);
        if (CommonUtils.isNull((Object)bizOrg)) {
            String displayName = this.getControlDisplayName(orgkey);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\u3002", (String)"ApplyBillBeforeF7SelectListener_4", (String)"scmc-im-formplugin", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        DynamicObject bizoperator = (DynamicObject)this.getModel().getValue(operatorkey);
        if (CommonUtils.isNull((Object)bizoperator)) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0));
        } else {
            bizoperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizoperator.getPkValue(), (String)"bd_operator");
            QFilter qFilter01 = new QFilter("operatorid", "=", bizoperator.getDynamicObject("operatorid").getPkValue());
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter01});
            if (map.size() != 0) {
                ArrayList list = new ArrayList(map.values());
                ArrayList<Long> groupList = new ArrayList<Long>();
                for (int i = 0; i < list.size(); ++i) {
                    groupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", groupList));
            }
        }
    }

    public void beforeSelectOrg(BeforeF7SelectEvent e) {
        String userID = RequestContext.get().getUserId();
        String entityName = this.getModel().getDataEntityType().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdList = PermissionServiceHelper.getAllPermissionOrgs((Long)Long.valueOf(userID), (String)appId, (String)entityName, (String)"47156aff000000ac");
        QFilter qFilter = new QFilter("id", "in", (Object)orgIdList);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void beforeSelectLocation(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        int rowindex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject warehouse = (DynamicObject)model.getValue("warehouse", rowindex);
        this.commonLocationFilter(warehouse, e);
    }

    private void commonLocationFilter(DynamicObject warehouse, BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (CommonUtils.isNull((Object)warehouse)) {
            e.setCancel(true);
        } else {
            QFilter qFilter = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol, String locationkey) {
        ArrayList<Long> ids = new ArrayList<Long>(locationCol.size());
        if (CommonUtils.isNull((Object)locationCol) || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject(locationkey);
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    public void beforeSelectUnit(BeforeF7SelectEvent e) {
        Object material;
        IDataModel bill = this.getModel();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Long masterMaterialId = 0L;
        Object masterMaterial = material = bill.getValue("material", rowIndex);
        if (MetaDataHelper.isExistField((IDataModel)bill, (String)"billentry", (String)"materialmasterid")) {
            masterMaterial = bill.getValue("materialmasterid", rowIndex);
        }
        masterMaterialId = masterMaterial instanceof DynamicObject ? (Long)((DynamicObject)masterMaterial).getPkValue() : (Long)masterMaterial;
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
        Long srcmuId = baseUnit == null ? Long.valueOf(0L) : Long.valueOf(baseUnit.getPkValue().toString());
        List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1", (Boolean)Boolean.TRUE);
        QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void beforeSelectMaterial(BeforeF7SelectEvent e) {
        IDataModel bill = this.getModel();
        DynamicObject org = (DynamicObject)bill.getValue("org");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject billType = (DynamicObject)bill.getValue("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"ApplyBillBeforeF7SelectListener_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        if (!CommonUtils.isNull((Object)org)) {
            QFilter qFilter = new QFilter("masterid.status", "=", (Object)"C");
            qFilter.and("masterid.enable", "=", (Object)"1").and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
            if (MetaDataHelper.isExistField((IDataModel)bill, (String)"biztype")) {
                DynamicObject bizType = (DynamicObject)bill.getValue("biztype");
                if (bizType == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ApplyBillBeforeF7SelectListener_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                }
                if (!CommonUtils.isNull((Object)bizType)) {
                    String domain;
                    Object value;
                    DynamicObject lineType = (DynamicObject)bill.getValue("linetype");
                    if (lineType == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u884c\u7c7b\u578b\u3002", (String)"ApplyBillBeforeF7SelectListener_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    }
                    QFilter[] qFilterByLineType = BillTypeMaterialHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)((Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (boolean)true);
                    if (qFilterByLineType != null && (value = qFilterByLineType[0].getValue()) != null && !value.equals(1)) {
                        QFilter serviceAttrFilter = QFilter.sqlExpress((String)"masterid.id", (String)"in", (String)(" ( select fid from t_bd_mtsserviceattribute where fbasedataid = " + value + " ) "));
                        qFilter.and(serviceAttrFilter);
                    }
                    if ("6".equals(domain = bizType.getString("domain"))) {
                        qFilter.and(MASTERID_ENABLEVMI, "=", (Object)Boolean.TRUE);
                    } else {
                        String bizCategory = bizType.getString("bizcategory");
                        List materialTypes = BizTypeHelper.getMaterialQFilterByBizCategory((String)bizCategory);
                        if (materialTypes.size() != 0) {
                            qFilter.and("masterid.materialtype", "in", (Object)materialTypes);
                        }
                    }
                }
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeSelectMaterialmasterid(BeforeF7SelectEvent e) {
        IDataModel bill = this.getModel();
        DynamicObject org = (DynamicObject)bill.getValue("org");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (!CommonUtils.isNull((Object)org)) {
            QFilter qFilter1 = new QFilter("status", "=", (Object)"C");
            QFilter qFilter2 = new QFilter("enable", "=", (Object)"1");
            if (MetaDataHelper.isExistField((IDataModel)bill, (String)"biztype")) {
                String bizCategory;
                List materialTypes;
                DynamicObject bizType = (DynamicObject)bill.getValue("biztype");
                if (!CommonUtils.isNull((Object)bizType) && (materialTypes = BizTypeHelper.getMaterialQFilterByBizCategory((String)(bizCategory = bizType.getString("bizcategory")))) != null && materialTypes.size() != 0) {
                    QFilter qFilter5 = new QFilter("materialtype", "in", (Object)materialTypes);
                    showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2, qFilter5));
                }
            } else {
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2));
            }
        }
    }

    public void beforeSelectLot(BeforeF7SelectEvent e, String fieldKey) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject selectEntry = model.getEntryRowEntity("billentry", rowIndex);
        String lotidField = "billentry." + fieldKey;
        LotMainFileHelper.setLotMainfFileF7Filter((BeforeF7SelectEvent)e, (DynamicObject)bill, (DynamicObject)selectEntry, (String)lotidField);
    }

    public void beforeSelectBiztype(BeforeF7SelectEvent e) {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"ApplyBillBeforeF7SelectListener_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String formid = this.getModel().getDataEntityType().getName();
        List bizTypeIds = BizTypeHelper.getBizTypeIds((Object)billType.getPkValue(), (String)formid);
        if (bizTypeIds != null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)bizTypeIds));
        }
    }

    private void beforeLineType(BeforeF7SelectEvent e, String formId) {
        LineTypeParam lineTypeParam;
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        ArrayList<Long> bizTypes = new ArrayList<Long>(16);
        List lineTypes = new ArrayList(16);
        if (bizType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ApplyBillBeforeF7SelectListener_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        bizTypes.add(bizType.getLong("id"));
        Map lineTypeByBillType = BillTypeMaterialHelper.getLineTypeByBillType(bizTypes);
        if (lineTypeByBillType.size() != 0 && (lineTypes = (List)(lineTypeParam = (LineTypeParam)lineTypeByBillType.get(bizType.getLong("id"))).getLineTypeQf()[0].getValue()) != null) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_linetype", (QFilter[])new QFilter("id", "in", lineTypes).toArray());
            Iterator iterator = lineTypes.iterator();
            while (iterator.hasNext()) {
                Long next = (Long)iterator.next();
                DynamicObject lineType = (DynamicObject)dynamicObjectMap.get(next);
                if (lineType == null) {
                    iterator.remove();
                    continue;
                }
                DynamicObject entity = lineType.getDynamicObject("serviceattribute").getDynamicObject("entity");
                String entityNum = entity.getString("number");
                if ("bd_material".equals(entityNum)) continue;
                iterator.remove();
            }
        }
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", lineTypes));
    }

    private String getControlDisplayName(String key) {
        BasedataEdit edit = (BasedataEdit)this.getView().getControl(key);
        if (edit == null) {
            return "";
        }
        IDataEntityProperty orgProp = edit.getProperty();
        LocaleString displayName = orgProp.getDisplayName();
        return displayName.toString();
    }

    private void applyUsertSelect(BeforeF7SelectEvent e, ListShowParameter showParameter, DynamicObject org) {
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u7ec4\u7ec7", (String)"MaterialReqBillPlugin_9", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        showParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        DynamicObject applyDept = (DynamicObject)this.getModel().getValue(APPLYDEPT);
        if (applyDept != null) {
            List orgidList = OrgHelper.getChildOrgId((String)this.getModel().getDataEntityType().getName(), (Long)((Long)applyDept.getPkValue()), (boolean)Boolean.TRUE, (String)APPLYDEPT);
            showParameter.getListFilterParameter().setFilter(new QFilter("entryentity.dpt", "in", (Object)orgidList));
        }
    }
}

