/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.transbill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.im.business.helper.ImBillEditHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.formplugin.ImApplyBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class TransApplyBill
extends ImApplyBillEditPlugin {
    private Map<Long, Long> orgOwnerCache = new HashMap<Long, Long>(16);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"inwarehouse", "inlocation", "warehouse", "location", "inorg", "outorg", "owner", "inowner"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.applyUserInit();
        this.bill = this.getBill(true);
        DynamicObject applyOrg = this.bill.getDynamicObject("org");
        if (null == applyOrg) {
            return;
        }
        DynamicObject bizType = this.getModel().getDataEntity().getDynamicObject("biztype");
        if (bizType != null && "6".equals(bizType.get("domain"))) {
            DynamicObject VMIInvType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invtype", (String)"number", (QFilter[])new QFilter("number", "=", (Object)"113").toArray());
            this.getModel().setValue("ownertype", (Object)"bd_supplier", 0);
            this.getModel().setValue("inownertype", (Object)"bos_org", 0);
            this.getModel().setValue("invtype", (Object)VMIInvType, 0);
        }
        String transType = this.bill.getString("transtype");
        boolean isStartInv = NewInvOrgHelper.isStartInv((Long)((Long)applyOrg.getPkValue()));
        this.initEntryRow(transType, 0, isStartInv);
        DynamicObject outOrg = (DynamicObject)this.getModel().getValue("outorg", 0);
        DynamicObject inOrg = (DynamicObject)this.getModel().getValue("inorg", 0);
        this.dealOwner(outOrg, 0);
        this.dealInOwner(inOrg, 0);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "bar_closestatus": {
                this.disableAll();
                break;
            }
            case "bar_unclosestatus": 
            case "unsubmit": 
            case "unaudit": {
                this.enableAll();
                this.handleEnable();
                break;
            }
        }
    }

    private void disableAll() {
        if ("D".equals(this.getModel().getValue("billstatus"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billentry", "org", "biztype", "transtype", "biztime", "applyuser", "settlecurrency", "comment", "applydept", "applyuser", "addrow", "deleterow", "fillbatch", "attachmentpanel"});
        }
    }

    private void enableAll() {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"billentry", "transtype", "biztime", "applyuser", "settlecurrency", "comment", "applydept", "applyuser", "addrow", "deleterow", "fillbatch", "attachmentpanel"});
        if (this.isDrawByBOTP()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"addrow"});
        }
    }

    @Override
    protected void setEnable4IsDraw(boolean isDraw) {
        super.setEnable4IsDraw(isDraw);
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(!isDraw), new String[]{"org", "biztype", "billtype"});
    }

    @Override
    protected void setEntryOtherEnable(DynamicObject billEntry, int rowIndex) {
        super.setEntryOtherEnable(billEntry, rowIndex);
        DynamicObject warehouse = billEntry.getDynamicObject("inwarehouse");
        if (warehouse != null) {
            boolean isOpenLocation = warehouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isOpenLocation), rowIndex, new String[]{"inlocation"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"inlocation"});
        }
        String transType = this.getModel().getDataEntity().getString("transtype");
        this.getView().setEnable(Boolean.valueOf("B".equals(transType)), rowIndex, new String[]{"inorg"});
    }

    @Override
    protected void setEntryRowEnable4IsDraw(int index, boolean isDraw) {
        super.setEntryRowEnable4IsDraw(index, isDraw);
    }

    private void initEntryRow(String transType, int row, boolean isStartInv) {
        if (row < 0 || null == transType) {
            return;
        }
        DynamicObject applyOrg = this.getModel().getDataEntity().getDynamicObject("org");
        if (isStartInv && "A".equals(transType)) {
            Object keeperType;
            this.getModel().setValue("outorg", (Object)(applyOrg == null ? null : applyOrg), row);
            this.getModel().setValue("inorg", (Object)(applyOrg == null ? null : applyOrg), row);
            Object inkeeperType = this.getModel().getValue("inkeepertype", row);
            if ("bos_org".equals(inkeeperType)) {
                this.getModel().setValue("inkeeper", applyOrg == null ? null : applyOrg.getPkValue(), row);
            }
            if ("bos_org".equals(keeperType = this.getModel().getValue("keepertype", row))) {
                this.getModel().setValue("keeper", applyOrg == null ? null : applyOrg.getPkValue(), row);
            }
        } else {
            this.getModel().setValue("outorg", null, row);
            this.getModel().setValue("inorg", null, row);
            this.getModel().setValue("inkeeper", null, row);
            this.getModel().setValue("keeper", null, row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"warehouse", "inwarehouse", "inowner"});
        }
        this.getView().setEnable(Boolean.valueOf("B".equals(transType)), row, new String[]{"inorg"});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"location"});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{"inlocation"});
    }

    private void dealOwner(DynamicObject org, int rowIndex) {
        if (org == null) {
            return;
        }
        Object OwnerType = this.getModel().getValue("ownertype", rowIndex);
        if ("bos_org".equals(OwnerType)) {
            Long ownerID = 0L;
            Long cacheOwnerId = this.orgOwnerCache.get((Long)org.getPkValue());
            if (cacheOwnerId != null) {
                ownerID = cacheOwnerId;
            } else {
                ownerID = (Long)OwnerHelper.getOwnerDefValue((Long)((Long)org.getPkValue()));
                this.orgOwnerCache.put((Long)org.getPkValue(), ownerID);
            }
            this.getModel().setValue("owner", (Object)ownerID, rowIndex);
        }
    }

    private void dealInOwner(DynamicObject org, int rowIndex) {
        if (org == null) {
            this.getModel().setValue("inowner", null, rowIndex);
            return;
        }
        Long ownerID = 0L;
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (org != null && billType != null) {
            Long cacheOwnerId = this.orgOwnerCache.get((Long)org.getPkValue());
            if (cacheOwnerId != null) {
                ownerID = cacheOwnerId;
            } else {
                ownerID = (Long)OwnerHelper.getOwnerDefValue((Long)((Long)org.getPkValue()));
                this.orgOwnerCache.put((Long)org.getPkValue(), ownerID);
            }
        }
        this.processTransBill(ownerID, billType, rowIndex);
    }

    private void processTransBill(Long ownerID, DynamicObject billType, int rowIndex) {
        Object inOwnerType = this.getModel().getValue("inownertype", rowIndex);
        if (!"bos_org".equals(inOwnerType)) {
            return;
        }
        String transType = this.getModel().getDataEntity().getString("transtype");
        if ("A".equals(transType)) {
            if (rowIndex != -1) {
                this.getModel().setValue("inowner", (Object)ownerID, rowIndex);
            } else {
                int rows = this.getModel().getEntryRowCount("billentry");
                for (int i = 0; i < rows; ++i) {
                    this.getModel().setValue("inowner", (Object)ownerID, i);
                }
            }
        } else {
            ownerID = 0L;
            DynamicObject inOrg = (DynamicObject)this.getModel().getValue("inorg", rowIndex);
            if (CommonUtils.isNull((Object)inOrg) || CommonUtils.isNull((Object)billType)) {
                return;
            }
            ownerID = (Long)OwnerHelper.getOwnerDefValue((Long)((Long)inOrg.getPkValue()));
            if (rowIndex != -1) {
                this.getModel().setValue("inowner", (Object)ownerID, rowIndex);
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rows = e.getRowDataEntities();
            DynamicObject VMIInvType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invtype", (String)"number", (QFilter[])new QFilter("number", "=", (Object)"113").toArray());
            for (RowDataEntity row : rows) {
                DynamicObject bizType;
                String transType = this.getModel().getDataEntity().getString("transtype");
                DynamicObject applyOrg = this.getModel().getDataEntity().getDynamicObject("org");
                boolean isStartInv = NewInvOrgHelper.isStartInv((Long)((Long)applyOrg.getPkValue()));
                this.initEntryRow(transType, row.getRowIndex(), isStartInv);
                DynamicObject outOrg = (DynamicObject)this.getModel().getValue("outorg", row.getRowIndex());
                if (!CommonUtils.isNull((Object)outOrg)) {
                    this.dealOwner(outOrg, row.getRowIndex());
                }
                if ((bizType = this.getModel().getDataEntity().getDynamicObject("biztype")) == null || !"6".equals(bizType.get("domain"))) continue;
                this.getModel().setValue("invtype", (Object)VMIInvType, row.getRowIndex());
                this.getModel().setValue("ownertype", (Object)"bd_supplier", row.getRowIndex());
                this.getModel().setValue("inownertype", (Object)"bos_org", row.getRowIndex());
            }
            int rowCount = this.getModel().getEntryRowCount("billentry");
            int curIndex = rowCount - 1;
            DynamicObject org = (DynamicObject)this.getModel().getValue("inorg", curIndex);
            this.dealInOwner(org, curIndex);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        if (!CommonUtils.isNull((Object)newValue) && newValue.equals(oldValue)) {
            return;
        }
        String key = e.getProperty().getName();
        int rowIndex = changeSet.getRowIndex();
        IDataModel model = this.getModel();
        DynamicObject outOrg = (DynamicObject)this.getModel().getValue("outorg");
        Object transType = this.getModel().getValue("transtype");
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "transtype": {
                boolean drawDyBotp = this.isDrawByBOTP();
                if (drawDyBotp) {
                    this.botpChange(newValue, model);
                    break;
                }
                this.changeTransType(newValue, model);
                break;
            }
            case "outorg": {
                this.changeOutOrg(newValue, rowIndex, model, transType);
                break;
            }
            case "inorg": {
                Object inOrgPK = newValue == null ? null : ((DynamicObject)newValue).getPkValue();
                Object inkeeperType = model.getValue("inkeepertype");
                model.setValue("inkeeper", "bos_org".equals(inkeeperType) ? inOrgPK : null, rowIndex);
                model.setValue("inwarehouse", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(newValue != null), rowIndex, new String[]{"inwarehouse", "inowner"});
                this.dealInOwner((DynamicObject)newValue, rowIndex);
                break;
            }
            case "warehouse": {
                model.setValue("location", null, rowIndex);
                this.dealLoaction(newValue, rowIndex, "location");
                break;
            }
            case "inwarehouse": {
                model.setValue("inlocation", null, rowIndex);
                this.dealLoaction(newValue, rowIndex, "inlocation");
                break;
            }
            case "ownertype": {
                DynamicObject bizType = model.getDataEntity().getDynamicObject("biztype");
                if (bizType != null && !"6".equals(bizType.get("domain"))) {
                    model.setValue("inownertype", newValue, rowIndex);
                }
                if ("bos_org".equals(newValue) && !CommonUtils.isNull((Object)outOrg)) {
                    int entryRowCount = this.getModel().getEntryRowCount("billentry");
                    for (int i = 0; i < entryRowCount; ++i) {
                        this.dealOwner(outOrg, i);
                    }
                }
                if (bizType == null || "6".equals(bizType.get("domain"))) break;
                model.setValue("inownertype", newValue, rowIndex);
                break;
            }
            case "inkeepertype": {
                if (!"bos_org".equals(newValue)) break;
                DynamicObject inOrg = (DynamicObject)model.getValue("inorg", rowIndex);
                model.setValue("inkeeper", inOrg == null ? null : inOrg.getPkValue(), rowIndex);
                break;
            }
            case "keepertype": {
                if (!"bos_org".equals(newValue)) break;
                outOrg = (DynamicObject)model.getValue("outorg", rowIndex);
                model.setValue("keeper", outOrg == null ? null : outOrg.getPkValue(), rowIndex);
                break;
            }
            case "inownertype": {
                if (!"bos_org".equals(newValue)) break;
                DynamicObject entryInOrg = null;
                entryInOrg = (DynamicObject)this.getModel().getValue("inorg", rowIndex);
                this.dealInOwner(entryInOrg, rowIndex);
                break;
            }
            case "entryinorg": {
                this.dealInOwner((DynamicObject)newValue, rowIndex);
                break;
            }
            case "owner": {
                Long inOwnerId;
                if (!"A".equals(transType)) break;
                Long l = inOwnerId = newValue == null ? null : (Long)((DynamicObject)newValue).getPkValue();
                if (this.getModel().getValue("inownertype", rowIndex) == null) break;
                this.getModel().setValue("inowner", (Object)inOwnerId, rowIndex);
                break;
            }
            case "applydept": {
                this.applyDeptChanged();
                break;
            }
        }
    }

    private void botpChange(Object newValue, IDataModel model) {
        this.clearFiled("warehouse");
        int count = model.getEntryRowCount("billentry");
        DynamicObject applyOrg = this.getModel().getDataEntity().getDynamicObject("org");
        boolean isStartInv = NewInvOrgHelper.isStartInv((Long)((Long)applyOrg.getPkValue()));
        for (int i = 0; i < count; ++i) {
            this.initEntryRowByBotp((String)newValue, i, isStartInv);
        }
    }

    private void initEntryRowByBotp(String transType, int row, boolean isStartInv) {
        if (row < 0 || null == transType) {
            return;
        }
        DynamicObject applyOrg = this.getModel().getDataEntity().getDynamicObject("org");
        if (isStartInv && "A".equals(transType)) {
            Object keeperType;
            this.getModel().setValue("outorg", (Object)(applyOrg == null ? null : applyOrg), row);
            Object inkeeperType = this.getModel().getValue("inkeepertype", row);
            if ("bos_org".equals(inkeeperType)) {
                this.getModel().setValue("inkeeper", applyOrg == null ? null : applyOrg.getPkValue(), row);
            }
            if ("bos_org".equals(keeperType = this.getModel().getValue("keepertype", row))) {
                this.getModel().setValue("keeper", applyOrg == null ? null : applyOrg.getPkValue(), row);
            }
        } else {
            this.getModel().setValue("outorg", null, row);
            this.getModel().setValue("inkeeper", null, row);
            this.getModel().setValue("keeper", null, row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"warehouse"});
        }
    }

    private void applyDeptChanged() {
        IDataModel model = this.getModel();
        DynamicObject applyDept = (DynamicObject)model.getValue("applydept");
        if (applyDept == null) {
            model.setValue("applyuser", null);
            return;
        }
        QFilter qFilter = new QFilter("entryentity.dpt", "=", applyDept.getPkValue());
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])qFilter.toArray());
        if (userMap == null || userMap.size() == 0) {
            model.setValue("applyuser", null);
            return;
        }
        String userId = RequestContext.get().getUserId();
        DynamicObject toUser = null;
        for (Map.Entry userEntry : userMap.entrySet()) {
            String userIdTmp = userEntry.getKey().toString();
            if (!userId.equals(userIdTmp)) continue;
            toUser = (DynamicObject)userEntry.getValue();
            break;
        }
        if (toUser == null) {
            toUser = (DynamicObject)userMap.entrySet().iterator().next().getValue();
        }
        model.setValue("applyuser", toUser);
    }

    private void changeOutOrg(Object newValue, int rowIndex, IDataModel model, Object transType) {
        Object keeperType;
        Object outOrgPK;
        model.setValue("warehouse", null, rowIndex);
        this.getView().setEnable(Boolean.valueOf(newValue != null), rowIndex, new String[]{"warehouse"});
        Object transtype = model.getValue("transtype");
        if (!CommonUtils.isNull((Object)newValue)) {
            this.dealOwner((DynamicObject)newValue, rowIndex);
        } else {
            this.getModel().setValue("owner", null, rowIndex);
        }
        Object object = outOrgPK = newValue == null ? null : ((DynamicObject)newValue).getPkValue();
        if ("A".equals(transtype)) {
            if ("A".equals(transType)) {
                model.setValue("inorg", outOrgPK, rowIndex);
            }
            this.dealInOwner((DynamicObject)newValue, rowIndex);
        }
        model.setValue("keeper", "bos_org".equals(keeperType = model.getValue("keepertype")) ? outOrgPK : null, rowIndex);
    }

    private void changeTransType(Object newValue, IDataModel model) {
        this.clearFiled("inwarehouse", "warehouse");
        int count = model.getEntryRowCount("billentry");
        DynamicObject applyOrg = this.getModel().getDataEntity().getDynamicObject("org");
        boolean isStartInv = NewInvOrgHelper.isStartInv((Long)((Long)applyOrg.getPkValue()));
        for (int i = 0; i < count; ++i) {
            this.initEntryRow((String)newValue, i, isStartInv);
        }
    }

    private boolean isDrawByBOTP() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        if (entrys == null || entrys.size() == 0) {
            return false;
        }
        DynamicObjectCollection linkColl = ((DynamicObject)entrys.get(0)).getDynamicObjectCollection("invbillentry_lk");
        return linkColl != null && linkColl.size() > 0;
    }

    private void clearFiled(String ... EntryFiled) {
        DynamicObjectCollection appEntry = this.getModel().getEntryEntity("billentry");
        if (null == appEntry || appEntry.size() == 0) {
            return;
        }
        for (int i = 0; i < appEntry.size(); ++i) {
            for (int j = 0; j < EntryFiled.length; ++j) {
                this.getModel().setValue(EntryFiled[j], null, i);
            }
        }
    }

    private void dealLoaction(Object newValue, int rowIndex, String location) {
        if (null == newValue) {
            this.getModel().setValue(location, null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{location});
            return;
        }
        boolean isopenlocation = ((DynamicObject)newValue).getBoolean("isopenlocation");
        this.getView().setEnable(Boolean.valueOf(isopenlocation), rowIndex, new String[]{location});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        String transType = (String)this.getModel().getValue("transtype");
        boolean isMainOrg = ImBillEditHelper.isMainOrgByF7((IFormView)this.getView(), (IDataModel)this.getModel(), (String)fieldKey);
        if (!isMainOrg) {
            e.setCancel(true);
            return;
        }
        switch (fieldKey) {
            case "inorg": {
                DynamicObject outOrg = (DynamicObject)this.getModel().getValue("outorg", e.getRow());
                this.beforeInOrOutOrgSelect(outOrg, qFilters, transType);
                break;
            }
            case "outorg": {
                DynamicObject inOrg = (DynamicObject)this.getModel().getValue("inorg", e.getRow());
                this.beforeInOrOutOrgSelect(inOrg, qFilters, transType);
                break;
            }
            case "warehouse": {
                IDataModel model = this.getModel();
                DynamicObject org = (DynamicObject)model.getValue("outorg", e.getRow());
                this.commonWareHouseFilter(org, e);
                break;
            }
            case "org": {
                this.beforeSelectOrg(e);
                break;
            }
            default: {
                super.beforeF7Select(e);
            }
        }
    }

    private void beforeInOrOutOrgSelect(DynamicObject inOrOutOrg, List<QFilter> qFilters, String transType) {
        List orgList = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"05", (boolean)false);
        qFilters.add(new QFilter("id", "in", (Object)orgList));
        if (inOrOutOrg != null && "B".equals(transType)) {
            qFilters.add(new QFilter("id", "!=", inOrOutOrg.getPkValue()));
        }
        QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
        Map tempInvAccs = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
        ArrayList<Object> orgIds = new ArrayList<Object>(tempInvAccs.size());
        for (DynamicObject tempInvAcc : tempInvAccs.values()) {
            DynamicObject org = tempInvAcc.getDynamicObject("org");
            if (org == null) continue;
            orgIds.add(org.getPkValue());
        }
        if (!orgIds.isEmpty()) {
            qFilters.add(new QFilter("id", "in", orgIds));
        }
    }

    public void beforeSelectOrg(BeforeF7SelectEvent e) {
        String userID = RequestContext.get().getUserId();
        String entityName = this.getModel().getDataEntityType().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdList = PermissionServiceHelper.getAllPermissionOrgs((Long)Long.valueOf(userID), (String)appId, (String)entityName, (String)"47156aff000000ac");
        QFilter qFilter = new QFilter("id", "in", (Object)orgIdList);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void commonWareHouseFilter(DynamicObject org, BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (CommonUtils.isNull((Object)org)) {
            e.setCancel(true);
        } else {
            String formId = this.getModel().getDataEntityType().getName();
            IDataModel bill = this.getModel();
            int rowIdx = bill.getEntryCurrentRowIndex("billentry");
            DynamicObject row = bill.getEntryRowEntity("billentry", rowIdx);
            WareHouseIsolateHelper.setWarehouseQFilterByDataCtrl((Long)org.getLong("id"), (ListShowParameter)showParameter, (String)formId, (DynamicObject)row, (String)"billentry.warehouse");
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        IDataModel model = this.getModel();
        for (int i = 0; i < entryRowCount; ++i) {
            this.dealLoaction((DynamicObject)model.getValue("warehouse", i), i, "location");
            this.dealLoaction((DynamicObject)model.getValue("inwarehouse", i), i, "inlocation");
        }
        DynamicObject applyOrg = this.getModel().getDataEntity().getDynamicObject("org");
        if (null == applyOrg) {
            return;
        }
        String transType = this.getModel().getDataEntity().getString("transtype");
        int rows = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rows; ++i) {
            this.getView().setEnable(Boolean.valueOf("B".equals(transType)), i, new String[]{"inorg"});
        }
        String status = (String)this.getModel().getValue("billstatus");
        if ("D".equals(status)) {
            this.disableAll();
        } else if ("A".equals(status)) {
            this.enableAll();
        }
    }

    @Override
    public void afterCopyData(EventObject e) {
        this.enableAll();
    }

    @Override
    protected String getEntryLinkName() {
        return "invbillentry_lk";
    }
}

