/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.transbill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.im.business.helper.ImBillEditHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MaterialWhRelationHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.transbill.AbstractTransBill;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;
import kd.scmc.im.utils.IMStringUtils;
import org.apache.commons.lang3.StringUtils;

public class TransBillDir
extends AbstractTransBill {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"warehouse", "location", "outwarehouse", "outlocation", "outowner", "owner", "keeper", "outkeeper", "outorg", "org", "inlot"});
        this.addClickListeners(new String[]{"inlotnumber"});
    }

    @Override
    public void afterBindData(EventObject e) {
        String bizDirection;
        DynamicObject invScheme;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        view.setEnable(Boolean.FALSE, new String[]{"outoperatorgroup"});
        Object transType = model.getValue("transtype");
        if ("A".equals(transType)) {
            view.setEnable(Boolean.FALSE, new String[]{"org"});
        }
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        ArrayList<String> errMsg = new ArrayList<String>();
        for (int i = 0; i < entryRowCount; ++i) {
            this.updateEnableLocation("outlocation", (DynamicObject)model.getValue("outwarehouse", i), i);
        }
        if (this.isDrawByBOTP() && (invScheme = (DynamicObject)model.getValue("invscheme")) != null && "1".equals(bizDirection = invScheme.getString("bizdirection"))) {
            view.setEnable(Boolean.valueOf(false), new String[]{"transtype"});
        }
        this.multiInLot4Enable(errMsg, entryRowCount, false);
        if (errMsg.isEmpty()) {
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        String notification = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_INORG_NOT_MATERIALINFO(), (Object[])new Object[]{String.join((CharSequence)",", errMsg), org.getString("name")});
        this.getView().showErrorNotification(notification);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue(this.getTransInOrgKey());
        boolean orgIsNull = CommonUtils.isNull((Object)org);
        if (!orgIsNull) {
            String transType = this.getModel().getDataEntity().getString("transtype");
            this.setOrg(transType);
        }
        DynamicObject outorg = (DynamicObject)this.getModel().getValue(this.getTransOutOrgKey());
        this.setSettleCurrency(outorg);
        this.initOutOperatorAndGroup();
        this.initEntry(org, outorg);
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"inlotnumber"});
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"inlot"});
    }

    private void initOutOperatorAndGroup() {
        Object operatorGroup;
        Object operator = this.getModel().getValue("operator");
        if (operator instanceof DynamicObject) {
            this.getModel().setValue("outoperator", ((DynamicObject)operator).getPkValue());
        }
        if ((operatorGroup = this.getModel().getValue("operatorgroup")) instanceof DynamicObject) {
            this.getModel().setValue("outoperatorgroup", ((DynamicObject)operatorGroup).getPkValue());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ArrayList<String> errMsg;
        if (!this.isPropertyChange(e)) {
            return;
        }
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        int index = changeSet.getRowIndex();
        if (!CommonUtils.isNull((Object)newValue) && newValue.equals(oldValue)) {
            return;
        }
        String key = e.getProperty().getName();
        this.updateLogisticBill(key);
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "outorg": {
                this.changeOutorg(e);
                break;
            }
            case "org": {
                this.changeOrg(e);
                break;
            }
            case "transtype": {
                this.changeTranstype(e);
                break;
            }
            case "owner": {
                this.changeOwner(e);
                break;
            }
            case "invscheme": {
                this.changeInvScheme(e);
                break;
            }
            case "isfreegift": {
                this.changeIsPresent(newValue, index);
                break;
            }
            case "outinvtype": {
                this.changeOutinvtype(e, newValue, index);
                break;
            }
            case "inlot": {
                this.changeLot(e, key, index);
                break;
            }
            case "inlotnumber": {
                this.changeInLotNumber(index);
                break;
            }
            case "outinvstatus": {
                this.changeOutinvstatus(newValue, index);
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
        if (key.equalsIgnoreCase("material")) {
            this.getModel().setValue("inlotnumber", null, index);
            this.getModel().setValue("inlot", (Object)null, index);
            errMsg = new ArrayList();
            this.inLot4Enable(index, (DynamicObject)newValue, errMsg);
            if (!errMsg.isEmpty()) {
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                String notification = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_INORG_NOT_MATERIALINFO(), (Object[])new Object[]{String.join((CharSequence)",", errMsg), org.getString("name")});
                this.getView().showErrorNotification(notification);
                return;
            }
        }
        if (key.equalsIgnoreCase("org")) {
            errMsg = new ArrayList<String>();
            this.changeInOrg(newValue, oldValue, index, errMsg);
            if (!errMsg.isEmpty()) {
                return;
            }
        }
        String transType = (String)this.getModel().getValue("transtype");
        if (key.equalsIgnoreCase("lotnumber") && "A".equals(transType)) {
            this.getModel().setValue("inlotnumber", this.getModel().getValue("lotnumber", index), index);
            this.getModel().setValue("inlot", this.getModel().getValue("lot", index), index);
        }
        if (key.toLowerCase(Locale.ENGLISH).equals("lot") && "A".equals(transType)) {
            this.getModel().setValue("inlotnumber", this.getModel().getValue("lotnumber", index), index);
            this.getModel().setValue("inlot", this.getModel().getValue("lot", index), index);
        }
    }

    private void changeLot(PropertyChangedArgs e, String fieldKey, int index) {
        String entryName = "billentry";
        String lotidField = "billentry." + fieldKey;
        String lotnumberField = "inlotnumber";
        LotMainFileHelper.changeLot((PropertyChangedArgs)e, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)entryName, (int)index, (String)lotidField, (String)lotnumberField);
    }

    private void changeInLotNumber(int rowIndex) {
        this.relInLotNumberSpace(rowIndex);
        this.setValue("inlot", null, rowIndex, false);
    }

    private void inLot4Enable(int index, DynamicObject material, List<String> errMsg) {
        String transType = (String)this.getModel().getValue("transtype");
        this.setLotValue(transType, index);
        this.setLotEnable(index, material);
        if ("A".equals(transType) || material == null) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
        DynamicObject[] materialinventory = BusinessDataServiceHelper.load((String)"bd_materialinventoryinfo", (String)"enablelot,ctrlstrategy", (QFilter[])new QFilter[]{new QFilter("masterid.id", "=", (Object)material.getLong("masterid.id")), baseDataFilter});
        this.dealWithMaterialStrategy(materialinventory, material, errMsg, index);
    }

    private void changeInOrg(Object newValue, Object oldValue, int index, List<String> errMsg) {
        int i;
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        ArrayList<Object> ids = new ArrayList<Object>(entryRowCount);
        for (int i2 = 0; i2 < entryRowCount; ++i2) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", i2);
            if (material == null) continue;
            ids.add(material.get("masterid.id"));
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        HashMap<Object, Set<DynamicObject>> masterIdToInvsMap = new HashMap<Object, Set<DynamicObject>>(entryRowCount);
        this.getMaterialInvs(org, ids, masterIdToInvsMap);
        for (i = 0; i < entryRowCount; ++i) {
            Set materialInvs;
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", i);
            if (material == null || (materialInvs = (Set)masterIdToInvsMap.get(material.get("masterid.id"))) != null && materialInvs.size() != 0) continue;
            errMsg.add(material.getString("masterid.name"));
        }
        if (!errMsg.isEmpty()) {
            if (org == null) {
                for (i = 0; i < entryRowCount; ++i) {
                    this.getModel().setValue("inlotnumber", null, i);
                    this.getModel().setValue("inlot", (Object)0, i);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"inlotnumber", "inlot"});
                }
                return;
            }
            ConfirmCallBackListener cb = new ConfirmCallBackListener("clearMaterialInfo", (IFormPlugin)this);
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(4);
            confirmInfo.put("oldvalue", oldValue == null ? null : ((DynamicObject)oldValue).getPkValue());
            confirmInfo.put("newvalue", newValue == null ? null : ((DynamicObject)newValue).getPkValue());
            confirmInfo.put("rowcount", entryRowCount);
            String notification = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_INORG_NOT_MATERIALINFO(), (Object[])new Object[]{String.join((CharSequence)",", errMsg), org.getString("name")});
            this.getView().showConfirm(IMStringUtils.append((String)notification, (Object[])new Object[]{ResManager.loadKDString((String)"\u786e\u8ba4\u6e05\u9664\u7269\u6599\u884c\u4fe1\u606f\uff1f", (String)"TransDirBillClearMatetial_0", (String)"scmc-im-formplugin", (Object[])new Object[0])}), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            String transType = (String)this.getModel().getValue("transtype");
            for (int i3 = 0; i3 < entryRowCount; ++i3) {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", i3);
                this.setLotValue(transType, i3);
                this.setLotEnable(i3, material);
                if (material == null || org == null) continue;
                Set materialInvs = (Set)masterIdToInvsMap.get(material.get("masterid.id"));
                DynamicObject[] array = materialInvs == null ? new DynamicObject[]{} : materialInvs.toArray(new DynamicObject[0]);
                this.dealWithMaterialStrategy(array, material, new ArrayList<String>(), i3);
            }
        }
    }

    private void multiInLot4Enable(List<String> errMsg, int entryRowCount, boolean setLotValue) {
        String transType = (String)this.getModel().getValue("transtype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Object> ids = new ArrayList<Object>(entryRowCount);
        for (int index = 0; index < entryRowCount; ++index) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", index);
            if (setLotValue) {
                this.setLotValue(transType, index);
            }
            this.setLotEnable(index, material);
            if (material == null) continue;
            ids.add(material.get("masterid.id"));
        }
        if (org == null || "A".equals(transType)) {
            return;
        }
        HashMap<Object, Set<DynamicObject>> masterIdToInvsMap = new HashMap<Object, Set<DynamicObject>>(entryRowCount);
        this.getMaterialInvs(org, ids, masterIdToInvsMap);
        for (int index = 0; index < entryRowCount; ++index) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", index);
            if (material == null) continue;
            Set materialInvs = (Set)masterIdToInvsMap.get(material.get("masterid.id"));
            DynamicObject[] array = materialInvs == null ? new DynamicObject[]{} : materialInvs.toArray(new DynamicObject[0]);
            this.dealWithMaterialStrategy(array, material, errMsg, index);
        }
    }

    private void setLotEnable(int index, DynamicObject material) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject outOrg = (DynamicObject)this.getModel().getValue("outorg");
        boolean enableInLot = org != null && material != null && material.getBoolean("enablelot");
        boolean enableOutLot = outOrg != null && material != null && material.getBoolean("enablelot");
        this.getView().setEnable(Boolean.valueOf(enableInLot), index, new String[]{"inlotnumber", "inlot"});
        this.getView().setEnable(Boolean.valueOf(enableOutLot), index, new String[]{"lotnumber"});
    }

    private void setLotValue(String transType, int index) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject outOrg = (DynamicObject)this.getModel().getValue("outorg");
        if (org == null) {
            this.getModel().setValue("inlotnumber", null, index);
            this.getModel().setValue("inlot", (Object)0, index);
        }
        if (outOrg == null) {
            this.getModel().setValue("lotnumber", null, index);
            this.getModel().setValue("lot", (Object)0, index);
        }
        if (outOrg == null || org == null) {
            return;
        }
        if ("A".equals(transType)) {
            this.getModel().setValue("inlotnumber", this.getModel().getValue("lotnumber", index), index);
            this.getModel().setValue("inlot", this.getModel().getValue("lot", index), index);
        }
    }

    private void dealWithMaterialStrategy(DynamicObject[] materialinventory, DynamicObject material, List<String> errMsg, int index) {
        if (materialinventory == null || materialinventory.length == 0) {
            errMsg.add(material.getString("masterid.name"));
            this.getModel().setValue("material", null, index);
            return;
        }
        DynamicObject materialInfo = materialinventory[0];
        String privateCtrlStrategy = "7";
        for (DynamicObject dynamicObject : materialinventory) {
            String ctrlStrategy = dynamicObject.getString("ctrlstrategy");
            if (!privateCtrlStrategy.equals(ctrlStrategy)) continue;
            materialInfo = dynamicObject;
            break;
        }
        boolean enableLot = materialInfo.getBoolean("enablelot");
        this.getView().setEnable(Boolean.valueOf(enableLot), index, new String[]{"inlotnumber"});
        this.getView().setEnable(Boolean.valueOf(enableLot), index, new String[]{"inlot"});
    }

    private void getMaterialInvs(DynamicObject org, List<Object> ids, Map<Object, Set<DynamicObject>> masterIdToInvsMap) {
        DynamicObject[] materialInventory;
        if (org == null) {
            return;
        }
        QFilter enableF = new QFilter("enable", "=", (Object)true);
        QFilter auditF = new QFilter("status", "=", (Object)"C");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
        for (DynamicObject materialInv : materialInventory = BusinessDataServiceHelper.load((String)"bd_materialinventoryinfo", (String)"enablelot,ctrlstrategy", (QFilter[])new QFilter[]{new QFilter("masterid.id", "in", ids), baseDataFilter, enableF, auditF})) {
            Object masterId = materialInv.get("masterid.id");
            Set set = masterIdToInvsMap.computeIfAbsent(masterId, key -> new HashSet());
            set.add(materialInv);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if ("clearMaterialInfo".equals(callBackId)) {
            String customValue = e.getCustomVaule();
            if (StringUtils.isBlank((CharSequence)customValue)) {
                return;
            }
            Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
            if (MessageBoxResult.Yes.equals((Object)result)) {
                Object rowCount = confirmInfo.get("rowcount");
                if (rowCount != null) {
                    this.multiInLot4Enable(new ArrayList<String>(), Integer.parseInt(rowCount.toString()), true);
                }
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("org", confirmInfo.get("oldvalue"));
                this.getView().updateView("org");
                this.getModel().endInit();
            }
        }
    }

    @Override
    protected void changeInvScheme(PropertyChangedArgs e) {
        DynamicObject invScheme;
        super.changeInvScheme(e);
        DynamicObject inorg = (DynamicObject)this.getModel().getValue(this.getTransInOrgKey());
        DynamicObject outorg = (DynamicObject)this.getModel().getValue(this.getTransOutOrgKey());
        if (this.isDrawByBOTP() && (invScheme = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            String bizDirection = invScheme.getString("bizdirection");
            if ("1".equals(bizDirection)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"transtype"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"transtype"});
            }
        }
        this.initEntry(inorg, outorg);
    }

    protected void changeTranstype(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        this.setOrg(newValue);
        this.clearDTFiled("warehouse");
    }

    private void setOrg(Object transType) {
        IDataModel model = this.getModel();
        DynamicObject outOrg = model.getDataEntity().getDynamicObject(this.getTransOutOrgKey());
        if (CommonUtils.isNull((Object)outOrg) || CommonUtils.isNull((Object)transType)) {
            return;
        }
        boolean isInv = outOrg.getBoolean("fisinventory");
        if (isInv && "A".equals(transType)) {
            model.setValue("org", (Object)outOrg);
            this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
        } else {
            model.setValue("org", null);
            model.setValue("dept", null);
            model.setValue("operator", null);
            model.setValue("operatorgroup", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"org"});
        }
    }

    protected void changeOrg(PropertyChangedArgs e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue(this.getTransInOrgKey());
        this.setDeptByOrg(org, "dept");
        this.clearDTFiled("warehouse");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entry.size(); ++i) {
            this.dealKeeper("keepertype", i);
            this.dealOwner("ownertype", i);
            this.getView().setEnable(Boolean.valueOf(org != null), i, new String[]{"warehouse", "owner"});
        }
        this.getView().sendFormAction(this.getView());
    }

    private void setDeptByOrg(DynamicObject org, String dept) {
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
            if (deptIds != null && deptIds.size() > 0) {
                this.getModel().setValue(dept, deptIds.get(0));
                return;
            }
            deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
            if (deptIds != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
                this.getModel().setValue(dept, (Object)orgId);
            }
        }
    }

    protected void changeOwner(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        int index = changeSet.getRowIndex();
        Object transType = this.getModel().getValue("transtype");
        if ("A".equals(transType)) {
            Long inOwnerId;
            Long l = inOwnerId = newValue == null ? null : (Long)((DynamicObject)newValue).getPkValue();
            if (this.getModel().getValue("ownertype", index) != null) {
                this.getModel().setValue("owner", (Object)inOwnerId, index);
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "scmcgenlotnum": {
                Object org;
                String transType = (String)this.getModel().getValue("transtype");
                if (!"B".equals(transType) || null != (org = this.getModel().getValue("org"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u5165\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u8c03\u5165\u7ec4\u7ec7\u3002", (String)"TransBillDir_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        boolean isMainOrg = ImBillEditHelper.isMainOrgByF7((IFormView)this.getView(), (IDataModel)this.getModel(), (String)fieldKey);
        if (!isMainOrg) {
            e.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "org": {
                this.beforeSelectOrg(e);
                break;
            }
            case "outorg": {
                this.beforeSelectOutOrg(e);
                break;
            }
            case "material": {
                this.beforeSelectMaterial(e);
                MaterialWhRelationHelper.addWarehouseSetupFilter((BeforeF7SelectEvent)e, (ListShowParameter)showParameter, (IDataModel)this.getModel(), (String)"warehouse");
                break;
            }
            case "inlot": {
                this.beforeSelectInlot(e, fieldKey);
                break;
            }
            case "outowner": {
                this.beforeSelectOutOwner(e);
            }
            default: {
                super.beforeF7Select(e);
            }
        }
    }

    public void beforeSelectOutOwner(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        int rowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getModel().getValue("outownertype", rowIndex);
        DynamicObject bizType = this.getModel().getDataEntity().getDynamicObject("biztype");
        if ("bd_supplier".equals(type) && bizType != null && "6".equals(bizType.get("domain"))) {
            QFilter f = new QFilter("enablevmi", "=", (Object)Boolean.TRUE);
            showParameter.getListFilterParameter().setFilter(f);
        }
    }

    private void beforeSelectInlot(BeforeF7SelectEvent e, String fieldKey) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject selectEntry = model.getEntryRowEntity("billentry", rowIndex);
        String lotidField = "billentry." + fieldKey;
        LotMainFileHelper.setLotMainfFileF7Filter((BeforeF7SelectEvent)e, (DynamicObject)bill, (DynamicObject)selectEntry, (String)lotidField);
    }

    private void beforeSelectMaterial(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (org == null) {
            QFilter orgFilter = new QFilter("'1'", "!=", (Object)"'1'");
            showParameter.getListFilterParameter().getQFilters().add(orgFilter);
        } else {
            Object domain;
            Object value;
            DynamicObject billType = (DynamicObject)model.getValue("billtype");
            if (billType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"ImBillBeforeF7Select_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            DynamicObject bizType = (DynamicObject)model.getValue("biztype");
            if (bizType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ImBillBeforeF7Select_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            DynamicObject lineType = (DynamicObject)model.getValue("linetype");
            if (lineType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u884c\u7c7b\u578b\u3002", (String)"ImBillBeforeF7Select_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("masterid.status", "=", (Object)"C");
            qFilter.and("masterid.enable", "=", (Object)"1");
            QFilter[] qFilterByLineType = BillTypeMaterialHelper.getQFilterByLineType((Long)billType.getLong("id"), (Long)bizType.getLong("id"), (Long)lineType.getLong("id"), (boolean)true);
            if (qFilterByLineType != null && (value = qFilterByLineType[0].getValue()) != null && !value.equals(1)) {
                QFilter serviceAttrFilter = QFilter.sqlExpress((String)"masterid.id", (String)"in", (String)(" ( select fid from t_bd_mtsserviceattribute where fbasedataid = " + value + " ) "));
                qFilter.and(serviceAttrFilter);
            }
            if ("6".equals(domain = bizType.get("domain"))) {
                qFilter.and("masterid.enablevmi", "=", (Object)Boolean.TRUE);
            }
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    protected void beforeSelectOrg(BeforeF7SelectEvent e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("outorg");
        QFilter qFilter = null;
        if (org != null) {
            qFilter = new QFilter("id", "!=", org.getPkValue());
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter invFilter = new QFilter("startstatus", "=", (Object)"B");
        Map tempInvAccs = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{invFilter});
        ArrayList<Object> orgIds = new ArrayList<Object>(tempInvAccs.size());
        for (DynamicObject tempInvAcc : tempInvAccs.values()) {
            DynamicObject invOrg = tempInvAcc.getDynamicObject("org");
            if (invOrg == null) continue;
            orgIds.add(invOrg.getPkValue());
        }
        if (!orgIds.isEmpty()) {
            if (qFilter == null) {
                qFilter = new QFilter("id", "in", orgIds);
            } else {
                qFilter.and("id", "in", orgIds);
            }
        }
        if (qFilter != null) {
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
        showParameter.setCustomParam("orgFuncId", (Object)"05");
    }

    protected void beforeSelectOutOrg(BeforeF7SelectEvent e) {
        String formid = this.getModel().getDataEntityType().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formid, (String)this.getView().getFormShowParameter().getAppId());
        QFilter filter = new QFilter("id", "in", (Object)orgIdList);
        showParameter.getListFilterParameter().setFilter(filter);
    }

    @Override
    protected String getTransOutOrgKey() {
        return "outorg";
    }

    @Override
    protected String getTransInOrgKey() {
        return "org";
    }

    @Override
    protected void initEntry(DynamicObject inorg, DynamicObject outorg) {
        super.initEntry(inorg, outorg);
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            String location = "outlocation";
            this.updateEnableLocation(location, (DynamicObject)this.getModel().getValue("outwarehouse", i), i);
        }
    }

    private void initPriceField(boolean isPresent, int rowIndex) {
        IFormView view = this.getView();
        boolean isEnable = !isPresent;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"price"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amount"});
    }

    @Override
    protected void setBillEntryEnable(RowDataEntity row) {
        super.setBillEntryEnable(row);
        DynamicObject dynamicObject = row.getDataEntity();
        Boolean isPresent = dynamicObject.getBoolean("isfreegift");
        int rowIndex = row.getRowIndex();
        this.initPriceField(isPresent, rowIndex);
        DynamicObject stockMaterial = dynamicObject.getDynamicObject("material");
        if (stockMaterial == null) {
            return;
        }
        boolean enableLot = stockMaterial.getBoolean("enablelot");
        Object org = this.getModel().getValue("org");
        this.getView().setEnable(Boolean.valueOf(enableLot), rowIndex, new String[]{"lotnumber", "lot"});
        this.getView().setEnable(Boolean.valueOf(enableLot && org != null), rowIndex, new String[]{"inlotnumber", "inlot"});
        DynamicObject warehouse = dynamicObject.getDynamicObject("outwarehouse");
        boolean isOpenLocation = warehouse != null && warehouse.getBoolean("isopenlocation");
        this.getView().setEnable(Boolean.valueOf(isOpenLocation), rowIndex, new String[]{"outlocation"});
    }

    @Override
    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        IFormView view = this.getView();
        int index = row.getRowIndex();
        if (isDraw) {
            view.setEnable(Boolean.valueOf(!isDraw), index, new String[]{"isfreegift"});
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)newValue;
        this.initPriceField(isPresent, rowIndex);
        if (isPresent) {
            model.setValue("price", (Object)Constants.ZERO, rowIndex);
            model.setValue("amount", (Object)Constants.ZERO, rowIndex);
        }
    }

    private void changeOutinvstatus(Object newValue, int rowIndex) {
        if (newValue == null) {
            return;
        }
        IDataModel bill = this.getModel();
        DynamicObject dynewValue = (DynamicObject)newValue;
        String masterid = String.valueOf(dynewValue.get("masterid"));
        if (masterid != null) {
            DynamicObject scheme = (DynamicObject)bill.getValue("invscheme");
            DynamicObjectCollection invstatusentry = scheme.getDynamicObjectCollection("invstatusentry");
            for (DynamicObject dynamicObject : invstatusentry) {
                DynamicObject invstatus = dynamicObject.getDynamicObject("invstatus");
                String smasterid = String.valueOf(invstatus.get("masterid"));
                if (!masterid.equals(smasterid)) continue;
                this.getModel().setValue("invstatus", newValue, rowIndex);
            }
        }
    }

    private void changeOutinvtype(PropertyChangedArgs e, Object newValue, int rowIndex) {
        super.propertyChanged(e);
        if (newValue == null) {
            return;
        }
        IDataModel bill = this.getModel();
        DynamicObject dynewValue = (DynamicObject)newValue;
        String masterid = String.valueOf(dynewValue.get("masterid"));
        if (masterid != null) {
            DynamicObject scheme = (DynamicObject)bill.getValue("invscheme");
            DynamicObjectCollection invtypeentry = scheme.getDynamicObjectCollection("invtypeentry");
            for (DynamicObject dynamicObject : invtypeentry) {
                DynamicObject invtype = dynamicObject.getDynamicObject("invtype");
                String smasterid = String.valueOf(invtype.get("masterid"));
                if (!masterid.equals(smasterid)) continue;
                this.getModel().setValue("invtype", newValue, rowIndex);
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue(this.getTransInOrgKey());
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                this.getView().setEnable(Boolean.valueOf(org != null), row.getRowIndex(), new String[]{"warehouse", "owner"});
                this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"lotnumber", "inlotnumber", "inlot", "outlocation", "location"});
            }
        }
    }

    private void relInLotNumberSpace(int row) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("billentry", row);
        String lotnumber = dynamicObject.getString("inlotnumber");
        if (lotnumber != null) {
            lotnumber = lotnumber.replaceAll("\u3000", " ").trim();
            this.setValue("inlotnumber", lotnumber, row, false);
        }
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        this.multiInLot4Enable(new ArrayList<String>(), entryRowCount, false);
    }
}

