/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.transbill;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.FillBatchHelper;
import kd.scmc.im.business.helper.ImBillEditHelper;
import kd.scmc.im.business.helper.InverseBillHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.formplugin.transbill.AbstractTransBill;
import kd.scmc.im.formplugin.transbill.TransBillCommonBeforeF7SelectListener;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class TransBillSetpIn
extends AbstractTransBill {
    public static final String BTN_GENERATELOT = "generatelot";
    protected static final Log logger = LogFactory.getLog(TransBillSetpIn.class);

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String opKey = FormUtils.getOpKey((BeforeDoOperationEventArgs)e);
        if ("draw".equals(opKey)) {
            this.getPageCache().put("drawfromstepin", "true");
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"owner", "outowner", "keeper", "outkeeper", "warehouse", "location", "outorg", "org", "outwarehouse", "outlocation", "transitowner"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject inorg = (DynamicObject)this.getModel().getValue(this.getTransInOrgKey());
        DynamicObject outorg = this.getModel().getDataEntity().getDynamicObject(this.getTransOutOrgKey());
        if (inorg != null) {
            String transType = this.getModel().getDataEntity().getString("transtype");
            this.setOrg(transType);
        }
        this.setSettleCurrency(outorg);
        this.initEntry(inorg, outorg);
        this.updateTransitOwner();
        this.initInWarehouse();
    }

    private void initInWarehouse() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.updateEnableLocation("outlocation", (DynamicObject)this.getModel().getValue("outwarehouse", i), i);
        }
    }

    @Override
    protected String getEntryLinkName() {
        return "invbillentry_lk";
    }

    private void setOrg(String transType) {
        DynamicObject inOrg = this.getModel().getDataEntity().getDynamicObject(this.getTransInOrgKey());
        if (inOrg != null && StringUtils.isNotBlank((CharSequence)transType)) {
            boolean isInv = inOrg.getBoolean("fisinventory");
            if (isInv && "A".equals(transType)) {
                this.getModel().setValue(this.getTransOutOrgKey(), (Object)inOrg);
            } else {
                this.getModel().setValue(this.getTransOutOrgKey(), null);
            }
        }
    }

    private void setOutOrgEnable() {
        String transType = this.getModel().getDataEntity().getString("transtype");
        boolean transInOrg = "A".equals(transType);
        this.getView().setEnable(Boolean.valueOf(!transInOrg), new String[]{this.getTransOutOrgKey()});
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!"fillbatch".equals(itemKey)) {
            super.itemClick(evt);
        }
        if ("A".equals(this.getModel().getValue("billstatus")) && "fillbatch".equals(itemKey)) {
            FillBatchHelper.batchFill((IFormView)this.getView());
        }
        if ("fillbatch".equals(itemKey)) {
            this.update2OverTrans();
        }
    }

    private void update2OverTrans() {
        int index = this.getModel().getEntryCurrentRowIndex("billentry");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        String selKey = entryGrid.getEntryState().getFocusField();
        if (!"isovertrans".equals(selKey)) {
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("billentry");
        if (index == -1 || StringUtils.isBlank((CharSequence)selKey) || "0".equals(selKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u5143\u683c\u3002", (String)"TransBillSetpIn_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        Object selValue = this.getModel().getValue(selKey, index);
        if (CommonUtils.isNull((Object)selValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u9009\u62e9\u503c\u586b\u5145\u3002", (String)"TransBillSetpIn_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = index + 1; i < rowCount; ++i) {
            this.getModel().setValue(selKey, selValue, i);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.isPropertyChange(e)) {
            return;
        }
        ChangeData changeSet = e.getChangeSet()[0];
        int index = changeSet.getRowIndex();
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        if (!CommonUtils.isNull((Object)newValue) && newValue.equals(oldValue)) {
            return;
        }
        String key = e.getProperty().getName();
        this.updateLogisticBill(key);
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "outorg": {
                this.changeOutorg(e);
                break;
            }
            case "transtype": {
                this.setOrg((String)newValue);
                this.setOutOrgEnable();
                break;
            }
            case "invscheme": {
                this.changeInvScheme(e);
                this.update4OutScheme();
                this.handleIsVisible();
                this.updateTransitOwner();
                break;
            }
            case "transit": {
                this.updateTransitOwner();
                break;
            }
            case "isfreegift": {
                this.changeIsPresent(newValue, index);
                break;
            }
            case "outownertype": 
            case "ownertype": 
            case "outowner": 
            case "owner": {
                super.propertyChanged(e);
                this.updateTransitOwnerByIndex(index);
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    @Override
    protected void changeInvScheme(PropertyChangedArgs e) {
        super.changeInvScheme(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue(this.getTransInOrgKey());
        DynamicObject outorg = this.getModel().getDataEntity().getDynamicObject(this.getTransOutOrgKey());
        this.initEntry(org, outorg);
    }

    @Override
    protected String getTransOutOrgKey() {
        return "outorg";
    }

    @Override
    protected String getTransInOrgKey() {
        return "org";
    }

    @Override
    protected void handleVisible() {
        super.handleVisible();
        this.update4OutScheme();
    }

    private void update4OutScheme() {
        IDataModel bill = this.getModel();
        DynamicObject scheme = (DynamicObject)bill.getValue("invscheme");
        DynamicObject invScheme = null;
        if (scheme == null || scheme.getPkValue() == null) {
            return;
        }
        invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        if (!isOutUpdate) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"outowner", "outownertype"});
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.isEnableOvertrans();
        this.handleIsVisible();
        this.getModel().setDataChanged(false);
        this.initInWarehouse();
        this.setOutOrgEnable();
        if (this.isDrawByBOTP()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"outorg"});
        }
    }

    private void isEnableOvertrans() {
        boolean negativeBill = InverseBillHelper.isNegativeBill((IDataModel)this.getModel());
        this.getView().setEnable(Boolean.valueOf(!negativeBill), new String[]{"bar_overtrans"});
    }

    private void initPriceField(boolean isPresent, int rowIndex) {
        IFormView view = this.getView();
        boolean isEnable = !isPresent;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"price"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amount"});
    }

    @Override
    protected void setEnable4IsDraw(boolean isDraw) {
        super.setEnable4IsDraw(isDraw);
        if (isDraw) {
            IFormView view = this.getView();
            String transType = (String)this.getModel().getValue("transtype");
            view.setEnable(Boolean.valueOf(!"A".equals(transType)), new String[]{"lot", "keeper"});
            view.setEnable(Boolean.FALSE, new String[]{"transit"});
        }
    }

    @Override
    protected void setBillEntryEnable(RowDataEntity row) {
        super.setBillEntryEnable(row);
        DynamicObject dynamicObject = row.getDataEntity();
        Boolean isPresent = dynamicObject.getBoolean("isfreegift");
        this.initPriceField(isPresent, row.getRowIndex());
    }

    @Override
    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        IFormView view = this.getView();
        int index = row.getRowIndex();
        if (isDraw) {
            view.setEnable(Boolean.valueOf(!isDraw), index, new String[]{"isfreegift"});
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)newValue;
        this.initPriceField(isPresent, rowIndex);
        if (isPresent) {
            model.setValue("price", (Object)Constants.ZERO, rowIndex);
            model.setValue("amount", (Object)Constants.ZERO, rowIndex);
        }
    }

    private void updateTransitOwner() {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("billentry");
        String transit = (String)model.getValue("transit");
        if (StringUtils.isBlank((CharSequence)transit)) {
            return;
        }
        switch (transit) {
            case "A": {
                for (int i = 0; i < entryRowCount; ++i) {
                    model.setValue("transitownertype", model.getValue("outownertype", i), i);
                    model.setValue("transitowner", model.getValue("outowner", i), i);
                }
                break;
            }
            case "B": {
                for (int i = 0; i < entryRowCount; ++i) {
                    model.setValue("transitownertype", model.getValue("ownertype", i), i);
                    model.setValue("transitowner", model.getValue("owner", i), i);
                }
                break;
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.updateTransitOwner();
    }

    private void handleIsVisible() {
        IDataModel model = this.getModel();
        DynamicObject invScheme = (DynamicObject)model.getValue("invscheme");
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        this.getView().setVisible(Boolean.valueOf(isOutUpdate), new String[]{"outwarehouse", "outlocation"});
        this.getView().setVisible(Boolean.valueOf(isInUpdate && isOutUpdate), new String[]{"transitownertype", "transitowner"});
    }

    private void updateTransitOwnerByIndex(int index) {
        IDataModel model = this.getModel();
        String transit = (String)model.getValue("transit");
        if (StringUtils.isBlank((CharSequence)transit)) {
            return;
        }
        switch (transit) {
            case "A": {
                model.setValue("transitownertype", model.getValue("outownertype", index), index);
                model.setValue("transitowner", model.getValue("outowner", index), index);
                break;
            }
            case "B": {
                model.setValue("transitownertype", model.getValue("ownertype", index), index);
                model.setValue("transitowner", model.getValue("owner", index), index);
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        boolean isMainOrg = ImBillEditHelper.isMainOrgByF7((IFormView)this.getView(), (IDataModel)this.getModel(), (String)fieldKey);
        if (!isMainOrg) {
            e.setCancel(true);
            return;
        }
        switch (fieldKey) {
            case "outwarehouse": {
                IDataModel model = this.getModel();
                DynamicObject inOrg = (DynamicObject)model.getValue("org");
                DynamicObject outOrg = (DynamicObject)model.getValue("outorg");
                this.outWareHouseFilter(outOrg, inOrg, e);
                break;
            }
            case "transitowner": {
                this.beforeF7BytransitOwner(e);
                break;
            }
            default: {
                super.beforeF7Select(e);
            }
        }
    }

    private void beforeF7BytransitOwner(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        String transitType = (String)model.getValue("transitownertype");
        String transit = (String)model.getValue("transit");
        int rowIndex = e.getRow();
        if (transitType.equals("bos_org")) {
            if (StringUtils.isBlank((CharSequence)transitType) || StringUtils.isBlank((CharSequence)transit)) {
                e.setCancel(true);
                return;
            }
            DynamicObject owner = null;
            if (transit.equals("A")) {
                owner = (DynamicObject)model.getValue("outowner", rowIndex);
            } else if (transit.equals("B")) {
                owner = (DynamicObject)model.getValue("owner", rowIndex);
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            if (owner == null) {
                e.setCancel(true);
            } else {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", owner.getPkValue()));
            }
        } else {
            TransBillCommonBeforeF7SelectListener listener = new TransBillCommonBeforeF7SelectListener(this.getView());
            listener.beforeF7Select(e);
        }
    }

    private void outWareHouseFilter(DynamicObject outOrg, DynamicObject inOrg, BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (outOrg == null || inOrg == null) {
            e.setCancel(true);
        } else {
            Long[] allWhs;
            String formId = this.getModel().getDataEntityType().getName();
            QFilter outWhsF7Filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)formId, (DynamicObject)outOrg);
            QFilter inWhsF7Filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)formId, (DynamicObject)inOrg);
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            if (outWhsF7Filter == null) {
                allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(outOrg.getPkValue().toString()));
                outWhsF7Filter = new QFilter("id", "in", (Object)allWhs);
            }
            if (inWhsF7Filter == null) {
                allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(inOrg.getPkValue().toString()));
                inWhsF7Filter = new QFilter("id", "in", (Object)allWhs);
            }
            filterParameter.getQFilters().clear();
            Object value = this.getModel().getValue("transit");
            if ("B".equals(value)) {
                showParameter.setUseOrgId(inOrg.getLong("id"));
                filterParameter.setFilter(inWhsF7Filter);
            } else if ("A".equals(value)) {
                showParameter.setUseOrgId(outOrg.getLong("id"));
                filterParameter.setFilter(outWhsF7Filter);
            }
        }
    }
}

