/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.warn;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.warn.EarlyWarnConditionCheckResult;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnConditionForm;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.formplugin.warn.WarnHelper;

public class ImShelfLifeWarnPlugin
extends AbstractFormPlugin
implements IEarlyWarnConditionForm {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        if (filterGrid == null) {
            return;
        }
        EntityTypeUtil helper = new EntityTypeUtil();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
        List filterColumns = helper.getFilterColumns((IDataEntityType)mainEntityType);
        if (filterColumns == null || filterColumns.isEmpty()) {
            return;
        }
        ArrayList<Map> resetFilterColumns = new ArrayList<Map>(filterColumns.size());
        for (Map filterColumn : filterColumns) {
            String fieldName = (String)filterColumn.get("fieldName");
            ArrayList<String> unitField = new ArrayList<String>(16);
            unitField.add("baseunit.number");
            unitField.add("baseunit.name");
            unitField.add("unit.number");
            unitField.add("unit.name");
            unitField.add("unit2nd.number");
            unitField.add("unit2nd.name");
            if ((fieldName.contains("qty") || fieldName.contains("unit") || fieldName.equals("lot.number") || fieldName.equals("materialname") || fieldName.equals("warehouse.isopenlocation") || fieldName.equals("updatetime") || fieldName.equals("keycol") || fieldName.contains("price")) && !unitField.contains(fieldName)) continue;
            resetFilterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(resetFilterColumns);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterCondition filterCondition = this.loadFilter();
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    private FilterCondition loadFilter() {
        FormShowParameter para = this.getView().getFormShowParameter();
        Map customParamsMap = para.getCustomParams();
        return WarnHelper.parseFilterCondition(customParamsMap);
    }

    public Map<String, Object> getCustomParams() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        return WarnHelper.parseCustomerParam(filterCondition);
    }

    public EarlyWarnConditionCheckResult checkCustomParams() {
        EarlyWarnConditionCheckResult result = new EarlyWarnConditionCheckResult();
        return result;
    }
}

