/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.warn.datasource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnDataSource;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.formplugin.warn.WarnHelper;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.sbs.business.reservation.ReserveHelper;

public class ShelfLifeWarnDataSource
implements IEarlyWarnDataSource {
    private static final Log log = LogFactory.getLog(ShelfLifeWarnDataSource.class);
    private static final String algoKey = ShelfLifeWarnDataSource.class.getName();

    public List<QFilter> buildFilter(String s, FilterCondition filterCondition, EarlyWarnContext earlyWarnContext) {
        return null;
    }

    public DynamicObjectCollection getData(String dataSource, List<QFilter> filterList, EarlyWarnContext context) {
        List<String> selectorSet;
        DynamicObjectCollection collection = new DynamicObjectCollection();
        QFilter customFilter = WarnHelper.buildQFilter(context.getCustomConditionDataMap(), MetadataServiceHelper.getDataEntityType((String)InvAccConst.getBalTb()));
        DataSet invAccs = this.queryInvAccs(customFilter, selectorSet = this.buildSelectorSet());
        Map<Long, Set<Long>> orgToMaterialsMapping = this.getOrgToMaterialsMapping(invAccs.copy());
        if (orgToMaterialsMapping.isEmpty()) {
            return collection;
        }
        HashMap<Long, Map<Object, DynamicObject>> orgMaterialInfoMap = new HashMap<Long, Map<Object, DynamicObject>>(16);
        for (Map.Entry<Long, Set<Long>> entry : orgToMaterialsMapping.entrySet()) {
            Long orgId = entry.getKey();
            Map<Object, DynamicObject> invInfo = this.getMaterialInventoryInfos(entry);
            if (invInfo.isEmpty()) continue;
            orgMaterialInfoMap.put(orgId, invInfo);
        }
        HashSet<Long> invAccIds = new HashSet<Long>(16);
        for (Row invAcc : invAccs) {
            Long materialMasterId;
            DynamicObject materialInfo;
            Long org = invAcc.getLong("org");
            Map materialInfoMap = (Map)orgMaterialInfoMap.get(org);
            if (materialInfoMap == null || materialInfoMap.isEmpty() || (materialInfo = (DynamicObject)materialInfoMap.get(materialMasterId = invAcc.getLong("material"))) == null) continue;
            Date expiryDate = invAcc.getDate("expirydate");
            String leadTimeUnit = materialInfo.getString("leadtimeunit");
            Long warnLeadTime = materialInfo.getLong("warnleadtime");
            Long invAccId = invAcc.getLong("id");
            boolean isWarning = this.getIsWarning(expiryDate, warnLeadTime, leadTimeUnit);
            if (!isWarning) continue;
            invAccIds.add(invAccId);
        }
        collection = this.buildWarnParam(invAccIds);
        return collection;
    }

    private List<String> buildSelectorSet() {
        ArrayList<String> selectorSet = new ArrayList<String>(16);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
        selectorSet.addAll(dt.getAllFields().keySet());
        return selectorSet;
    }

    public List<Map<String, Object>> getCommonFilterColumns(String s) {
        return null;
    }

    public TreeNode getSingleMessageFieldTree(String s) {
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setOnlyPhysicsField(false);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
        try {
            mainEntityType = (MainEntityType)mainEntityType.clone();
            DataEntityPropertyCollection entry = mainEntityType.getProperties();
            for (IDataEntityProperty dataEntityPropEntry : entry) {
                if (!dataEntityPropEntry.getName().equals("lot")) continue;
                entry.remove((Object)dataEntityPropEntry);
                break;
            }
        }
        catch (CloneNotSupportedException e) {
            log.error("clone\u5373\u65f6\u5e93\u5b58tree node\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"clone\u5373\u65f6\u5e93\u5b58\u5c5e\u6027tree node\u5931\u8d25\u3002", (String)"ShelfLifeWarnDataSource_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        TreeNode root = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)option);
        root.setIsOpened(true);
        return root;
    }

    public TreeNode getMergeMessageFieldTree(String s) {
        return this.getSingleMessageFieldTree(s);
    }

    private DynamicObjectCollection buildWarnParam(Set<Long> invAccIds) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
        DynamicObjectCollection collection = new DynamicObjectCollection((DynamicObjectType)mainEntityType, null, new ArrayList(16));
        DynamicObject[] shelfLifeWarnParams = BusinessDataServiceHelper.load((Object[])invAccIds.toArray(), (DynamicObjectType)mainEntityType);
        collection.addAll(Arrays.asList(shelfLifeWarnParams));
        return collection;
    }

    private boolean getIsWarning(Date expiryDate, Long warnLeadTime, String leadTimeUnit) {
        Date date = new Date();
        if (warnLeadTime.intValue() >= 0) {
            date = DateUtils.addDay((Date)new Date(), (int)warnLeadTime.intValue());
            switch (leadTimeUnit) {
                case "month": {
                    date = DateUtils.addMonth((Date)new Date(), (int)warnLeadTime.intValue());
                    break;
                }
                case "year": {
                    date = DateUtils.addYear((Date)new Date(), (int)warnLeadTime.intValue());
                    break;
                }
            }
        }
        return date.compareTo(expiryDate) >= 0;
    }

    private Map<Object, DynamicObject> getMaterialInventoryInfos(Map.Entry<Long, Set<Long>> entry) {
        Long orgId = entry.getKey();
        Set<Long> materialMasterIds = entry.getValue();
        ArrayList<String> selectorSet = new ArrayList<String>(16);
        selectorSet.add("leadtimeunit");
        selectorSet.add("warnleadtime");
        selectorSet.add("id");
        selectorSet.add("masterid.id");
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        QFilter warnFilter = new QFilter("enablewarnlead", "=", (Object)"1");
        QFilter masterIdFilter = new QFilter("masterid", "in", materialMasterIds);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
        qFilter.and(warnFilter).and(masterIdFilter).and(baseDataFilter);
        DynamicObject[] materialInfos = BusinessDataServiceHelper.load((String)"bd_materialinventoryinfo", (String)String.join((CharSequence)",", selectorSet), (QFilter[])qFilter.toArray());
        HashMap<Object, DynamicObject> materialInvInfo = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject materialInfo : materialInfos) {
            Object masterId = materialInfo.get("masterid.id");
            materialInvInfo.put(masterId, materialInfo);
        }
        return materialInvInfo;
    }

    private DataSet queryInvAccs(QFilter customFilter, List<String> selectorSet) {
        QFilter filter = new QFilter("baseqty", ">", (Object)0).and("expirydate", ">", (Object)new Date());
        if (customFilter != null) {
            filter.and(customFilter);
        }
        selectorSet.add("id");
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)InvAccConst.getBalTb(), (String)String.join((CharSequence)",", selectorSet), (QFilter[])filter.toArray(), null);
        DataSet avbbaseqtyDs = ReserveHelper.getAvbbaseqty((DataSet)queryDataSet.copy()).filter("avbbaseqty > 0");
        return avbbaseqtyDs;
    }

    private Map<Long, Set<Long>> getOrgToMaterialsMapping(DataSet invAccCopy) {
        HashMap<Long, Set<Long>> orgToMaterialsMapping = new HashMap<Long, Set<Long>>(16);
        for (Row row : invAccCopy) {
            Long org = row.getLong("org");
            Long materialMasterId = row.getLong("material");
            if (org == null || materialMasterId == null) continue;
            orgToMaterialsMapping.putIfAbsent(org, new HashSet(1));
            ((Set)orgToMaterialsMapping.get(org)).add(materialMasterId);
        }
        return orgToMaterialsMapping;
    }
}

