/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OccSaleOrder2OutWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String ITEMENTRY = "itementry";
    private static final String OCBSOC_SALEORDER = "ocbsoc_saleorder";
    private static final String APPROVEBASEQTY = "approvebaseqty";
    private static final String TOTALOUTSTOCKBASEQTY = "totaloutstockbaseqty";
    private static final String TOTALINSTOCKBASEQTY = "totalinstockbaseqty";
    private static final String TOTALSIGNEDBASEQTY = "totalsignedbaseqty";
    private static final String SIGNSTATUS = "signstatus";
    private static final String BILLSTATUS = "billstatus";
    private static final String SRCBILLENTITY = "srcbillentity";
    private static final String SRCBILLENTRYID = "srcbillentryid";
    private static final String SRCBILLID = "srcbillid";
    private static final String ENTRYCLOSESTATUS = "entryclosestatus";
    private static final String DELIVERYDETAIL_MAINBILLID = "deliverydetail.mainbillid";
    private static final String PURSALEMODEL = "pursalemodel";

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if (OCBSOC_SALEORDER.equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add(APPROVEBASEQTY);
            e.getFieldKeys().add(TOTALOUTSTOCKBASEQTY);
            e.getFieldKeys().add(TOTALSIGNEDBASEQTY);
            e.getFieldKeys().add(SIGNSTATUS);
            e.getFieldKeys().add(BILLSTATUS);
            e.getFieldKeys().add(SRCBILLENTRYID);
            e.getFieldKeys().add(SRCBILLENTITY);
            e.getFieldKeys().add(SRCBILLID);
        }
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        super.afterExcessCheck(e);
        String opType = this.getOpType();
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        if (OCBSOC_SALEORDER.equals(srcSubMainType.getName()) && opType.equalsIgnoreCase("unaudit")) {
            DynamicObject srcActiveRow = e.getSrcActiveRow();
            DynamicObject targetActiveRow = e.getTargetActiveRow();
            DynamicObject saleOrder = (DynamicObject)((DynamicObject)srcActiveRow.getParent()).getParent();
            QFilter qFilter = new QFilter(DELIVERYDETAIL_MAINBILLID, "=", saleOrder.getPkValue());
            qFilter.and("deliverydetail.mainbillentity", "=", (Object)OCBSOC_SALEORDER);
            qFilter.and("deliverydetail.srcbillentryid", "=", targetActiveRow.getPkValue());
            qFilter.and(BILLSTATUS, "in", (Object)new String[]{"C", "D"});
            boolean exists = QueryServiceHelper.exists((String)"ocbsoc_delivery_record", (QFilter[])qFilter.toArray());
            if (exists) {
                e.setExcess(true);
                e.setMessage(ResManager.loadKDString((String)"\u51fa\u5e93\u5df2\u7b7e\u6536\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"OccSaleOrder2OutWriteBackPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        if (OCBSOC_SALEORDER.equals(srcSubMainType.getName()) && (opType.equalsIgnoreCase("audit") || opType.equalsIgnoreCase("unaudit") || "cancel".equalsIgnoreCase(opType))) {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>(16);
            for (DynamicObject srcDataEntity : srcDataEntities) {
                srcDataEntity = BusinessDataServiceHelper.loadSingle((Object)srcDataEntity.getPkValue(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)OCBSOC_SALEORDER));
                String billStatus = this.getBillstatus(srcDataEntity);
                srcDataEntity.set(BILLSTATUS, (Object)billStatus);
                String signStatus = "";
                if (opType.equalsIgnoreCase("audit")) {
                    signStatus = this.getSignstatus();
                } else if (opType.equalsIgnoreCase("unaudit")) {
                    signStatus = this.getUnAuditSignStatus(srcDataEntity);
                }
                if (StringUtils.isEmpty((Object)signStatus)) {
                    signStatus = srcDataEntity.getString(SIGNSTATUS);
                }
                srcDataEntity.set(SIGNSTATUS, (Object)signStatus);
                saveValue.add(srcDataEntity);
                saveValue.addAll(this.setTotalStockBaseQty(srcDataEntity, signStatus));
            }
            DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
            SaveServiceHelper.save((DynamicObject[])saveValues);
        }
    }

    private List<DynamicObject> setTotalStockBaseQty(DynamicObject srcDataEntity, String signstatus) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection itemEntrys = srcDataEntity.getDynamicObjectCollection(ITEMENTRY);
        if (CollectionUtils.isEmpty((Collection)itemEntrys)) {
            return itemEntrys;
        }
        DynamicObject dynObj = ((DynamicObject)itemEntrys.get(0)).getDynamicObject(SRCBILLENTITY);
        if (dynObj != null && OCBSOC_SALEORDER.equals(dynObj.getPkValue())) {
            DynamicObject[] saleOrderDynObjs;
            Map<Long, List<DynamicObject>> itemEntryMap = itemEntrys.stream().collect(Collectors.groupingBy(obj -> obj.getLong(SRCBILLENTRYID)));
            Set srcBillIdSet = itemEntrys.stream().map(obj -> obj.getLong(SRCBILLID)).collect(Collectors.toSet());
            for (DynamicObject saleOrderDynObj : saleOrderDynObjs = BusinessDataServiceHelper.load((Object[])srcBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)OCBSOC_SALEORDER))) {
                if (!"G".equals(saleOrderDynObj.getString(PURSALEMODEL))) continue;
                DynamicObjectCollection orderEntryColl = saleOrderDynObj.getDynamicObjectCollection(ITEMENTRY);
                boolean isSave = false;
                for (DynamicObject entryDynObj : orderEntryColl) {
                    long entryId = entryDynObj.getLong("id");
                    List<DynamicObject> list = itemEntryMap.get(entryId);
                    if (CollectionUtils.isEmpty(list)) continue;
                    BigDecimal allStockBaseQty = list.stream().map(m -> m.getBigDecimal(TOTALOUTSTOCKBASEQTY)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set(TOTALOUTSTOCKBASEQTY, (Object)allStockBaseQty);
                    isSave = true;
                }
                if (!isSave) continue;
                String billStatus = this.getBillstatus(saleOrderDynObj);
                saleOrderDynObj.set(BILLSTATUS, (Object)billStatus);
                saleOrderDynObj.set(SIGNSTATUS, (Object)signstatus);
                updateList.add(saleOrderDynObj);
            }
        }
        return updateList;
    }

    private String getBillstatus(DynamicObject srcDataEntity) {
        long count;
        DynamicObjectCollection itemEntrys = srcDataEntity.getDynamicObjectCollection(ITEMENTRY);
        BigDecimal allstockSum = itemEntrys.stream().map(m -> m.getBigDecimal(TOTALOUTSTOCKBASEQTY)).reduce(BigDecimal.ZERO, BigDecimal::add);
        String billStatus = allstockSum.compareTo(BigDecimal.ZERO) > 0 ? ((count = itemEntrys.stream().filter(m -> (m.getLong("combinationid_id") == 0L || m.getLong("combineparentid") > 0L) && m.getBigDecimal(APPROVEBASEQTY).compareTo(m.getBigDecimal(TOTALOUTSTOCKBASEQTY)) > 0 && m.getString(ENTRYCLOSESTATUS).equals("A")).count()) > 0L ? "D" : "E") : "C";
        return billStatus;
    }

    private String getSignstatus() {
        return "B";
    }

    private String getUnAuditSignStatus(DynamicObject srcDataEntity) {
        DynamicObjectCollection itemEntries = srcDataEntity.getDynamicObjectCollection(ITEMENTRY);
        BigDecimal sumOutStockBaseQty = itemEntries.stream().map(m -> m.getBigDecimal(TOTALOUTSTOCKBASEQTY)).reduce(BigDecimal.ZERO, BigDecimal::add);
        long cnt = itemEntries.stream().filter(m -> m.getBigDecimal(TOTALINSTOCKBASEQTY).compareTo(m.getBigDecimal(TOTALOUTSTOCKBASEQTY)) < 0).count();
        String signStatus = sumOutStockBaseQty.compareTo(BigDecimal.ZERO) == 0 ? "A" : (cnt > 0L ? "B" : "C");
        return signStatus;
    }
}

