/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.wb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class PurOrder2InWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final Log log = LogFactory.getLog(PurOrder2InWriteBackPlugin.class);
    private static final Long ADMINISTRATORID = 1L;
    private static final String CLOSESTATUS = "closestatus";
    private static final String CLOSER = "closer";
    private static final String CLOSEDATE = "closedate";

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        e.getFieldKeys().add("biztime");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("receivedate");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("isvirtualbill");
    }

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if ("pm_purorderbill".equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add("unitrate");
            e.getFieldKeys().add("invqty");
            e.getFieldKeys().add("planqty");
            e.getFieldKeys().add("planreceiveqty");
            e.getFieldKeys().add("planreceivedate");
            e.getFieldKeys().add(CLOSER);
            e.getFieldKeys().add(CLOSEDATE);
            e.getFieldKeys().add(CLOSESTATUS);
            e.getFieldKeys().add("receivedayup");
            e.getFieldKeys().add("receivedaydown");
            e.getFieldKeys().add("iscontrolday");
            e.getFieldKeys().add("deliverdate");
            e.getFieldKeys().add("supplier");
            e.getFieldKeys().add("qty");
        }
    }

    public void beforeExcessCheck(BeforeExcessCheckEventArgs e) {
        super.beforeExcessCheck(e);
        String opType = this.getOpType();
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        if ("pm_purorderbill".equals(srcSubMainType.getName()) && ("audit".equalsIgnoreCase(opType) || "unaudit".equalsIgnoreCase(opType) || "Cancel".equalsIgnoreCase(opType))) {
            DynamicObjectCollection srcDeliverEntrys;
            DynamicObject srcActiveRow = e.getSrcActiveRow();
            DynamicObject targetActiveRow = e.getTargetActiveRow();
            if (srcActiveRow == null || targetActiveRow == null) {
                return;
            }
            DynamicObject tarBill = (DynamicObject)targetActiveRow.getParent();
            Date receiveDate = tarBill.getDate("biztime");
            if (targetActiveRow.getDate("receivedate") != null) {
                receiveDate = targetActiveRow.getDate("receivedate");
            }
            if ((srcDeliverEntrys = srcActiveRow.getDynamicObjectCollection("purbillentry_deliver")) != null && srcDeliverEntrys.size() > 0) {
                BigDecimal invQty = srcActiveRow.getBigDecimal("invqty");
                BigDecimal planQtys = BigDecimal.ZERO;
                BigDecimal totalReciveQty = BigDecimal.ZERO;
                for (int i = 0; i < srcDeliverEntrys.size(); ++i) {
                    DynamicObject srcDeliverEntry = (DynamicObject)srcDeliverEntrys.get(i);
                    BigDecimal planQty = srcDeliverEntry.getBigDecimal("planqty");
                    BigDecimal planReceiveQty = srcDeliverEntry.getBigDecimal("planreceiveqty");
                    if (invQty.compareTo(planQtys = planQtys.add(planQty)) > 0) {
                        if (i == srcDeliverEntrys.size() - 1) {
                            srcDeliverEntry.set("planreceiveqty", (Object)invQty.subtract(totalReciveQty));
                            if (invQty.subtract(totalReciveQty).compareTo(BigDecimal.ZERO) == 0) {
                                srcDeliverEntry.set("planreceivedate", null);
                            }
                        } else {
                            srcDeliverEntry.set("planreceiveqty", (Object)planQty);
                        }
                        if (planQty.compareTo(planReceiveQty) > 0) {
                            srcDeliverEntry.set("planreceivedate", (Object)receiveDate);
                        }
                    } else if (invQty.compareTo(planQtys) <= 0) {
                        BigDecimal receiveQty = invQty.subtract(planQtys.subtract(planQty));
                        if (receiveQty.compareTo(BigDecimal.ZERO) <= 0) {
                            receiveQty = BigDecimal.ZERO;
                            srcDeliverEntry.set("planreceiveqty", (Object)receiveQty);
                            srcDeliverEntry.set("planreceivedate", null);
                        } else {
                            srcDeliverEntry.set("planreceiveqty", (Object)receiveQty);
                            srcDeliverEntry.set("planreceivedate", (Object)receiveDate);
                        }
                    }
                    totalReciveQty = totalReciveQty.add(srcDeliverEntry.getBigDecimal("planreceiveqty"));
                }
            }
        }
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        super.afterExcessCheck(e);
        String opType = this.getOpType();
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        if ("pm_purorderbill".equals(srcSubMainType.getName()) && opType.equalsIgnoreCase("audit")) {
            boolean iscontrolday;
            DynamicObject srcActiveRow = e.getSrcActiveRow();
            DynamicObject targetActiveRow = e.getTargetActiveRow();
            DynamicObject purInBill = (DynamicObject)targetActiveRow.getParent();
            boolean isvirtualbill = purInBill.getBoolean("isvirtualbill");
            if (isvirtualbill) {
                return;
            }
            DynamicObject biztype = purInBill.getDynamicObject("biztype");
            if (biztype != null) {
                Long pkValue = (Long)biztype.getPkValue();
                if (this.getRefundBizTypeIDS().contains(pkValue)) {
                    return;
                }
            }
            if (iscontrolday = srcActiveRow.getBoolean("iscontrolday")) {
                Date deliverdate = (Date)srcActiveRow.get("deliverdate");
                Date purInDate = purInBill.getDate("biztime");
                int ahead = srcActiveRow.getInt("receivedayup");
                int delay = srcActiveRow.getInt("receivedaydown");
                Date aheadDate = this.getTargetDate(deliverdate, -ahead);
                Date delayDate = this.getTargetDate(deliverdate, delay);
                if (purInDate.compareTo(aheadDate) < 0 || purInDate.compareTo(delayDate) > 0) {
                    e.setExcess(true);
                    String message = e.getMessage();
                    StringBuilder sb = new StringBuilder();
                    if (StringUtils.isNotEmpty((String)message)) {
                        sb.append(message);
                    }
                    e.setMessage(sb.append(ResManager.loadKDString((String)"\u5165\u5e93\u65e5\u671f\u8d85\u8fc7\u4e86\u7269\u6599\u5141\u8bb8\u6536\u8d27\u7684\u63a7\u5236\u5929\u6570\u3002", (String)"PurOrder2InWriteBackPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0])).toString());
                }
            }
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        ArrayList<Long> IDs = new ArrayList<Long>(16);
        String opType = this.getOpType();
        if ("pm_purorderbill".equals(srcSubMainType.getName()) && (opType.equalsIgnoreCase("audit") || opType.equalsIgnoreCase("unaudit") || "Cancel".equalsIgnoreCase(opType))) {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>();
            for (DynamicObject srcDataEntity : srcDataEntities) {
                Long billId = (Long)srcDataEntity.getPkValue();
                IDs.add(billId);
                if (srcDataEntity.get(CLOSESTATUS).equals("B")) {
                    if (srcDataEntity.get(CLOSER) != null || srcDataEntity.get(CLOSEDATE) != null) continue;
                    srcDataEntity.set(CLOSER, (Object)ADMINISTRATORID);
                    srcDataEntity.set(CLOSEDATE, (Object)TimeServiceHelper.now());
                    saveValue.add(srcDataEntity);
                    continue;
                }
                if (srcDataEntity.get(CLOSER) == null || srcDataEntity.get(CLOSEDATE) == null) continue;
                srcDataEntity.set(CLOSER, null);
                srcDataEntity.set(CLOSEDATE, null);
                saveValue.add(srcDataEntity);
            }
            if (IDs != null && IDs.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("botp_track_only_dirt_link", String.valueOf(true));
                List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)"pm_purorderbill", (Long[])IDs.toArray(new Long[0]), (OperateOption)option);
                TableDefine purOrderTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)"pur_order", (String)"materialentry");
                Long scmPurOrdertableId = purOrderTableDefine.getTableId();
                HashSet<Long> pm_purorderbillid = new HashSet<Long>();
                for (BFRow bfRow : bfRows) {
                    BFRowId id = bfRow.getId();
                    BFRowId sId = bfRow.getSId();
                    DynamicObject[] tTableId = id.getTableId();
                    if (scmPurOrdertableId == null || tTableId == null || !scmPurOrdertableId.equals(tTableId)) continue;
                    pm_purorderbillid.add(sId.getBillId());
                }
                QFilter orderFilter = new QFilter("id", "in", pm_purorderbillid);
                String selectFields = "id,closestatus,closer,closedate,billentry.id,billentry.rowclosestatus,billentry.rowterminatestatus";
                DynamicObject[] pm_purorderbills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)selectFields, (QFilter[])new QFilter[]{orderFilter});
                HashMap purMap = new HashMap();
                if (pm_purorderbills != null && pm_purorderbills.length > 0) {
                    for (DynamicObject order : pm_purorderbills) {
                        String closeStatus;
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        String orderId = order.getPkValue().toString();
                        if (order.get(CLOSESTATUS).equals("B")) {
                            closeStatus = "0";
                            hashMap.put("closeStatus", closeStatus);
                            hashMap.put(CLOSER, ADMINISTRATORID);
                            Date now = TimeServiceHelper.now();
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            String closeDate = format.format(now);
                            hashMap.put("alertDate", closeDate);
                        } else {
                            closeStatus = "1";
                            hashMap.put("closeStatus", closeStatus);
                            hashMap.put(CLOSER, null);
                            hashMap.put("alertDate", null);
                        }
                        DynamicObjectCollection billentry = order.getDynamicObjectCollection("billentry");
                        for (DynamicObject entry : billentry) {
                            String entryId = entry.getPkValue().toString();
                            String rowCloseStatus = entry.getString("rowclosestatus");
                            String rowTerminateStatus = entry.getString("rowterminatestatus");
                            String purRowStatus = rowCloseStatus.equals("B") || rowTerminateStatus.equals("B") ? "0" : "1";
                            hashMap.put(entryId, purRowStatus);
                        }
                        purMap.put(orderId, hashMap);
                    }
                }
                log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.updatePurCloseStatus \u53c2\u6570 --> " + purMap);
                if (SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0004")) {
                    if (ECServiceSwitch.isOpened()) {
                        String scenesCode = "im_purinbill_unaudit";
                        if ("audit".equalsIgnoreCase(opType)) {
                            scenesCode = "im_purinbill_audit";
                        }
                        CommonParam commonParam = new CommonParam();
                        commonParam.putAll(purMap);
                        ECServiceHelper.execute((String)scenesCode, (String)"writeBackPurOrder", (String)"scm", (String)"pur", (String)"OrderCloseService", (Param)commonParam);
                    } else {
                        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"updatePurCloseStatus", (Object[])new Object[]{purMap});
                        log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.updatePurCloseStatus \u7ed3\u679c --> " + result);
                    }
                }
            }
            DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
            SaveServiceHelper.save((DynamicObject[])saveValues);
        }
    }

    private List<Long> getRefundBizTypeIDS() {
        ArrayList<Long> list = new ArrayList<Long>(16);
        Collections.addAll(list, 688847172015446016L, 688850502762584064L, 691915699186345984L);
        return list;
    }

    private Date getTargetDate(Date fromDate, int daysCount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(fromDate);
        cal.add(5, daysCount);
        return cal.getTime();
    }
}

