/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.wb;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SctmScpo2InOspurinWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final Long ADMINISTRATORID = 1L;
    private static final String CLOSESTATUS = "closestatus";
    private static final String CLOSER = "closer";
    private static final String CLOSEDATE = "closedate";

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        String opType = this.getOpType();
        if ("sctm_scpo".equals(e.getSrcMainType().getName()) && ("audit".equalsIgnoreCase(opType) || "unaudit".equalsIgnoreCase(opType))) {
            e.getFieldKeys().add(CLOSER);
            e.getFieldKeys().add(CLOSEDATE);
            e.getFieldKeys().add(CLOSESTATUS);
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        if (!"sctm_scpo".equals(srcSubMainType.getName())) {
            return;
        }
        String opType = this.getOpType();
        if (!"audit".equalsIgnoreCase(opType) && !"unaudit".equalsIgnoreCase(opType)) {
            return;
        }
        DynamicObject[] srcDataEntities = e.getSrcDataEntities();
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(16);
        for (DynamicObject srcDataEntity : srcDataEntities) {
            if (srcDataEntity.get(CLOSESTATUS).equals("B")) {
                if (srcDataEntity.get(CLOSER) != null || srcDataEntity.get(CLOSEDATE) != null) continue;
                srcDataEntity.set(CLOSER, (Object)ADMINISTRATORID);
                srcDataEntity.set(CLOSEDATE, (Object)TimeServiceHelper.now());
                bills.add(srcDataEntity);
                continue;
            }
            if (srcDataEntity.get(CLOSER) == null || srcDataEntity.get(CLOSEDATE) == null) continue;
            srcDataEntity.set(CLOSER, null);
            srcDataEntity.set(CLOSEDATE, null);
            bills.add(srcDataEntity);
        }
        if (bills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[bills.size()]));
        }
    }
}

