/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.workbench;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mpscmm.msbd.workbench.util.IdentifyUtils;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.workbench.InterfaceCfgField;
import kd.scmc.im.business.workbench.WorkbenchBeforeF7SelectHelper;
import kd.scmc.im.business.workbench.WorkbenchServiceHelper;
import kd.scmc.im.helper.ShelfLifeDateUtil;
import kd.scmc.im.utils.FormUtils;

public class ImWorkBenchSplitBillFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String[] FIELDS = new String[]{"outwarehouse", "outlocation", "inwarehouse", "inlocation"};
    private static final Log logger = LogFactory.getLog(ImWorkBenchSplitBillFormPlugin.class);
    public static final String ENTRYENTITY = "entryentity";
    public static final String HEADMATERIEL = "headmateriel";
    public static final String HEADQTY = "headqty";
    public static final String HEADUNIT = "headunit";
    public static final String ID = "id";
    public static final String CONFIRM = "confirm";
    public static final int ROW_COUNT = 20;
    public static final String HEADINORG = "headinorg";
    public static final String HEADOUTORG = "headoutorg";
    private DynamicObject billInfo = null;
    private DynamicObject entryInfo = null;
    private DynamicObject rowInfo = null;
    private Map<String, InterfaceCfgField> fieldMap;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])FIELDS);
        FlexEdit flexEdit = (FlexEdit)this.getControl("auxpty");
        if (flexEdit != null) {
            flexEdit.registerBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        IdentifyUtils.executeWithCatchException(() -> {
            this.initParam();
            this.initHead();
            this.initEntry();
        });
    }

    private void initEntry() {
        int[] indexes = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 20);
        Map entryFields = ((EntityType)this.getModel().getDataEntityType().getAllEntities().get(ENTRYENTITY)).getFields();
        entryFields.remove("qty");
        DynamicObject materielInvInfo = (DynamicObject)this.getModel().getValue(HEADMATERIEL);
        boolean enableLot = false;
        boolean enableShelflife = false;
        boolean enableAuxpty = false;
        if (materielInvInfo != null) {
            try {
                enableLot = materielInvInfo.getBoolean("enablelot");
                enableShelflife = materielInvInfo.getBoolean("enableshelflifemgr");
                enableAuxpty = materielInvInfo.getDynamicObject("masterid").getBoolean("isuseauxpty");
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        List<String> configFields = entryFields.keySet().stream().filter(k -> this.fieldMap.containsKey(k)).collect(Collectors.toList());
        this.handelNewEntry(configFields, enableLot, enableShelflife, enableAuxpty, indexes);
        this.handelEntryVisibleAndMustInput(entryFields, enableLot, enableShelflife, enableAuxpty);
    }

    private void handelEntryVisibleAndMustInput(Map<String, IDataEntityProperty> entryFields, boolean enableLot, boolean enableShelflife, boolean enableAuxpty) {
        for (String configField : entryFields.keySet()) {
            InterfaceCfgField cfgField = this.fieldMap.get(configField);
            if (cfgField != null) {
                this.getView().setVisible(Boolean.valueOf(cfgField.getShow()), new String[]{configField});
                FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(configField);
                switch (configField) {
                    case "lotnumber": {
                        fieldEdit.setMustInput(enableLot && cfgField.getMustInput());
                        break;
                    }
                    case "producedate": 
                    case "expiredate": {
                        fieldEdit.setMustInput(enableShelflife && cfgField.getMustInput());
                        break;
                    }
                    case "auxpty": {
                        fieldEdit.setMustInput(enableAuxpty && cfgField.getMustInput());
                        break;
                    }
                    default: {
                        fieldEdit.setMustInput(cfgField.getMustInput());
                        break;
                    }
                }
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{configField});
        }
    }

    private void handelNewEntry(List<String> configFields, boolean enableLot, boolean enableShelflife, boolean enableAuxpty, int[] indexes) {
        Map lockMap = (Map)this.getView().getFormShowParameter().getCustomParam("lockMap");
        boolean enableInLocation = this.getEnableLocation("inwarehouse");
        boolean enableOutLocation = this.getEnableLocation("outwarehouse");
        for (int index : indexes) {
            block16: for (String configField : configFields) {
                InterfaceCfgField cfgField = this.fieldMap.get(configField);
                this.getModel().setValue(configField, this.getValue(cfgField), index);
                boolean enable = lockMap.get(configField) != null && (Boolean)lockMap.get(configField) == false;
                switch (configField) {
                    case "lotnumber": {
                        this.getView().setEnable(Boolean.valueOf(enableLot && enable), index, new String[]{configField});
                        continue block16;
                    }
                    case "producedate": 
                    case "expiredate": {
                        this.getView().setEnable(Boolean.valueOf(enableShelflife && enable), index, new String[]{configField});
                        continue block16;
                    }
                    case "auxpty": {
                        this.getView().setEnable(Boolean.valueOf(enableAuxpty && enable), index, new String[]{configField});
                        continue block16;
                    }
                    case "inlocation": {
                        this.getView().setEnable(Boolean.valueOf(enableInLocation && enable), index, new String[]{configField});
                        continue block16;
                    }
                    case "outlocation": {
                        this.getView().setEnable(Boolean.valueOf(enableOutLocation && enable), index, new String[]{configField});
                        continue block16;
                    }
                }
                this.getView().setEnable(Boolean.valueOf(enable), index, new String[]{configField});
            }
        }
    }

    private Boolean getEnableLocation(String warehouseField) {
        Object inWarehouse;
        Boolean enableInLocation = false;
        InterfaceCfgField cfgField = this.fieldMap.get(warehouseField);
        if (cfgField != null && (inWarehouse = this.getValue(cfgField)) instanceof DynamicObject) {
            enableInLocation = ((DynamicObject)inWarehouse).getBoolean("isopenlocation");
        }
        return enableInLocation;
    }

    private void initHead() {
        InterfaceCfgField unitField;
        InterfaceCfgField qtyField;
        InterfaceCfgField materialField;
        InterfaceCfgField inOrgField = this.fieldMap.get("inorg");
        this.getView().setVisible(Boolean.valueOf(inOrgField != null), new String[]{HEADINORG});
        if (inOrgField != null) {
            this.getModel().setValue(HEADINORG, this.getValue(inOrgField));
        }
        InterfaceCfgField outOrgField = this.fieldMap.get("outorg");
        this.getView().setVisible(Boolean.valueOf(outOrgField != null), new String[]{HEADOUTORG});
        if (outOrgField != null) {
            this.getModel().setValue(HEADOUTORG, this.getValue(outOrgField));
        }
        if ((materialField = this.fieldMap.get("materiel")) != null) {
            this.getModel().setValue(HEADMATERIEL, this.getValue(materialField));
        }
        if ((qtyField = this.fieldMap.get("qty")) != null) {
            this.getModel().setValue(HEADQTY, this.getValue(qtyField));
        }
        if ((unitField = this.fieldMap.get("unit")) != null) {
            this.getModel().setValue(HEADUNIT, this.getValue(unitField));
        }
    }

    private void initParam() {
        Object[] cacheData;
        Object[] objs;
        String billStr = (String)this.getView().getFormShowParameter().getCustomParam("billInfo");
        String entryId = (String)this.getView().getFormShowParameter().getCustomParam("entryid");
        String entryKey = (String)this.getView().getFormShowParameter().getCustomParam("entryKey");
        String entityType = (String)this.getView().getFormShowParameter().getCustomParam("entityType");
        String rowInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("rowInfo");
        EntityType rowType = (EntityType)MetadataServiceHelper.getDataEntityType((String)"im_workbench_editlist").getAllEntities().get(ENTRYENTITY);
        if (StringUtils.isNotBlank((CharSequence)rowInfoStr) && (objs = DynamicObjectSerializeUtil.deserialize((String)rowInfoStr, (DynamicObjectType)rowType)) != null && objs.length > 0) {
            this.rowInfo = (DynamicObject)objs[0];
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityType);
        if (StringUtils.isNotBlank((CharSequence)billStr) && (cacheData = DynamicObjectSerializeUtil.deserialize((String)billStr, (DynamicObjectType)dataEntityType)) != null && cacheData.length > 0) {
            Optional<DynamicObject> first;
            this.billInfo = (DynamicObject)cacheData[0];
            DynamicObjectCollection entries = this.billInfo.getDynamicObjectCollection(entryKey);
            if (StringUtils.isNotBlank((CharSequence)entryId) && entries != null && !entries.isEmpty() && (first = entries.stream().filter(entry -> entryId.equals(entry.getString(ID))).findFirst()).isPresent()) {
                this.entryInfo = first.get();
            }
        }
        String fieldMapStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldMap");
        List interfaceCfgFields = SerializationUtils.fromJsonStringToList((String)fieldMapStr, InterfaceCfgField.class);
        this.fieldMap = interfaceCfgFields.stream().collect(Collectors.toMap(InterfaceCfgField::getInterfaceField, field -> field));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IdentifyUtils.executeWithCatchException(() -> {
            if (CONFIRM.equals(operateKey)) {
                this.doConfirm();
            }
        });
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IdentifyUtils.executeWithCatchException(() -> {
            this.initParam();
            Map entryFields = ((EntityType)this.getModel().getDataEntityType().getAllEntities().get(ENTRYENTITY)).getFields();
            entryFields.remove("qty");
            List<String> configFields = entryFields.keySet().stream().filter(k -> this.fieldMap.containsKey(k)).collect(Collectors.toList());
            DynamicObject materielInvInfo = (DynamicObject)this.getModel().getValue(HEADMATERIEL);
            boolean enableLot = false;
            boolean enableShelflife = false;
            boolean enableAuxpty = false;
            if (materielInvInfo != null) {
                try {
                    enableLot = materielInvInfo.getBoolean("enablelot");
                    enableShelflife = materielInvInfo.getBoolean("enableshelflifemgr");
                    enableAuxpty = materielInvInfo.getDynamicObject("masterid").getBoolean("isuseauxpty");
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                }
            }
            int[] indexes = new int[e.getRowDataEntities().length];
            for (int i = 0; i < e.getRowDataEntities().length; ++i) {
                indexes[i] = e.getRowDataEntities()[i].getRowIndex();
            }
            this.handelNewEntry(configFields, enableLot, enableShelflife, enableAuxpty, indexes);
        });
    }

    private void doConfirm() {
        boolean checkResult = this.confirmCheck();
        if (!checkResult) {
            return;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (DynamicObject entry : entries) {
            BigDecimal qty = entry.getBigDecimal("qty");
            if (qty == null || qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            result.add(entry);
        }
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private boolean confirmCheck() {
        this.initParam();
        InterfaceCfgField auxptyCfg = this.fieldMap.get("auxpty");
        DynamicObject materielInvInfo = (DynamicObject)this.getModel().getValue(HEADMATERIEL);
        if (materielInvInfo != null && auxptyCfg != null) {
            StringBuilder errorBuilder = new StringBuilder();
            boolean enableAuxpty = materielInvInfo.getDynamicObject("masterid").getBoolean("isuseauxpty");
            DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                BigDecimal qty = entry.getBigDecimal("qty");
                Object auxpty = entry.get("auxpty");
                if (qty == null || qty.compareTo(BigDecimal.ZERO) <= 0 || !enableAuxpty || !auxptyCfg.getMustInput() || auxpty != null) continue;
                errorBuilder.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImWorkBenchSplitBillFormPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[]{i + 1})).append("\n");
            }
            if (errorBuilder.length() > 0) {
                this.getView().showConfirm("", errorBuilder.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
                return false;
            }
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        int rowIndex = evt.getRow();
        IdentifyUtils.executeWithCatchException(() -> {
            switch (propName) {
                case "outwarehouse": 
                case "inwarehouse": {
                    this.beforeWarehouseSelect(evt);
                    break;
                }
                case "inlocation": {
                    this.beforeLocationSelect("inwarehouse", rowIndex, evt);
                    break;
                }
                case "outlocation": {
                    this.beforeLocationSelect("outwarehouse", rowIndex, evt);
                    break;
                }
            }
            if (propName.contains("auxpty")) {
                this.beforeAuxPtySelect(evt);
            }
        });
    }

    private void beforeWarehouseSelect(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        DynamicObject org = null;
        if ("inwarehouse".equals(propName)) {
            org = (DynamicObject)this.getModel().getValue(HEADINORG);
            if (org == null) {
                org = (DynamicObject)this.getModel().getValue(HEADOUTORG);
            }
        } else {
            org = (DynamicObject)this.getModel().getValue(HEADOUTORG);
            if (org == null) {
                org = (DynamicObject)this.getModel().getValue(HEADINORG);
            }
        }
        if (org != null) {
            List allWarehouse = WarehouseHelper.getAllWarehouse(new ArrayList<Object>(Collections.singleton(org.getPkValue())));
            QFilter qFilter = new QFilter(ID, "in", (Object)allWarehouse);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u51fa\u5e93\u7ec4\u7ec7\u6216\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"ImWorkBenchSplitBillFormPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void beforeLocationSelect(String warehouseName, int rowIndex, BeforeF7SelectEvent evt) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue(warehouseName, rowIndex);
        if (warehouse != null) {
            QFilter inWareHouseFilter = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(inWareHouseFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length == 1) {
            ChangeData changeData = changeSet[0];
            int rowIndex = changeData.getRowIndex();
            Object newValue = changeData.getNewValue();
            IdentifyUtils.executeWithCatchException(() -> this.dealPropChange(propName, rowIndex, newValue));
        }
    }

    private void dealPropChange(String propName, int rowIndex, Object newValue) {
        switch (propName) {
            case "inwarehouse": {
                this.warehouseChange(newValue, rowIndex, "inlocation");
                break;
            }
            case "outwarehouse": {
                this.warehouseChange(newValue, rowIndex, "outlocation");
                break;
            }
            case "producedate": {
                this.productDateChange(rowIndex, newValue);
                break;
            }
            case "expiredate": {
                this.expireDateChange(rowIndex, newValue);
                break;
            }
        }
    }

    private void expireDateChange(int rowIndex, Object newValue) {
        if (!(newValue instanceof Date)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject materialInvInfo = (DynamicObject)model.getValue(HEADMATERIEL);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        Date date = (Date)newValue;
        String calculationForEndDate = materialInvInfo.getString("calculationforenddate");
        Date producedate = (Date)model.getValue("producedate", rowIndex);
        if (MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)false) && !"2".equals(calculationForEndDate)) {
            String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
            int shelflife = materialInvInfo.getInt("shelflife");
            producedate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife * -1), (Date)date, (String)calculationForEndDate);
        }
        if (producedate != null && date.before(producedate)) {
            String newExpirydateStr = this.getDateStr(date);
            String newProduceDateStr = this.getDateStr(producedate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u3002\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"ImBillPropChanged_99", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.getModel().setValue("expiredate", null, rowIndex);
        }
        this.getModel().beginInit();
        this.getModel().setValue("producedate", (Object)producedate, rowIndex);
        this.getModel().endInit();
    }

    private void productDateChange(int rowIndex, Object newValue) {
        DynamicObject materialInvInfo = (DynamicObject)this.getModel().getValue(HEADMATERIEL);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!(newValue instanceof Date)) {
            return;
        }
        Date date = (Date)newValue;
        Date expirydate = (Date)this.getModel().getValue("expiredate");
        if (MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)true)) {
            String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
            int shelflife = materialInvInfo.getInt("shelflife");
            String calculationForEndDate = materialInvInfo.getString("calculationforenddate");
            expirydate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)shelflife, (Date)date, (String)calculationForEndDate);
        }
        if (expirydate != null && expirydate.before(date)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(date);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImBillPropChanged_9", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.getModel().setValue("producedate", null, rowIndex);
        }
        this.getModel().beginInit();
        this.getModel().setValue("expiredate", (Object)expirydate, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("expiredate", rowIndex);
    }

    private String getDateStr(Date date) {
        String dateStr = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        dateStr = sd.format(date);
        return dateStr;
    }

    private void warehouseChange(Object newValue, int rowIndex, String locationField) {
        if (newValue instanceof DynamicObject) {
            this.getView().setEnable(Boolean.valueOf(((DynamicObject)newValue).getBoolean("isopenlocation")), rowIndex, new String[]{locationField});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{locationField});
        }
        this.getModel().setValue(locationField, null, rowIndex);
    }

    private Object getValue(InterfaceCfgField cfgField) {
        if (cfgField == null) {
            return null;
        }
        if (this.billInfo != null && this.entryInfo != null) {
            return WorkbenchServiceHelper.getValue((DynamicObject)this.billInfo, (DynamicObject)this.entryInfo, (String)cfgField.getTarBillField());
        }
        if (this.rowInfo != null) {
            return this.rowInfo.get(cfgField.getInterfaceField());
        }
        return null;
    }

    private void beforeAuxPtySelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject inOrg = (DynamicObject)this.getModel().getValue(HEADINORG);
        DynamicObject outOrg = (DynamicObject)this.getModel().getValue(HEADOUTORG);
        if (inOrg == null && outOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u51fa\u5e93\u7ec4\u7ec7\u6216\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"ImWorkBenchSplitBillFormPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        ArrayList<Long> orgList = new ArrayList<Long>(2);
        if (inOrg != null) {
            orgList.add(inOrg.getLong(ID));
        }
        if (outOrg != null) {
            orgList.add(outOrg.getLong(ID));
        }
        WorkbenchBeforeF7SelectHelper.auxPtyOrgFilter((BeforeF7SelectEvent)beforeF7SelectEvent, orgList);
    }
}

