/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.workbench;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.IconAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.userconfig.GridConfigDAO;
import kd.bos.util.JSONUtils;
import kd.mpscmm.msbd.algorithm.business.helper.AlgorithmHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.workbench.formplugin.GridCardPlugin;
import kd.mpscmm.msbd.workbench.pojo.IdentifyResultInfo;
import kd.mpscmm.msbd.workbench.util.IdentifyUtils;
import kd.scmc.im.business.workbench.InterfaceCfgField;
import kd.scmc.im.business.workbench.WorkbenchBeforeF7SelectHelper;
import kd.scmc.im.business.workbench.WorkbenchFieldsConditionShowAndLockHelper;
import kd.scmc.im.business.workbench.WorkbenchPropertyChangeHelper;
import kd.scmc.im.business.workbench.WorkbenchServiceHelper;

public class ImWorkbenchCardListFormPlugin
extends GridCardPlugin
implements RowClickEventListener,
BeforeF7SelectListener,
TabSelectListener,
EntryGridBindDataListener,
TreeNodeClickListener,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(ImWorkbenchCardListFormPlugin.class);
    private static final String DETAIL_ROW_INDEX = "detail_row_index";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CAKEY_TAR_ENTITY_TYPE_KEY = "tarEntityType";
    private static final String CAKEY_SRC_ENTITY_TYPE_KEY = "srcEntityType";
    private static final String CACHE_DATA_FROM_BOTP_KEY = "dataFromBOTP";
    private static final String INTERFACE_FIELD = "interfacefield";
    private static final String INTERFACE_FIELD_CACHE = "interfaceFieldCache";
    public static final String OCRBILL = "ocrbill";
    public static final String MSBD_IMAGE_SCANNER = "msbd_image_scanner";
    public static final String KC0101 = "1931214066785723392";
    public static final String SPLITCOUNT = "splitcount";
    public static final String IM_WB_SPLITBILL = "im_wb_splitbill";
    public static final String BILLID = "billid";
    public static final String ROWID = "rowid";
    public static final String USER_AGREEMENT = "userAgreement";
    public static final String TENANT_AGREEMENT = "tenantAgreement";
    public static final String IS_USER_AGREE = "isUserAgree";
    public static final String IS_TENANT_AGREE = "isTenantAgree";
    public static final String AGREEMENT_TYPE = "agreementType";
    public static final String GAI_PRIVACY_AGREEMENT = "gai_privacy_agreement";
    public static final String TENANT_AGREE = "tenantAgree";
    public static final String USER_AGREE = "userAgree";
    public static final long GAI_GROUP_ID = 606L;
    public static final String SAVED = "A";
    private static final String INTERFACE_CFG_ID = "interfaceCfgId";
    private static final String SELECTED_TASK_CALLBACK = "selected_task_callback";
    private static final String VECTOR_PREFIX = "vectorap";
    private static final String UNSELECT_FONT = "kdfont kdfont-fuxuankuangweixuanzhong_yuan";
    private static final String SELECTED_FONT = "kdfont kdfont-fuxuankuangxuanzhong_yuan";
    private static final String SELECTED_TASK_TYPE = "cache_selectedTaskType";
    private static final int MAX_SHOW_OP_RECORD_ROW = 10;
    private static final int MAX_SAVE_OP_RECORD_ROW = 100;
    private static final String TASK_FLEX_PANEL_PREFIX = "taskflexpanel";
    private static final String INTERFACE_CFG_ORDER_MAP_CACHE = "interfaceCfgOrderMapCache";
    private static final String INTERFACE_CFG_ORDER_MAP = "interfaceCfgOrderMap";
    private static final String SEARCH_VECTOR_AP = "searchvectorap";
    public static final long AI_GAIR_ID = 2026183729222894592L;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.setBaseDataF7Listener();
        Button moveUpBt = (Button)this.getControl("moveupbtap");
        moveUpBt.addClickListener((ClickListener)this);
        Button moveDownBt = (Button)this.getControl("movedownbtap");
        moveDownBt.addClickListener((ClickListener)this);
        Button resetBt = (Button)this.getControl("resetbtap");
        resetBt.addClickListener((ClickListener)this);
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search searchAp = (Search)this.getView().getControl("searchap");
        searchAp.addEnterListener((SearchEnterListener)this);
        Vector searchVector = (Vector)this.getView().getControl(SEARCH_VECTOR_AP);
        searchVector.addClickListener((ClickListener)this);
    }

    public void search(SearchEnterEvent evt) {
        String text = evt.getText();
        this.inputBillNoChange(text, true);
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(key);
        String nodeId = this.getPageCache().get("nodeClickBillNo");
        Search searchAp = (Search)this.getView().getControl("searchap");
        searchAp.setSearchKey("");
        this.cacheInterfaceCfgId(key);
        this.taskClassificationChange(key);
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            this.inputBillNoChange(nodeId, false);
            this.getPageCache().remove("nodeClickBillNo");
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = (String)evt.getNodeId();
        String parentNodeId = (String)evt.getParentNodeId();
        if (StringUtils.isBlank((CharSequence)parentNodeId)) {
            return;
        }
        String selectedInterfaceCfgId = this.getSelectedInterfaceCfgId();
        if (parentNodeId.equals(selectedInterfaceCfgId)) {
            Search searchAp = (Search)this.getView().getControl("searchap");
            searchAp.setSearchKey(nodeId);
            this.inputBillNoChange(nodeId, false);
        } else {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab(parentNodeId);
            this.getPageCache().put("nodeClickBillNo", nodeId);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        WorkbenchServiceHelper.setPageShowProperty((IFormView)this.getView(), (boolean)this.isDataFromBOTP());
    }

    private void cacheInterfaceCfgId(String id) {
        this.getPageCache().put(INTERFACE_CFG_ID, id);
    }

    private DynamicObject getInterfaceCfg() {
        String selectedInterfaceCfgId = this.getSelectedInterfaceCfgId();
        if (StringUtils.isEmpty((CharSequence)selectedInterfaceCfgId)) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(selectedInterfaceCfgId), (String)"im_wb_interfacecfg");
    }

    private String getSelectedInterfaceCfgId() {
        return this.getPageCache().get(INTERFACE_CFG_ID);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void loadTaskClassification() {
        ArrayList<Map> tabPageItems = new ArrayList<Map>();
        Map<String, Integer> taskClassOrderMap = this.getUserInterfaceCfgOrderMap();
        try (DataSet taskClassificationData = this.getTaskClassificationData();){
            if (!CommonUtils.isNull((Object)taskClassificationData) && !taskClassificationData.isEmpty()) {
                for (Row row : taskClassificationData) {
                    String id = row.getString("id");
                    String name = row.getString("taskname");
                    taskClassOrderMap.computeIfAbsent(id, k -> taskClassOrderMap.put(id, taskClassOrderMap.size()));
                    Integer serviceConfCount = row.getInteger("serviceconfcount");
                    Integer taskCount = row.getInteger("taskcount");
                    if (serviceConfCount != null && serviceConfCount > 0 && taskCount != null && taskCount > 0) {
                        name = name + "\uff08" + taskCount + "\uff09";
                    }
                    TabPageAp tabPageAp = new TabPageAp();
                    tabPageAp.setName(new LocaleString(name));
                    tabPageAp.setKey(id);
                    tabPageItems.add(tabPageAp.createControl());
                }
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u7528\u7684\u5de5\u4f5c\u53f0\u754c\u9762\u914d\u7f6e\uff0c\u8bf7\u542f\u7528\u540e\u91cd\u8bd5\u3002", (String)"ImWorkbenchCardListFormPlugin_11", (String)"scmc-im-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                this.getView().setEnable(Boolean.FALSE, new String[]{"content"});
                WorkbenchServiceHelper.clearEntryData((IFormView)this.getView());
                this.buildDetailPanel(-1);
            }
        }
        if (!tabPageItems.isEmpty()) {
            List orderDataItems = tabPageItems.stream().sorted(Comparator.comparingInt(o -> (Integer)taskClassOrderMap.get(o.get("id")))).collect(Collectors.toList());
            Tab tab = (Tab)this.getControl("tabap");
            tab.addControls(orderDataItems);
            Map firstItemMap = (Map)orderDataItems.get(0);
            String id = (String)firstItemMap.get("id");
            this.cacheInterfaceCfgId(id);
            this.taskClassificationChange(id);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(VECTOR_PREFIX)) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            e.setControl((Control)vector);
        } else if (key.startsWith("iconap")) {
            Vector vector = new Vector();
            vector.setKey(VECTOR_PREFIX + key.substring("iconap".length()));
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            e.setControl((Control)vector);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int focusLineIndex = WorkbenchServiceHelper.getFocusLineIndex((IFormView)this.getView());
        if (focusLineIndex >= 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            entryGrid.selectRows(focusLineIndex);
        }
        WorkbenchServiceHelper.setPageShowProperty((IFormView)this.getView(), (boolean)this.isDataFromBOTP());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            this.getView().setVisible(Boolean.FALSE, new String[]{"edittaskpanelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"taskgroupflexpanelap", "toolbarflexpanelap", "splitcontainerap"});
            this.loadTaskClassification();
        }
        catch (Exception ex) {
            logger.error("\u52a0\u8f7d\u5e93\u5b58\u5de5\u4f5c\u53f0\u4efb\u52a1\u5206\u7c7b\u53d1\u751f\u5f02\u5e38\uff1a", (Object)e);
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void loadDesignModeData() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"edittaskpanelap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"taskgroupflexpanelap", "toolbarflexpanelap", "splitcontainerap"});
        SplitContainer splitControl = (SplitContainer)this.getControl("splitcontainerap1");
        splitControl.hidePanel(SplitDirection.left, true);
        Map<String, Integer> orderMap = this.getUserInterfaceCfgOrderMap();
        this.loadEditInterfaceCfgData(orderMap);
    }

    private void loadEditInterfaceCfgData(Map<String, Integer> userOrderMap) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection imInterfaceCfgCollection = QueryServiceHelper.query((String)"im_wb_interfacecfg", (String)"id,tasktype.id as taskid,tasktype.number as tasknumber,tasktype.name as taskname", (QFilter[])qFilter.toArray(), (String)"id desc");
        if (imInterfaceCfgCollection == null || imInterfaceCfgCollection.isEmpty()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u7528\u7684\u5de5\u4f5c\u53f0\u754c\u9762\u914d\u7f6e\uff0c\u8bf7\u542f\u7528\u540e\u91cd\u8bd5\u3002", (String)"ImWorkbenchCardListFormPlugin_11", (String)"scmc-im-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        for (DynamicObject row : imInterfaceCfgCollection) {
            String id = row.getString("id");
            userOrderMap.computeIfAbsent(id, k -> userOrderMap.put(id, userOrderMap.size()));
        }
        List orderDataList = imInterfaceCfgCollection.stream().sorted(Comparator.comparingInt(o -> (Integer)userOrderMap.get(o.getString("id")))).collect(Collectors.toList());
        int i = 0;
        ArrayList<Map> list = new ArrayList<Map>(orderDataList.size());
        HashMap<Integer, String> interfaceCfgOrderMap = new HashMap<Integer, String>(imInterfaceCfgCollection.size());
        for (DynamicObject row : orderDataList) {
            String id = row.getString("id");
            String name = row.getString("taskname");
            String key = id + "#" + name;
            interfaceCfgOrderMap.put(i, key);
            FlexPanelAp flexAp = this.buildTaskFlexPanelAp(id, name, false);
            list.add(flexAp.createControl());
            ++i;
        }
        this.getPageCache().put(INTERFACE_CFG_ORDER_MAP_CACHE, SerializationUtils.toJsonString(interfaceCfgOrderMap));
        Container control = (Container)this.getControl("taskpanelap");
        control.addControls(list);
    }

    private Map<String, Integer> getUserInterfaceCfgOrderMap() {
        Map orderMap;
        Map curCardConfigMap = this.getCurCardConfigMap();
        if (curCardConfigMap == null || curCardConfigMap.isEmpty()) {
            return new HashMap<String, Integer>(8);
        }
        Object orderMapStr = curCardConfigMap.get(INTERFACE_CFG_ORDER_MAP);
        if (StringUtils.isNotBlank(orderMapStr)) {
            if (orderMapStr instanceof Map) {
                orderMap = (Map)orderMapStr;
            } else {
                try {
                    orderMap = (Map)SerializationUtils.fromJsonString((String)orderMapStr.toString(), Map.class);
                }
                catch (Exception e) {
                    orderMap = new HashMap(8);
                }
            }
        } else {
            orderMap = new HashMap(8);
        }
        return orderMap;
    }

    private FlexPanelAp buildTaskFlexPanelAp(String key, String name, boolean isSelected) {
        FlexPanelAp flexAp = new FlexPanelAp();
        flexAp.setKey(TASK_FLEX_PANEL_PREFIX + key);
        flexAp.setDirection("row");
        flexAp.setAlignItems("center");
        flexAp.setGrow(0);
        flexAp.setJustifyContent("center");
        flexAp.setAlignItems("center");
        flexAp.setShrink(0);
        flexAp.setWidth(new LocaleString("100px"));
        flexAp.setOverflow("hidden");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("12px");
        margin.setLeft("12px");
        margin.setBottom("12px");
        style.setMargin(margin);
        flexAp.setStyle(style);
        IconAp icon = new IconAp();
        icon.setKey("iconap" + key);
        icon.setName(new LocaleString(name));
        icon.setImageKey("/icons/pc/application/danjuzhuanhuan_48_48.png");
        icon.setHeight(new LocaleString("48px"));
        icon.setWidth(new LocaleString("48px"));
        icon.setRadius("6px");
        icon.setImageZoom(true);
        style = new Style();
        margin = new Margin();
        margin.setBottom("3px");
        style.setMargin(margin);
        icon.setStyle(style);
        VectorAp selector = new VectorAp();
        selector.setKey(VECTOR_PREFIX + key);
        selector.setName(new LocaleString());
        selector.setfontClass(UNSELECT_FONT);
        if (isSelected) {
            selector.setfontClass(SELECTED_FONT);
        }
        selector.setFontSize(13);
        selector.setForeColor("#007fff");
        style = selector.getStyle();
        if (style == null) {
            style = new Style();
        }
        Margin selectorMargin = new Margin();
        selectorMargin.setTop("-35px");
        selectorMargin.setLeft("2px");
        style.setMargin(selectorMargin);
        selector.setStyle(style);
        selector.setAlignSelf("center");
        LabelAp labelMenu = new LabelAp();
        labelMenu.setKey("label_prefix" + key);
        labelMenu.setName(new LocaleString(name));
        labelMenu.setWidth(new LocaleString("90px"));
        labelMenu.setHeight(new LocaleString("31px"));
        labelMenu.setTextAlign("center");
        labelMenu.setAutoTextWrap(true);
        labelMenu.setShrink(0);
        labelMenu.setLineHeight("15px");
        style = labelMenu.getStyle();
        if (style == null) {
            style = new Style();
        }
        Margin labelMargin = new Margin();
        labelMargin.setLeft("-15px");
        labelMargin.setTop("5px");
        style.setMargin(labelMargin);
        labelMenu.setStyle(style);
        flexAp.getItems().add(icon);
        flexAp.getItems().add(selector);
        flexAp.getItems().add(labelMenu);
        return flexAp;
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int row = evt.getRow();
        this.buildDetailPanel(row);
    }

    private void buildDetailPanel(int row) {
        String oldRowIndexStr;
        if (row == -1) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.down, true);
            this.getPageCache().remove(DETAIL_ROW_INDEX);
            return;
        }
        String nowRowIndexStr = String.valueOf(row);
        if (nowRowIndexStr.equals(oldRowIndexStr = this.getPageCache().get(DETAIL_ROW_INDEX))) {
            return;
        }
        DynamicObjectCollection entryDataColl = (DynamicObjectCollection)this.getModel().getDataEntity(true).get(ENTRY_ENTITY);
        if (entryDataColl == null || entryDataColl.isEmpty()) {
            return;
        }
        this.putCache(DETAIL_ROW_INDEX, String.valueOf(row));
        try {
            String interfaceCfgId = this.getPageCache().get(INTERFACE_CFG_ID);
            DynamicObject entryData = (DynamicObject)entryDataColl.get(row);
            this.fillDetailData(entryData, interfaceCfgId);
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u8be6\u60c5\u9875\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
        this.clearDataChanged();
    }

    protected void registerEventListener() {
        super.registerEventListener();
        this.addEventListener(new String[]{"propertyChangedEvent"});
    }

    protected void handleEvent(String eventId, Map<String, Object> eventParams) {
        super.handleEvent(eventId, eventParams);
        if ("propertyChangedEvent".equals(eventId)) {
            int index = Integer.parseInt(this.getCache(DETAIL_ROW_INDEX));
            try {
                String key = (String)eventParams.get("key");
                Object val = eventParams.get("val");
                IDataEntityProperty property = this.getModel().getProperty(key);
                if (property == null) {
                    return;
                }
                this.getModel().beginInit();
                this.getModel().setValue(key, val, index);
                this.getModel().endInit();
                this.getView().updateView(key, index);
                WorkbenchServiceHelper.setTarDynamicObjectValue((int)index, (String)key, (Object)this.getModel().getValue(key), (IFormView)this.getView());
                List fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList((IFormView)this.getView());
                DynamicObject entryRowData = this.getModel().getEntryRowEntity(ENTRY_ENTITY, index);
                WorkbenchFieldsConditionShowAndLockHelper.propertyChangeLock((IFormView)this.getView(), (DynamicObject)entryRowData, (boolean)this.isDataFromBOTP(), (String)key, (int)index, (List)fieldsMappingList);
            }
            catch (Exception e) {
                logger.error("\u7ed9\u5206\u5f55\u9875\u8bbe\u7f6e\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        int index = changeSet[0].getRowIndex();
        try {
            int detailIndex;
            if ("auxpty".equals(key) && newValue != null) {
                DynamicObject auxValue = (DynamicObject)newValue;
                long pkValue = (Long)auxValue.getPkValue();
                if (pkValue == 0L) {
                    this.getModel().beginInit();
                    this.getModel().setValue(key, null, index);
                    this.getModel().endInit();
                    return;
                }
                String auxValueStr = auxValue.get("value").toString();
                try {
                    Map map = (Map)JSONUtils.cast((String)auxValueStr, HashMap.class);
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Object value = entry.getValue();
                        if (value instanceof String && StringUtils.isBlank(value)) {
                            iterator.remove();
                            continue;
                        }
                        if (value instanceof Integer && (Integer)value == 0) {
                            iterator.remove();
                            continue;
                        }
                        if (!(value instanceof Long) || (Long)value != 0L) continue;
                        iterator.remove();
                    }
                    auxValue.set("value", (Object)SerializationUtils.toJsonString((Object)map));
                    this.getModel().beginInit();
                    this.getModel().setValue(key, (Object)auxValue, index);
                    this.getModel().endInit();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            WorkbenchServiceHelper.setTarDynamicObjectValue((int)index, (String)key, (Object)newValue, (IFormView)this.getView());
            String cacheIndex = this.getCache(DETAIL_ROW_INDEX);
            if (StringUtils.isNotBlank((CharSequence)cacheIndex) && index == (detailIndex = Integer.parseInt(cacheIndex))) {
                WorkbenchServiceHelper.sendPropertyChangeEvent((IFormView)this.getView(), (String)key, (Object)newValue);
            }
            List fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList((IFormView)this.getView());
            boolean dataFromBOTP = this.isDataFromBOTP();
            DynamicObject entryRowData = this.getModel().getEntryRowEntity(ENTRY_ENTITY, index);
            WorkbenchFieldsConditionShowAndLockHelper.propertyChangeLock((IFormView)this.getView(), (DynamicObject)entryRowData, (boolean)dataFromBOTP, (String)key, (int)index, (List)fieldsMappingList);
            WorkbenchPropertyChangeHelper.propertyChange((String)key, (Object)newValue, (Object)oldValue, (int)index, (boolean)this.isDataFromBOTP(), (IFormView)this.getView(), (IFormPlugin)this);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("propertyChangedEvent".equalsIgnoreCase(operateKey)) {
            Map cacheEventParams;
            FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
            String eventId = operate.getOption().getVariableValue("eventid");
            IPageCache pageCache = this.getPageCache();
            String eventParamStr = pageCache.get("cache_event_params");
            Map<String, Object> eventParams = new HashMap<String, Object>(16);
            if (kd.bos.util.StringUtils.isNotEmpty((String)eventParamStr) && (cacheEventParams = (Map)SerializationUtils.fromJsonString((String)eventParamStr, Map.class)).containsKey(eventId)) {
                eventParams = (Map)cacheEventParams.get(eventId);
            }
            this.handleEvent(eventId, eventParams);
        } else if (OCRBILL.equals(operateKey)) {
            IdentifyUtils.executeWithCatchException(() -> this.ocrBill());
        } else if (SPLITCOUNT.equals(operateKey)) {
            IdentifyUtils.executeWithCatchException(() -> this.splitQty());
        } else if ("deleteentry".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            int selectRow = -1;
            if (selectRows != null && selectRows.length > 0) {
                selectRow = selectRows[0];
            }
            this.buildDetailPanel(selectRow);
        }
    }

    private void taskClassificationChange(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ImWorkbenchCardListFormPlugin_9", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject imInterfaceCfg = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(id), (String)"im_wb_interfacecfg");
        if (imInterfaceCfg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\u7684\u754c\u9762\u914d\u7f6e\uff0c\u8bf7\u786e\u8ba4\u8be5\u4efb\u52a1\u5bf9\u5e94\u7684\u754c\u9762\u914d\u7f6e\u662f\u5426\u5df2\u88ab\u7981\u7528\u3002", (String)"ImWorkbenchCardListFormPlugin_10", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String taskName = imInterfaceCfg.getString("tasktype.name");
        String srcBillNumber = imInterfaceCfg.getString("srcbill.number");
        long taskId = imInterfaceCfg.getLong("tasktype.id");
        boolean existServiceConf = this.isExistTaskCreateServiceConf(taskId);
        this.doTaskComplete(id, taskName, srcBillNumber, taskId, existServiceConf);
        this.buildColumnAndData(imInterfaceCfg);
        String taskTypeId = imInterfaceCfg.getString("tasktype.id");
        this.showOcrBillBtn(taskTypeId);
        this.showSearchIcon(existServiceConf);
        this.showOpBtn(imInterfaceCfg);
    }

    private void buildColumnAndData(DynamicObject imInterfaceCfg) {
        try {
            this.removeCache();
            this.cacheNeedInfo(imInterfaceCfg);
            this.createEntryColumn(imInterfaceCfg);
            WorkbenchServiceHelper.clearEntryData((IFormView)this.getView());
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.down, true);
            this.loadEditListData(imInterfaceCfg);
            WorkbenchServiceHelper.setDataLoadTime((IFormView)this.getView());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void createEntryColumn(DynamicObject imInterfaceCfg) {
        DynamicObjectCollection interfaceCfgColl = imInterfaceCfg.getDynamicObjectCollection(ENTRY_ENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        List fieldEdits = entryGrid.getFieldEdits();
        ArrayList<GridConfigurationRow> beans = new ArrayList<GridConfigurationRow>(fieldEdits.size());
        for (int j = 0; j < fieldEdits.size(); ++j) {
            FieldEdit fieldEdit = (FieldEdit)fieldEdits.get(j);
            String fieldKey = fieldEdit.getFieldKey();
            LocaleString fieldName = fieldEdit.getProperty().getDisplayName();
            GridConfigurationRow bean = new GridConfigurationRow();
            bean.setColWidth(0);
            bean.setFreeze(false);
            bean.setHide(true);
            bean.setTextAlign("default");
            bean.setFieldKey(fieldKey);
            bean.setFieldName(fieldName);
            beans.add(bean);
        }
        int i = 0;
        HashSet<String> notFindFieldSet = new HashSet<String>(8);
        for (DynamicObject interfaceCfg : interfaceCfgColl) {
            String interfaceField = interfaceCfg.getString(INTERFACE_FIELD);
            for (GridConfigurationRow bean : beans) {
                String fieldKey = bean.getFieldKey();
                LocaleString fieldName = bean.getFieldName();
                if (!fieldKey.equals(interfaceField)) continue;
                GridConfigurationRow gridConfigurationRow = (GridConfigurationRow)beans.get(i);
                bean.setFieldKey(gridConfigurationRow.getFieldKey());
                bean.setFieldName(gridConfigurationRow.getFieldName());
                gridConfigurationRow.setFieldKey(fieldKey);
                gridConfigurationRow.setFieldName(fieldName);
                gridConfigurationRow.setHide(false);
            }
            boolean isMustInput = interfaceCfg.getBoolean("ismustinput");
            FieldEdit control = (FieldEdit)this.getControl(interfaceField);
            if (control != null) {
                control.setMustInput(isMustInput);
            } else {
                notFindFieldSet.add(interfaceField);
            }
            ++i;
        }
        if (!notFindFieldSet.isEmpty()) {
            String tpl = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\uff0c\u5728\u3010\u5e93\u5b58\u5de5\u4f5c\u53f0\u7f16\u8f91\u5217\u8868\u680f\u3011\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u589e\u52a0\u5b57\u6bb5\u3002", (String)"IM-N-448857", (String)"scmc-im-formplugin", (Object[])new Object[]{String.join((CharSequence)",", notFindFieldSet)});
            this.getView().showTipNotification(tpl);
        }
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        gridConfigDAO.saveGridConfig(this.getView().getFormShowParameter().getFormId(), ENTRY_ENTITY, beans);
        GridConfigRenderUtils.resetGridConfig((IFormView)this.getView(), (String)ENTRY_ENTITY);
        entryGrid.bindData(new BindingContext((Object)this.getView().getModel().getDataEntity()));
    }

    private void removeCache() {
        this.getPageCache().remove(CAKEY_TAR_ENTITY_TYPE_KEY);
        this.getPageCache().remove(CAKEY_SRC_ENTITY_TYPE_KEY);
        this.getPageCache().remove(DETAIL_ROW_INDEX);
        this.getPageCache().remove("detailPageId");
        this.getPageCache().remove(INTERFACE_FIELD_CACHE);
        this.getPageCache().remove("data_load_time");
        this.getPageCache().remove("bill_no_load_time");
    }

    private void cacheNeedInfo(DynamicObject imInterfaceCfg) {
        List interfaceFieldList = WorkbenchServiceHelper.getInterfaceFieldList((DynamicObject)imInterfaceCfg);
        String fieldsMapStr = SerializationUtils.toJsonString((Object)interfaceFieldList);
        this.getPageCache().put(INTERFACE_FIELD_CACHE, fieldsMapStr);
        String tarEntityNumber = imInterfaceCfg.getString("tarbill.number");
        this.getPageCache().put(CAKEY_TAR_ENTITY_TYPE_KEY, tarEntityNumber);
        String srcEntityNumber = imInterfaceCfg.getString("srcbill.number");
        this.getPageCache().put(CAKEY_SRC_ENTITY_TYPE_KEY, srcEntityNumber);
        this.getPageCache().put(INTERFACE_CFG_ID, imInterfaceCfg.getString("id"));
    }

    private void loadEditListData(DynamicObject imInterfaceCfg) {
        String tarEntityNumber = imInterfaceCfg.getString("tarbill.number");
        String srcEntityNumber = imInterfaceCfg.getString("srcbill.number");
        long taskTypeId = imInterfaceCfg.getLong("tasktype.id");
        boolean loadTaskDirect = imInterfaceCfg.getBoolean("loadtaskdirect");
        boolean isRelationCreate = imInterfaceCfg.getBoolean("tasktype.isrelationcreate");
        DynamicObject botp = imInterfaceCfg.getDynamicObject("botp");
        if (!isRelationCreate) {
            this.newTarBill(tarEntityNumber);
        } else if (loadTaskDirect) {
            this.newTarBillByBOTP(srcEntityNumber, taskTypeId, botp);
        }
        DynamicObjectCollection entryDataColl = (DynamicObjectCollection)this.getModel().getDataEntity(true).get(ENTRY_ENTITY);
        if (entryDataColl == null || entryDataColl.isEmpty()) {
            return;
        }
        this.putCache(DETAIL_ROW_INDEX, "0");
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.selectRows(0);
        this.fillDetailData((DynamicObject)entryDataColl.get(0), imInterfaceCfg.getString("id"));
        this.clearDataChanged();
    }

    private void newTarBillByBOTP(String srcEntityNumber, long taskTypeId, DynamicObject botp) {
        DynamicObjectCollection taskDataColl = WorkbenchServiceHelper.getCurrentUserTaskDataByTaskTypeId((long)taskTypeId, (String)srcEntityNumber, null);
        List pushTarBill = new ArrayList(16);
        if (taskDataColl == null || taskDataColl.isEmpty()) {
            return;
        }
        pushTarBill = WorkbenchServiceHelper.getTarBillByBOTP((DynamicObjectCollection)taskDataColl, null, (DynamicObject)botp, (IFormView)this.getView());
        if (pushTarBill == null || pushTarBill.isEmpty()) {
            return;
        }
        this.getPageCache().put(CACHE_DATA_FROM_BOTP_KEY, "true");
        WorkbenchServiceHelper.addEntryRowData(pushTarBill, (IFormView)this.getView());
    }

    private List<DynamicObject> loadBySrcBill(String srcEntityNumber, String billNo, long taskTypeId, DynamicObject botp, Set<Long> existEntryIds) {
        String[] splitBillNos;
        boolean existTaskCreateServiceConf = this.isExistTaskCreateServiceConf(taskTypeId);
        List<DynamicObject> pushTarBill = Collections.emptyList();
        if (existTaskCreateServiceConf) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u5931\u8d25\uff0c\u672a\u627e\u5230\u5355\u636e\u6216\u4efb\u52a1\u5355\u3002", (String)"ImWorkbenchCardListFormPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return pushTarBill;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
        String numberField = ((BillEntityType)dataEntityType).getBillNo();
        QFilter srcFilter = new QFilter(numberField, "in", (Object)(splitBillNos = billNo.split(" ")));
        List srcBillIdList = QueryServiceHelper.queryPrimaryKeys((String)srcEntityNumber, (QFilter[])srcFilter.toArray(), null, (int)-1);
        if (srcBillIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u5931\u8d25\uff0c\u672a\u627e\u5230\u5355\u636e\u6216\u4efb\u52a1\u5355\u3002", (String)"ImWorkbenchCardListFormPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return pushTarBill;
        }
        List tarBills = WorkbenchServiceHelper.getTarBillByBOTP((List)srcBillIdList, (DynamicObject)botp, (IFormView)this.getView());
        this.removeExistRowData(existEntryIds, tarBills);
        return tarBills;
    }

    private void newTarBill(String tarEntityNumber) {
        this.getPageCache().put(CACHE_DATA_FROM_BOTP_KEY, "false");
        DynamicObject bizObj = WorkbenchServiceHelper.newTarBill((String)tarEntityNumber, (IFormView)this.getView());
        WorkbenchServiceHelper.addEntryRowData(Collections.singletonList(bizObj), (IFormView)this.getView());
    }

    public void click(EventObject e) {
        super.click(e);
        String controlName = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            controlName = ((Control)source).getKey();
        }
        if (controlName.equals(SEARCH_VECTOR_AP)) {
            this.showSelectedTaskForm();
        } else if (controlName.startsWith(VECTOR_PREFIX)) {
            Vector vectorIcon = (Vector)this.getView().getControl(controlName);
            String vectorUrl = this.getPageCache().get(controlName);
            Set<String> selSet = this.getDesignSelectTaskClass();
            if (StringUtils.isBlank((CharSequence)vectorUrl) || UNSELECT_FONT.equals(vectorUrl)) {
                vectorIcon.setFontClass(SELECTED_FONT);
                this.getPageCache().put(controlName, SELECTED_FONT);
                selSet.add(controlName.substring(VECTOR_PREFIX.length()));
            } else {
                vectorIcon.setFontClass(UNSELECT_FONT);
                this.getPageCache().put(controlName, UNSELECT_FONT);
                selSet.remove(controlName.substring(VECTOR_PREFIX.length()));
            }
            this.getPageCache().put(SELECTED_TASK_TYPE, SerializationUtils.toJsonString(selSet));
        } else if (controlName.equals("moveupbtap")) {
            this.moveTaskClassPosition(true);
        } else if (controlName.equals("movedownbtap")) {
            this.moveTaskClassPosition(false);
        } else if (controlName.equals("resetbtap")) {
            this.resetClassPosition();
        }
    }

    private void resetClassPosition() {
        Map<String, String> interfaceCfgOrderCacheMap = this.getInterfaceCfgOrderCacheMap();
        ArrayList<String> interfaceCfgIdList = new ArrayList<String>(16);
        for (String idAndName : interfaceCfgOrderCacheMap.values()) {
            String[] split = idAndName.split("#");
            if (split.length <= 0) continue;
            String interfaceCfgId = split[0];
            interfaceCfgIdList.add(TASK_FLEX_PANEL_PREFIX + interfaceCfgId);
        }
        if (!interfaceCfgIdList.isEmpty()) {
            Container control = (Container)this.getControl("taskpanelap");
            control.deleteControls(interfaceCfgIdList.toArray(new String[0]));
        }
        this.loadEditInterfaceCfgData(new HashMap<String, Integer>(16));
        Map curCardConfigMap = this.getCurCardConfigMap();
        curCardConfigMap.remove(INTERFACE_CFG_ORDER_MAP);
        this.updateCurCardConfigMap(curCardConfigMap);
    }

    private void moveTaskClassPosition(boolean isMoveUp) {
        Set<String> designSelectTaskClassSet = this.getDesignSelectTaskClass();
        if (designSelectTaskClassSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u79fb\u52a8\u7684\u5206\u7c7b\u3002", (String)"ImWorkbenchCardListFormPlugin_12", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, String> interfaceCfgOrderMap = this.getInterfaceCfgOrderCacheMap();
        int total = interfaceCfgOrderMap.size();
        if (designSelectTaskClassSet.size() == total) {
            return;
        }
        HashMap<String, Integer> interfaceCfgIdIndexMap = new HashMap<String, Integer>(interfaceCfgOrderMap.size());
        HashMap<String, String> interfaceCfgIdNameMap = new HashMap<String, String>(interfaceCfgOrderMap.size());
        for (Map.Entry<String, String> integerStringEntry : interfaceCfgOrderMap.entrySet()) {
            String value = integerStringEntry.getValue();
            Integer orderNum = Integer.parseInt(integerStringEntry.getKey());
            String[] split = value.split("#");
            interfaceCfgIdIndexMap.put(split[0], orderNum);
            interfaceCfgIdNameMap.put(split[0], split[1]);
        }
        List orderSelectIntrefaceCfgIdList = designSelectTaskClassSet.stream().sorted(Comparator.comparingInt(interfaceCfgIdIndexMap::get)).collect(Collectors.toList());
        Container control = (Container)this.getControl("taskpanelap");
        HashMap<String, Integer> changeIndexMap = new HashMap<String, Integer>(8);
        for (String selectedInterfaceId : orderSelectIntrefaceCfgIdList) {
            String taskName = (String)interfaceCfgIdNameMap.get(selectedInterfaceId);
            int n = (Integer)interfaceCfgIdIndexMap.get(selectedInterfaceId);
            int newIndex = this.getNewIndex(isMoveUp, total, n);
            if (newIndex == -1) continue;
            control.deleteControls(new String[]{TASK_FLEX_PANEL_PREFIX + selectedInterfaceId});
            FlexPanelAp flexPanelAp = this.buildTaskFlexPanelAp(selectedInterfaceId, taskName, true);
            Map controlMap = flexPanelAp.createControl();
            ArrayList<Map> list = new ArrayList<Map>(8);
            list.add(controlMap);
            control.insertControls(newIndex, list);
            String newIndexVal = interfaceCfgOrderMap.get(String.valueOf(newIndex));
            String[] split = newIndexVal.split("#");
            interfaceCfgOrderMap.put(String.valueOf(newIndex), selectedInterfaceId + "#" + (String)taskName);
            Integer movedIndex = (Integer)changeIndexMap.get(selectedInterfaceId);
            if (movedIndex == null) {
                changeIndexMap.put(split[0], n);
                interfaceCfgOrderMap.put(String.valueOf(n), newIndexVal);
            } else {
                changeIndexMap.put(split[0], movedIndex);
                interfaceCfgOrderMap.put(String.valueOf(movedIndex), newIndexVal);
            }
            changeIndexMap.put(selectedInterfaceId, newIndex);
        }
        String orderMapStr = SerializationUtils.toJsonString(interfaceCfgOrderMap);
        this.getPageCache().put(INTERFACE_CFG_ORDER_MAP_CACHE, orderMapStr);
        HashMap<String, Integer> interfaceCfgOrderCustomMap = new HashMap<String, Integer>(interfaceCfgOrderMap.size());
        for (Map.Entry entry : interfaceCfgOrderMap.entrySet()) {
            String value = (String)entry.getValue();
            Integer orderNum = Integer.parseInt((String)entry.getKey());
            String[] split = value.split("#");
            interfaceCfgOrderCustomMap.put(split[0], orderNum);
        }
        String interfaceCfgOrderCustomStr = SerializationUtils.toJsonString(interfaceCfgOrderCustomMap);
        Map map = this.getCurCardConfigMap();
        map.put(INTERFACE_CFG_ORDER_MAP, interfaceCfgOrderCustomStr);
        this.updateCurCardConfigMap(map);
    }

    private Map<String, String> getInterfaceCfgOrderCacheMap() {
        String interfaceCfgOrderStr = this.getPageCache().get(INTERFACE_CFG_ORDER_MAP_CACHE);
        Map<String, String> interfaceCfgOrderMap = new HashMap<String, String>(8);
        if (StringUtils.isNotEmpty((CharSequence)interfaceCfgOrderStr)) {
            interfaceCfgOrderMap = (Map)SerializationUtils.fromJsonString((String)interfaceCfgOrderStr, Map.class);
        }
        return interfaceCfgOrderMap;
    }

    private int getNewIndex(boolean isMoveUp, int total, int nowIndex) {
        int newIndex;
        if (isMoveUp) {
            if (nowIndex == 0) {
                return -1;
            }
            newIndex = nowIndex - 1;
            if (newIndex <= 0) {
                newIndex = 0;
            }
        } else {
            if (nowIndex == total - 1) {
                return -1;
            }
            newIndex = nowIndex + 1;
            if (newIndex > total - 1) {
                newIndex = total - 1;
            }
        }
        return newIndex;
    }

    private Set<String> getDesignSelectTaskClass() {
        String selStr = this.getPageCache().get(SELECTED_TASK_TYPE);
        HashSet<String> selSet = null;
        if (StringUtils.isNotEmpty((CharSequence)selStr)) {
            selSet = (HashSet<String>)SerializationUtils.fromJsonString((String)selStr, Set.class);
            if (selSet == null) {
                selSet = new HashSet(8);
            }
        } else {
            selSet = new HashSet<String>(8);
        }
        return selSet;
    }

    private void showSelectedTaskForm() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("msbd_wb_task_manage");
        listShowParameter.setLookUp(true);
        listShowParameter.setF7Style(0);
        listShowParameter.setMultiSelect(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCustomParam("wbTaskDomain", (Object)"IM");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.setShowTitle(false);
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECTED_TASK_CALLBACK));
        DynamicObject wbInterfaceCfg = this.getInterfaceCfg();
        if (wbInterfaceCfg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u754c\u9762\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ImWorkbenchCardListFormPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("taskstatus", "=", (Object)SAVED);
        qFilter.and("bizuser.operatorid", "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("tasktype", "=", (Object)wbInterfaceCfg.getLong("tasktype.id"));
        String srcEntityType = WorkbenchServiceHelper.getSrcEntityType((IFormView)this.getView());
        if (StringUtils.isNotEmpty((CharSequence)srcEntityType)) {
            qFilter.and("srcobj.number", "=", (Object)srcEntityType);
        }
        listShowParameter.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void putCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private String getCache(String key) {
        return this.getPageCache().get(key);
    }

    private void clearDataChanged() {
        this.getModel().setDataChanged(false);
    }

    private void fillDetailData(DynamicObject rowData, String imInterfaceCfgId) {
        List fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList((IFormView)this.getView());
        Optional<InterfaceCfgField> existTabField = fieldsMappingList.stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getTab())).findAny();
        if (!existTabField.isPresent()) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.down, true);
            return;
        }
        SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
        control.hidePanel(SplitDirection.down, false);
        this.getView().setEnable(Boolean.TRUE, new String[]{"detailflexpanelap"});
        String billId = "";
        String rowId = "";
        if (rowData != null) {
            billId = rowData.getString(BILLID);
            rowId = rowData.getString(ROWID);
            String billNo = rowData.getString("billno");
            if (StringUtils.isNotEmpty((CharSequence)billNo)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"detailflexpanelap"});
            }
        }
        String entryRowDynamicDataStr = WorkbenchServiceHelper.getEntryRowStrData((IFormView)this.getView(), (String)billId);
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        paramMap.put("rowId", rowId);
        paramMap.put("rowData", entryRowDynamicDataStr);
        String detailPageId = this.getPageCache().get("detailPageId");
        if (StringUtils.isNotBlank((CharSequence)detailPageId)) {
            WorkbenchServiceHelper.sendRowChangeEvent((IFormView)this.getView(), paramMap);
            return;
        }
        paramMap.put("id", imInterfaceCfgId);
        paramMap.put("billId", billId);
        paramMap.put("type", this.getCache(CAKEY_TAR_ENTITY_TYPE_KEY));
        paramMap.put(CACHE_DATA_FROM_BOTP_KEY, this.getCache(CACHE_DATA_FROM_BOTP_KEY));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("im_workbench_dltab");
        formShowParameter.getCustomParams().putAll(paramMap);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("detailflexpanelap");
        String pageId = formShowParameter.getPageId();
        this.getPageCache().put("detailPageId", pageId);
        this.getView().showForm(formShowParameter);
    }

    private boolean isDataFromBOTP() {
        return WorkbenchServiceHelper.isDataFromBOTP((IFormView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        String formId = this.getView().getPageCache().get(CAKEY_TAR_ENTITY_TYPE_KEY);
        try {
            WorkbenchBeforeF7SelectHelper.beforeF7Select((String)key, (BeforeF7SelectEvent)evt, (IFormView)this.getView(), (String)formId);
        }
        catch (Exception e) {
            logger.error("\u5b57\u6bb5beforeF7\u4e8b\u4ef6\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void setBaseDataF7Listener() {
        List fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList((IFormView)this.getView());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"im_workbench_modal");
        for (InterfaceCfgField interfaceCfgField : fieldsMappingList) {
            BasedataEdit basedataEdit;
            String interfaceField = interfaceCfgField.getInterfaceField();
            DynamicProperty property = dataEntityType.getProperty(interfaceField);
            if (property instanceof FlexProp) {
                FlexEdit flexEdit = (FlexEdit)this.getControl(interfaceField);
                if (flexEdit == null) continue;
                flexEdit.registerBeforeF7SelectListener((BeforeF7SelectListener)this);
                continue;
            }
            if (!(property instanceof BasedataProp) || (basedataEdit = (BasedataEdit)this.getControl(interfaceField)) == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void ocrBill() {
        String productVersion = LicenseServiceHelper.getProductVersion();
        Long aiGropId = 606L;
        try {
            BigDecimal proVer = new BigDecimal(productVersion);
            if (proVer.compareTo(new BigDecimal("7")) >= 0) {
                aiGropId = 2026183729222894592L;
            }
        }
        catch (Exception ex) {
            logger.info("productVersion:" + productVersion);
        }
        LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)RequestContext.get().getCurrUserId(), (Long)aiGropId);
        boolean hasLicense = licenseCheckResult.getHasLicense();
        if (!hasLicense) {
            FormShowParameter formShowParameter = LicenseServiceHelper.buildNoticeFormShowParameter((String)licenseCheckResult.getMsg(), new ArrayList(0));
            this.getView().showForm(formShowParameter);
            return;
        }
        boolean result = IdentifyUtils.checkGaiPrivacy((IFormView)this.getView(), (IFormPlugin)this);
        if (!result) {
            return;
        }
        this.showImageScanForm();
    }

    private void showImageScanForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(MSBD_IMAGE_SCANNER);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        parameter.setOpenStyle(openStyle);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MSBD_IMAGE_SCANNER));
        this.getView().showForm(parameter);
    }

    private void showGaiPrivacy(String privacyType) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(GAI_PRIVACY_AGREEMENT);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        if (IS_USER_AGREE.equals(privacyType)) {
            fsp.setCustomParam(AGREEMENT_TYPE, (Object)USER_AGREEMENT);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, USER_AGREEMENT));
        } else if (IS_TENANT_AGREE.equals(privacyType)) {
            fsp.setCustomParam(AGREEMENT_TYPE, (Object)TENANT_AGREEMENT);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TENANT_AGREEMENT));
        }
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        IdentifyUtils.executeWithCatchException(() -> {
            switch (actionId) {
                case "msbd_image_scanner": {
                    if (!(returnData instanceof List) || ((List)returnData).isEmpty()) break;
                    this.showOcrCreateBillForm((List)returnData);
                    break;
                }
                case "msbd_ocr_createbill": {
                    if (!(returnData instanceof List) || ((List)returnData).isEmpty()) break;
                    WorkbenchServiceHelper.addEntryRowData((List)((List)returnData), (IFormView)this.getView());
                    WorkbenchServiceHelper.setPageShowProperty((IFormView)this.getView(), (boolean)this.isDataFromBOTP());
                    break;
                }
                case "im_wb_splitbill": {
                    if (!(returnData instanceof List) || ((List)returnData).isEmpty()) break;
                    this.dealSplitResult((List)returnData);
                    WorkbenchServiceHelper.selectedFocusRow((IFormView)this.getView());
                    WorkbenchServiceHelper.setPageShowProperty((IFormView)this.getView(), (boolean)this.isDataFromBOTP());
                    break;
                }
                case "tenantAgreement": {
                    if (!(returnData instanceof String) || !TENANT_AGREE.equals(returnData)) break;
                    boolean userAgree = (Boolean)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPrivacyService", (String)IS_USER_AGREE, (Object[])new Object[0]);
                    if (!userAgree) {
                        this.showGaiPrivacy(IS_USER_AGREE);
                        break;
                    }
                    this.showImageScanForm();
                    break;
                }
                case "userAgreement": {
                    if (!(returnData instanceof String) || !USER_AGREE.equals(returnData)) break;
                    this.showImageScanForm();
                    break;
                }
                case "selected_task_callback": {
                    this.selectedTaskCallBack((ListSelectedRowCollection)returnData);
                    break;
                }
            }
        });
    }

    private void selectedTaskCallBack(ListSelectedRowCollection returnData) {
        Object[] primaryKeyValues = returnData.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObject interfaceCfg = this.getInterfaceCfg();
        if (interfaceCfg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u754c\u9762\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ImWorkbenchCardListFormPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject botp = interfaceCfg.getDynamicObject("botp");
        if (botp == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5206\u7c7b\u7ed1\u5b9a\u7684\u754c\u9762\u914d\u7f6e\u672a\u914d\u7f6ebotp\u8f6c\u6362\u89c4\u5219\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"ImWorkbenchCardListFormPlugin_8", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection taskDataCollection = QueryServiceHelper.query((String)"msbd_wb_task_manage", (String)"id as manangeid,srcid,srcentryid,tasktype,srcentrykey,srcbillno", (QFilter[])qFilter.toArray());
        String billNos = taskDataCollection.stream().map(p -> p.getString("srcbillno")).collect(Collectors.joining(" "));
        Search searchAp = (Search)this.getView().getControl("searchap");
        searchAp.setSearchKey(billNos);
        DynamicObjectCollection newTaskDataCollection = this.getNeedNewTaskData(taskDataCollection);
        if (newTaskDataCollection == null || newTaskDataCollection.isEmpty()) {
            return;
        }
        List tarBillList = WorkbenchServiceHelper.getTarBillByBOTP((DynamicObjectCollection)newTaskDataCollection, (String)"", (DynamicObject)botp, (IFormView)this.getView());
        this.getPageCache().put(CACHE_DATA_FROM_BOTP_KEY, "true");
        WorkbenchServiceHelper.addEntryRowData((List)tarBillList, (IFormView)this.getView());
        WorkbenchServiceHelper.setPageShowProperty((IFormView)this.getView(), (boolean)this.isDataFromBOTP());
    }

    private void dealSplitResult(List<DynamicObject> splitInfos) {
        if (splitInfos == null || splitInfos.isEmpty()) {
            return;
        }
        EntryGrid control = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = control.getSelectRows();
        int selectRow = selectRows[0];
        String billId = (String)this.getModel().getValue(BILLID, selectRow);
        String entryId = (String)this.getModel().getValue(ROWID, selectRow);
        DynamicObject billInfo = WorkbenchServiceHelper.getEntryRowDynamicData((IFormView)this.getView(), (String)billId);
        List fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList((IFormView)this.getView());
        Map<String, String> fieldMap = fieldsMappingList.stream().collect(Collectors.toMap(InterfaceCfgField::getInterfaceField, InterfaceCfgField::getTarBillField));
        String qtyField = fieldMap.get("qty");
        String entityType = WorkbenchServiceHelper.getTargetEntityType((IFormView)this.getView());
        DataEntityPropertyCollection properties = splitInfos.get(0).getDataEntityType().getProperties();
        List updateProps = properties.stream().map(prop -> prop.getName()).filter(prop -> fieldMap.containsKey(prop)).collect(Collectors.toList());
        updateProps.remove("materiel");
        String entryKey = WorkbenchServiceHelper.getTarBillEntryKey((List)fieldsMappingList);
        if (billInfo != null && StringUtils.isNotBlank((CharSequence)entryId)) {
            DynamicObject entry;
            DynamicObjectCollection entries = billInfo.getDynamicObjectCollection(entryKey);
            int index = 0;
            Iterator iterator = entries.iterator();
            while (iterator.hasNext() && !entryId.equals((entry = (DynamicObject)iterator.next()).getString("id"))) {
                ++index;
            }
            DynamicObject entryInfo = (DynamicObject)entries.get(index);
            entries.remove(index);
            long[] ids = DB.genGlobalLongIds((int)splitInfos.size());
            CloneUtils cloneUtils = new CloneUtils(false, true);
            this.getModel().deleteEntryRow(ENTRY_ENTITY, selectRow);
            for (int i = 0; i < splitInfos.size(); ++i) {
                DynamicObject splitInfo = splitInfos.get(i);
                DynamicObject newEntry = (DynamicObject)cloneUtils.clone((IDataEntityBase)entryInfo);
                newEntry.set("id", (Object)ids[i]);
                newEntry.setParent((Object)billInfo);
                for (String updateProp : updateProps) {
                    WorkbenchServiceHelper.setValue((DynamicObject)billInfo, (DynamicObject)newEntry, (String)fieldMap.get(updateProp), (Object)splitInfo.get(updateProp));
                }
                ImWorkbenchCardListFormPlugin.reCalEntry(qtyField, entityType, newEntry);
                this.getModel().insertEntryRow(ENTRY_ENTITY, selectRow);
                WorkbenchServiceHelper.appendRowByTarBillEntry((List)fieldsMappingList, (DynamicObject)billInfo, (DynamicObject)newEntry, (long)ids[i], (int)selectRow, (IFormView)this.getView());
                entries.add(index, newEntry);
                ++index;
                ++selectRow;
            }
            WorkbenchServiceHelper.updateDynamicObjCache((IFormView)this.getView(), (DynamicObject)billInfo);
            this.getView().updateView(ENTRY_ENTITY);
        } else {
            CloneUtils cloneUtils = new CloneUtils(false, true);
            DynamicObject selectEntryInfo = this.getModel().getEntryRowEntity(ENTRY_ENTITY, selectRow);
            this.getModel().deleteEntryRow(ENTRY_ENTITY, selectRow);
            for (DynamicObject splitInfo : splitInfos) {
                DynamicObject newEntryInfo = (DynamicObject)cloneUtils.clone((IDataEntityBase)selectEntryInfo);
                this.getModel().createNewEntryRow(ENTRY_ENTITY, selectRow, newEntryInfo);
                for (String updateProp : updateProps) {
                    this.getModel().setValue(updateProp, splitInfo.get(updateProp), selectRow);
                }
                ++selectRow;
            }
        }
    }

    private static void reCalEntry(String qtyField, String entityType, DynamicObject newEntry) {
        String[] split = qtyField.split("\\.");
        if (split.length == 2) {
            qtyField = split[1];
        } else if (split.length != 1) {
            return;
        }
        Map changePropMaps = AlgorithmHelper.entryCalculate((String)entityType, (DynamicObject)newEntry, (String)qtyField);
        if (changePropMaps != null && !changePropMaps.isEmpty()) {
            for (Map.Entry changePropEntry : changePropMaps.entrySet()) {
                String key = (String)changePropEntry.getKey();
                Object value = changePropEntry.getValue();
                newEntry.set(key, value);
            }
        }
    }

    private void showOcrCreateBillForm(List<IdentifyResultInfo> identifyResultInfos) {
        String interfaceCfgId = this.getPageCache().get(INTERFACE_CFG_ID);
        String botpRuleId = null;
        if (StringUtils.isNotBlank((CharSequence)interfaceCfgId)) {
            DynamicObject configInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(interfaceCfgId), (String)"im_wb_interfacecfg");
            botpRuleId = configInfo.getString("botp.id");
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("msbd_ocr_createbill");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        parameter.setOpenStyle(openStyle);
        parameter.setCustomParam("identifyresult", identifyResultInfos);
        parameter.setCustomParam("botprule", (Object)botpRuleId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "msbd_ocr_createbill"));
        this.getView().showForm(parameter);
    }

    private void splitQty() {
        EntryGrid control = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = control.getSelectRows();
        if (selectRows == null || selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SelectOneEntryToHandleSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        int selectRow = selectRows[0];
        List fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList((IFormView)this.getView());
        Map<String, InterfaceCfgField> fieldMap = fieldsMappingList.stream().collect(Collectors.toMap(InterfaceCfgField::getInterfaceField, cfg -> cfg));
        boolean qtyExists = fieldMap.containsKey("qty");
        String tarBillEntryKey = WorkbenchServiceHelper.getTarBillEntryKey((List)fieldsMappingList);
        StringBuilder errorMsgBuilder = new StringBuilder();
        if (!qtyExists) {
            errorMsgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u754c\u9762\u914d\u7f6e\u4e2d\u914d\u7f6e\u6570\u91cf\u5b57\u6bb5\u3002", (String)"ImWorkbenchCardListFormPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0])).append("\n");
        }
        if (!fieldMap.containsKey("materiel")) {
            errorMsgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u754c\u9762\u914d\u7f6e\u4e2d\u914d\u7f6e\u7269\u6599\u7f16\u7801\u5b57\u6bb5\u3002", (String)"ImWorkbenchCardListFormPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0])).append("\n");
        } else if (this.getModel().getValue("materiel", selectRow) == null) {
            errorMsgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u7f16\u7801\u3002", (String)"ImWorkbenchCardListFormPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0])).append("\n");
        }
        if (!fieldMap.containsKey("billstatus")) {
            errorMsgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u754c\u9762\u914d\u7f6e\u4e2d\u914d\u7f6e\u5355\u636e\u72b6\u6001\u5b57\u6bb5\u3002", (String)"ImWorkbenchCardListFormPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0])).append("\n");
        } else {
            Object billStatus = this.getModel().getValue("billstatus", selectRow);
            if (billStatus != null && !SAVED.equals(billStatus)) {
                errorMsgBuilder.append(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u751f\u5355\u4e0d\u5141\u8bb8\u62c6\u5206\u6570\u91cf\u3002", (String)"ImWorkbenchCardListFormPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0])).append("\n");
            }
        }
        if (errorMsgBuilder.length() > 0) {
            this.getView().showConfirm("", errorMsgBuilder.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
            return;
        }
        String billId = (String)this.getModel().getValue(BILLID, selectRow);
        String entryId = (String)this.getModel().getValue(ROWID, selectRow);
        String billStr = WorkbenchServiceHelper.getEntryRowStrData((IFormView)this.getView(), (String)billId);
        String fieldMapStr = this.getPageCache().get(INTERFACE_FIELD_CACHE);
        HashMap<String, Boolean> fieldLockMap = new HashMap<String, Boolean>(fieldsMappingList.size());
        DynamicObject selectEntryData = this.getModel().getEntryRowEntity(ENTRY_ENTITY, selectRow);
        boolean dataFromBOTP = this.isDataFromBOTP();
        for (InterfaceCfgField cfgField : fieldsMappingList) {
            boolean lock = WorkbenchFieldsConditionShowAndLockHelper.isLock((DynamicObject)selectEntryData, (boolean)dataFromBOTP, (String)cfgField.getInterfaceField());
            fieldLockMap.put(cfgField.getInterfaceField(), lock || cfgField.getLock());
        }
        String entityType = WorkbenchServiceHelper.getTargetEntityType((IFormView)this.getView());
        DynamicObjectType rowType = selectEntryData.getDynamicObjectType();
        FormShowParameter formParameter = new FormShowParameter();
        formParameter.setCustomParam("billInfo", (Object)billStr);
        formParameter.setCustomParam("entryid", (Object)entryId);
        formParameter.setCustomParam("fieldMap", (Object)fieldMapStr);
        formParameter.setCustomParam("entryKey", (Object)tarBillEntryKey);
        formParameter.setCustomParam("entityType", (Object)entityType);
        formParameter.setCustomParam("lockMap", fieldLockMap);
        formParameter.setCustomParam("rowInfo", (Object)DynamicObjectSerializeUtil.serialize((Object[])new Object[]{selectEntryData}, (DynamicObjectType)rowType));
        formParameter.setFormId(IM_WB_SPLITBILL);
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        formParameter.setOpenStyle(style);
        formParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IM_WB_SPLITBILL));
        this.getView().showForm(formParameter);
    }

    protected void refreshCard(Map<String, String> cardConfigMap) {
        super.refreshCard(cardConfigMap);
    }

    private void showOcrBillBtn(String interfaceCfgId) {
        if (KC0101.equals(interfaceCfgId)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{OCRBILL});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OCRBILL});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if ("MaterialLifeDate".equals(callBackId)) {
            String customVaule = e.getCustomVaule();
            List alertMsgList = (List)SerializationUtils.fromJsonString((String)customVaule, List.class);
            for (int i = 0; i < alertMsgList.size(); ++i) {
                Map params = (Map)alertMsgList.get(i);
                Date newExpirydate = WorkbenchServiceHelper.parseDate((String)((String)params.get("newExpiryDate")));
                Date newProducedate = WorkbenchServiceHelper.parseDate((String)((String)params.get("newProduceDate")));
                int rowIndex = (Integer)params.get("index");
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    WorkbenchServiceHelper.setValueNoChange((String)"producedate", (Object)newProducedate, (int)rowIndex, (IFormView)this.getView());
                    WorkbenchServiceHelper.setValueNoChange((String)"expiredate", (Object)newExpirydate, (int)rowIndex, (IFormView)this.getView());
                    continue;
                }
                Date oldProduceDate = WorkbenchServiceHelper.parseDate((String)((String)params.get("oldProduceDate")));
                Date oldExpiryDate = WorkbenchServiceHelper.parseDate((String)((String)params.get("oldExpiryDate")));
                WorkbenchServiceHelper.setValueNoChange((String)"producedate", (Object)oldProduceDate, (int)rowIndex, (IFormView)this.getView());
                WorkbenchServiceHelper.setValueNoChange((String)"expiredate", (Object)oldExpiryDate, (int)rowIndex, (IFormView)this.getView());
            }
        }
    }

    private void doTaskComplete(String key, String taskName, String srcEntityNumber, long taskTypeId, boolean existTaskCreateServiceConf) {
        if (StringUtils.isEmpty((CharSequence)srcEntityNumber)) {
            return;
        }
        DynamicObjectCollection taskDataColl = WorkbenchServiceHelper.getCurrentUserTaskDataByTaskTypeId((long)taskTypeId, (String)srcEntityNumber, (String)"");
        if (taskDataColl == null || taskDataColl.isEmpty()) {
            return;
        }
        ArrayList taskData = new ArrayList(taskDataColl.size());
        for (DynamicObject task : taskDataColl) {
            HashMap<String, String> dataMap = new HashMap<String, String>(2);
            dataMap.put("id", task.getString("srcid"));
            dataMap.put(ROWID, task.getString("srcentryid"));
            taskData.add(dataMap);
        }
        Map compulteResMap = Collections.emptyMap();
        int taskCount = taskDataColl.size();
        try {
            compulteResMap = WorkbenchServiceHelper.doTaskComplete(taskData, (String)srcEntityNumber, (long)taskTypeId);
            String success = compulteResMap.getOrDefault("success", "false");
            int num = compulteResMap.getOrDefault("num", 0);
            if ("true".equals(success) && num > 0 && (taskCount -= num) <= 0) {
                taskCount = 0;
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5fae\u670d\u52a1\u8fdb\u884c\u5de5\u4f5c\u53f0\u4efb\u52a1\u5b8c\u6210\u670d\u52a1\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
        }
        if (existTaskCreateServiceConf) {
            this.updateTaskCount(key, taskName, taskCount);
        }
    }

    private boolean isExistTaskCreateServiceConf(long taskTypeId) {
        QFilter taskServiceConfQf = new QFilter("enable", "=", (Object)"1");
        taskServiceConfQf.and("group", "=", (Object)1931298209213604864L);
        taskServiceConfQf.and("taskservicegroup", "=", (Object)taskTypeId);
        return QueryServiceHelper.exists((String)"msbd_task_service_conf", (QFilter[])taskServiceConfQf.toArray());
    }

    private void updateTaskCount(String key, String taskName, int taskCount) {
        HashMap map = new HashMap(2);
        HashMap<String, String> textMap = new HashMap<String, String>(2);
        map.put("text", textMap);
        String taskShowName = taskName + "\uff08" + taskCount + "\uff09";
        if (taskCount <= 0) {
            taskShowName = taskName;
        }
        textMap.put(RequestContext.get().getLang().name(), taskShowName);
        this.getView().updateControlMetadata(key, map);
    }

    private DataSet getTaskClassificationData() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DataSet taskTypeData = QueryServiceHelper.queryDataSet((String)"query_interfaceCfg_data", (String)"im_wb_interfacecfg", (String)"id,loadtaskdirect,tasktype.id as taskid,tasktype.number as tasknumber,tasktype.name as taskname,tasktype.isrelationcreate as isrelationcreate,srcbill.number as srcentitynumber", (QFilter[])qFilter.toArray(), (String)"id desc");
        QFilter taskServiceConfQf = new QFilter("enable", "=", (Object)"1");
        taskServiceConfQf.and(new QFilter("group", "=", (Object)1931298209213604864L));
        DataSet taskServiceConfData = QueryServiceHelper.queryDataSet((String)"query_taskServiceConf_data", (String)"msbd_task_service_conf", (String)"taskservicegroup", (QFilter[])taskServiceConfQf.toArray(), null).groupBy(new String[]{"taskservicegroup"}).count().finish();
        QFilter taskManageQf = new QFilter("taskstatus", "=", (Object)SAVED);
        taskManageQf.and("bizuser.operatorid", "=", (Object)UserServiceHelper.getCurrentUserId());
        DataSet taskManageData = QueryServiceHelper.queryDataSet((String)"query_taskManage_data", (String)"msbd_wb_task_manage", (String)"tasktype", (QFilter[])taskManageQf.toArray(), null).groupBy(new String[]{"tasktype"}).count().finish();
        taskTypeData = taskTypeData.join(taskServiceConfData, JoinType.LEFT).on("taskid", "taskservicegroup").select(new String[]{"id", "loadtaskdirect", "taskid", "tasknumber", "taskname", "isrelationcreate", "srcentitynumber"}, new String[]{"count as serviceconfcount", "taskservicegroup"}).finish();
        taskTypeData = taskTypeData.join(taskManageData, JoinType.LEFT).on("taskid", "tasktype").select(new String[]{"id", "loadtaskdirect", "taskid", "tasknumber", "taskname", "isrelationcreate", "srcentitynumber", "serviceconfcount"}, new String[]{"count as taskcount"}).finish();
        return taskTypeData;
    }

    private void showSearchIcon(boolean existTaskCreateServiceConf) {
        this.getView().setVisible(Boolean.valueOf(existTaskCreateServiceConf), new String[]{SEARCH_VECTOR_AP});
    }

    private void inputBillNoChange(String billNo, boolean needRecord) {
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            return;
        }
        DynamicObject interfaceCfg = this.getInterfaceCfg();
        if (interfaceCfg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u754c\u9762\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ImWorkbenchCardListFormPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        long taskTypeId = interfaceCfg.getLong("tasktype.id");
        String srcEntityNumber = interfaceCfg.getString("srcbill.number");
        DynamicObject botp = interfaceCfg.getDynamicObject("botp");
        if (botp == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5206\u7c7b\u7ed1\u5b9a\u7684\u754c\u9762\u914d\u7f6e\u672a\u914d\u7f6ebotp\u8f6c\u6362\u89c4\u5219\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"ImWorkbenchCardListFormPlugin_8", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection taskDataColl = WorkbenchServiceHelper.getCurrentUserTaskDataByTaskTypeId((long)taskTypeId, (String)srcEntityNumber, (String)billNo);
        this.removeExistEntryRowByBillNo(billNo);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        Set<Long> existEntryIds = entryEntity.stream().map(entry -> entry.getLong("sourcerowid")).collect(Collectors.toSet());
        List<Object> tarBillList = new ArrayList(16);
        if (taskDataColl == null || taskDataColl.isEmpty()) {
            tarBillList = this.loadBySrcBill(srcEntityNumber, billNo, taskTypeId, botp, existEntryIds);
        } else {
            tarBillList = WorkbenchServiceHelper.getTarBillByBOTP((DynamicObjectCollection)taskDataColl, (String)billNo, (DynamicObject)botp, (IFormView)this.getView());
            this.removeExistRowData(existEntryIds, tarBillList);
        }
        if (tarBillList == null || tarBillList.isEmpty()) {
            return;
        }
        this.getPageCache().put(CACHE_DATA_FROM_BOTP_KEY, "true");
        WorkbenchServiceHelper.addEntryRowData(tarBillList, (IFormView)this.getView());
        WorkbenchServiceHelper.setPageShowProperty((IFormView)this.getView(), (boolean)this.isDataFromBOTP());
        String[] splitBillNos = billNo.split(" ");
        WorkbenchServiceHelper.setBillNoLoadTime((IFormView)this.getView(), (String[])splitBillNos);
    }

    private void removeExistRowData(Set<Long> existEntryIds, List<DynamicObject> tarBillList) {
        List fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList((IFormView)this.getView());
        String tarBillEntryKey = WorkbenchServiceHelper.getTarBillEntryKey((List)fieldsMappingList);
        Optional<InterfaceCfgField> first = fieldsMappingList.stream().filter(field -> "sourcerowid".equals(field.getInterfaceField())).findFirst();
        if (StringUtils.isNotBlank((CharSequence)tarBillEntryKey) && first.isPresent()) {
            String srcEntryIdField = first.get().getTarBillField();
            for (DynamicObject tarBill : tarBillList) {
                DynamicObjectCollection entries = tarBill.getDynamicObjectCollection(tarBillEntryKey);
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entry = (DynamicObject)iterator.next();
                    Object srcEntryId = WorkbenchServiceHelper.getValue((DynamicObject)tarBill, (DynamicObject)entry, (String)srcEntryIdField);
                    if (!existEntryIds.contains(srcEntryId)) continue;
                    iterator.remove();
                }
            }
        }
    }

    private DynamicObjectCollection getNeedNewTaskData(DynamicObjectCollection taskDataCollection) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (entryEntity == null || entryEntity.isEmpty()) {
            return taskDataCollection;
        }
        Map<String, DynamicObject> taskDataMap = taskDataCollection.stream().collect(Collectors.toMap(data -> data.getString("srcid") + data.getString("srcentryid"), data -> data));
        List fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList((IFormView)this.getView());
        for (DynamicObject entryData : entryEntity) {
            String id = entryData.getString(BILLID);
            String sourceId = entryData.getString("sourcebillid");
            String sourceEntryId = entryData.getString("sourcerowid");
            if (StringUtils.isEmpty((CharSequence)id)) continue;
            if (StringUtils.isNotEmpty((CharSequence)sourceId) && StringUtils.isNotEmpty((CharSequence)sourceEntryId)) {
                taskDataMap.remove(sourceId);
                String key = sourceId + sourceEntryId;
                taskDataMap.remove(key);
                continue;
            }
            DynamicObject entryRowDynamicData = WorkbenchServiceHelper.getEntryRowDynamicData((IFormView)this.getView(), (String)id);
            if (entryRowDynamicData == null) continue;
            String tarBillEntryKey = WorkbenchServiceHelper.getTarBillEntryKey((List)fieldsMappingList);
            InterfaceCfgField sourBillIdCfg = WorkbenchServiceHelper.getInterfaceFieldByKey((List)fieldsMappingList, (String)"sourcebillid");
            String tarBillIdField = sourBillIdCfg.getTarBillField();
            if (StringUtils.isEmpty((CharSequence)tarBillIdField)) continue;
            if (!StringUtils.isEmpty((CharSequence)tarBillEntryKey)) {
                DynamicObjectCollection entryCollection = entryRowDynamicData.getDynamicObjectCollection(tarBillEntryKey);
                InterfaceCfgField sourBillRowIdCfg = WorkbenchServiceHelper.getInterfaceFieldByKey((List)fieldsMappingList, (String)"sourcerowid");
                String tarBillRowIdField = sourBillRowIdCfg.getTarBillField();
                if (StringUtils.isEmpty((CharSequence)tarBillRowIdField)) continue;
                for (DynamicObject tarEntryData : entryCollection) {
                    String tarBillId;
                    String tarBillRowId = tarEntryData.getString(tarBillRowIdField);
                    if (tarBillIdField.contains("\\.")) {
                        String[] split = tarBillIdField.split("\\.");
                        tarBillId = tarEntryData.getString(split[1]);
                    } else {
                        tarBillId = entryRowDynamicData.getString(tarBillIdField);
                    }
                    taskDataMap.remove(tarBillId);
                    String key = tarBillId + tarBillRowId;
                    taskDataMap.remove(key);
                }
                continue;
            }
            String tarBillId = entryRowDynamicData.getString(tarBillIdField);
            taskDataMap.remove(tarBillId);
        }
        return taskDataMap.values().stream().collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    private void showOpBtn(DynamicObject imInterfaceCfg) {
        DynamicObjectCollection btEntryCollection = imInterfaceCfg.getDynamicObjectCollection("entrybtentity");
        if (btEntryCollection == null || btEntryCollection.isEmpty()) {
            return;
        }
        for (DynamicObject btEntryData : btEntryCollection) {
            String btn = btEntryData.getString("btn");
            if (OCRBILL.equals(btn)) continue;
            boolean isBtShow = btEntryData.getBoolean("isbtshow");
            this.getView().setVisible(Boolean.valueOf(isBtShow), new String[]{btn});
        }
    }

    private void inputBillNoRecord(String billNo) {
        String[] splitBillNos = billNo.split(" ");
        Set billNos = Arrays.stream(splitBillNos).collect(Collectors.toSet());
        String selectedInterfaceCfgId = this.getSelectedInterfaceCfgId();
        long interfaceCfgId = Long.parseLong(selectedInterfaceCfgId);
        QFilter qFilter = new QFilter("billno", "in", billNos);
        qFilter.and("creator", "in", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("interfacecfg", "=", (Object)interfaceCfgId);
        DynamicObjectCollection existBillNoColl = QueryServiceHelper.query((String)"im_wb_recent_op_record", (String)"id,billno", (QFilter[])qFilter.toArray());
        Map<String, Long> existBillNoMap = existBillNoColl.stream().collect(Collectors.toMap(p -> p.getString("billno"), p -> p.getLong("id")));
        ArrayList<DynamicObject> saveRecentList = new ArrayList<DynamicObject>(splitBillNos.length);
        ArrayList<DynamicObject> updateRecentList = new ArrayList<DynamicObject>(splitBillNos.length);
        for (String splitBillNo : billNos) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"im_wb_recent_op_record");
            dynamicObject.set("billno", (Object)splitBillNo);
            dynamicObject.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            dynamicObject.set("interfacecfg", (Object)interfaceCfgId);
            Long id = existBillNoMap.getOrDefault(splitBillNo, 0L);
            if (id > 0L) {
                dynamicObject.set("id", (Object)id);
                dynamicObject.set("createtime", (Object)System.currentTimeMillis());
                updateRecentList.add(dynamicObject);
                continue;
            }
            saveRecentList.add(dynamicObject);
        }
        if (!saveRecentList.isEmpty()) {
            Object[] saveData = SaveServiceHelper.save((DynamicObject[])saveRecentList.toArray(new DynamicObject[0]));
            this.updateNode(saveData);
        }
        if (!updateRecentList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateRecentList.toArray(new DynamicObject[0]));
        }
        QFilter qCountFilter = new QFilter("creator", "in", (Object)UserServiceHelper.getCurrentUserId());
        qCountFilter.and("interfacecfg", "=", (Object)interfaceCfgId);
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"im_wb_recent_op_record", (QFilter[])qCountFilter.toArray(), (String)"createtime asc", (int)-1);
        if (objects != null && !objects.isEmpty() && objects.size() > 100) {
            int removeCount = objects.size() - 100;
            List removeIdList = objects.subList(0, removeCount);
            QFilter idF = new QFilter("id", "in", removeIdList);
            DeleteServiceHelper.delete((String)"im_wb_recent_op_record", (QFilter[])idF.toArray());
        }
    }

    private void updateNode(Object[] saveData) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(saveData.length);
        for (Object saveDatum : saveData) {
            DynamicObject saveDy = (DynamicObject)saveDatum;
            String interfaceCfg = saveDy.getString("interfacecfg");
            String saveBillNo = saveDy.getString("billno");
            TreeNode treeNode = new TreeNode(interfaceCfg, saveBillNo, saveBillNo);
            nodes.add(treeNode);
        }
        String nodeStr = this.getPageCache().get("recordTreeNodes");
        if (StringUtils.isBlank((CharSequence)nodeStr)) {
            this.loadRecentOpRecord();
            return;
        }
        List treeNodeList = SerializationUtils.fromJsonStringToList((String)nodeStr, TreeNode.class);
        String selectedInterfaceCfgId = this.getSelectedInterfaceCfgId();
        Optional<TreeNode> firstInterfaceCfg = treeNodeList.stream().filter(p -> p.getId().equals(selectedInterfaceCfgId)).findFirst();
        if (!firstInterfaceCfg.isPresent()) {
            this.loadRecentOpRecord();
            return;
        }
        TreeNode treeNode = firstInterfaceCfg.get();
        treeNodeList.removeIf(p -> p.getId().equals(selectedInterfaceCfgId));
        List children = treeNode.getChildren();
        TreeView control = (TreeView)this.getControl("treeviewap");
        children.addAll(0, nodes);
        if (children.size() > 10) {
            treeNode.setChildren(children.subList(0, 10));
        }
        control.updateNode(treeNode);
        treeNodeList.add(treeNode);
        control.expand(selectedInterfaceCfgId);
        String treeNodeStr = SerializationUtils.toJsonString((Object)treeNodeList);
        this.getPageCache().put("recordTreeNodes", treeNodeStr);
    }

    private void loadRecentOpRecord() {
        String billNo;
        QFilter qFilter = new QFilter("creator", "in", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("interfacecfg.enable", "=", (Object)Character.valueOf('1'));
        DataSet[] dataSets = QueryServiceHelper.queryDataSet((String)"im_op_record_count", (String)"im_wb_recent_op_record", (String)"id,billno,interfacecfg.id as interfacecfgid, interfacecfg.tasktype.name as taskname,createtime", (QFilter[])qFilter.toArray(), (String)"createtime desc").splitByGroup(new String[]{"interfacecfgid"});
        if (dataSets == null || dataSets.length == 0) {
            return;
        }
        HashMap<String, List> taskMapList = new HashMap<String, List>(16);
        for (DataSet dataSet : dataSets) {
            try (DataSet limitDataSet = dataSet.limit(0, 10);){
                for (Row row : limitDataSet) {
                    HashMap<String, String> dataMap = new HashMap<String, String>(4);
                    String interfaceCfgId = row.getString("interfacecfgid");
                    String taskName = row.getString("taskname");
                    billNo = row.getString("billno");
                    dataMap.put("interfacecfgid", interfaceCfgId);
                    dataMap.put("taskname", taskName);
                    dataMap.put("billno", billNo);
                    List mapList = taskMapList.computeIfAbsent(interfaceCfgId, k -> new ArrayList(16));
                    mapList.add(dataMap);
                }
            }
        }
        Map<String, Integer> orderMap = this.getUserInterfaceCfgOrderMap();
        for (String key : taskMapList.keySet()) {
            orderMap.computeIfAbsent(key, k -> orderMap.put(key, orderMap.size()));
        }
        List orderInterfaceCfgIdList = taskMapList.keySet().stream().sorted(Comparator.comparingInt(orderMap::get)).collect(Collectors.toList());
        ArrayList<TreeNode> parentNodes = new ArrayList<TreeNode>(16);
        for (String interfaceCfgId : orderInterfaceCfgIdList) {
            List mapList = (List)taskMapList.get(interfaceCfgId);
            if (mapList == null || mapList.isEmpty()) continue;
            String taskName = (String)((Map)mapList.get(0)).get("taskname");
            TreeNode treeNode = new TreeNode("", interfaceCfgId, taskName);
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(mapList.size());
            for (Map dataMap : mapList) {
                billNo = (String)dataMap.get("billno");
                nodes.add(new TreeNode(interfaceCfgId, billNo, billNo));
            }
            treeNode.addChildren(nodes);
            parentNodes.add(treeNode);
        }
        TreeView control = (TreeView)this.getControl("treeviewap");
        control.addNodes(parentNodes);
        String nodeStr = SerializationUtils.toJsonString(parentNodes);
        this.getPageCache().put("recordTreeNodes", nodeStr);
    }

    private void removeExistEntryRowByBillNo(String billNo) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        String[] splitBillNos = billNo.split(" ");
        HashSet<String> billNoSet = new HashSet<String>(Arrays.asList(splitBillNos));
        HashSet<Integer> delRows = new HashSet<Integer>(8);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String sourceBillNo = entry.getString("sourcebillno");
            if (!StringUtils.isNotBlank((CharSequence)sourceBillNo) || !billNoSet.contains(sourceBillNo)) continue;
            delRows.add(i);
        }
        int[] array = delRows.stream().mapToInt(Integer::intValue).toArray();
        this.getModel().beginInit();
        this.getModel().deleteEntryRows(ENTRY_ENTITY, array);
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }
}

