/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.workbench;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.utils.FormUtils;

public class ImWorkbenchInterfaceCfgEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"botp"});
    }

    public void beforeBindData(EventObject e) {
        this.loadEntryInterfaceField();
        this.loadEntryTarBillField();
        this.loadEntryTabField();
        this.loadBtEntryBtField();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
        this.getView().setEnable(Boolean.valueOf(isPreset == false), new String[]{"conentpanel"});
        this.getView().setEnable(Boolean.valueOf(isPreset == false), new String[]{"bar_save"});
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        if ("entryentity".equals(entryProp.getName())) {
            this.interfaceFieldChange();
            this.tarBillFieldChange();
        } else if ("entrybtentity".equals(entryProp.getName())) {
            this.loadBtEntryBtField();
        }
    }

    private void loadEntryInterfaceField() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Set<String> hasSelectedInterfaceFields = entryEntity.stream().map(p -> p.getString("interfacefield")).collect(Collectors.toSet());
        this.buildEntityComboItems("im_workbench_modal", "interfacefield", hasSelectedInterfaceFields);
    }

    private void loadEntryTarBillField() {
        DynamicObject tarBill = (DynamicObject)this.getModel().getValue("tarbill");
        if (tarBill != null) {
            String number = tarBill.getString("number");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Set<String> hasSelectedTarFields = entryEntity.stream().map(p -> p.getString("tarbillfield")).collect(Collectors.toSet());
            this.buildEntityComboItems(number, "tarbillfield", hasSelectedTarFields);
        }
    }

    private void loadEntryTabField() {
        String id = MetadataDao.getIdByNumber((String)"im_workbench_dltab", (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List items = formMeta.getItems();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (ControlAp item : items) {
            if (!(item instanceof TabPageAp)) continue;
            comboItems.add(new ComboItem(item.getName(), item.getKey()));
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("wbtab");
        comboEdit.setComboItems(comboItems);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String f7FiledKey = evt.getProperty().getName();
        if ("botp".equals(f7FiledKey)) {
            DynamicObject srcBill = (DynamicObject)this.getModel().getValue("srcbill");
            DynamicObject tarBill = (DynamicObject)this.getModel().getValue("tarbill");
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            if (srcBill != null) {
                qFilterList.add(new QFilter("sourceentitynumber", "=", srcBill.getPkValue()));
            }
            if (tarBill != null) {
                qFilterList.add(new QFilter("targetentitynumber", "=", tarBill.getPkValue()));
            }
            evt.setCustomQFilters(qFilterList);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        switch (propertyName) {
            case "tasktype": {
                this.taskTypeChange(newValue);
                break;
            }
            case "srcbill": {
                this.srcBillChange();
                break;
            }
            case "tarbill": {
                this.tarBillChange();
                break;
            }
            case "tarbillfield": {
                this.tarBillFieldChange();
                break;
            }
            case "interfacefield": {
                this.interfaceFieldChange();
                break;
            }
            case "btn": {
                this.btnChange();
                break;
            }
        }
    }

    private void taskTypeChange(Object newValue) {
        if (Objects.nonNull(newValue)) {
            DynamicObject taskType = (DynamicObject)newValue;
            boolean isRelationCreate = taskType.getBoolean("isrelationcreate");
            BasedataEdit srcBillEdit = (BasedataEdit)this.getControl("srcbill");
            srcBillEdit.setMustInput(isRelationCreate);
        }
        this.getModel().setValue("botp", null);
        this.getModel().setValue("srcbill", null);
    }

    private void srcBillChange() {
        this.getModel().setValue("botp", null);
    }

    private void tarBillChange() {
        this.getModel().setValue("botp", null);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        this.getModel().beginInit();
        for (DynamicObject entryData : entryEntity) {
            entryData.set("tarbillfield", null);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.loadEntryTarBillField();
    }

    private void tarBillFieldChange() {
        this.loadEntryTarBillField();
    }

    private void interfaceFieldChange() {
        this.loadEntryInterfaceField();
    }

    private void btnChange() {
        this.loadBtEntryBtField();
        this.getModel().setValue("opcode", null);
    }

    public void buildEntityComboItems(String entityNumber, String comboKey, Set<String> hasSelectedTarFields) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allFields = dataEntityType.getAllFields();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        IDataEntityType parent = null;
        String key = null;
        LocaleString name = null;
        for (IDataEntityProperty pro : allFields.values()) {
            parent = pro.getParent();
            if (parent instanceof MainEntityType) {
                key = pro.getName();
                name = pro.getDisplayName();
            } else if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                key = parent.getName() + '.' + pro.getName();
                name = new LocaleString(parent.getDisplayName().getLocaleValue() + '.' + pro.getDisplayName().getLocaleValue());
            } else if (parent instanceof EntryType && parent.getParent() instanceof EntryType) {
                EntryType grandParent = (EntryType)parent.getParent();
                key = grandParent.getName() + '.' + parent.getName() + '.' + pro.getName();
                name = new LocaleString(grandParent.getDisplayName().getLocaleValue() + '.' + parent.getDisplayName().getLocaleValue() + '.' + pro.getDisplayName().getLocaleValue());
            }
            if (!hasSelectedTarFields.contains(key)) {
                comboItems.add(new ComboItem(name, key));
                continue;
            }
            comboItems.add(new ComboItem(name, key, true, null));
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(comboKey);
        comboEdit.setComboItems(comboItems);
    }

    private void loadBtEntryBtField() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrybtentity");
        Set hasSelectedBtnSet = entryEntity.stream().map(p -> p.getString("btn")).collect(Collectors.toSet());
        String id = MetadataDao.getIdByNumber((String)"im_workbench_editlist", (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List items = formMeta.getItems();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (ControlAp item : items) {
            String parentId;
            ControlAp parentItem;
            String parentItemKey;
            if (!(item instanceof ButtonAp)) continue;
            boolean invisible = item.isInvisible();
            String visible = item.getVisible();
            if (invisible || StringUtils.isBlank((CharSequence)visible) || !"searchflexpanelap".equals(parentItemKey = (parentItem = formMeta.getItem(parentId = item.getParentId())).getKey()) && !"optoolbarap".equals(parentItemKey)) continue;
            comboItems.add(new ComboItem(item.getName(), item.getKey(), hasSelectedBtnSet.contains(item.getKey()), null));
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("btn");
        comboEdit.setComboItems(comboItems);
    }
}

