/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.invp.common.enumeration.InitContextEnum;

public class InvpInitModelHelper {
    private static final Log logger = LogFactory.getLog(InvpInitModelHelper.class);

    public static Set<Long> getOrgIdsByPlanView() {
        HashSet<Long> idSet = new HashSet<Long>(16);
        QFilter viewFilter = new QFilter("view", "=", (Object)914427355726916608L);
        QFilter ctrlFilter = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)InvpInitModelHelper.class.getName(), (String)"bos_org_structure", (String)"org,isctrlunit", (QFilter[])new QFilter[]{viewFilter, ctrlFilter}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            long id = row.getLong("org");
            idSet.add(id);
        }
        logger.info("\u83b7\u53d6\u5230\u7684\u8ba1\u5212\u63a7\u5236\u89c6\u56fe\u7ec4\u7ec7ID\u96c6\u5408\u4e3a\uff1a" + idSet);
        return idSet;
    }

    public static void initConfigData(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        ArrayList<InitContextEnum> values = new ArrayList<InitContextEnum>(Arrays.asList(InitContextEnum.values()));
        DataSet initItems = QueryServiceHelper.queryDataSet((String)InvpInitModelHelper.class.getName(), (String)"invp_init_model", (String)"modelitem", (QFilter[])new QFilter[]{qFilter}, null);
        while (initItems.hasNext()) {
            Row row = initItems.next();
            String initType = row.getString("modelitem");
            InitContextEnum initEnum = null;
            switch (initType) {
                case "A": {
                    initEnum = InitContextEnum.ResModule;
                    break;
                }
                case "B": {
                    initEnum = InitContextEnum.AlgoModule;
                    break;
                }
            }
            if (initEnum == null) continue;
            values.remove((Object)initEnum);
        }
        for (InitContextEnum initContextEnum : values) {
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"invp_init_model");
            data.set("org", (Object)orgId);
            data.set("createtime", (Object)new Date());
            data.set("creator", (Object)RequestContext.get().getCurrUserId());
            data.set("initstatus", (Object)"B");
            data.set("inittext", (Object)initContextEnum.getValue());
            String modelItem = "";
            switch (initContextEnum) {
                case ResModule: {
                    modelItem = "A";
                    break;
                }
                case AlgoModule: {
                    modelItem = "B";
                    break;
                }
            }
            data.set("modelitem", (Object)modelItem);
            list.add(data);
        }
        if (values.isEmpty()) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    public static void initInvPlanData(long useOrgId, List<Long> ids, List<InitContextEnum> initEnums) {
        if (ids.isEmpty() || initEnums.isEmpty()) {
            return;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)useOrgId, (String)"bos_org");
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        for (InitContextEnum initEnum : initEnums) {
            switch (initEnum) {
                case ResModule: {
                    List<String> modelList = Arrays.asList("avgconsumptiondata", "demandmodeldata", "supplymodeldata", "safestockdata");
                    InvpInitModelHelper.execInit("invp_model_register", modelList, useOrgId, userId, org, user, null);
                    break;
                }
                case AlgoModule: {
                    InvpInitModelHelper.initAlgoModule(useOrgId, userId, org, user);
                    break;
                }
            }
        }
        Timestamp timestamp = new Timestamp(new Date().getTime());
        String updateSql = "update t_invp_initmodel set finitstatus = 'A',fmodifierid = ?, fmodifytime = ? where fid = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(ids.size());
        for (Long id : ids) {
            Object[] p = new Object[]{userId, timestamp, id};
            params.add(p);
        }
        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updateSql, params);
    }

    private static void initAlgoModule(long orgId, Long userId, DynamicObject org, DynamicObject user) {
        List<String> algoSteps = Arrays.asList("algoregister01", "algoregister02", "algoregister03", "algoregister04", "algoregister05", "algoregister06", "algoregister07", "algoregister08", "algoregister09", "algoregister10");
        List<Long> registerIds = InvpInitModelHelper.execInit("invp_algoregister", algoSteps, orgId, userId, org, user, null);
        InvpInitModelHelper.execInit("invp_algoconfig", Collections.singletonList("algoconfig"), orgId, userId, org, user, registerIds);
    }

    private static List<Long> execInit(String entity, List<String> sourceNums, long orgId, Long userId, DynamicObject org, DynamicObject user, List<Long> registerIds) {
        OperationResult submitResult;
        List<String> initResources = InvpInitModelHelper.getInitResources(sourceNums);
        ArrayList<Long> result = new ArrayList<Long>(initResources.size());
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(initResources.size());
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entity);
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds((IDataEntityType)dt, initResources.size());
        for (int i = 0; i < initResources.size(); ++i) {
            String resources = initResources.get(i);
            Object[] deserialize = DynamicObjectSerializeUtil.deserialize((String)resources, (DynamicObjectType)dt);
            DynamicObject newData = (DynamicObject)OrmUtils.clone((Object)deserialize[0], (IDataEntityType)dt, (boolean)true, (boolean)true);
            Date date = new Date();
            String strgy = BaseDataServiceHelper.getBdCtrlStrgy((String)entity, (String)String.valueOf(orgId));
            newData.set("masterid", (Object)ids[i]);
            newData.set("org", (Object)org);
            newData.set("org_id", (Object)orgId);
            newData.set("createorg", (Object)org);
            newData.set("createorg_id", (Object)orgId);
            newData.set("id", (Object)ids[i]);
            newData.set("createtime", (Object)date);
            newData.set("modifytime", (Object)date);
            newData.set("creator", (Object)user);
            newData.set("creator_id", (Object)userId);
            newData.set("modifier", (Object)userId);
            newData.set("modifier_id", (Object)user);
            newData.set("ctrlstrategy", (Object)strgy);
            String newNumber = CodeRuleServiceHelper.getNumber((String)entity, (DynamicObject)newData, (String)"");
            if (!StringUtils.isBlank((CharSequence)newNumber)) {
                newData.set("number", (Object)newNumber);
            }
            if ("invp_algoconfig".equals(entity) && registerIds != null) {
                DynamicObjectCollection collection = newData.getDynamicObjectCollection("entryentity");
                for (int j = 0; j < collection.size(); ++j) {
                    DynamicObject entry = (DynamicObject)collection.get(j);
                    entry.set("algorithm", (Object)registerIds.get(j));
                    entry.set("algorithm_id", (Object)registerIds.get(j));
                }
            }
            saveData.add(newData);
            result.add(ids[i]);
        }
        if (saveData.isEmpty()) {
            return new ArrayList<Long>();
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entity, (DynamicObject[])saveData.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            StringBuilder tip = new StringBuilder();
            String msg = ResManager.loadKDString((String)"\u751f\u6210\u7684", (String)"InvpInitModelHelper_0", (String)"scmc-invp-formplugin", (Object[])new Object[0]);
            tip.append(msg).append(((DynamicObject)saveData.get(0)).getDataEntityType().getDisplayName().getLocaleValue()).append(":\r\n");
            for (IOperateInfo info2 : operationResult.getAllErrorOrValidateInfo()) {
                tip.append(info2.getMessage()).append("\r\n");
            }
            throw new KDBizException(tip.toString());
        }
        if (("invp_algoregister".equals(entity) || "invp_algoconfig".equals(entity)) && !(submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)entity, (DynamicObject[])saveData.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())).isSuccess()) {
            List submitErrInfos = submitResult.getAllErrorOrValidateInfo();
            submitErrInfos.forEach(info -> logger.error(info.getMessage()));
            throw new KDBizException(submitResult.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getInitResources(List<String> sourceNums) {
        ArrayList<String> sources = new ArrayList<String>(4);
        InputStream in = InvpInitModelHelper.class.getResourceAsStream("/quickinit-data");
        if (in == null) {
            return sources;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            boolean flag = false;
            while ((line = reader.readLine()) != null) {
                if (flag) {
                    sources.add(line);
                    flag = false;
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)line) || !sourceNums.contains(line)) continue;
                flag = true;
            }
        }
        catch (IOException e) {
            logger.error(InvpInitModelHelper.class.getName() + ":" + e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error(InvpInitModelHelper.class.getName() + ":" + e.getMessage());
            }
        }
        return sources;
    }
}

