/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.bean;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class DacExceptionFilter {
    private MainEntityType modelType;
    private String filter;
    private BigDecimal overPercent;
    private BigDecimal underPercent;
    private BigDecimal avgBaseQty;
    private BigDecimal overBaseQty;
    private BigDecimal underBaseQty;
    private Set<String> fields;

    public DacExceptionFilter(String entityKey, String filter, BigDecimal avgBaseQty, BigDecimal overPercent, BigDecimal underPercent) {
        this.modelType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        this.filter = filter;
        this.avgBaseQty = avgBaseQty;
        this.overPercent = overPercent;
        this.underPercent = underPercent;
        if (null != overPercent && overPercent.compareTo(BigDecimal.ZERO) > 0) {
            this.overBaseQty = avgBaseQty.multiply(overPercent).add(avgBaseQty);
        }
        if (null != underPercent && underPercent.compareTo(BigDecimal.ZERO) > 0) {
            this.underBaseQty = avgBaseQty.subtract(avgBaseQty.multiply(underPercent));
        }
        if (StringUtils.isNotBlank((CharSequence)this.filter)) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"invp_dac_model");
            RowDataModel rowDataModel = new RowDataModel("invp_dac_model", mainEntityType);
            ExpressionParameter expressionParameter = new ExpressionParameter(this.filter, rowDataModel);
            this.fields = expressionParameter.getBOSExpression().getVars();
        }
    }

    public boolean isFilterData(Row modelDym, BigDecimal baseQty) {
        if (!this.isCheck(modelDym)) {
            return false;
        }
        if (null != this.overBaseQty && baseQty.compareTo(this.overBaseQty) > 0) {
            return true;
        }
        return null != this.underBaseQty && baseQty.compareTo(this.underBaseQty) < 0;
    }

    private boolean isCheck(Row modelDym) {
        if (StringUtils.isBlank((CharSequence)this.filter)) {
            return true;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"invp_dac_model");
        HashMap<String, Object> valMap = new HashMap<String, Object>(this.fields.size());
        for (String field : this.fields) {
            DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)field);
            if (property instanceof BasedataProp) {
                String entityKey = ((BasedataProp)property).getBaseEntityId();
                Object pkId = modelDym.get(property.getName());
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)entityKey, (String)field);
                Object val = dynamicObject.get(StringUtils.substringAfterLast((String)field, (String)"."));
                if (val instanceof OrmLocaleValue) {
                    valMap.put(field, ((OrmLocaleValue)val).getDefaultItem());
                    continue;
                }
                valMap.put(field, val);
                continue;
            }
            valMap.put(field, modelDym.get(property.getName()));
        }
        return (Boolean)FormulaEngine.execExcelFormula((String)this.filter, valMap);
    }

    public MainEntityType getModelType() {
        return this.modelType;
    }

    public String getFilter() {
        return this.filter;
    }

    public BigDecimal getOverPercent() {
        return this.overPercent;
    }

    public BigDecimal getUnderPercent() {
        return this.underPercent;
    }

    public BigDecimal getAvgBaseQty() {
        return this.avgBaseQty;
    }

    public BigDecimal getOverBaseQty() {
        return this.overBaseQty;
    }

    public BigDecimal getUnderBaseQty() {
        return this.underBaseQty;
    }
}

