/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.bean;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;

public class DateRangeFilter {
    private Date startDate;
    private Date endDate;
    private BigDecimal periodDays;
    private BigDecimal factor;

    public DateRangeFilter(Date today, int year, int start, int end, BigDecimal factor) {
        Date preYear = DateUtils.addYears((Date)today, (int)(-year));
        this.startDate = DateUtils.addDays((Date)preYear, (int)start);
        this.endDate = DateUtils.addDays((Date)preYear, (int)end);
        this.periodDays = new BigDecimal(end - start);
        this.factor = factor;
    }

    public QFilter getQFilter(String dateField) {
        return new QFilter(dateField, ">=", (Object)this.startDate).and(dateField, "<", (Object)this.endDate);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public BigDecimal getPeriodDays() {
        return this.periodDays;
    }

    public BigDecimal getFactor() {
        return this.factor;
    }
}

