/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.consumer;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.scmc.invp.common.helper.InvpFactorCalHelper;

public class InvpFactorCalBaseConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(InvpFactorCalBaseConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker messageAcker) {
        Date execTime = new Date();
        boolean enableLog = false;
        Object masterId = null;
        Object subTaskNo = null;
        String logEntityName = null;
        try {
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)((String)body), Map.class);
            Object schemaId = paramMap.get("schemaId");
            masterId = paramMap.get("masterId");
            subTaskNo = paramMap.get("subtaskno");
            Object levelInfo = paramMap.get("levelList");
            if (levelInfo == null) {
                log.info("\u5f53\u524d\u6279\u6b21\u83b7\u53d6\u5230\u7684\u6c34\u4f4d\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u8ba1\u7b97\uff0c\u4e3b\u4efb\u52a1\u53f7={}\uff0c \u5b50\u4efb\u52a1\u53f7={}", masterId, subTaskNo);
                return;
            }
            List levelList = (List)levelInfo;
            enableLog = "TRUE".equals(paramMap.get("enablelog"));
            logEntityName = paramMap.get("logentityname") == null ? "" : paramMap.get("logentityname").toString();
            this.calc(schemaId, levelList);
            if (enableLog) {
                InvpFactorCalHelper.updateLogStatus(masterId, subTaskNo, "B", execTime, null, logEntityName);
            }
            messageAcker.ack(messageId);
        }
        catch (Exception e) {
            if (enableLog) {
                InvpFactorCalHelper.updateLogStatus(masterId, subTaskNo, "C", execTime, e, logEntityName);
            }
            log.error((Throwable)e);
            messageAcker.discard(messageId);
        }
    }

    protected void calc(Object schemaId, List<Object> levelList) {
    }
}

