/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.func;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditionType;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.UDFunction;
import kd.scmc.invp.business.func.GetRelationOrg;

public class ExpressionCalcFunc
extends MapFunction {
    private RowMeta rowMeta;
    private Map<String, String> formulaMap;
    private Map<String, String> condExpressionMap;
    private FunctionManage functionManage;
    MainEntityType dataEntityType;

    public ExpressionCalcFunc(MainEntityType dataEntityType, RowMeta rowMeta, Map<String, String> formulaMap, Map<String, String> condExpressionMap) {
        this.rowMeta = rowMeta;
        this.formulaMap = formulaMap;
        this.condExpressionMap = condExpressionMap;
        this.dataEntityType = dataEntityType;
        this.functionManage = FunctionManage.get();
        this.functionManage.addFunc("GetRelationOrg", (BOSUDFunction)new GetRelationOrg());
    }

    public Object[] map(Row row) {
        Map rowMap = RowUtil.toMap((Row)row);
        HashMap param = new HashMap();
        rowMap.forEach((field, value) -> {
            if (field.endsWith("_XX")) {
                param.put(field.replace("_XX", ""), value);
            }
        });
        Object[] objArr = RowUtil.toArray((Row)row);
        BOSUDFunction[] bosUdFunctions = this.functionManage.getFuncMap().values().toArray(new BOSUDFunction[0]);
        for (Map.Entry<String, String> fieldExpression : this.formulaMap.entrySet()) {
            Object result;
            objArr[this.rowMeta.getFieldIndex((String)fieldExpression.getKey())] = result = FormulaEngine.execExcelFormula((String)fieldExpression.getValue(), param, (UDFunction[])bosUdFunctions);
        }
        block1: for (Map.Entry<String, String> condExpressionEntry : this.condExpressionMap.entrySet()) {
            String condExpression = condExpressionEntry.getValue();
            CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)condExpression, CRValByConditions.class);
            List conditionItems = valByConditions.getItems();
            for (CRValByCondition conditionItem : conditionItems) {
                String filterExpression;
                CRCondition condition = conditionItem.getCondition();
                boolean condResult = true;
                if (condition != null && CRValByConditionType.ByCondition.equals((Object)conditionItem.getSelectType()) && StringUtils.isNotBlank((CharSequence)(filterExpression = condition.buildFullFormula(this.dataEntityType)))) {
                    condResult = (Boolean)FormulaEngine.execExcelFormula((String)filterExpression, param, (UDFunction[])bosUdFunctions);
                }
                if (!condResult) continue;
                CRFormula formula = conditionItem.getFormula();
                Object result = null;
                if (formula != null && StringUtils.isNotBlank((CharSequence)formula.getExpression())) {
                    result = FormulaEngine.execExcelFormula((String)formula.getExpression(), param, (UDFunction[])bosUdFunctions);
                }
                objArr[this.rowMeta.getFieldIndex((String)condExpressionEntry.getKey())] = result;
                continue block1;
            }
        }
        return objArr;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

