/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.func;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class GetRelationOrg
implements BOSUDFunction {
    public GetRelationOrg() {
    }

    public GetRelationOrg(ExpressionContext expContext) {
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new GetRelationOrg(expContext);
    }

    public String getName() {
        return "GetRelationOrg";
    }

    public Object call(Object ... objects) {
        Long owner = Long.parseLong(objects[0].toString());
        Long recorg = Long.parseLong(objects[1].toString());
        Long reqorg = Long.parseLong(objects[2].toString());
        return this.getValue(owner, recorg, reqorg);
    }

    private Long getValue(long realOwner, long realRecorgId, long realReqorgId) {
        if (realOwner != 0L) {
            return realOwner;
        }
        if (realRecorgId != 0L) {
            Map<String, Object> relationMap = GetRelationOrg.getDelegationOrgList(realRecorgId);
            if (relationMap == null || relationMap.isEmpty() || relationMap.get("data") == null) {
                return this.calStrategyOrgId(realRecorgId);
            }
            if (relationMap.get("data") != null) {
                ArrayList orgList = (ArrayList)relationMap.get("data");
                if (orgList.isEmpty()) {
                    return this.calStrategyOrgId(realRecorgId);
                }
                return this.calStrategyOrgId(realReqorgId);
            }
        }
        return 0L;
    }

    private static Map<String, Object> getDelegationOrgList(Long orgId) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType("05");
        param.setToViewType("10");
        param.setDirectViewType("toorg");
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
    }

    private static Long getRealId(String field, Row data) {
        long realId = 0L;
        if ((field = field.trim()) != null && (field.matches("[1-9]+[0-9]*") || "0".equals(field))) {
            return Long.parseLong(field);
        }
        if (field != null && data != null && data.get(field) != null && (realId = data.getLong(field).longValue()) != 0L) {
            return realId;
        }
        return 0L;
    }

    public Long calStrategyOrgId(long orgId) {
        boolean hasAccountBiz = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
        if (hasAccountBiz) {
            return orgId;
        }
        Map orgParentMap = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"10", Collections.singletonList(orgId));
        if (orgParentMap == null || orgParentMap.isEmpty()) {
            return 0L;
        }
        return (Long)((Map.Entry)orgParentMap.entrySet().stream().findFirst().get()).getValue();
    }
}

