/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.invp.business.func;

import java.util.Map;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.util.StringUtils;
import kd.scmc.invp.business.pojo.InvSupplyPolicy;

public class SupplyOrderFunc
extends MapFunction {
    private RowMeta rowMeta;
    private InvSupplyPolicy supplyPolicy;

    public SupplyOrderFunc(RowMeta rowMeta, InvSupplyPolicy supplyPolicy) {
        this.rowMeta = rowMeta;
        this.supplyPolicy = supplyPolicy;
    }

    public Object[] map(Row row) {
        String ownerType;
        Object[] valueArr = RowUtil.toArray((Row)row);
        Map<Long, Integer> storeStateMap = this.supplyPolicy.getStoreStateMap();
        if (storeStateMap != null && storeStateMap.containsKey(row.getLong("invstatus"))) {
            Integer soreStateOrder = storeStateMap.get(row.getLong("invstatus"));
            valueArr[this.rowMeta.getFieldIndex((String)"invstatuspriority")] = soreStateOrder;
        }
        Map<Long, Integer> storageOrderMap = this.supplyPolicy.getStorageOrderMap();
        Integer storageOrgOrder = storageOrderMap.get(row.getLong("invorg"));
        valueArr[this.rowMeta.getFieldIndex((String)"priority")] = storageOrgOrder;
        int warehouseSetting = this.supplyPolicy.getWarehouseSetting();
        if (warehouseSetting == 2 && this.supplyPolicy.getWarehouseEntries() != null && !this.supplyPolicy.getWarehouseEntries().isEmpty()) {
            String location = row.getString("supplylocation");
            if (!StringUtils.isEmpty((String)location) && !"0".equals(location)) {
                String orderSign = row.getString("invorg") + "$" + row.getString("supplywarehouse") + "$" + location;
                if (this.supplyPolicy.getLocationOrderMap().containsKey(orderSign)) {
                    Integer locationOrder = this.supplyPolicy.getLocationOrderMap().get(orderSign);
                    valueArr[this.rowMeta.getFieldIndex((String)"supplypriority")] = locationOrder;
                }
            } else {
                String orderSign = row.getString("invorg") + "$" + row.getString("supplywarehouse");
                if (this.supplyPolicy.getWarehouseOrderMap().containsKey(orderSign)) {
                    Integer warehouseOrder = this.supplyPolicy.getWarehouseOrderMap().get(orderSign);
                    valueArr[this.rowMeta.getFieldIndex((String)"supplypriority")] = warehouseOrder;
                }
            }
        }
        valueArr[this.rowMeta.getFieldIndex((String)"invtypepriority")] = "bd_supplier".equals(ownerType = row.getString("onwertype")) ? Integer.valueOf(2) : Integer.valueOf(1);
        return valueArr;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

